/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata.contacts.serializer.xml;

import com.google.wireless.gdata.contacts.data.ContactEntry;
import com.google.wireless.gdata.contacts.data.ContactsElement;
import com.google.wireless.gdata.contacts.data.EmailAddress;
import com.google.wireless.gdata.contacts.data.GroupMembershipInfo;
import com.google.wireless.gdata.contacts.data.ImAddress;
import com.google.wireless.gdata.contacts.data.Organization;
import com.google.wireless.gdata.contacts.data.PhoneNumber;
import com.google.wireless.gdata.contacts.data.PostalAddress;
import com.google.wireless.gdata.contacts.parser.xml.XmlContactsGDataParser;
import com.google.wireless.gdata.data.ExtendedProperty;
import com.google.wireless.gdata.data.StringUtils;
import com.google.wireless.gdata.parser.ParseException;
import com.google.wireless.gdata.parser.xml.XmlParserFactory;
import com.google.wireless.gdata.serializer.xml.XmlEntryGDataSerializer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlpull.v1.XmlSerializer;

public class XmlContactEntryGDataSerializer
extends XmlEntryGDataSerializer {
    public XmlContactEntryGDataSerializer(XmlParserFactory factory, ContactEntry entry) {
        super(factory, entry);
    }

    protected void declareExtraEntryNamespaces(XmlSerializer serializer) throws IOException {
        super.declareExtraEntryNamespaces(serializer);
        serializer.setPrefix("gContact", "http://schemas.google.com/contact/2008");
    }

    protected ContactEntry getContactEntry() {
        return (ContactEntry)this.getEntry();
    }

    protected void serializeExtraEntryContents(XmlSerializer serializer, int format) throws ParseException, IOException {
        ContactEntry entry = this.getContactEntry();
        entry.validate();
        XmlContactEntryGDataSerializer.serializeLink(serializer, "http://schemas.google.com/contacts/2008/rel#edit-photo", entry.getLinkEditPhotoHref(), entry.getLinkEditPhotoType());
        XmlContactEntryGDataSerializer.serializeLink(serializer, "http://schemas.google.com/contacts/2008/rel#photo", entry.getLinkPhotoHref(), entry.getLinkPhotoType());
        Enumeration eachEmail = entry.getEmailAddresses().elements();
        while (eachEmail.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (EmailAddress)eachEmail.nextElement());
        }
        Enumeration eachIm = entry.getImAddresses().elements();
        while (eachIm.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (ImAddress)eachIm.nextElement());
        }
        Enumeration eachPhone = entry.getPhoneNumbers().elements();
        while (eachPhone.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (PhoneNumber)eachPhone.nextElement());
        }
        Enumeration eachAddress = entry.getPostalAddresses().elements();
        while (eachAddress.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (PostalAddress)eachAddress.nextElement());
        }
        Enumeration eachOrganization = entry.getOrganizations().elements();
        while (eachOrganization.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (Organization)eachOrganization.nextElement());
        }
        Enumeration eachExtendedProperty = entry.getExtendedProperties().elements();
        while (eachExtendedProperty.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (ExtendedProperty)eachExtendedProperty.nextElement());
        }
        Enumeration eachGroup = entry.getGroups().elements();
        while (eachGroup.hasMoreElements()) {
            XmlContactEntryGDataSerializer.serialize(serializer, (GroupMembershipInfo)eachGroup.nextElement());
        }
        XmlContactEntryGDataSerializer.serializeYomiName(serializer, entry.getYomiName());
    }

    private static void serialize(XmlSerializer serializer, EmailAddress email) throws IOException, ParseException {
        if (StringUtils.isEmptyOrWhitespace(email.getAddress())) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", "email");
        XmlContactEntryGDataSerializer.serializeContactsElement(serializer, email, XmlContactsGDataParser.TYPE_TO_REL_EMAIL);
        serializer.attribute(null, "address", email.getAddress());
        serializer.endTag("http://schemas.google.com/g/2005", "email");
    }

    private static void serialize(XmlSerializer serializer, ImAddress im) throws IOException, ParseException {
        if (StringUtils.isEmptyOrWhitespace(im.getAddress())) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", "im");
        XmlContactEntryGDataSerializer.serializeContactsElement(serializer, im, XmlContactsGDataParser.TYPE_TO_REL_IM);
        serializer.attribute(null, "address", im.getAddress());
        switch (im.getProtocolPredefined()) {
            case 10: {
                break;
            }
            case 1: {
                String protocolString = im.getProtocolCustom();
                if (protocolString == null) {
                    throw new IllegalArgumentException("the protocol is custom, but the custom string is null");
                }
                serializer.attribute(null, "protocol", protocolString);
                break;
            }
            default: {
                String protocolString = (String)XmlContactsGDataParser.IM_PROTOCOL_TYPE_TO_STRING_MAP.get(new Byte(im.getProtocolPredefined()));
                serializer.attribute(null, "protocol", protocolString);
            }
        }
        serializer.endTag("http://schemas.google.com/g/2005", "im");
    }

    private static void serialize(XmlSerializer serializer, PhoneNumber phone) throws IOException, ParseException {
        if (StringUtils.isEmptyOrWhitespace(phone.getPhoneNumber())) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", "phoneNumber");
        XmlContactEntryGDataSerializer.serializeContactsElement(serializer, phone, XmlContactsGDataParser.TYPE_TO_REL_PHONE);
        serializer.text(phone.getPhoneNumber());
        serializer.endTag("http://schemas.google.com/g/2005", "phoneNumber");
    }

    private static void serialize(XmlSerializer serializer, Organization organization) throws IOException, ParseException {
        String name = organization.getName();
        String title = organization.getTitle();
        if (StringUtils.isEmptyOrWhitespace(name) && StringUtils.isEmptyOrWhitespace(title)) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", "organization");
        XmlContactEntryGDataSerializer.serializeContactsElement(serializer, organization, XmlContactsGDataParser.TYPE_TO_REL_ORGANIZATION);
        if (!StringUtils.isEmpty(name)) {
            serializer.startTag("http://schemas.google.com/g/2005", "orgName");
            serializer.text(name);
            serializer.endTag("http://schemas.google.com/g/2005", "orgName");
        }
        if (!StringUtils.isEmpty(title)) {
            serializer.startTag("http://schemas.google.com/g/2005", "orgTitle");
            serializer.text(title);
            serializer.endTag("http://schemas.google.com/g/2005", "orgTitle");
        }
        serializer.endTag("http://schemas.google.com/g/2005", "organization");
    }

    private static void serialize(XmlSerializer serializer, PostalAddress addr) throws IOException, ParseException {
        if (StringUtils.isEmptyOrWhitespace(addr.getValue())) {
            return;
        }
        serializer.startTag("http://schemas.google.com/g/2005", "postalAddress");
        XmlContactEntryGDataSerializer.serializeContactsElement(serializer, addr, XmlContactsGDataParser.TYPE_TO_REL_POSTAL);
        String addressValue = addr.getValue();
        if (addressValue != null) {
            serializer.text(addressValue);
        }
        serializer.endTag("http://schemas.google.com/g/2005", "postalAddress");
    }

    private static void serializeContactsElement(XmlSerializer serializer, ContactsElement element, Hashtable typeToRelMap) throws IOException, ParseException {
        boolean hasType;
        String label = element.getLabel();
        boolean bl = hasType = element.getType() != -1;
        if (label == null && !hasType || label != null && hasType) {
            throw new ParseException("exactly one of label or rel must be set");
        }
        if (label != null) {
            serializer.attribute(null, "label", label);
        }
        if (hasType) {
            serializer.attribute(null, "rel", (String)typeToRelMap.get(new Byte(element.getType())));
        }
        if (element.isPrimary()) {
            serializer.attribute(null, "primary", "true");
        }
    }

    private static void serialize(XmlSerializer serializer, GroupMembershipInfo groupMembershipInfo) throws IOException, ParseException {
        String group = groupMembershipInfo.getGroup();
        boolean isDeleted = groupMembershipInfo.isDeleted();
        if (StringUtils.isEmptyOrWhitespace(group)) {
            throw new ParseException("the group must not be empty");
        }
        serializer.startTag("http://schemas.google.com/contact/2008", "groupMembershipInfo");
        serializer.attribute(null, "href", group);
        serializer.attribute(null, "deleted", isDeleted ? "true" : "false");
        serializer.endTag("http://schemas.google.com/contact/2008", "groupMembershipInfo");
    }

    private static void serialize(XmlSerializer serializer, ExtendedProperty extendedProperty) throws IOException, ParseException {
        String name = extendedProperty.getName();
        String value = extendedProperty.getValue();
        String xmlBlob = extendedProperty.getXmlBlob();
        serializer.startTag("http://schemas.google.com/g/2005", "extendedProperty");
        if (!StringUtils.isEmpty(name)) {
            serializer.attribute(null, "name", name);
        }
        if (!StringUtils.isEmpty(value)) {
            serializer.attribute(null, "value", value);
        }
        if (!StringUtils.isEmpty(xmlBlob)) {
            XmlContactEntryGDataSerializer.serializeBlob(serializer, xmlBlob);
        }
        serializer.endTag("http://schemas.google.com/g/2005", "extendedProperty");
    }

    private static void serializeBlob(XmlSerializer serializer, String blob) throws IOException, ParseException {
        serializer.text(blob);
    }

    private static void serializeYomiName(XmlSerializer serializer, String yomiName) throws IOException {
        if (StringUtils.isEmpty(yomiName)) {
            return;
        }
        serializer.startTag("http://schemas.google.com/contact/2008", "yomiName");
        serializer.text(yomiName);
        serializer.endTag("http://schemas.google.com/contact/2008", "yomiName");
    }
}

