/*
 * Decompiled with CFR 0.152.
 */
package com.google.wireless.gdata.calendar.data;

import com.google.wireless.gdata.calendar.data.Reminder;
import com.google.wireless.gdata.calendar.data.When;
import com.google.wireless.gdata.calendar.data.Who;
import com.google.wireless.gdata.data.Entry;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EventEntry
extends Entry {
    public static final byte STATUS_TENTATIVE = 0;
    public static final byte STATUS_CONFIRMED = 1;
    public static final byte STATUS_CANCELED = 2;
    public static final byte VISIBILITY_DEFAULT = 0;
    public static final byte VISIBILITY_CONFIDENTIAL = 1;
    public static final byte VISIBILITY_PRIVATE = 2;
    public static final byte VISIBILITY_PUBLIC = 3;
    public static final byte TRANSPARENCY_OPAQUE = 0;
    public static final byte TRANSPARENCY_TRANSPARENT = 1;
    private byte status = 0;
    private String recurrence = null;
    private byte visibility = 0;
    private byte transparency = 0;
    private Vector attendees = new Vector();
    private boolean sendEventNotifications = false;
    private boolean guestsCanModify = false;
    private boolean guestsCanInviteOthers = true;
    private boolean guestsCanSeeGuests = true;
    private String organizer = null;
    private Vector whens = new Vector();
    private Vector reminders = null;
    private String originalEventId = null;
    private String originalEventStartTime = null;
    private String where = null;
    private String commentsUri = null;
    private Hashtable extendedProperties = null;
    private boolean quickAdd = false;

    public void clear() {
        super.clear();
        this.status = 0;
        this.recurrence = null;
        this.visibility = 0;
        this.transparency = 0;
        this.sendEventNotifications = false;
        this.guestsCanModify = false;
        this.guestsCanInviteOthers = true;
        this.guestsCanSeeGuests = true;
        this.organizer = null;
        this.attendees.removeAllElements();
        this.whens.removeAllElements();
        this.reminders = null;
        this.originalEventId = null;
        this.originalEventStartTime = null;
        this.where = null;
        this.commentsUri = null;
        this.extendedProperties = null;
        this.quickAdd = false;
    }

    public String getRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(String recurrence) {
        this.recurrence = recurrence;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public byte getTransparency() {
        return this.transparency;
    }

    public void setTransparency(byte transparency) {
        this.transparency = transparency;
    }

    public byte getVisibility() {
        return this.visibility;
    }

    public void setVisibility(byte visibility) {
        this.visibility = visibility;
    }

    public boolean getSendEventNotifications() {
        return this.sendEventNotifications;
    }

    public void setSendEventNotifications(boolean sendEventNotifications) {
        this.sendEventNotifications = sendEventNotifications;
    }

    public boolean getGuestsCanModify() {
        return this.guestsCanModify;
    }

    public void setGuestsCanModify(boolean guestsCanModify) {
        this.guestsCanModify = guestsCanModify;
    }

    public boolean getGuestsCanInviteOthers() {
        return this.guestsCanInviteOthers;
    }

    public void setGuestsCanInviteOthers(boolean guestsCanInviteOthers) {
        this.guestsCanInviteOthers = guestsCanInviteOthers;
    }

    public boolean getGuestsCanSeeGuests() {
        return this.guestsCanSeeGuests;
    }

    public void setGuestsCanSeeGuests(boolean guestsCanSeeGuests) {
        this.guestsCanSeeGuests = guestsCanSeeGuests;
    }

    public String getOrganizer() {
        return this.organizer;
    }

    public void setOrganizer(String organizer) {
        this.organizer = organizer;
    }

    public void clearAttendees() {
        this.attendees.clear();
    }

    public void addAttendee(Who attendee) {
        this.attendees.add(attendee);
    }

    public Vector getAttendees() {
        return this.attendees;
    }

    public void clearWhens() {
        this.whens.clear();
    }

    public void addWhen(When when) {
        this.whens.add(when);
    }

    public Vector getWhens() {
        return this.whens;
    }

    public When getFirstWhen() {
        if (this.whens.isEmpty()) {
            return null;
        }
        return (When)this.whens.elementAt(0);
    }

    public Vector getReminders() {
        return this.reminders;
    }

    public void addReminder(Reminder reminder) {
        if (this.reminders == null) {
            this.reminders = new Vector();
        }
        this.reminders.add(reminder);
    }

    public void clearReminders() {
        this.reminders = null;
    }

    public String getOriginalEventId() {
        return this.originalEventId;
    }

    public void setOriginalEventId(String originalEventId) {
        this.originalEventId = originalEventId;
    }

    public String getOriginalEventStartTime() {
        return this.originalEventStartTime;
    }

    public void setOriginalEventStartTime(String originalEventStartTime) {
        this.originalEventStartTime = originalEventStartTime;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public Hashtable getExtendedProperties() {
        return this.extendedProperties;
    }

    public String getExtendedProperty(String name) {
        if (this.extendedProperties == null) {
            return null;
        }
        String value = null;
        if (this.extendedProperties.containsKey(name)) {
            value = (String)this.extendedProperties.get(name);
        }
        return value;
    }

    public void addExtendedProperty(String name, String value) {
        if (this.extendedProperties == null) {
            this.extendedProperties = new Hashtable();
        }
        this.extendedProperties.put(name, value);
    }

    public void clearExtendedProperties() {
        this.extendedProperties = null;
    }

    public String getCommentsUri() {
        return this.commentsUri;
    }

    public void setCommentsUri(String commentsUri) {
        this.commentsUri = commentsUri;
    }

    public boolean isQuickAdd() {
        return this.quickAdd;
    }

    public void setQuickAdd(boolean quickAdd) {
        this.quickAdd = quickAdd;
    }

    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append("STATUS: " + this.status + "\n");
        this.appendIfNotNull(sb, "RECURRENCE", this.recurrence);
        sb.append("VISIBILITY: " + this.visibility + "\n");
        sb.append("TRANSPARENCY: " + this.transparency + "\n");
        this.appendIfNotNull(sb, "ORIGINAL_EVENT_ID", this.originalEventId);
        this.appendIfNotNull(sb, "ORIGINAL_START_TIME", this.originalEventStartTime);
        sb.append("QUICK_ADD: " + (this.quickAdd ? "true" : "false"));
        sb.append("SEND_EVENT_NOTIFICATIONS: " + (this.sendEventNotifications ? "true" : "false"));
        sb.append("GUESTS_CAN_MODIFY: " + (this.guestsCanModify ? "true" : "false"));
        sb.append("GUESTS_CAN_INVITE_OTHERS: " + (this.guestsCanInviteOthers ? "true" : "false"));
        sb.append("GUESTS_CAN_SEE_GUESTS: " + (this.guestsCanSeeGuests ? "true" : "false"));
        this.appendIfNotNull(sb, "ORGANIZER", this.organizer);
        Enumeration whos = this.attendees.elements();
        while (whos.hasMoreElements()) {
            Who who = (Who)whos.nextElement();
            who.toString(sb);
        }
        Enumeration times = this.whens.elements();
        while (times.hasMoreElements()) {
            When when = (When)times.nextElement();
            when.toString(sb);
        }
        if (this.reminders != null) {
            Enumeration alarms = this.reminders.elements();
            while (alarms.hasMoreElements()) {
                Reminder reminder = (Reminder)alarms.nextElement();
                reminder.toString(sb);
            }
        }
        this.appendIfNotNull(sb, "WHERE", this.where);
        this.appendIfNotNull(sb, "COMMENTS", this.commentsUri);
        if (this.extendedProperties != null) {
            Enumeration entryNames = this.extendedProperties.keys();
            while (entryNames.hasMoreElements()) {
                String name = (String)entryNames.nextElement();
                String value = (String)this.extendedProperties.get(name);
                sb.append(name);
                sb.append(':');
                sb.append(value);
                sb.append('\n');
            }
        }
    }
}

