/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gsf;

import android.content.ContentResolver;
import android.content.Context;
import android.os.AsyncTask;
import android.provider.Browser;
import android.util.Log;
import com.google.android.gsf.GoogleSettingsContract;

public class UseLocationForServices {
    private static final String TAG = "UseLocationForServices";
    public static final String ACTION_SET_USE_LOCATION_FOR_SERVICES = "com.google.android.gsf.action.SET_USE_LOCATION_FOR_SERVICES";
    public static final int USE_LOCATION_FOR_SERVICES_OFF = 0;
    public static final int USE_LOCATION_FOR_SERVICES_ON = 1;
    public static final int USE_LOCATION_FOR_SERVICES_NOT_SET = 2;
    private static String[] GOOGLE_GEOLOCATION_ORIGINS = new String[]{"http://www.google.com", "http://www.google.co.uk"};

    public static int getUseLocationForServices(Context context) {
        return GoogleSettingsContract.Partner.getInt(context.getContentResolver(), "use_location_for_services", 2);
    }

    public static boolean setUseLocationForServices(Context context, boolean value) {
        UseLocationForServices.setGoogleBrowserGeolocationAsync(context, value);
        return GoogleSettingsContract.Partner.putInt(context.getContentResolver(), "use_location_for_services", value ? 1 : 0);
    }

    private static void setGoogleBrowserGeolocationAsync(final Context context, final boolean allow) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                UseLocationForServices.setGoogleBrowserGeolocation(context, allow);
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    private static void setGoogleBrowserGeolocation(Context context, boolean allow) {
        try {
            for (String origin : GOOGLE_GEOLOCATION_ORIGINS) {
                if (allow) {
                    Browser.allowGeolocation((ContentResolver)context.getContentResolver(), (String)origin);
                    continue;
                }
                Browser.clearGeolocation((ContentResolver)context.getContentResolver(), (String)origin);
            }
        }
        catch (RuntimeException ex) {
            Log.e((String)TAG, (String)("Failed to set browser geolocation permissions: " + ex));
        }
    }
}

