/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gsf;

import android.content.ContentQueryMap;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.provider.BaseColumns;

public class TalkContract {
    public static final String AUTHORITY = "com.google.android.providers.talk";
    public static final Uri AUTHORITY_URI = Uri.parse((String)"content://com.google.android.providers.talk");

    private TalkContract() {
    }

    public static final class ServerToDeviceRmqIds
    implements BaseColumns,
    ServerToDeviceRmqIdsColumn {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/s2dids");
    }

    public static interface ServerToDeviceRmqIdsColumn {
        public static final String RMQ_ID = "rmq_id";
    }

    public static final class LastRmqId
    implements BaseColumns,
    LastRmqIdColumns {
        private static String[] PROJECTION = new String[]{"rmq_id"};
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/lastRmqId");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final long queryLastRmqId(ContentResolver resolver) {
            Cursor cursor = resolver.query(CONTENT_URI, PROJECTION, null, null, null);
            long retVal = 0L;
            try {
                if (cursor.moveToFirst()) {
                    retVal = cursor.getLong(cursor.getColumnIndexOrThrow("rmq_id"));
                }
            }
            finally {
                cursor.close();
            }
            return retVal;
        }

        public static final void saveLastRmqId(ContentResolver resolver, long rmqId) {
            ContentValues values = new ContentValues();
            values.put("_id", Integer.valueOf(1));
            values.put("rmq_id", Long.valueOf(rmqId));
            resolver.insert(CONTENT_URI, values);
        }
    }

    public static interface LastRmqIdColumns {
        public static final String RMQ_ID = "rmq_id";
    }

    public static final class OutgoingRmq
    implements BaseColumns,
    OutgoingRmqColumns {
        private static String[] RMQ_ID_PROJECTION = new String[]{"rmq_id"};
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/outgoingRmqMessages");
        public static final Uri CONTENT_URI_FOR_HIGHEST_RMQ_ID = Uri.parse((String)"content://com.google.android.providers.talk/outgoingHighestRmqId");
        public static final String DEFAULT_SORT_ORDER = "rmq_id ASC";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final long queryHighestRmqId(ContentResolver resolver) {
            Cursor cursor = resolver.query(CONTENT_URI_FOR_HIGHEST_RMQ_ID, RMQ_ID_PROJECTION, null, null, null);
            long retVal = 0L;
            try {
                if (cursor.moveToFirst()) {
                    retVal = cursor.getLong(cursor.getColumnIndexOrThrow("rmq_id"));
                }
            }
            finally {
                cursor.close();
            }
            return retVal;
        }
    }

    public static interface OutgoingRmqColumns {
        public static final String RMQ_ID = "rmq_id";
        public static final String TIMESTAMP = "ts";
        public static final String DATA = "data";
        public static final String PROTOBUF_TAG = "type";
    }

    public static class ProviderSettings
    implements ProviderSettingsColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/providerSettings");
        public static final String CONTENT_TYPE = "vnd.android-dir/gtalk-providerSettings";
        public static final String SHOW_OFFLINE_CONTACTS = "show_offline_contacts";
        public static final String SETTING_AUTOMATICALLY_CONNECT_GTALK = "gtalk_auto_connect";
        public static final String SETTING_AUTOMATICALLY_START_SERVICE = "auto_start_service";
        public static final String SETTING_HIDE_OFFLINE_CONTACTS = "hide_offline_contacts";
        public static final String SETTING_ENABLE_NOTIFICATION = "enable_notification";
        public static final String SETTING_VIBRATE = "vibrate";
        public static final String SETTING_VIBRATE_WHEN = "vibrate-when";
        public static final String SETTING_RINGTONE = "ringtone";
        public static final String SETTING_RINGTONE_DEFAULT = "content://settings/system/notification_sound";
        public static final String SETTING_SHOW_MOBILE_INDICATOR = "mobile_indicator";
        public static final String SETTING_SHOW_AWAY_ON_IDLE = "show_away_on_idle";
        public static final String SETTING_UPLOAD_HEARTBEAT_STAT = "upload_heartbeat_stat";
        public static final String SETTING_HEARTBEAT_INTERVAL = "heartbeat_interval";
        public static final String SETTING_JID_RESOURCE = "jid_resource";
        public static final String LAST_RMQ_RECEIVED = "last_rmq_rec";

        private ProviderSettings() {
        }

        public static void putLongValue(ContentResolver cr, String name, long value) {
            ContentValues v = new ContentValues(3);
            v.put("name", name);
            v.put("value", Long.valueOf(value));
            cr.insert(CONTENT_URI, v);
        }

        public static void putBooleanValue(ContentResolver cr, String name, boolean value) {
            ContentValues v = new ContentValues(3);
            v.put("name", name);
            v.put("value", Boolean.toString(value));
            cr.insert(CONTENT_URI, v);
        }

        public static void putStringValue(ContentResolver cr, String name, String value) {
            ContentValues v = new ContentValues(3);
            v.put("name", name);
            v.put("value", value);
            cr.insert(CONTENT_URI, v);
        }

        public static void setAutomaticallyConnectGTalk(ContentResolver contentResolver, boolean autoConnect) {
            ProviderSettings.putBooleanValue(contentResolver, SETTING_AUTOMATICALLY_CONNECT_GTALK, autoConnect);
        }

        public static void setHideOfflineContacts(ContentResolver contentResolver, boolean hideOfflineContacts) {
            ProviderSettings.putBooleanValue(contentResolver, SETTING_HIDE_OFFLINE_CONTACTS, hideOfflineContacts);
        }

        public static void setEnableNotification(ContentResolver contentResolver, boolean enable) {
            ProviderSettings.putBooleanValue(contentResolver, SETTING_ENABLE_NOTIFICATION, enable);
        }

        public static void setVibrate(ContentResolver contentResolver, boolean vibrate) {
            ProviderSettings.putBooleanValue(contentResolver, SETTING_VIBRATE, vibrate);
        }

        public static void setVibrateWhen(ContentResolver contentResolver, String when) {
            ProviderSettings.putStringValue(contentResolver, SETTING_VIBRATE_WHEN, when);
        }

        public static void setRingtoneURI(ContentResolver contentResolver, String ringtoneUri) {
            ProviderSettings.putStringValue(contentResolver, SETTING_RINGTONE, ringtoneUri);
        }

        public static void setShowMobileIndicator(ContentResolver contentResolver, boolean showMobileIndicator) {
            ProviderSettings.putBooleanValue(contentResolver, SETTING_SHOW_MOBILE_INDICATOR, showMobileIndicator);
        }

        public static void setShowAwayOnIdle(ContentResolver contentResolver, boolean showAway) {
            ProviderSettings.putBooleanValue(contentResolver, SETTING_SHOW_AWAY_ON_IDLE, showAway);
        }

        public static void setUploadHeartbeatStat(ContentResolver contentResolver, boolean uploadStat) {
            ProviderSettings.putBooleanValue(contentResolver, SETTING_UPLOAD_HEARTBEAT_STAT, uploadStat);
        }

        public static void setHeartbeatInterval(ContentResolver contentResolver, long interval) {
            ProviderSettings.putLongValue(contentResolver, SETTING_HEARTBEAT_INTERVAL, interval);
        }

        public static void setJidResource(ContentResolver contentResolver, String jidResource) {
            ProviderSettings.putStringValue(contentResolver, SETTING_JID_RESOURCE, jidResource);
        }

        public static class QueryMap
        extends ContentQueryMap {
            private ContentResolver mContentResolver;

            public QueryMap(ContentResolver contentResolver, boolean keepUpdated, Handler handlerForUpdateNotifications) {
                super(contentResolver.query(CONTENT_URI, new String[]{"name", "value"}, null, null, null), "name", keepUpdated, handlerForUpdateNotifications);
                this.mContentResolver = contentResolver;
            }

            public void setAutomaticallyConnectToGTalkServer(boolean autoConnect) {
                ProviderSettings.setAutomaticallyConnectGTalk(this.mContentResolver, autoConnect);
            }

            public boolean getAutomaticallyConnectToGTalkServer() {
                return this.getBoolean(ProviderSettings.SETTING_AUTOMATICALLY_CONNECT_GTALK, true);
            }

            public void setHideOfflineContacts(boolean hideOfflineContacts) {
                ProviderSettings.setHideOfflineContacts(this.mContentResolver, hideOfflineContacts);
            }

            public boolean getHideOfflineContacts() {
                return this.getBoolean(ProviderSettings.SETTING_HIDE_OFFLINE_CONTACTS, false);
            }

            public void setEnableNotification(boolean enable) {
                ProviderSettings.setEnableNotification(this.mContentResolver, enable);
            }

            public boolean getEnableNotification() {
                return this.getBoolean(ProviderSettings.SETTING_ENABLE_NOTIFICATION, true);
            }

            public void setVibrate(boolean vibrate) {
                ProviderSettings.setVibrate(this.mContentResolver, vibrate);
            }

            public boolean getVibrate() {
                return this.getBoolean(ProviderSettings.SETTING_VIBRATE, false);
            }

            public void setVibrateWhen(String when) {
                ProviderSettings.setVibrateWhen(this.mContentResolver, when);
            }

            public String getVibrateWhen() {
                String when = this.getString(ProviderSettings.SETTING_VIBRATE_WHEN, null);
                if (when != null) {
                    return when;
                }
                return this.getVibrate() ? "always" : "never";
            }

            public void setRingtoneURI(String ringtoneUri) {
                ProviderSettings.setRingtoneURI(this.mContentResolver, ringtoneUri);
            }

            public String getRingtoneURI() {
                return this.getString(ProviderSettings.SETTING_RINGTONE, ProviderSettings.SETTING_RINGTONE_DEFAULT);
            }

            public void setShowMobileIndicator(boolean showMobile) {
                ProviderSettings.setShowMobileIndicator(this.mContentResolver, showMobile);
            }

            public boolean getShowMobileIndicator() {
                return this.getBoolean(ProviderSettings.SETTING_SHOW_MOBILE_INDICATOR, true);
            }

            public void setShowAwayOnIdle(boolean showAway) {
                ProviderSettings.setShowAwayOnIdle(this.mContentResolver, showAway);
            }

            public boolean getShowAwayOnIdle() {
                return this.getBoolean(ProviderSettings.SETTING_SHOW_AWAY_ON_IDLE, true);
            }

            public void setUploadHeartbeatStat(boolean uploadStat) {
                ProviderSettings.setUploadHeartbeatStat(this.mContentResolver, uploadStat);
            }

            public boolean getUploadHeartbeatStat() {
                return this.getBoolean(ProviderSettings.SETTING_UPLOAD_HEARTBEAT_STAT, false);
            }

            public void setHeartbeatInterval(long interval) {
                ProviderSettings.setHeartbeatInterval(this.mContentResolver, interval);
            }

            public long getHeartbeatInterval() {
                return this.getLong(ProviderSettings.SETTING_HEARTBEAT_INTERVAL, 0L);
            }

            public void setJidResource(String jidResource) {
                ProviderSettings.setJidResource(this.mContentResolver, jidResource);
            }

            public String getJidResource() {
                return this.getString(ProviderSettings.SETTING_JID_RESOURCE, null);
            }

            private boolean getBoolean(String name, boolean def) {
                ContentValues values = this.getValues(name);
                return values != null ? values.getAsBoolean("value") : def;
            }

            private String getString(String name, String def) {
                ContentValues values = this.getValues(name);
                return values != null ? values.getAsString("value") : def;
            }

            private int getInteger(String name, int def) {
                ContentValues values = this.getValues(name);
                return values != null ? values.getAsInteger("value") : def;
            }

            private long getLong(String name, long def) {
                ContentValues values = this.getValues(name);
                return values != null ? values.getAsLong("value") : def;
            }
        }
    }

    public static interface ProviderSettingsColumns {
        public static final String PROVIDER = "provider";
        public static final String NAME = "name";
        public static final String VALUE = "value";
    }

    public static final class Chats
    implements BaseColumns,
    ChatsColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/chats");
        public static final Uri CONTENT_URI_BY_ACCOUNT = Uri.parse((String)"content://com.google.android.providers.talk/chats/account");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/gtalk-chats";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/gtalk-chats";
        public static final String DEFAULT_SORT_ORDER = "last_message_date ASC";

        private Chats() {
        }
    }

    public static interface ChatsColumns {
        public static final String CONTACT_ID = "contact_id";
        public static final String JID_RESOURCE = "jid_resource";
        public static final String GROUP_CHAT = "groupchat";
        public static final String LAST_UNREAD_MESSAGE = "last_unread_message";
        public static final String LAST_MESSAGE_DATE = "last_message_date";
        public static final String UNSENT_COMPOSED_MESSAGE = "unsent_composed_message";
        public static final String SHORTCUT = "shortcut";
    }

    public static final class Presence
    implements BaseColumns,
    PresenceColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/presence");
        public static final Uri CONTENT_URI_BY_ACCOUNT = Uri.parse((String)"content://com.google.android.providers.talk/presence/account");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/gtalk-presence";
        public static final String DEFAULT_SORT_ORDER = "mode DESC";
    }

    public static interface PresenceColumns
    extends CommonPresenceColumns {
        public static final String CONTACT_ID = "contact_id";
        public static final String JID_RESOURCE = "jid_resource";
        public static final String CLIENT_TYPE = "client_type";
        public static final int CLIENT_TYPE_DEFAULT = 0;
        public static final int CLIENT_TYPE_MOBILE = 1;
        public static final int CLIENT_TYPE_ANDROID = 2;
    }

    public static interface CommonPresenceColumns {
        public static final String PRIORITY = "priority";
        public static final String PRESENCE_STATUS = "mode";
        public static final int OFFLINE = 0;
        public static final int INVISIBLE = 1;
        public static final int AWAY = 2;
        public static final int IDLE = 3;
        public static final int DO_NOT_DISTURB = 4;
        public static final int AVAILABLE = 5;
        public static final String PRESENCE_CUSTOM_STATUS = "status";
    }

    public static final class Avatars
    implements BaseColumns,
    AvatarsColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/avatars");
        public static final Uri CONTENT_URI_AVATARS_BY = Uri.parse((String)"content://com.google.android.providers.talk/avatarsBy");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/gtalk-avatars";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/gtalk-avatars";
        public static final String DEFAULT_SORT_ORDER = "contact ASC";

        private Avatars() {
        }
    }

    public static interface AvatarsColumns {
        public static final String CONTACT = "contact";
        public static final String PROVIDER = "provider_id";
        public static final String ACCOUNT = "account_id";
        public static final String HASH = "hash";
        public static final String DATA = "data";
    }

    public static final class Invitation
    implements InvitationColumns,
    BaseColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/invitations");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/gtalk-invitations";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/gtalk-invitations";

        private Invitation() {
        }
    }

    public static interface InvitationColumns {
        public static final String PROVIDER = "providerId";
        public static final String ACCOUNT = "accountId";
        public static final String INVITE_ID = "inviteId";
        public static final String SENDER = "sender";
        public static final String GROUP_NAME = "groupName";
        public static final String NOTE = "note";
        public static final String STATUS = "status";
        public static final int STATUS_PENDING = 0;
        public static final int STATUS_ACCEPTED = 1;
        public static final int STATUS_REJECTED = 2;
    }

    public static final class GroupMembers
    implements GroupMemberColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/groupMembers");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/gtalk-groupMembers";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/gtalk-groupMembers";

        private GroupMembers() {
        }
    }

    public static interface GroupMemberColumns {
        public static final String GROUP = "groupId";
        public static final String USERNAME = "username";
        public static final String NICKNAME = "nickname";
    }

    public static final class Messages
    implements BaseColumns,
    MessageColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/messages");
        public static final Uri CONTENT_URI_MESSAGES_BY_THREAD_ID = Uri.parse((String)"content://com.google.android.providers.talk/messagesByThreadId");
        public static final Uri CONTENT_URI_MESSAGES_BY_ACCOUNT_AND_CONTACT = Uri.parse((String)"content://com.google.android.providers.talk/messagesByAcctAndContact");
        public static final Uri CONTENT_URI_MESSAGES_BY_PROVIDER = Uri.parse((String)"content://com.google.android.providers.talk/messagesByProvider");
        public static final Uri CONTENT_URI_BY_ACCOUNT = Uri.parse((String)"content://com.google.android.providers.talk/messagesByAccount");
        public static final Uri OTR_MESSAGES_CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/otrMessages");
        public static final Uri OTR_MESSAGES_CONTENT_URI_BY_THREAD_ID = Uri.parse((String)"content://com.google.android.providers.talk/otrMessagesByThreadId");
        public static final Uri OTR_MESSAGES_CONTENT_URI_BY_ACCOUNT_AND_CONTACT = Uri.parse((String)"content://com.google.android.providers.talk/otrMessagesByAcctAndContact");
        public static final Uri OTR_MESSAGES_CONTENT_URI_BY_PROVIDER = Uri.parse((String)"content://com.google.android.providers.talk/otrMessagesByProvider");
        public static final Uri OTR_MESSAGES_CONTENT_URI_BY_ACCOUNT = Uri.parse((String)"content://com.google.android.providers.talk/otrMessagesByAccount");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/gtalk-messages";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/gtalk-messages";
        public static final String DEFAULT_SORT_ORDER = "date ASC";
        public static final String CONTACT = "contact";

        private Messages() {
        }

        public static final Uri getContentUriByThreadId(long threadId) {
            Uri.Builder builder = CONTENT_URI_MESSAGES_BY_THREAD_ID.buildUpon();
            ContentUris.appendId((Uri.Builder)builder, (long)threadId);
            return builder.build();
        }

        public static final Uri getContentUriByContact(long accountId, String username) {
            Uri.Builder builder = CONTENT_URI_MESSAGES_BY_ACCOUNT_AND_CONTACT.buildUpon();
            ContentUris.appendId((Uri.Builder)builder, (long)accountId);
            builder.appendPath(username);
            return builder.build();
        }

        public static final Uri getContentUriByProvider(long providerId) {
            Uri.Builder builder = CONTENT_URI_MESSAGES_BY_PROVIDER.buildUpon();
            ContentUris.appendId((Uri.Builder)builder, (long)providerId);
            return builder.build();
        }

        public static final Uri getContentUriByAccount(long accountId) {
            Uri.Builder builder = CONTENT_URI_BY_ACCOUNT.buildUpon();
            ContentUris.appendId((Uri.Builder)builder, (long)accountId);
            return builder.build();
        }

        public static final Uri getOtrMessagesContentUriByThreadId(long threadId) {
            Uri.Builder builder = OTR_MESSAGES_CONTENT_URI_BY_THREAD_ID.buildUpon();
            ContentUris.appendId((Uri.Builder)builder, (long)threadId);
            return builder.build();
        }

        public static final Uri getOtrMessagesContentUriByContact(long accountId, String username) {
            Uri.Builder builder = OTR_MESSAGES_CONTENT_URI_BY_ACCOUNT_AND_CONTACT.buildUpon();
            ContentUris.appendId((Uri.Builder)builder, (long)accountId);
            builder.appendPath(username);
            return builder.build();
        }

        public static final Uri getOtrMessagesContentUriByProvider(long providerId) {
            Uri.Builder builder = OTR_MESSAGES_CONTENT_URI_BY_PROVIDER.buildUpon();
            ContentUris.appendId((Uri.Builder)builder, (long)providerId);
            return builder.build();
        }

        public static final Uri getOtrMessagesContentUriByAccount(long accountId) {
            Uri.Builder builder = OTR_MESSAGES_CONTENT_URI_BY_ACCOUNT.buildUpon();
            ContentUris.appendId((Uri.Builder)builder, (long)accountId);
            return builder.build();
        }
    }

    public static interface MessageColumns {
        public static final String THREAD_ID = "thread_id";
        public static final String NICKNAME = "nickname";
        public static final String BODY = "body";
        public static final String DATE = "date";
        public static final String REAL_DATE = "real_date";
        public static final String TYPE = "type";
        public static final String ERROR_CODE = "err_code";
        public static final String ERROR_MESSAGE = "err_msg";
        public static final String PACKET_ID = "packet_id";
        public static final String IS_GROUP_CHAT = "is_muc";
        public static final String DISPLAY_SENT_TIME = "show_ts";
        public static final String CONSOLIDATION_KEY = "consolidation_key";
    }

    public static interface MessageType {
        public static final int OUTGOING = 0;
        public static final int INCOMING = 1;
        public static final int PRESENCE_AVAILABLE = 2;
        public static final int PRESENCE_AWAY = 3;
        public static final int PRESENCE_DND = 4;
        public static final int PRESENCE_UNAVAILABLE = 5;
        public static final int CONVERT_TO_GROUPCHAT = 6;
        public static final int STATUS = 7;
        public static final int POSTPONED = 8;
        public static final int OTR_IS_TURNED_OFF = 9;
        public static final int OTR_IS_TURNED_ON = 10;
        public static final int OTR_TURNED_ON_BY_USER = 11;
        public static final int OTR_TURNED_ON_BY_BUDDY = 12;
    }

    public static final class ContactsEtag
    implements BaseColumns,
    ContactsEtagColumns {
        private static final String[] CONTACT_ETAG_PROJECTION = new String[]{"etag"};
        private static int COLUMN_ETAG = 0;
        private static final String[] CONTACT_OTR_ETAG_PROJECTION = new String[]{"otr_etag"};
        private static int COLUMN_OTR_ETAG = 0;
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/contactsEtag");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/gtalk-contactsEtag";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/gtalk-contactsEtag";

        private ContactsEtag() {
        }

        public static final Cursor query(ContentResolver cr, String[] projection) {
            return cr.query(CONTENT_URI, projection, null, null, null);
        }

        public static final Cursor query(ContentResolver cr, String[] projection, String where, String orderBy) {
            return cr.query(CONTENT_URI, projection, where, null, orderBy == null ? null : orderBy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final String getRosterEtag(ContentResolver resolver, long accountId) {
            String retVal = null;
            Cursor c = resolver.query(CONTENT_URI, CONTACT_ETAG_PROJECTION, "account=" + accountId, null, null);
            try {
                if (c.moveToFirst()) {
                    retVal = c.getString(COLUMN_ETAG);
                }
            }
            finally {
                c.close();
            }
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final String getOtrEtag(ContentResolver resolver, long accountId) {
            String retVal = null;
            Cursor c = resolver.query(CONTENT_URI, CONTACT_OTR_ETAG_PROJECTION, "account=" + accountId, null, null);
            try {
                if (c.moveToFirst()) {
                    retVal = c.getString(COLUMN_OTR_ETAG);
                }
            }
            finally {
                c.close();
            }
            return retVal;
        }
    }

    public static interface ContactsEtagColumns {
        public static final String ETAG = "etag";
        public static final String OTR_ETAG = "otr_etag";
        public static final String ACCOUNT = "account";
    }

    public static final class Contacts
    implements BaseColumns,
    ContactsColumns,
    PresenceColumns,
    ChatsColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/contacts");
        public static final Uri CONTENT_URI_WITH_PRESENCE = Uri.parse((String)"content://com.google.android.providers.talk/contactsWithPresence");
        public static final Uri CONTENT_URI_CONTACTS_BAREBONE = Uri.parse((String)"content://com.google.android.providers.talk/contactsBarebone");
        public static final Uri CONTENT_URI_CHAT_CONTACTS = Uri.parse((String)"content://com.google.android.providers.talk/contacts_chatting");
        public static final Uri CONTENT_URI_BLOCKED_CONTACTS = Uri.parse((String)"content://com.google.android.providers.talk/contacts/blocked");
        public static final Uri CONTENT_URI_CONTACTS_BY = Uri.parse((String)"content://com.google.android.providers.talk/contacts");
        public static final Uri CONTENT_URI_CHAT_CONTACTS_BY = Uri.parse((String)"content://com.google.android.providers.talk/contacts/chatting");
        public static final Uri CONTENT_URI_ONLINE_CONTACTS_BY = Uri.parse((String)"content://com.google.android.providers.talk/contacts/online");
        public static final Uri CONTENT_URI_OFFLINE_CONTACTS_BY = Uri.parse((String)"content://com.google.android.providers.talk/contacts/offline");
        public static final Uri CONTENT_URI_ONLINE_COUNT = Uri.parse((String)"content://com.google.android.providers.talk/contacts/onlineCount");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/gtalk-contacts";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/gtalk-contacts";
        public static final String DEFAULT_SORT_ORDER = "subscriptionType DESC, last_message_date DESC, mode DESC, nickname COLLATE UNICODE ASC";
        public static final String CHATS_CONTACT = "chats_contact";
        public static final String AVATAR_HASH = "avatars_hash";
        public static final String AVATAR_DATA = "avatars_data";

        private Contacts() {
        }
    }

    public static interface OffTheRecordType {
        public static final int DISABLED = 0;
        public static final int ENABLED = 1;
        public static final int ENABLED_BY_USER = 2;
        public static final int ENABLED_BY_BUDDY = 3;
    }

    public static interface ContactsColumns {
        public static final String USERNAME = "username";
        public static final String NICKNAME = "nickname";
        public static final String PROVIDER = "provider";
        public static final String ACCOUNT = "account";
        public static final String CONTACTLIST = "contactList";
        public static final String TYPE = "type";
        public static final int TYPE_NORMAL = 0;
        public static final int TYPE_TEMPORARY = 1;
        public static final int TYPE_GROUP = 2;
        public static final int TYPE_BLOCKED = 3;
        public static final int TYPE_HIDDEN = 4;
        public static final int TYPE_PINNED = 5;
        public static final String SUBSCRIPTION_STATUS = "subscriptionStatus";
        public static final int SUBSCRIPTION_STATUS_NONE = 0;
        public static final int SUBSCRIPTION_STATUS_SUBSCRIBE_PENDING = 1;
        public static final int SUBSCRIPTION_STATUS_UNSUBSCRIBE_PENDING = 2;
        public static final String SUBSCRIPTION_TYPE = "subscriptionType";
        public static final int SUBSCRIPTION_TYPE_NONE = 0;
        public static final int SUBSCRIPTION_TYPE_REMOVE = 1;
        public static final int SUBSCRIPTION_TYPE_TO = 2;
        public static final int SUBSCRIPTION_TYPE_FROM = 3;
        public static final int SUBSCRIPTION_TYPE_BOTH = 4;
        public static final int SUBSCRIPTION_TYPE_INVITATIONS = 5;
        public static final String QUICK_CONTACT = "qc";
        public static final String REJECTED = "rejected";
        public static final String OTR = "otr";
    }

    public static final class AccountStatus
    implements BaseColumns,
    AccountStatusColumns {
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/accountStatus");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/gtalk-account-status";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/gtalk-account-status";
        public static final String DEFAULT_SORT_ORDER = "name ASC";
    }

    public static interface AccountStatusColumns {
        public static final String ACCOUNT = "account";
        public static final String PRESENCE_STATUS = "presenceStatus";
        public static final String CONNECTION_STATUS = "connStatus";
    }

    public static interface ConnectionStatus {
        public static final int OFFLINE = 0;
        public static final int CONNECTING = 1;
        public static final int SUSPENDED = 2;
        public static final int ONLINE = 3;
    }

    public static final class Account
    implements BaseColumns,
    AccountColumns {
        private static final String[] PROVIDER_PROJECTION = new String[]{"provider"};
        private static final int PROVIDER_COLUMN = 0;
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/accounts");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/gtalk-accounts";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/gtalk-accounts";
        public static final String DEFAULT_SORT_ORDER = "name ASC";

        private Account() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final long getProviderIdForAccount(ContentResolver cr, long accountId) {
            Cursor cursor = cr.query(CONTENT_URI, PROVIDER_PROJECTION, "_id=" + accountId, null, null);
            long providerId = 0L;
            try {
                if (cursor.moveToFirst()) {
                    providerId = cursor.getLong(0);
                }
            }
            finally {
                cursor.close();
            }
            return providerId;
        }
    }

    public static interface AccountColumns {
        public static final String NAME = "name";
        public static final String PROVIDER = "provider";
        public static final String USERNAME = "username";
        public static final String PASSWORD = "pw";
        public static final String ACTIVE = "active";
        public static final String LOCKED = "locked";
        public static final String KEEP_SIGNED_IN = "keep_signed_in";
        public static final String LAST_LOGIN_STATE = "last_login_state";
    }

    public static final class Provider
    implements BaseColumns,
    ProviderColumns {
        private static final String[] PROVIDER_PROJECTION = new String[]{"_id", "name"};
        public static final String ACTIVE_ACCOUNT_ID = "account_id";
        public static final String ACTIVE_ACCOUNT_USERNAME = "account_username";
        public static final String ACTIVE_ACCOUNT_PW = "account_pw";
        public static final String ACTIVE_ACCOUNT_LOCKED = "account_locked";
        public static final String ACTIVE_ACCOUNT_KEEP_SIGNED_IN = "account_keepSignedIn";
        public static final String ACCOUNT_PRESENCE_STATUS = "account_presenceStatus";
        public static final String ACCOUNT_CONNECTION_STATUS = "account_connStatus";
        public static final Uri CONTENT_URI = Uri.parse((String)"content://com.google.android.providers.talk/providers");
        public static final Uri CONTENT_URI_WITH_ACCOUNT = Uri.parse((String)"content://com.google.android.providers.talk/providers/account");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/gtalk-providers";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/gtalk-providers";
        public static final String DEFAULT_SORT_ORDER = "name ASC";

        private Provider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final long getProviderIdForName(ContentResolver cr, String providerName) {
            String[] selectionArgs = new String[]{providerName};
            Cursor cursor = cr.query(CONTENT_URI, PROVIDER_PROJECTION, "name=?", selectionArgs, null);
            long retVal = 0L;
            try {
                if (cursor.moveToFirst()) {
                    retVal = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                }
            }
            finally {
                cursor.close();
            }
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final String getProviderNameForId(ContentResolver cr, long providerId) {
            Cursor cursor = cr.query(CONTENT_URI, PROVIDER_PROJECTION, "_id=" + providerId, null, null);
            String retVal = null;
            try {
                if (cursor.moveToFirst()) {
                    retVal = cursor.getString(cursor.getColumnIndexOrThrow("name"));
                }
            }
            finally {
                cursor.close();
            }
            return retVal;
        }
    }

    public static interface ProviderNames {
        public static final String YAHOO = "Yahoo";
        public static final String GTALK = "GTalk";
        public static final String MSN = "MSN";
        public static final String ICQ = "ICQ";
        public static final String AIM = "AIM";
        public static final String XMPP = "XMPP";
        public static final String JABBER = "JABBER";
        public static final String SKYPE = "SKYPE";
        public static final String QQ = "QQ";
    }

    public static interface ProviderColumns {
        public static final String NAME = "name";
        public static final String FULLNAME = "fullname";
        public static final String CATEGORY = "category";
        public static final String SIGNUP_URL = "signup_url";
    }
}

