/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class TestHttpServer {
    private final HttpParams params = new BasicHttpParams();
    private final BasicHttpProcessor httpproc;
    private final ConnectionReuseStrategy connStrategy;
    private final HttpResponseFactory responseFactory;
    private final HttpRequestHandlerRegistry reqistry;
    private final ServerSocket serversocket;
    private HttpExpectationVerifier expectationVerifier;
    private Thread listener;
    private volatile boolean shutdown;

    public TestHttpServer(int port) throws IOException {
        this.params.setIntParameter("http.socket.timeout", 20000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"TEST-SERVER/1.1");
        this.httpproc = new BasicHttpProcessor();
        this.httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        this.httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        this.httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        this.httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        this.connStrategy = new DefaultConnectionReuseStrategy();
        this.responseFactory = new DefaultHttpResponseFactory();
        this.reqistry = new HttpRequestHandlerRegistry();
        this.serversocket = new ServerSocket(port);
    }

    public TestHttpServer() throws IOException {
        this(0);
    }

    public void registerHandler(String pattern, HttpRequestHandler handler) {
        this.reqistry.register(pattern, handler);
    }

    public void setExpectationVerifier(HttpExpectationVerifier expectationVerifier) {
        this.expectationVerifier = expectationVerifier;
    }

    private HttpServerConnection acceptConnection() throws IOException {
        Socket socket = this.serversocket.accept();
        DefaultHttpServerConnection conn = new DefaultHttpServerConnection();
        conn.bind(socket, this.params);
        return conn;
    }

    public int getPort() {
        return this.serversocket.getLocalPort();
    }

    public InetAddress getInetAddress() {
        return this.serversocket.getInetAddress();
    }

    public void start() {
        if (this.listener != null) {
            throw new IllegalStateException("Listener already running");
        }
        this.listener = new Thread(new Runnable(){

            public void run() {
                while (!TestHttpServer.this.shutdown && !Thread.interrupted()) {
                    try {
                        HttpServerConnection conn = TestHttpServer.this.acceptConnection();
                        HttpService httpService = new HttpService((HttpProcessor)TestHttpServer.this.httpproc, TestHttpServer.this.connStrategy, TestHttpServer.this.responseFactory);
                        httpService.setParams(TestHttpServer.this.params);
                        httpService.setExpectationVerifier(TestHttpServer.this.expectationVerifier);
                        httpService.setHandlerResolver((HttpRequestHandlerResolver)TestHttpServer.this.reqistry);
                        WorkerThread t = new WorkerThread(httpService, conn);
                        t.setDaemon(true);
                        t.start();
                    }
                    catch (InterruptedIOException ex) {
                        break;
                    }
                    catch (IOException e) {
                        break;
                    }
                }
            }
        });
        this.listener.start();
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        try {
            this.serversocket.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        this.listener.interrupt();
        try {
            this.listener.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class WorkerThread
    extends Thread {
        private final HttpService httpservice;
        private final HttpServerConnection conn;

        public WorkerThread(HttpService httpservice, HttpServerConnection conn) {
            this.httpservice = httpservice;
            this.conn = conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block13: {
                BasicHttpContext context = new BasicHttpContext(null);
                while (!Thread.interrupted() && this.conn.isOpen()) {
                    this.httpservice.handleRequest(this.conn, (HttpContext)context);
                }
                Object var4_2 = null;
                try {
                    this.conn.shutdown();
                }
                catch (IOException ignore) {}
                break block13;
                {
                    catch (ConnectionClosedException ex) {
                        Object var4_3 = null;
                        try {
                            this.conn.shutdown();
                        }
                        catch (IOException ignore) {}
                        break block13;
                    }
                    catch (IOException ex) {
                        System.err.println("I/O error: " + ex.getMessage());
                        Object var4_4 = null;
                        try {
                            this.conn.shutdown();
                        }
                        catch (IOException ignore) {}
                        break block13;
                    }
                    catch (HttpException ex) {
                        System.err.println("Unrecoverable HTTP protocol violation: " + ex.getMessage());
                        Object var4_5 = null;
                        try {
                            this.conn.shutdown();
                        }
                        catch (IOException ignore) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    try {
                        this.conn.shutdown();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }
}

