/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.common.http;

import android.net.TrafficStats;
import android.os.SystemClock;
import android.util.EventLog;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public class NetworkStatsEntity
extends HttpEntityWrapper {
    private static final int HTTP_STATS_EVENT = 52001;
    private final String mUa;
    private final int mUid;
    private final long mStartTx;
    private final long mStartRx;
    private final long mResponseLatency;
    private final long mProcessingStartTime;

    public NetworkStatsEntity(HttpEntity orig, String ua, int uid, long startTx, long startRx, long responseLatency, long processingStartTime) {
        super(orig);
        this.mUa = ua;
        this.mUid = uid;
        this.mStartTx = startTx;
        this.mStartRx = startRx;
        this.mResponseLatency = responseLatency;
        this.mProcessingStartTime = processingStartTime;
    }

    public InputStream getContent() throws IOException {
        InputStream orig = super.getContent();
        return new NetworkStatsInputStream(orig);
    }

    private class NetworkStatsInputStream
    extends FilterInputStream {
        public NetworkStatsInputStream(InputStream wrapped) {
            super(wrapped);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                long processingTime = SystemClock.elapsedRealtime() - NetworkStatsEntity.this.mProcessingStartTime;
                long tx = TrafficStats.getUidTxBytes((int)NetworkStatsEntity.this.mUid);
                long rx = TrafficStats.getUidRxBytes((int)NetworkStatsEntity.this.mUid);
                EventLog.writeEvent((int)52001, (Object[])new Object[]{NetworkStatsEntity.this.mUa, NetworkStatsEntity.this.mResponseLatency, processingTime, tx - NetworkStatsEntity.this.mStartTx, rx - NetworkStatsEntity.this.mStartRx});
                throw throwable;
            }
            long processingTime = SystemClock.elapsedRealtime() - NetworkStatsEntity.this.mProcessingStartTime;
            long tx = TrafficStats.getUidTxBytes((int)NetworkStatsEntity.this.mUid);
            long rx = TrafficStats.getUidRxBytes((int)NetworkStatsEntity.this.mUid);
            EventLog.writeEvent((int)52001, (Object[])new Object[]{NetworkStatsEntity.this.mUa, NetworkStatsEntity.this.mResponseLatency, processingTime, tx - NetworkStatsEntity.this.mStartTx, rx - NetworkStatsEntity.this.mStartRx});
        }
    }
}

