/*
 * Decompiled with CFR 0.152.
 */
package com.android.common;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.util.HashMap;

public class NetworkConnectivityListener {
    private static final String TAG = "NetworkConnectivityListener";
    private static final boolean DBG = false;
    private Context mContext;
    private HashMap<Handler, Integer> mHandlers = new HashMap();
    private State mState = State.UNKNOWN;
    private boolean mListening;
    private String mReason;
    private boolean mIsFailover;
    private NetworkInfo mNetworkInfo;
    private NetworkInfo mOtherNetworkInfo;
    private ConnectivityBroadcastReceiver mReceiver = new ConnectivityBroadcastReceiver();

    public synchronized void startListening(Context context) {
        if (!this.mListening) {
            this.mContext = context;
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver((BroadcastReceiver)this.mReceiver, filter);
            this.mListening = true;
        }
    }

    public synchronized void stopListening() {
        if (this.mListening) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mReceiver);
            this.mContext = null;
            this.mNetworkInfo = null;
            this.mOtherNetworkInfo = null;
            this.mIsFailover = false;
            this.mReason = null;
            this.mListening = false;
        }
    }

    public void registerHandler(Handler target, int what) {
        this.mHandlers.put(target, what);
    }

    public void unregisterHandler(Handler target) {
        this.mHandlers.remove(target);
    }

    public State getState() {
        return this.mState;
    }

    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public NetworkInfo getOtherNetworkInfo() {
        return this.mOtherNetworkInfo;
    }

    public boolean isFailover() {
        return this.mIsFailover;
    }

    public String getReason() {
        return this.mReason;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNKNOWN,
        CONNECTED,
        NOT_CONNECTED;

    }

    private class ConnectivityBroadcastReceiver
    extends BroadcastReceiver {
        private ConnectivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (!action.equals("android.net.conn.CONNECTIVITY_CHANGE") || !NetworkConnectivityListener.this.mListening) {
                Log.w((String)NetworkConnectivityListener.TAG, (String)("onReceived() called with " + NetworkConnectivityListener.this.mState.toString() + " and " + intent));
                return;
            }
            boolean noConnectivity = intent.getBooleanExtra("noConnectivity", false);
            if (noConnectivity) {
                NetworkConnectivityListener.this.mState = State.NOT_CONNECTED;
            } else {
                NetworkConnectivityListener.this.mState = State.CONNECTED;
            }
            NetworkConnectivityListener.this.mNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            NetworkConnectivityListener.this.mOtherNetworkInfo = (NetworkInfo)intent.getParcelableExtra("otherNetwork");
            NetworkConnectivityListener.this.mReason = intent.getStringExtra("reason");
            NetworkConnectivityListener.this.mIsFailover = intent.getBooleanExtra("isFailover", false);
            for (Handler target : NetworkConnectivityListener.this.mHandlers.keySet()) {
                Message message = Message.obtain((Handler)target, (int)((Integer)NetworkConnectivityListener.this.mHandlers.get(target)));
                target.sendMessage(message);
            }
        }
    }
}

