/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.google.android.apps.analytics.PersistentEventStore;
import java.util.HashMap;

public class AnalyticsReceiver
extends BroadcastReceiver {
    private static final String INSTALL_ACTION = "com.android.vending.INSTALL_REFERRER";

    public void onReceive(Context context, Intent intent) {
        String string = intent.getStringExtra("referrer");
        if (!INSTALL_ACTION.equals(intent.getAction()) || string == null) {
            return;
        }
        String string2 = AnalyticsReceiver.formatReferrer(string);
        if (string2 != null) {
            PersistentEventStore persistentEventStore = new PersistentEventStore(new PersistentEventStore.DataBaseHelper(context));
            persistentEventStore.setReferrer(string2);
            Log.d((String)"GoogleAnalyticsTracker", (String)("Stored referrer:" + string2));
        } else {
            Log.w((String)"GoogleAnalyticsTracker", (String)"Badly formatted referrer, ignored");
        }
    }

    static String formatReferrer(String string) {
        String[][] stringArrayArray;
        Object object;
        int n;
        String[] stringArray = string.split("&");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        for (n = 0; n < n2 && ((String[])(object = (stringArrayArray = stringArray2[n]).split("="))).length == 2; ++n) {
            hashMap.put(object[0], object[1]);
        }
        boolean bl = hashMap.get("utm_campaign") != null;
        n2 = hashMap.get("utm_medium") != null ? 1 : 0;
        int n3 = n = hashMap.get("utm_source") != null ? 1 : 0;
        if (!bl || n2 == 0 || n == 0) {
            Log.w((String)"GoogleAnalyticsTracker", (String)"Badly formatted referrer missing campaign, name or source");
            return null;
        }
        stringArrayArray = new String[][]{{"utmcid", (String)hashMap.get("utm_id")}, {"utmcsr", (String)hashMap.get("utm_source")}, {"utmgclid", (String)hashMap.get("gclid")}, {"utmccn", (String)hashMap.get("utm_campaign")}, {"utmcmd", (String)hashMap.get("utm_medium")}, {"utmctr", (String)hashMap.get("utm_term")}, {"utmcct", (String)hashMap.get("utm_content")}};
        object = new StringBuilder();
        boolean bl2 = true;
        for (int i = 0; i < stringArrayArray.length; ++i) {
            if (stringArrayArray[i][1] == null) continue;
            String string2 = stringArrayArray[i][1].replace("+", "%20");
            string2 = string2.replace(" ", "%20");
            if (bl2) {
                bl2 = false;
            } else {
                ((StringBuilder)object).append("|");
            }
            ((StringBuilder)object).append(stringArrayArray[i][0]).append("=").append(string2);
        }
        return ((StringBuilder)object).toString();
    }
}

