package com.github.yeriomin.workoutlog.Model;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import java.util.ArrayList;
import java.util.List;

import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.Property;
import de.greenrobot.dao.internal.DaoConfig;
import de.greenrobot.dao.internal.SqlUtils;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "EXERCISE".
*/
public class ExerciseDao extends AbstractDao<Exercise, Void> {

    public static final String TABLENAME = "EXERCISE";

    /**
     * Properties of entity Exercise.<br/>
     * Can be used for QueryBuilder and for referencing column names.
    */
    public static class Properties {
        public final static Property Timestamp = new Property(0, Long.class, "timestamp", false, "TIMESTAMP");
        public final static Property Reps = new Property(1, Integer.class, "reps", false, "REPS");
        public final static Property Weight = new Property(2, Integer.class, "weight", false, "WEIGHT");
        public final static Property TypeId = new Property(3, long.class, "typeId", false, "TYPE_ID");
    }

    private DaoSession daoSession;


    public ExerciseDao(DaoConfig config) {
        super(config);
    }
    
    public ExerciseDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(SQLiteDatabase db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"EXERCISE\" (" + //
                "\"TIMESTAMP\" INTEGER," + // 0: timestamp
                "\"REPS\" INTEGER," + // 1: reps
                "\"WEIGHT\" INTEGER," + // 2: weight
                "\"TYPE_ID\" INTEGER NOT NULL );"); // 3: typeId
        // Add Indexes
        db.execSQL("CREATE INDEX " + constraint + "timestamp ON EXERCISE" +
                " (\"TIMESTAMP\");");
    }

    /** Drops the underlying database table. */
    public static void dropTable(SQLiteDatabase db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"EXERCISE\"";
        db.execSQL(sql);
    }

    /** @inheritdoc */
    @Override
    protected void bindValues(SQLiteStatement stmt, Exercise entity) {
        stmt.clearBindings();
 
        Long timestamp = entity.getTimestamp();
        if (timestamp != null) {
            stmt.bindLong(1, timestamp);
        }
 
        Integer reps = entity.getReps();
        if (reps != null) {
            stmt.bindLong(2, reps);
        }
 
        Integer weight = entity.getWeight();
        if (weight != null) {
            stmt.bindLong(3, weight);
        }
        stmt.bindLong(4, entity.getTypeId());
    }

    @Override
    protected void attachEntity(Exercise entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    /** @inheritdoc */
    @Override
    public Void readKey(Cursor cursor, int offset) {
        return null;
    }    

    /** @inheritdoc */
    @Override
    public Exercise readEntity(Cursor cursor, int offset) {
        Exercise entity = new Exercise( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // timestamp
            cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1), // reps
            cursor.isNull(offset + 2) ? null : cursor.getInt(offset + 2), // weight
            cursor.getLong(offset + 3) // typeId
        );
        return entity;
    }
     
    /** @inheritdoc */
    @Override
    public void readEntity(Cursor cursor, Exercise entity, int offset) {
        entity.setTimestamp(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setReps(cursor.isNull(offset + 1) ? null : cursor.getInt(offset + 1));
        entity.setWeight(cursor.isNull(offset + 2) ? null : cursor.getInt(offset + 2));
        entity.setTypeId(cursor.getLong(offset + 3));
     }
    
    /** @inheritdoc */
    @Override
    protected Void updateKeyAfterInsert(Exercise entity, long rowId) {
        // Unsupported or missing PK type
        return null;
    }
    
    /** @inheritdoc */
    @Override
    public Void getKey(Exercise entity) {
        return null;
    }

    /** @inheritdoc */
    @Override    
    protected boolean isEntityUpdateable() {
        return true;
    }
    
    private String selectDeep;

    protected String getSelectDeep() {
        if (selectDeep == null) {
            StringBuilder builder = new StringBuilder("SELECT ");
            SqlUtils.appendColumns(builder, "T", getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T0", daoSession.getExerciseTypeDao().getAllColumns());
            builder.append(" FROM EXERCISE T");
            builder.append(" LEFT JOIN EXERCISE_TYPE T0 ON T.\"TYPE_ID\"=T0.\"_id\"");
            builder.append(' ');
            selectDeep = builder.toString();
        }
        return selectDeep;
    }
    
    protected Exercise loadCurrentDeep(Cursor cursor, boolean lock) {
        Exercise entity = loadCurrent(cursor, 0, lock);
        int offset = getAllColumns().length;

        ExerciseType exerciseType = loadCurrentOther(daoSession.getExerciseTypeDao(), cursor, offset);
         if(exerciseType != null) {
            entity.setExerciseType(exerciseType);
        }

        return entity;    
    }

    public Exercise loadDeep(Long key) {
        assertSinglePk();
        if (key == null) {
            return null;
        }

        StringBuilder builder = new StringBuilder(getSelectDeep());
        builder.append("WHERE ");
        SqlUtils.appendColumnsEqValue(builder, "T", getPkColumns());
        String sql = builder.toString();
        
        String[] keyArray = new String[] { key.toString() };
        Cursor cursor = db.rawQuery(sql, keyArray);
        
        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                return null;
            } else if (!cursor.isLast()) {
                throw new IllegalStateException("Expected unique result, but count was " + cursor.getCount());
            }
            return loadCurrentDeep(cursor, true);
        } finally {
            cursor.close();
        }
    }
    
    /** Reads all available rows from the given cursor and returns a list of new ImageTO objects. */
    public List<Exercise> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        List<Exercise> list = new ArrayList<Exercise>(count);
        
        if (cursor.moveToFirst()) {
            if (identityScope != null) {
                identityScope.lock();
                identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            } finally {
                if (identityScope != null) {
                    identityScope.unlock();
                }
            }
        }
        return list;
    }
    
    protected List<Exercise> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            return loadAllDeepFromCursor(cursor);
        } finally {
            cursor.close();
        }
    }
    

    /** A raw-style query where you can pass any WHERE clause and arguments. */
    public List<Exercise> queryDeep(String where, String... selectionArg) {
        Cursor cursor = db.rawQuery(getSelectDeep() + where, selectionArg);
        return loadDeepAllAndCloseCursor(cursor);
    }
 
}
