<div align="center">
    <h1>Jiyi</h1>
</div>

<a href="https://f-droid.org/en/packages/com.github.xiaoshihou.jiyi/">
    <img src="https://f-droid.org/badge/get-it-on-en.svg" height="100">
</a>
<a href="https://github.com/xiaoshihou514/jiyi/releases/latest">
    <img src="https://github.com/user-attachments/assets/22a7d628-00e8-44ee-b7b4-20325fa627d7" height="100">
</a>

Jiyi is a cross-platform encrypted voice note application.

- **Protect Your Privacy**: In today's world where cloud services are increasingly prevalent, privacy has become a black box. All features of Jiyi run locally to fully protect your privacy.
- **Hear Past Selves**: In the hustle and bustle of life, writing a diary seems like a luxury. Open your phone and record a short voice note to capture the present moment.
- **Visualize Your Journey**: Explore the world and leave behind voice notes in different corners! Jiyi supports recording the location at the time of recording, helping you visualize your travels.

![Screenshot](https://github.com/user-attachments/assets/0943329e-faa0-4786-9a47-cce64bd72ede)

## Technical Stack

- **Encryption**: [Argon2](https://en.wikipedia.org/wiki/Argon2), [ChaCha20-Poly1305](https://en.wikipedia.org/wiki/ChaCha20-Poly1305)
- **Speech Recognition System**: [Next-generation Kaldi (sherpa-onnx)](https://github.com/k2-fsa/sherpa-onnx)

## Building

Install dependencies:

```shell
sudo dnf install \
    gstreamer1 \                                     # Audio recording
    gstreamer1-devel gstreamer1-plugins-base-devel \ # Audio playback
    pam-devel \                                      # Auth
    libsecret-devel \                                # Save sensitive data
    gtk3-devel \                                     # Linux UI
    squashfs-tools                                   # Linux Appimage packaging
```

```shell
dart run build_runner build --build-filter 'package:jiyi/utils/data/*'
# Android
flutter build apk --release
# Linux
flutter build linux --release
cp -r build/linux/x64/release/bundle ./AppDir
appimage-builder
```
