// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class AppLocalizationsZh extends AppLocalizations {
  AppLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get welcome_1 => '你所记录的';

  @override
  String get welcome_2_1 => '就是';

  @override
  String get welcome_2_2 => '你的回忆';

  @override
  String get welcome_3 => '让心事沉入琥珀';

  @override
  String get welcome_4_1 => '封存';

  @override
  String get welcome_4_2 => '此刻';

  @override
  String get mk_title => '创建主密钥';

  @override
  String get mk_desc => '用来解密您的语音日志的密钥。若录音文件被转移到其他设备，需重新输入该密钥方可读取录音。';

  @override
  String get mk_warn_title => '请务必牢记主密钥！';

  @override
  String get mk_warn_desc_1 => '主密钥不可重置或找回';

  @override
  String get mk_warn_desc_2 => '，一旦丢失，您将永久无法访问已加密的语音内容。';

  @override
  String get st_title => '选择储存路径';

  @override
  String get st_desc => '所有文件均储存在本地，用户可以自行将其备份到云端或其他设备。';

  @override
  String get st_hint => '选择文件夹';

  @override
  String get st_path_placeholder => '您还未选择储存路径';

  @override
  String get st_path_prefix => '您已选择：';

  @override
  String get auth_unlock_reason => '验证身份以解锁';

  @override
  String get auth_unlock_err => '身份认证时出现错误';

  @override
  String get auth_linux_unknown_user => '未知用户';

  @override
  String get auth_linux_cancel => '取消';

  @override
  String get auth_linux_enter => '确定';

  @override
  String get mic_error_title => '麦克风初始化失败';

  @override
  String get mic_error_ok => '啊这';

  @override
  String get settings_map => '地图设置';

  @override
  String get settings_map_provider => '选择地图源';

  @override
  String get settings_map_local => '本地地图';

  @override
  String get settings_map_osm => 'OpenStreetMap';

  @override
  String get settings_map_amap => '高德地图（闭源）';

  @override
  String get settings_map_amap_satelite => '高德地图卫星图（闭源）';

  @override
  String get settings_map_custom => '其他在线地图源';

  @override
  String get settings_map_loc_path => '原始栅格文件路径';

  @override
  String get settings_map_loc_pattern => '查找规则（例：{z}/{x}-{y}.png）';

  @override
  String get settings_map_max_zoom => '最大缩放比例';

  @override
  String get settings_map_saved => '地图设置已保存';

  @override
  String get settings_map_reset => '地图设置已重置';

  @override
  String get settings_map_settings_dne => '您还未配置地图源，请在设置配置';

  @override
  String get settings_map_loc_missing_field => '有些参数还未设置，请检查后重试';

  @override
  String get settings_map_pull_desc => '你可以从以下网站下载已打包的栅格文件（最大支持10倍放大）';

  @override
  String settings_map_loc_down_src(Object src) {
    return '自$src下载地图';
  }

  @override
  String get settings_map_custom_desc =>
      '链接模板（例：https://tile.me/{z}/{x}/{y}/?key=APIKEY）';

  @override
  String get settings_map_custom_headers => 'HTTP请求头（例：{\"key\": \"xxx\"}）';

  @override
  String get settings_reset => '重置应用状态';

  @override
  String get settings_reset_mk => '重置主密钥';

  @override
  String get settings_reset_mk_desc => '在下次打开应用时重新输入主密钥';

  @override
  String get settings_reset_spath => '重置储存路径';

  @override
  String get settings_reset_spath_desc => '在下次打开应用时重新输入储存路径';

  @override
  String get settings_reset_success => '已重置';

  @override
  String get settings_reset_index => '重置索引';

  @override
  String get settings_reset_index_desc => '重新建立日志索引';

  @override
  String get settings_asr_model => '语音识别设置';

  @override
  String get settings_asr_provider => '选择语音识别模型';

  @override
  String get settings_asr_custom => '本地语音识别模型';

  @override
  String get settings_asr_saved => '语音识别设置已保存';

  @override
  String get settings_asr_reset => '语音识别设置已重置';

  @override
  String get settings_asr_single => '单个模型路径（适用于Ctc系列模型）';

  @override
  String get settings_asr_encoder => '编码器（encoder）模型路径';

  @override
  String get settings_asr_decoder => '解码器（decoder）模型路径';

  @override
  String get settings_asr_joiner => '拼接器（joiner）模型路径（适用于transducer模型）';

  @override
  String get settings_asr_tokens => '词元文件（tokens.txt）路径';

  @override
  String get settings_asr_model_type => '模型类型（根据模型名称判断）';

  @override
  String get settings_asr_picker_desc => '选择模型';

  @override
  String get settings_asr_download_desc => '请自行从sherpa-onnx下载模型，如果懒得搞可以使用预配置';

  @override
  String get settings_asr_download_exp =>
      '一般格式为sherpa-onnx-<架构>-<支持的语言>，自行下载解压后即可看到模型（onnx）文件。如果模型文件名称中有int8意味着会牺牲部分精确度换取速度和更小的内存需求。';

  @override
  String get settings_asr_missing_fields => '语音识别配置不完整';

  @override
  String get settings_asr_zh_en_streaming_zipformer => '中英双语识别（~500M）';

  @override
  String get settings_asr_zh_en_streaming_paraformer => '中英双语识别（~1G）';

  @override
  String get settings_asr_zh_streaming_ctc => '中文识别（~700M）';

  @override
  String get settings_asr_en_nemo_ctc => '英文识别（~50M）';

  @override
  String get settings_llm_model => '大模型设置';

  @override
  String get settings_llm_provider => '选择大模型';

  @override
  String get settings_llm_custom => '本地大语言模型';

  @override
  String get settings_llm_qwen3_1_7B => '千问3-1.7B';

  @override
  String get settings_llm_qwen3_4B => '千问3-4B（需要大量内存）';

  @override
  String get settings_llm_root_picker_desc => '选择模型所在文件夹';

  @override
  String get settings_llm_root_picker_cover => '选择文件夹';

  @override
  String get settings_llm_imagine_prompt_desc => '畅想功能提示词';

  @override
  String get settings_llm_saved => '大模型设置已保存';

  @override
  String get settings_llm_reset => '大模型设置已重置';

  @override
  String get settings_zdpp_custom => '本地排版模型';

  @override
  String get settings_zdpp_zh_en => '中英排版模型';

  @override
  String get settings_zdpp_zh_en_int8 => '中英排版模型（int8）';

  @override
  String get settings_zdpp_model => '自动排版设置';

  @override
  String get settings_zdpp_missing_fields => '自动排版配置不完整';

  @override
  String get settings_zdpp_saved => '自动排版设置已保存';

  @override
  String get settings_zdpp_reset => '自动排版设置已重置';

  @override
  String get settings_zdpp_provider => '选择自动排版模型';

  @override
  String get settings_zdpp_path => '模型路径';

  @override
  String get settings_zdpp_download_desc => '请自行从sherpa-onnx下载模型，如果懒得搞可以使用预配置';

  @override
  String get settings_zdpp_download_exp => 'sherpa-onnx一共就提供了三个模型，自己看着办吧';

  @override
  String get download_title => '下载';

  @override
  String download_perc(Object a, Object b) {
    return '$a：$b%';
  }

  @override
  String get download_extracting => '解压中';

  @override
  String get download_done => '完成';

  @override
  String get download_exit => '完成';

  @override
  String get cover_desc => '为日志添加标题和封面';

  @override
  String get cover_desc_hint => '输入一个emoji';

  @override
  String get metadata_title => '导入（WAV文件，pcm_s16le格式）';

  @override
  String get metadata_select_file => '选择音频文件';

  @override
  String get metadata_no_file_selected => '未选择文件';

  @override
  String get metadata_duration => '时长';

  @override
  String metadata_duration_error(Object error) {
    return '获取时长失败: $error';
  }

  @override
  String get metadata_select_datetime => '选择日期和时间';

  @override
  String get metadata_select_date => '选择日期';

  @override
  String get metadata_select_time => '选择时间';

  @override
  String get metadata_title_label => '标题';

  @override
  String get metadata_title_required => '标题不能为空';

  @override
  String get metadata_location_optional => '位置信息（可选）';

  @override
  String get metadata_latitude => '纬度';

  @override
  String get metadata_latitude_hint => '例如: 34.0522';

  @override
  String get metadata_invalid_latitude => '无效纬度（-90~90）';

  @override
  String get metadata_longitude => '经度';

  @override
  String get metadata_longitude_hint => '例如: -118.2437';

  @override
  String get metadata_invalid_longitude => '无效经度（-180~180）';

  @override
  String get metadata_cover_label => '封面（单个字符）';

  @override
  String get metadata_cover_required => '请输入一个字符';

  @override
  String get metadata_cancel => '取消';

  @override
  String get metadata_import => '导入';

  @override
  String get metadata_duration_missing => '无法获取音频时长，请重新选择文件';

  @override
  String metadata_save_error(Object msg) {
    return '导入失败：$msg';
  }

  @override
  String get metadata_edit_title => '编辑元数据';

  @override
  String get metadata_save => '保存';

  @override
  String get metadata_transcript_label => '转录文本';

  @override
  String get metadata_transcript_hint => '输入音频转录文本';

  @override
  String get metadata_missing_llm_setting => '未配置自动排版';

  @override
  String get metadata_missing_asr_setting => '未配置语音识别';

  @override
  String get metadata_zdpp => '自动排版';

  @override
  String get metadata_rebuild_transcript => '重新识别语音';

  @override
  String get untitled_cd => '未命名磁带';

  @override
  String playlist_title(Object len) {
    return '选中的记录（$len）';
  }

  @override
  String get search_hint => '搜索标题或内容...';

  @override
  String search_results_count(Object n, Object needle) {
    return '找到$n个匹配$needle的结果';
  }

  @override
  String get search_no_results => '未找到匹配结果';

  @override
  String decryption_err(Object err) {
    return '解密失败：$err，请检查主密钥是否正确';
  }

  @override
  String get transcript_empty => '未识别到文本';

  @override
  String get missing_map_settings => '未配置地图源，地理视图不可用';

  @override
  String get missing_asr_settings => '未配置转录模型，语音转文字不可用';

  @override
  String get missing_llm_settings => '未配置语言大模型，畅想不可用';

  @override
  String get missing_zdpp_settings => '未配置自动排版模型，自动排版不可用';

  @override
  String get imagine_download_geo_desc =>
      '畅想功能需要从www.geonames.org下载一次数据，用来离线获取坐标对应的城市，是否同意下载？';

  @override
  String get imagine_download_geo_yes => '确认下载';

  @override
  String get imagine_download_geo_no => '下次吧';

  @override
  String get imagine_default_prompt => 'TODO';
}
