// this file is not the one generated by ffiGen.
// ffiGen will generate [flutter_soloud_bindings_ffi_TMP.dart]
// from [ffi_gen_tmp.h] file. Read notes in the latter
// ignore_for_file: avoid_positional_boolean_parameters,require_trailing_commas
// ignore_for_file: omit_local_variable_types,public_member_api_docs

import 'dart:ffi' as ffi;
import 'dart:typed_data';

import 'package:ffi/ffi.dart';
import 'package:flutter_soloud/src/bindings/audio_data.dart';
import 'package:flutter_soloud/src/bindings/bindings_player.dart';
import 'package:flutter_soloud/src/enums.dart';
import 'package:flutter_soloud/src/exceptions/exceptions.dart';
import 'package:flutter_soloud/src/filters/filters.dart';
import 'package:flutter_soloud/src/helpers/playback_device.dart';
import 'package:flutter_soloud/src/sound_handle.dart';
import 'package:flutter_soloud/src/sound_hash.dart';
import 'package:logging/logging.dart';
import 'package:meta/meta.dart';

typedef DartVoiceEndedCallbackT
    = ffi.Pointer<ffi.NativeFunction<DartVoiceEndedCallbackTFunction>>;

typedef DartVoiceEndedCallbackTFunction = ffi.Void Function(
    ffi.Pointer<ffi.UnsignedInt>);

typedef DartdartVoiceEndedCallbackTFunction = void Function(
    ffi.Pointer<ffi.UnsignedInt>);

typedef DartFileLoadedCallbackT
    = ffi.Pointer<ffi.NativeFunction<DartFileLoadedCallbackTFunction>>;

typedef DartFileLoadedCallbackTFunction = ffi.Void Function(
    ffi.Pointer<ffi.Int32>,
    ffi.Pointer<ffi.Char>,
    ffi.Pointer<ffi.UnsignedInt>);

typedef DartdartFileLoadedCallbackTFunction = void Function(
    ffi.Pointer<ffi.Int32>,
    ffi.Pointer<ffi.Char>,
    ffi.Pointer<ffi.UnsignedInt>);

typedef DartStateChangedCallbackT
    = ffi.Pointer<ffi.NativeFunction<DartStateChangedCallbackTFunction>>;

typedef DartStateChangedCallbackTFunction = ffi.Void Function(
    ffi.Pointer<ffi.Int32>);

typedef DartdartStateChangedCallbackTFunction = void Function(
    ffi.Pointer<ffi.Int32>);

/// FFI bindings to SoLoud
@internal
class FlutterSoLoudFfi extends FlutterSoLoud {
  static final Logger _log = Logger('flutter_soloud.FlutterSoLoudFfi');

  /// Holds the symbol lookup function.
  final ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
      _lookup;

  /// The symbols are looked up in [dynamicLibrary].
  // ignore: sort_constructors_first
  FlutterSoLoudFfi(ffi.DynamicLibrary dynamicLibrary)
      : _lookup = dynamicLibrary.lookup;

  /// The symbols are looked up with [lookup].
  // ignore: sort_constructors_first
  FlutterSoLoudFfi.fromLookup(
    ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName) lookup,
  ) : _lookup = lookup;

  // ////////////////////////////////////////////////
  // Callbacks impl
  // ////////////////////////////////////////////////

  void _voiceEndedCallback(ffi.Pointer<ffi.UnsignedInt> handle) {
    _log.finest(() => 'VOICE ENDED EVENT handle: ${handle.value}');
    voiceEndedEventController.add(handle.value);
    // Must free a pointer made on cpp. On Windows this must be freed
    // there and cannot use `calloc.free(...)`
    nativeFree(handle.cast<ffi.Void>());
  }

  ///
  void _fileLoadedCallback(
    ffi.Pointer<ffi.Int32> error,
    ffi.Pointer<ffi.Char> completeFileName,
    ffi.Pointer<ffi.UnsignedInt> hash,
  ) {
    _log.finest(() =>
        'FILE LOADED EVENT error: ${PlayerErrors.values[error.value].name}  '
        'hash: ${hash.value}  '
        'file: ${completeFileName.cast<Utf8>().toDartString()}');
    final result = <String, dynamic>{
      'error': error.value,
      'completeFileName': completeFileName.cast<Utf8>().toDartString(),
      'hash': hash.value,
    };
    fileLoadedEventsController.add(result);
    // Must free a pointer made on cpp. On Windows this must be freed
    // there and cannot use `calloc.free(...)`
    nativeFree(error.cast<ffi.Void>());
    nativeFree(completeFileName.cast<ffi.Void>());
    nativeFree(hash.cast<ffi.Void>());
  }

  void _stateChangedCallback(ffi.Pointer<ffi.Int32> state) {
    final s = PlayerStateNotification.values[state.value];
    // Must free a pointer made on cpp. On Windows this must be freed
    // there and cannot use `calloc.free(state)`
    nativeFree(state.cast<ffi.Void>());
    _log.finest(() => 'STATE CHANGED EVENT state: $s');
    stateChangedController.add(s);
  }

  @override
  Future<void> setDartEventCallbacks() async {
    // Create a NativeCallable for the Dart functions
    final nativeVoiceEndedCallable =
        ffi.NativeCallable<DartVoiceEndedCallbackTFunction>.listener(
      _voiceEndedCallback,
    );
    final nativeFileLoadedCallable =
        ffi.NativeCallable<DartFileLoadedCallbackTFunction>.listener(
      _fileLoadedCallback,
    );
    final nativeStateChangedCallable =
        ffi.NativeCallable<DartStateChangedCallbackTFunction>.listener(
      _stateChangedCallback,
    );

    _setDartEventCallback(
      nativeVoiceEndedCallable.nativeFunction,
      nativeFileLoadedCallable.nativeFunction,
      nativeStateChangedCallable.nativeFunction,
    );
  }

  late final _setDartEventCallbackPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(DartVoiceEndedCallbackT, DartFileLoadedCallbackT,
              DartStateChangedCallbackT)>>('setDartEventCallback');
  late final _setDartEventCallback = _setDartEventCallbackPtr.asFunction<
      void Function(DartVoiceEndedCallbackT, DartFileLoadedCallbackT,
          DartStateChangedCallbackT)>();

  // ////////////////////////////////////////////////
  // Navtive bindings
  // ////////////////////////////////////////////////

  @override
  bool areOpusOggLibsAvailable() {
    return _areOpusOggLibsAvailable();
  }

  late final _areOpusOggLibsAvailablePtr =
      _lookup<ffi.NativeFunction<ffi.Bool Function()>>(
    'areOpusOggLibsAvailable',
  );
  late final _areOpusOggLibsAvailable =
      _areOpusOggLibsAvailablePtr.asFunction<bool Function()>();

  /// When allocating memory in C code, more attention must be given when
  /// we are on Windows OS. It's not good to call `calloc.free()` because
  /// Windows could use different allocating methods for this and the same
  /// must be used freeing it. `calloc.free()` use the standard `free()` and
  /// doesn't have problems using it in other OSes.
  void nativeFree(ffi.Pointer<ffi.Void> pointer) {
    return _nativeFree(pointer);
  }

  late final _nativeFreePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>(
          'nativeFree');
  late final _nativeFree =
      _nativeFreePtr.asFunction<void Function(ffi.Pointer<ffi.Void>)>();

  @override
  PlayerErrors initEngine(
    int deviceId,
    int sampleRate,
    int bufferSize,
    Channels channels,
  ) {
    final ret = _initEngine(
      deviceId,
      sampleRate,
      bufferSize,
      channels.count,
    );
    return PlayerErrors.values[ret];
  }

  late final _initEnginePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.Int, ffi.UnsignedInt, ffi.UnsignedInt,
              ffi.UnsignedInt)>>('initEngine');
  late final _initEngine =
      _initEnginePtr.asFunction<int Function(int, int, int, int)>();

  @override
  PlayerErrors changeDevice(int deviceId) {
    final ret = _changeDevice(deviceId);
    return PlayerErrors.values[ret];
  }

  late final _changeDevicePtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(ffi.Int)>>(
          'changeDevice');
  late final _changeDevice = _changeDevicePtr.asFunction<int Function(int)>();

  @override
  List<PlaybackDevice> listPlaybackDevices() {
    final ret = <PlaybackDevice>[];
    final ffi.Pointer<ffi.Pointer<ffi.Char>> deviceNames =
        calloc(ffi.sizeOf<ffi.Pointer<ffi.Pointer<ffi.Char>>>() * 255);
    final ffi.Pointer<ffi.Pointer<ffi.Int>> deviceIds =
        calloc(ffi.sizeOf<ffi.Pointer<ffi.Pointer<ffi.Int>>>() * 50);
    final ffi.Pointer<ffi.Pointer<ffi.Int>> deviceIsDefault =
        calloc(ffi.sizeOf<ffi.Pointer<ffi.Pointer<ffi.Int>>>() * 50);
    final ffi.Pointer<ffi.Int> nDevices = calloc();

    _listPlaybackDevices(
      deviceNames,
      deviceIds,
      deviceIsDefault,
      nDevices,
    );

    final ndev = nDevices.value;
    for (var i = 0; i < ndev; i++) {
      final s1 = (deviceNames + i).value;
      final s = s1.cast<Utf8>().toDartString();
      final id1 = (deviceIds + i).value;
      final id = id1.value;
      final n1 = (deviceIsDefault + i).value;
      final n = n1.value;
      ret.add(PlaybackDevice(id, n == 1, s));
    }

    /// Free allocated memory is done in C.
    /// This work on all platforms but not on win.
    // for (int i = 0; i < ndev; i++) {
    //   calloc.free(devices.elementAt(i).value.ref.name);
    //   calloc.free(devices.elementAt(i).value);
    // }
    _freeListPlaybackDevices(
      deviceNames,
      deviceIds,
      deviceIsDefault,
      ndev,
    );

    calloc
      ..free(deviceNames)
      ..free(deviceIds)
      ..free(nDevices);
    return ret;
  }

  late final _listPlaybackDevicesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Pointer<ffi.Pointer<ffi.Int>>,
              ffi.Pointer<ffi.Pointer<ffi.Int>>,
              ffi.Pointer<ffi.Int>)>>('listPlaybackDevices');
  late final _listPlaybackDevices = _listPlaybackDevicesPtr.asFunction<
      void Function(
          ffi.Pointer<ffi.Pointer<ffi.Char>>,
          ffi.Pointer<ffi.Pointer<ffi.Int>>,
          ffi.Pointer<ffi.Pointer<ffi.Int>>,
          ffi.Pointer<ffi.Int>)>();

  void freeListPlaybackDevices(
    ffi.Pointer<ffi.Pointer<ffi.Char>> devicesName,
    ffi.Pointer<ffi.Pointer<ffi.Int>> deviceId,
    ffi.Pointer<ffi.Pointer<ffi.Int>> isDefault,
    int nDevices,
  ) {
    return _freeListPlaybackDevices(
      devicesName,
      deviceId,
      isDefault,
      nDevices,
    );
  }

  late final _freeListPlaybackDevicesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<ffi.Pointer<ffi.Char>>,
              ffi.Pointer<ffi.Pointer<ffi.Int>>,
              ffi.Pointer<ffi.Pointer<ffi.Int>>,
              ffi.Int)>>('freeListPlaybackDevices');
  late final _freeListPlaybackDevices = _freeListPlaybackDevicesPtr.asFunction<
      void Function(
          ffi.Pointer<ffi.Pointer<ffi.Char>>,
          ffi.Pointer<ffi.Pointer<ffi.Int>>,
          ffi.Pointer<ffi.Pointer<ffi.Int>>,
          int)>();

  @override
  void deinit() {
    return _dispose();
  }

  late final _disposePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function()>>('dispose');
  late final _dispose = _disposePtr.asFunction<void Function()>();

  @override
  bool isInited() {
    return _isInited() == 1;
  }

  late final _isInitedPtr = _lookup<ffi.NativeFunction<ffi.Int Function()>>(
    'isInited',
  );
  late final _isInited = _isInitedPtr.asFunction<int Function()>();

  /// After loading the file, the [_fileLoadedCallback] will call the
  /// Dart function defined with [_setDartEventCallback] which gives back
  /// the error and the new hash.
  @override
  void loadFile(
    String completeFileName,
    LoadMode mode,
  ) {
    final ffi.Pointer<ffi.UnsignedInt> h =
        calloc(ffi.sizeOf<ffi.UnsignedInt>());
    final ffi.Pointer<Utf8> cString = completeFileName.toNativeUtf8();
    _loadFile(
      cString,
      mode == LoadMode.memory ? 1 : 0,
    );
    calloc
      ..free(cString)
      ..free(h);
  }

  late final _loadFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Pointer<Utf8>,
            ffi.Int,
          )>>('loadFile');
  late final _loadFile =
      _loadFilePtr.asFunction<void Function(ffi.Pointer<Utf8>, int)>();

  @override
  ({PlayerErrors error, SoundHash soundHash}) loadMem(
    String uniqueName,
    Uint8List buffer,
    LoadMode mode,
  ) {
    final ffi.Pointer<ffi.UnsignedInt> hash =
        calloc(ffi.sizeOf<ffi.UnsignedInt>());
    final ffi.Pointer<ffi.Uint8> bufferPtr = calloc(buffer.length);
    for (var i = 0; i < buffer.length; i++) {
      bufferPtr[i] = buffer[i];
    }

    final ffi.Pointer<Utf8> cString = uniqueName.toNativeUtf8();
    final e = _loadMem(
      cString,
      bufferPtr,
      buffer.length,
      mode == LoadMode.memory ? 1 : 0,
      hash,
    );
    final soundHash = SoundHash(hash.value);
    final ret = (error: PlayerErrors.values[e], soundHash: soundHash);
    calloc
      ..free(hash)
      ..free(cString);
    return ret;
  }

  late final _loadMemPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.Pointer<Utf8>, ffi.Pointer<ffi.Uint8>, ffi.Int,
              ffi.Int, ffi.Pointer<ffi.UnsignedInt>)>>('loadMem');
  late final _loadMem = _loadMemPtr.asFunction<
      int Function(ffi.Pointer<Utf8>, ffi.Pointer<ffi.Uint8>, int, int,
          ffi.Pointer<ffi.UnsignedInt>)>();

  @override
  ({PlayerErrors error, SoundHash soundHash}) setBufferStream(
    int maxBufferSize,
    BufferingType bufferingType,
    double bufferingTimeNeeds,
    int sampleRate,
    int channels,
    int format,
    OnBufferingCallbackTFunction? onBuffering,
  ) {
    // Create a NativeCallable for the given [onBuffering] callback.
    ffi.NativeCallable<ffi.Void Function(ffi.Bool, ffi.Int, ffi.Double)>?
        nativeOnBufferingCallable;
    if (onBuffering != null) {
      nativeOnBufferingCallable = ffi.NativeCallable<
          ffi.Void Function(ffi.Bool, ffi.Int, ffi.Double)>.listener(
        onBuffering,
      );
    }

    final ffi.Pointer<ffi.UnsignedInt> hash =
        calloc(ffi.sizeOf<ffi.UnsignedInt>());
    final e = _setBufferStream(
      hash,
      maxBufferSize,
      bufferingType.index,
      bufferingTimeNeeds,
      sampleRate,
      channels,
      format,
      nativeOnBufferingCallable?.nativeFunction ?? ffi.nullptr,
    );
    final soundHash = SoundHash(hash.value);
    final ret = (error: PlayerErrors.values[e], soundHash: soundHash);
    calloc.free(hash);
    return ret;
  }

  late final _setBufferStreamPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.UnsignedLong,
              ffi.UnsignedInt,
              ffi.Double,
              ffi.UnsignedInt,
              ffi.UnsignedInt,
              ffi.Int,
              ffi.Pointer<
                  ffi.NativeFunction<
                      ffi.Void Function(ffi.Bool, ffi.Int,
                          ffi.Double)>>)>>('setBufferStream');
  late final _setBufferStream = _setBufferStreamPtr.asFunction<
      int Function(
        ffi.Pointer<ffi.UnsignedInt>,
        int,
        int,
        double,
        int,
        int,
        int,
        ffi.Pointer<
            ffi
            .NativeFunction<ffi.Void Function(ffi.Bool, ffi.Int, ffi.Double)>>,
      )>();

  @override
  PlayerErrors resetBufferStream(SoundHash soundHash) {
    final e = _resetBufferStream(soundHash.hash);
    return PlayerErrors.values[e];
  }

  late final _resetBufferStreamPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(ffi.UnsignedInt)>>(
          'resetBufferStream');
  late final _resetBufferStream =
      _resetBufferStreamPtr.asFunction<int Function(int)>();

  @override
  PlayerErrors addAudioDataStream(
    int hash,
    Uint8List audioChunk,
  ) {
    final ffi.Pointer<ffi.Uint8> audioChunkPtr = calloc(audioChunk.length);
    for (var i = 0; i < audioChunk.length; i++) {
      audioChunkPtr[i] = audioChunk[i];
    }
    final e = _addAudioDataStream(
      hash,
      audioChunkPtr,
      audioChunk.length,
    );
    return PlayerErrors.values[e];
  }

  late final _addAudioDataStreamPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.UnsignedInt, ffi.Pointer<ffi.Uint8>,
              ffi.UnsignedInt)>>('addAudioDataStream');
  late final _addAudioDataStream = _addAudioDataStreamPtr
      .asFunction<int Function(int, ffi.Pointer<ffi.Uint8>, int)>();

  @override
  PlayerErrors setDataIsEnded(SoundHash soundHash) {
    final e = _setDataIsEnded(soundHash.hash);
    return PlayerErrors.values[e];
  }

  late final _setDataIsEndedPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function(ffi.UnsignedInt)>>(
          'setDataIsEnded');
  late final _setDataIsEnded =
      _setDataIsEndedPtr.asFunction<int Function(int)>();

  @override
  ({PlayerErrors error, int sizeInBytes}) getBufferSize(SoundHash soundHash) {
    final ffi.Pointer<ffi.UnsignedInt> size =
        calloc(ffi.sizeOf<ffi.UnsignedInt>());
    final e = _getBufferSize(soundHash.hash, size);
    final ret = (error: PlayerErrors.values[e], sizeInBytes: size.value);
    calloc.free(size);
    return ret;
  }

  late final _getBufferSizePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.UnsignedInt, ffi.Pointer<ffi.UnsignedInt>)>>('getBufferSize');
  late final _getBufferSize = _getBufferSizePtr
      .asFunction<int Function(int, ffi.Pointer<ffi.UnsignedInt>)>();

  @override
  ({PlayerErrors error, SoundHash soundHash}) loadWaveform(
    WaveForm waveform,
    bool superWave,
    double scale,
    double detune,
  ) {
    final ffi.Pointer<ffi.UnsignedInt> h =
        calloc(ffi.sizeOf<ffi.UnsignedInt>());
    final e = _loadWaveform(
      waveform.index,
      superWave ? 1 : 0,
      scale,
      detune,
      h,
    );
    final soundHash = SoundHash(h.value);
    final ret = (error: PlayerErrors.values[e], soundHash: soundHash);
    calloc.free(h);
    return ret;
  }

  late final _loadWaveformPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.Int, ffi.Int, ffi.Float, ffi.Float,
              ffi.Pointer<ffi.UnsignedInt>)>>('loadWaveform');
  late final _loadWaveform = _loadWaveformPtr.asFunction<
      int Function(int, int, double, double, ffi.Pointer<ffi.UnsignedInt>)>();

  @override
  void setWaveformScale(SoundHash hash, double newScale) {
    return _setWaveformScale(hash.hash, newScale);
  }

  late final _setWaveformScalePtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Float)>>(
      'setWaveformScale');
  late final _setWaveformScale =
      _setWaveformScalePtr.asFunction<void Function(int, double)>();

  @override
  void setWaveformDetune(SoundHash hash, double newDetune) {
    return _setWaveformDetune(hash.hash, newDetune);
  }

  late final _setWaveformDetunePtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Float)>>(
      'setWaveformDetune');
  late final _setWaveformDetune =
      _setWaveformDetunePtr.asFunction<void Function(int, double)>();

  @override
  void setWaveformFreq(SoundHash hash, double newFreq) {
    return _setWaveformFreq(hash.hash, newFreq);
  }

  late final _setWaveformFreqPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Float)>>(
      'setWaveformFreq');
  late final _setWaveformFreq =
      _setWaveformFreqPtr.asFunction<void Function(int, double)>();

  @override
  void setWaveformSuperWave(SoundHash hash, int superwave) {
    return _setSuperWave(hash.hash, superwave);
  }

  late final _setSuperWavePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Int)>>(
          'setSuperWave');
  late final _setSuperWave =
      _setSuperWavePtr.asFunction<void Function(int, int)>();

  @override
  void setWaveform(SoundHash hash, WaveForm newWaveform) {
    return _setWaveform(hash.hash, newWaveform.index);
  }

  late final _setWaveformPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Int)>>(
          'setWaveform');
  late final _setWaveform =
      _setWaveformPtr.asFunction<void Function(int, int)>();

  @override
  ({PlayerErrors error, SoundHandle handle}) speechText(String textToSpeech) {
    final ffi.Pointer<ffi.UnsignedInt> handle = calloc();
    final ffi.Pointer<Utf8> cString = textToSpeech.toNativeUtf8();
    final e = _speechText(
      cString,
      handle,
    );
    final ret =
        (error: PlayerErrors.values[e], handle: SoundHandle(handle.value));
    calloc.free(handle);
    return ret;
  }

  late final _speechTextPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(
            ffi.Pointer<Utf8>,
            ffi.Pointer<ffi.UnsignedInt>,
          )>>('speechText');
  late final _speechText = _speechTextPtr.asFunction<
      int Function(ffi.Pointer<Utf8>, ffi.Pointer<ffi.UnsignedInt>)>();

  @override
  void pauseSwitch(SoundHandle handle) {
    return _pauseSwitch(handle.id);
  }

  late final _pauseSwitchPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt)>>(
    'pauseSwitch',
  );
  late final _pauseSwitch = _pauseSwitchPtr.asFunction<void Function(int)>();

  @override
  void setPause(SoundHandle handle, int pause) {
    return _setPause(handle.id, pause);
  }

  late final _setPausePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Int)>>(
          'setPause');
  late final _setPause = _setPausePtr.asFunction<void Function(int, int)>();

  @override
  bool getPause(SoundHandle handle) {
    return _getPause(handle.id) == 1;
  }

  late final _getPausePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.UnsignedInt)>>(
    'getPause',
  );
  late final _getPause = _getPausePtr.asFunction<int Function(int)>();

  @override
  void setRelativePlaySpeed(SoundHandle handle, double speed) {
    return _setRelativePlaySpeed(handle.id, speed);
  }

  late final _setRelativePlaySpeedPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Float)>>(
      'setRelativePlaySpeed');
  late final _setRelativePlaySpeed =
      _setRelativePlaySpeedPtr.asFunction<void Function(int, double)>();

  /// Return the current play speed.
  ///
  /// [handle] the sound handle
  @override
  double getRelativePlaySpeed(SoundHandle handle) {
    return _getRelativePlaySpeed(handle.id);
  }

  late final _getRelativePlaySpeedPtr =
      _lookup<ffi.NativeFunction<ffi.Float Function(ffi.UnsignedInt)>>(
          'getRelativePlaySpeed');
  late final _getRelativePlaySpeed =
      _getRelativePlaySpeedPtr.asFunction<double Function(int)>();

  @override
  ({PlayerErrors error, SoundHandle newHandle}) play(
    SoundHash soundHash, {
    double volume = 1,
    double pan = 0,
    bool paused = false,
    bool looping = false,
    Duration loopingStartAt = Duration.zero,
  }) {
    final ffi.Pointer<ffi.UnsignedInt> handle = calloc();
    final hash = soundHash.hash;
    final e = _play(
      hash,
      volume,
      pan,
      paused ? 1 : 0,
      looping ? 1 : 0,
      loopingStartAt.toDouble(),
      handle,
    );
    final ret =
        (error: PlayerErrors.values[e], newHandle: SoundHandle(handle.value));
    calloc.free(handle);
    return ret;
  }

  late final _playPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.UnsignedInt, ffi.Float, ffi.Float, ffi.Int,
              ffi.Int, ffi.Double, ffi.Pointer<ffi.UnsignedInt>)>>('play');
  late final _play = _playPtr.asFunction<
      int Function(int, double, double, int, int, double,
          ffi.Pointer<ffi.UnsignedInt>)>();

  @override
  void stop(SoundHandle handle) {
    return _stop(handle.id);
  }

  late final _stopPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt)>>('stop');
  late final _stop = _stopPtr.asFunction<void Function(int)>();

  @override
  void disposeSound(SoundHash soundHash) {
    return _disposeSound(soundHash.hash);
  }

  late final _disposeSoundPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt)>>(
    'disposeSound',
  );
  late final _disposeSound = _disposeSoundPtr.asFunction<void Function(int)>();

  @override
  void disposeAllSound() {
    return _disposeAllSound();
  }

  late final _disposeAllSoundPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function()>>('disposeAllSound');
  late final _disposeAllSound =
      _disposeAllSoundPtr.asFunction<void Function()>();

  @override
  bool getLooping(SoundHandle handle) {
    return _getLooping(handle.id) == 1;
  }

  late final _getLoopingPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.UnsignedInt)>>(
          'getLooping');
  late final _getLooping = _getLoopingPtr.asFunction<int Function(int)>();

  @override
  void setLooping(SoundHandle handle, bool enable) {
    return _setLooping(handle.id, enable ? 1 : 0);
  }

  late final _setLoopingPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Int)>>(
    'setLooping',
  );
  late final _setLooping = _setLoopingPtr.asFunction<void Function(int, int)>();

  @override
  Duration getLoopPoint(SoundHandle handle) {
    return _getLoopPoint(handle.id).toDuration();
  }

  late final _getLoopPointPtr =
      _lookup<ffi.NativeFunction<ffi.Double Function(ffi.UnsignedInt)>>(
          'getLoopPoint');
  late final _getLoopPoint =
      _getLoopPointPtr.asFunction<double Function(int)>();

  @override
  void setLoopPoint(SoundHandle handle, Duration timestamp) {
    _setLoopPoint(handle.id, timestamp.toDouble());
  }

  late final _setLoopPointPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Double)>>(
      'setLoopPoint');
  late final _setLoopPoint =
      _setLoopPointPtr.asFunction<void Function(int, double)>();

  @override
  void setVisualizationEnabled(bool enabled) {
    return _setVisualizationEnabled(
      enabled ? 1 : 0,
    );
  }

  late final _setVisualizationEnabledPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Int)>>(
    'setVisualizationEnabled',
  );
  late final _setVisualizationEnabled =
      _setVisualizationEnabledPtr.asFunction<void Function(int)>();

  @override
  bool getVisualizationEnabled() {
    return _getVisualizationEnabled() == 1;
  }

  late final _getVisualizationEnabledPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function()>>(
          'getVisualizationEnabled');
  late final _getVisualizationEnabled =
      _getVisualizationEnabledPtr.asFunction<int Function()>();

  @override
  bool getFft(AudioData fft) {
    final isTheSameAsBefore = calloc<ffi.Bool>();
    _getFft(fft.ctrl.samplesWave, isTheSameAsBefore);
    final ret = isTheSameAsBefore.value;
    calloc.free(isTheSameAsBefore);
    return ret;
  }

  late final _getFftPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<ffi.Pointer<ffi.Float>>,
              ffi.Pointer<ffi.Bool>)>>('getFft');
  late final _getFft = _getFftPtr.asFunction<
      void Function(
          ffi.Pointer<ffi.Pointer<ffi.Float>>, ffi.Pointer<ffi.Bool>)>();

  @override
  bool getWave(AudioData wave) {
    final isTheSameAsBefore = calloc<ffi.Bool>();
    _getWave(wave.ctrl.samplesWave, isTheSameAsBefore);
    final ret = isTheSameAsBefore.value;
    calloc.free(isTheSameAsBefore);
    return ret;
  }

  late final _getWavePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<ffi.Pointer<ffi.Float>>,
              ffi.Pointer<ffi.Bool>)>>('getWave');
  late final _getWave = _getWavePtr.asFunction<
      void Function(
          ffi.Pointer<ffi.Pointer<ffi.Float>>, ffi.Pointer<ffi.Bool>)>();

  @override
  void setFftSmoothing(double smooth) {
    return _setFftSmoothing(smooth);
  }

  late final _setFftSmoothingPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Float)>>(
    'setFftSmoothing',
  );
  late final _setFftSmoothing =
      _setFftSmoothingPtr.asFunction<void Function(double)>();

  @override
  bool getAudioTexture(AudioData samples) {
    final isTheSameAsBefore = calloc<ffi.Bool>();
    _getAudioTexture(samples.ctrl.samples1D, isTheSameAsBefore);
    final ret = isTheSameAsBefore.value;
    calloc.free(isTheSameAsBefore);
    return ret;
  }

  late final _getAudioTexturePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.Pointer<ffi.Pointer<ffi.Float>>, ffi.Pointer<ffi.Bool>)>>(
    'getAudioTexture',
  );
  late final _getAudioTexture = _getAudioTexturePtr.asFunction<
      void Function(
          ffi.Pointer<ffi.Pointer<ffi.Float>>, ffi.Pointer<ffi.Bool>)>();

  @override
  bool getAudioTexture2D(AudioData samples) {
    final isTheSameAsBefore = calloc<ffi.Bool>();
    _getAudioTexture2D(samples.ctrl.samples2D, isTheSameAsBefore);
    final ret = isTheSameAsBefore.value;
    calloc.free(isTheSameAsBefore);
    return ret;
  }

  late final _getAudioTexture2DPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.Pointer<ffi.Pointer<ffi.Float>>,
              ffi.Pointer<ffi.Bool>)>>('getAudioTexture2D');
  late final _getAudioTexture2D = _getAudioTexture2DPtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.Float>>, ffi.Pointer<ffi.Bool>)>();

  @override
  double getTextureValue(int row, int column) {
    return _getTextureValue(row, column);
  }

  late final _getTextureValuePtr =
      _lookup<ffi.NativeFunction<ffi.Float Function(ffi.Int, ffi.Int)>>(
          'getTextureValue');
  late final _getTextureValue =
      _getTextureValuePtr.asFunction<double Function(int, int)>();

  @override
  Duration getLength(SoundHash soundHash) {
    return _getLength(soundHash.hash).toDuration();
  }

  late final _getLengthPtr =
      _lookup<ffi.NativeFunction<ffi.Double Function(ffi.UnsignedInt)>>(
    'getLength',
  );
  late final _getLength = _getLengthPtr.asFunction<double Function(int)>();

  @override
  int seek(SoundHandle handle, Duration time) {
    return _seek(handle.id, time.toDouble());
  }

  late final _seekPtr = _lookup<
      ffi.NativeFunction<ffi.Int32 Function(ffi.UnsignedInt, ffi.Float)>>(
    'seek',
  );
  late final _seek = _seekPtr.asFunction<int Function(int, double)>();

  @override
  Duration getPosition(SoundHandle handle) {
    return _getPosition(handle.id).toDuration();
  }

  late final _getPositionPtr =
      _lookup<ffi.NativeFunction<ffi.Double Function(ffi.UnsignedInt)>>(
    'getPosition',
  );
  late final _getPosition = _getPositionPtr.asFunction<double Function(int)>();

  @override
  double getGlobalVolume() {
    return _getGlobalVolume();
  }

  late final _getGlobalVolumePtr =
      _lookup<ffi.NativeFunction<ffi.Double Function()>>('getGlobalVolume');
  late final _getGlobalVolume =
      _getGlobalVolumePtr.asFunction<double Function()>();

  @override
  int setGlobalVolume(double volume) {
    return _setGlobalVolume(volume);
  }

  late final _setGlobalVolumePtr =
      _lookup<ffi.NativeFunction<ffi.Int32 Function(ffi.Float)>>(
          'setGlobalVolume');
  late final _setGlobalVolume =
      _setGlobalVolumePtr.asFunction<int Function(double)>();

  @override
  double getVolume(SoundHandle handle) {
    return _getVolume(handle.id);
  }

  late final _getVolumePtr =
      _lookup<ffi.NativeFunction<ffi.Double Function(ffi.UnsignedInt)>>(
          'getVolume');
  late final _getVolume = _getVolumePtr.asFunction<double Function(int)>();

  @override
  int setVolume(SoundHandle handle, double volume) {
    return _setVolume(handle.id, volume);
  }

  late final _setVolumePtr = _lookup<
          ffi.NativeFunction<ffi.Int32 Function(ffi.UnsignedInt, ffi.Float)>>(
      'setVolume');
  late final _setVolume = _setVolumePtr.asFunction<int Function(int, double)>();

  /// Get a sound's current pan setting.
  ///
  /// [handle] the sound handle.
  /// Returns the range of the pan values is -1 to 1, where -1 is left, 0 is
  /// middle and and 1 is right.
  @override
  double getPan(SoundHandle handle) {
    // Note that because of the float<=>double conversion precision error
    // (SoLoud lib uses floats), the returned value is not precise.
    return _getPan(handle.id);
  }

  late final _getPanPtr =
      _lookup<ffi.NativeFunction<ffi.Double Function(ffi.UnsignedInt)>>(
          'getPan');
  late final _getPan = _getPanPtr.asFunction<double Function(int)>();

  /// Set a sound's current pan setting.
  ///
  /// [handle] the sound handle.
  /// [pan] the range of the pan values is -1 to 1, where -1 is left, 0 is
  /// middle and and 1 is right.
  @override
  void setPan(SoundHandle handle, double pan) {
    return _setPan(handle.id, pan);
  }

  late final _setPanPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Double)>>(
      'setPan');
  late final _setPan = _setPanPtr.asFunction<void Function(int, double)>();

  /// Set the left/right volumes directly.
  /// Note that this does not affect the value returned by getPan.
  ///
  /// [handle] the sound handle.
  /// [panLeft] value for the left pan.
  /// [panRight] value for the right pan.
  @override
  void setPanAbsolute(SoundHandle handle, double panLeft, double panRight) {
    return _setPanAbsolute(handle.id, panLeft, panRight);
  }

  late final _setPanAbsolutePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.UnsignedInt, ffi.Double, ffi.Double)>>('setPanAbsolute');
  late final _setPanAbsolute =
      _setPanAbsolutePtr.asFunction<void Function(int, double, double)>();

  /// Check if a handle is still valid.
  ///
  /// [handle] handle to check
  /// Return true if it still exists
  @override
  bool getIsValidVoiceHandle(SoundHandle handle) {
    return _getIsValidVoiceHandle(handle.id) == 1;
  }

  late final _getIsValidVoiceHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.UnsignedInt)>>(
    'getIsValidVoiceHandle',
  );
  late final _getIsValidVoiceHandle =
      _getIsValidVoiceHandlePtr.asFunction<int Function(int)>();

  @override
  int getActiveVoiceCount() {
    return _getActiveVoiceCount();
  }

  late final _getActiveVoiceCountPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function()>>(
          'getActiveVoiceCount');
  late final _getActiveVoiceCount =
      _getActiveVoiceCountPtr.asFunction<int Function()>();

  @override
  int countAudioSource(SoundHash soundHash) {
    return _countAudioSource(soundHash.hash);
  }

  late final _countAudioSourcePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.UnsignedInt)>>(
          'countAudioSource');
  late final _countAudioSource =
      _countAudioSourcePtr.asFunction<int Function(int)>();

  @override
  int getVoiceCount() {
    return _getVoiceCount();
  }

  late final _getVoiceCountPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function()>>('getVoiceCount');
  late final _getVoiceCount = _getVoiceCountPtr.asFunction<int Function()>();

  @override
  bool getProtectVoice(SoundHandle handle) {
    return _getProtectVoice(handle.id) == 1;
  }

  late final _getProtectVoicePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.UnsignedInt)>>(
          'getProtectVoice');
  late final _getProtectVoice =
      _getProtectVoicePtr.asFunction<int Function(int)>();

  @override
  void setProtectVoice(SoundHandle handle, bool protect) {
    return _setProtectVoice(handle.id, protect ? 1 : 0);
  }

  late final _setProtectVoicePtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Int)>>(
          'setProtectVoice');
  late final _setProtectVoice =
      _setProtectVoicePtr.asFunction<void Function(int, int)>();

  @override
  void setInaudibleBehavior(
    SoundHandle handle,
    bool mustTick,
    bool kill,
  ) {
    return _setInaudibleBehavior(
      handle.id,
      mustTick,
      kill,
    );
  }

  late final _setInaudibleBehaviorPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
              ffi.UnsignedInt, ffi.Bool, ffi.Bool)>>('setInaudibleBehavior');
  late final _setInaudibleBehavior =
      _setInaudibleBehaviorPtr.asFunction<void Function(int, bool, bool)>();

  @override
  int getMaxActiveVoiceCount() {
    return _getMaxActiveVoiceCount();
  }

  late final _getMaxActiveVoiceCountPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function()>>(
          'getMaxActiveVoiceCount');
  late final _getMaxActiveVoiceCount =
      _getMaxActiveVoiceCountPtr.asFunction<int Function()>();

  @override
  void setMaxActiveVoiceCount(int maxVoiceCount) {
    return _setMaxActiveVoiceCount(maxVoiceCount);
  }

  late final _setMaxActiveVoiceCountPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt)>>(
          'setMaxActiveVoiceCount');
  late final _setMaxActiveVoiceCount =
      _setMaxActiveVoiceCountPtr.asFunction<void Function(int)>();

  /////////////////////////////////////////
  /// voice groups
  /////////////////////////////////////////

  @override
  SoundHandle createVoiceGroup() {
    final ret = _createVoiceGroup();
    return SoundHandle(ret > 0 ? ret : -1);
  }

  late final _createVoiceGroupPtr =
      _lookup<ffi.NativeFunction<ffi.UnsignedInt Function()>>(
          'createVoiceGroup');
  late final _createVoiceGroup =
      _createVoiceGroupPtr.asFunction<int Function()>();

  @override
  void destroyVoiceGroup(SoundHandle handle) {
    return _destroyVoiceGroup(handle.id);
  }

  late final _destroyVoiceGroupPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt)>>(
          'destroyVoiceGroup');
  late final _destroyVoiceGroup =
      _destroyVoiceGroupPtr.asFunction<void Function(int)>();

  @override
  void addVoicesToGroup(
    SoundHandle voiceGroupHandle,
    List<SoundHandle> voiceHandles,
  ) {
    for (final handle in voiceHandles) {
      _addVoiceToGroup(voiceGroupHandle.id, handle.id);
    }
  }

  late final _addVoiceToGroupPtr = _lookup<
          ffi
          .NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.UnsignedInt)>>(
      'addVoiceToGroup');
  late final _addVoiceToGroup =
      _addVoiceToGroupPtr.asFunction<void Function(int, int)>();

  @override
  bool isVoiceGroup(SoundHandle handle) {
    return _isVoiceGroup(handle.id) == 1;
  }

  late final _isVoiceGroupPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.UnsignedInt)>>(
          'isVoiceGroup');
  late final _isVoiceGroup = _isVoiceGroupPtr.asFunction<int Function(int)>();

  @override
  bool isVoiceGroupEmpty(SoundHandle handle) {
    return _isVoiceGroupEmpty(handle.id) == 1;
  }

  late final _isVoiceGroupEmptyPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.UnsignedInt)>>(
          'isVoiceGroupEmpty');
  late final _isVoiceGroupEmpty =
      _isVoiceGroupEmptyPtr.asFunction<int Function(int)>();

  /////////////////////////////////////////
  /// faders
  /////////////////////////////////////////

  @override
  PlayerErrors fadeGlobalVolume(double to, Duration duration) {
    final e = _fadeGlobalVolume(to, duration.toDouble());
    return PlayerErrors.values[e];
  }

  late final _fadeGlobalVolumePtr =
      _lookup<ffi.NativeFunction<ffi.Int32 Function(ffi.Float, ffi.Float)>>(
          'fadeGlobalVolume');
  late final _fadeGlobalVolume =
      _fadeGlobalVolumePtr.asFunction<int Function(double, double)>();

  @override
  PlayerErrors fadeVolume(SoundHandle handle, double to, Duration duration) {
    final e = _fadeVolume(handle.id, to, duration.toDouble());
    return PlayerErrors.values[e];
  }

  late final _fadeVolumePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(
              ffi.UnsignedInt, ffi.Float, ffi.Float)>>('fadeVolume');
  late final _fadeVolume =
      _fadeVolumePtr.asFunction<int Function(int, double, double)>();

  @override
  PlayerErrors fadePan(SoundHandle handle, double to, Duration duration) {
    final e = _fadePan(handle.id, to, duration.toDouble());
    return PlayerErrors.values[e];
  }

  late final _fadePanPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(
              ffi.UnsignedInt, ffi.Float, ffi.Float)>>('fadePan');
  late final _fadePan =
      _fadePanPtr.asFunction<int Function(int, double, double)>();

  @override
  PlayerErrors fadeRelativePlaySpeed(
    SoundHandle handle,
    double to,
    Duration time,
  ) {
    final e = _fadeRelativePlaySpeed(handle.id, to, time.toDouble());
    return PlayerErrors.values[e];
  }

  late final _fadeRelativePlaySpeedPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(
              ffi.UnsignedInt, ffi.Float, ffi.Float)>>('fadeRelativePlaySpeed');
  late final _fadeRelativePlaySpeed =
      _fadeRelativePlaySpeedPtr.asFunction<int Function(int, double, double)>();

  @override
  PlayerErrors schedulePause(SoundHandle handle, Duration duration) {
    final e = _schedulePause(handle.id, duration.toDouble());
    return PlayerErrors.values[e];
  }

  late final _schedulePausePtr = _lookup<
          ffi.NativeFunction<ffi.Int32 Function(ffi.UnsignedInt, ffi.Float)>>(
      'schedulePause');
  late final _schedulePause =
      _schedulePausePtr.asFunction<int Function(int, double)>();

  @override
  PlayerErrors scheduleStop(SoundHandle handle, Duration duration) {
    final e = _scheduleStop(handle.id, duration.toDouble());
    return PlayerErrors.values[e];
  }

  late final _scheduleStopPtr = _lookup<
          ffi.NativeFunction<ffi.Int32 Function(ffi.UnsignedInt, ffi.Float)>>(
      'scheduleStop');
  late final _scheduleStop =
      _scheduleStopPtr.asFunction<int Function(int, double)>();

  @override
  PlayerErrors oscillateVolume(
      SoundHandle handle, double from, double to, Duration time) {
    final e = _oscillateVolume(handle.id, from, to, time.toDouble());
    return PlayerErrors.values[e];
  }

  late final _oscillateVolumePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.UnsignedInt, ffi.Float, ffi.Float,
              ffi.Float)>>('oscillateVolume');
  late final _oscillateVolume = _oscillateVolumePtr
      .asFunction<int Function(int, double, double, double)>();

  @override
  PlayerErrors oscillatePan(
    SoundHandle handle,
    double from,
    double to,
    Duration time,
  ) {
    final e = _oscillatePan(handle.id, from, to, time.toDouble());
    return PlayerErrors.values[e];
  }

  late final _oscillatePanPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.UnsignedInt, ffi.Float, ffi.Float,
              ffi.Float)>>('oscillatePan');
  late final _oscillatePan =
      _oscillatePanPtr.asFunction<int Function(int, double, double, double)>();

  @override
  PlayerErrors oscillateRelativePlaySpeed(
      SoundHandle handle, double from, double to, Duration time) {
    final e = _oscillateRelativePlaySpeed(handle.id, from, to, time.toDouble());
    return PlayerErrors.values[e];
  }

  late final _oscillateRelativePlaySpeedPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.UnsignedInt, ffi.Float, ffi.Float,
              ffi.Float)>>('oscillateRelativePlaySpeed');
  late final _oscillateRelativePlaySpeed = _oscillateRelativePlaySpeedPtr
      .asFunction<int Function(int, double, double, double)>();

  @override
  PlayerErrors oscillateGlobalVolume(double from, double to, Duration time) {
    final e = _oscillateGlobalVolume(from, to, time.toDouble());
    return PlayerErrors.values[e];
  }

  late final _oscillateGlobalVolumePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int32 Function(ffi.Float, ffi.Float, ffi.Float)>>(
      'oscillateGlobalVolume');
  late final _oscillateGlobalVolume = _oscillateGlobalVolumePtr
      .asFunction<int Function(double, double, double)>();

  @override
  PlayerErrors fadeFilterParameter(
    FilterType filterType,
    int attributeId,
    double to,
    double time, {
    SoundHandle? handle,
  }) {
    final e = _fadeFilterParameter(
      handle?.id ?? 0,
      filterType.index,
      attributeId,
      to,
      time,
    );
    return PlayerErrors.values[e];
  }

  late final _fadeFilterParameterPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.UnsignedInt, ffi.Int32, ffi.Int, ffi.Float,
              ffi.Float)>>('fadeFilterParameter');
  late final _fadeFilterParameter = _fadeFilterParameterPtr
      .asFunction<int Function(int, int, int, double, double)>();

  @override
  PlayerErrors oscillateFilterParameter(
    FilterType filterType,
    int attributeId,
    double from,
    double to,
    double time, {
    SoundHandle? handle,
  }) {
    final e = _oscillateFilterParameter(
      handle?.id ?? 0,
      filterType.index,
      attributeId,
      from,
      to,
      time,
    );
    return PlayerErrors.values[e];
  }

  late final _oscillateFilterParameterPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.UnsignedInt, ffi.Int32, ffi.Int, ffi.Float,
              ffi.Float, ffi.Float)>>('oscillateFilterParameter');
  late final _oscillateFilterParameter = _oscillateFilterParameterPtr
      .asFunction<int Function(int, int, int, double, double, double)>();

  // ///////////////////////////////////////
  //  Filters
  // ///////////////////////////////////////

  @override
  ({PlayerErrors error, int index}) isFilterActive(
    FilterType filterType, {
    SoundHash? soundHash,
  }) {
    final ffi.Pointer<ffi.Int> id = calloc(ffi.sizeOf<ffi.Int>());
    final e = _isFilterActive(soundHash?.hash ?? 0, filterType.index, id);
    final ret = (error: PlayerErrors.values[e], index: id.value);
    calloc.free(id);
    return ret;
  }

  late final _isFilterActivePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.UnsignedInt, ffi.Int32,
              ffi.Pointer<ffi.Int>)>>('isFilterActive');
  late final _isFilterActive = _isFilterActivePtr
      .asFunction<int Function(int, int, ffi.Pointer<ffi.Int>)>();

  @override
  ({PlayerErrors error, List<String> names}) getFilterParamNames(
      FilterType filterType) {
    final ffi.Pointer<ffi.Int> paramsCount = calloc(ffi.sizeOf<ffi.Int>());
    final ffi.Pointer<ffi.Pointer<ffi.Char>> names =
        calloc(ffi.sizeOf<ffi.Char>() * 30);
    _log.fine(() =>
        'PARAMS NAME paramsCount: ${paramsCount.address.toRadixString(16)}  '
        'names: ${names.address.toRadixString(16)}');

    final e = _getFilterParamNames(
      filterType.index,
      paramsCount,
      names,
    );
    final pNames = <String>[];
    for (var i = 0; i < paramsCount.value; i++) {
      _log.fine(() => 'PARAMS NAME $i ${names + i}   '
          '${names[i].cast<Utf8>().toDartString()}    '
          'names[i]: ${names[i].address.toRadixString(16)}');
      pNames.add(names[i].cast<Utf8>().toDartString());
    }
    final ret = (error: PlayerErrors.values[e], names: pNames);
    calloc.free(paramsCount);
    for (var i = 0; i < pNames.length; i++) {
      calloc.free(names[i]);
    }
    calloc.free(names);
    return ret;
  }

  late final _getFilterParamNamesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.Int32, ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Pointer<ffi.Char>>)>>('getFilterParamNames');
  late final _getFilterParamNames = _getFilterParamNamesPtr.asFunction<
      int Function(
          int, ffi.Pointer<ffi.Int>, ffi.Pointer<ffi.Pointer<ffi.Char>>)>();

  @override
  PlayerErrors addFilter(
    FilterType filterType, {
    SoundHash? soundHash,
  }) {
    final e = _addFilter(soundHash?.hash ?? 0, filterType.index);
    return PlayerErrors.values[e];
  }

  late final _addFilterPtr = _lookup<
          ffi.NativeFunction<ffi.Int32 Function(ffi.UnsignedInt, ffi.Int32)>>(
      'addFilter');
  late final _addFilter = _addFilterPtr.asFunction<int Function(int, int)>();

  @override
  PlayerErrors removeFilter(
    FilterType filterType, {
    SoundHash? soundHash,
  }) {
    final e = _removeFilter(soundHash?.hash ?? 0, filterType.index);
    return PlayerErrors.values[e];
  }

  late final _removeFilterPtr = _lookup<
          ffi.NativeFunction<ffi.Int32 Function(ffi.UnsignedInt, ffi.Int32)>>(
      'removeFilter');
  late final _removeFilter =
      _removeFilterPtr.asFunction<int Function(int, int)>();

  @override
  PlayerErrors setFilterParams(
    FilterType filterType,
    int attributeId,
    double value, {
    SoundHandle? handle,
  }) {
    final e = _setFilterParams(
      handle?.id ?? 0,
      filterType.index,
      attributeId,
      value,
    );
    return PlayerErrors.values[e];
  }

  late final _setFilterParamsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.UnsignedInt, ffi.Int32, ffi.Int,
              ffi.Float)>>('setFilterParams');
  late final _setFilterParams =
      _setFilterParamsPtr.asFunction<int Function(int, int, int, double)>();

  @override
  ({PlayerErrors error, double value}) getFilterParams(
    FilterType filterType,
    int attributeId, {
    SoundHandle? handle,
  }) {
    final ffi.Pointer<ffi.Float> paramValue = calloc();
    final error = _getFilterParams(
      handle?.id ?? 0,
      filterType.index,
      attributeId,
      paramValue,
    );
    final ret = paramValue.value;
    calloc.free(paramValue);
    return (error: PlayerErrors.values[error], value: ret);
  }

  late final _getFilterParamsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int32 Function(ffi.UnsignedInt, ffi.Int32, ffi.Int,
              ffi.Pointer<ffi.Float>)>>('getFilterParams');
  late final _getFilterParams = _getFilterParamsPtr
      .asFunction<int Function(int, int, int, ffi.Pointer<ffi.Float>)>();

  /////////////////////////////////////////
  /// 3D audio methods
  /////////////////////////////////////////

  @override
  ({PlayerErrors error, SoundHandle newHandle}) play3d(
    SoundHash soundHash,
    double posX,
    double posY,
    double posZ, {
    double velX = 0,
    double velY = 0,
    double velZ = 0,
    double volume = 1,
    bool paused = false,
    bool looping = false,
    Duration loopingStartAt = Duration.zero,
  }) {
    final ffi.Pointer<ffi.UnsignedInt> handle = calloc();
    final e = _play3d(
      soundHash.hash,
      posX,
      posY,
      posZ,
      velX,
      velY,
      velZ,
      volume,
      paused ? 1 : 0,
      looping ? 1 : 0,
      loopingStartAt.toDouble(),
      handle,
    );
    final ret =
        (error: PlayerErrors.values[e], newHandle: SoundHandle(handle.value));
    calloc.free(handle);
    return ret;
  }

  late final _play3dPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.UnsignedInt,
              ffi.Float,
              ffi.Float,
              ffi.Float,
              ffi.Float,
              ffi.Float,
              ffi.Float,
              ffi.Float,
              ffi.Int,
              ffi.Int,
              ffi.Double,
              ffi.Pointer<ffi.UnsignedInt>)>>('play3d');
  late final _play3d = _play3dPtr.asFunction<
      int Function(int, double, double, double, double, double, double, double,
          int, int, double, ffi.Pointer<ffi.UnsignedInt>)>();

  @override
  void set3dSoundSpeed(double speed) {
    return _set3dSoundSpeed(speed);
  }

  late final _set3dSoundSpeedPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Float)>>(
    'set3dSoundSpeed',
  );
  late final _set3dSoundSpeed =
      _set3dSoundSpeedPtr.asFunction<void Function(double)>();

  @override
  double get3dSoundSpeed() {
    return _get3dSoundSpeed();
  }

  late final _get3dSoundSpeedPtr =
      _lookup<ffi.NativeFunction<ffi.Float Function()>>('get3dSoundSpeed');
  late final _get3dSoundSpeed =
      _get3dSoundSpeedPtr.asFunction<double Function()>();

  @override
  void set3dListenerParameters(
    double posX,
    double posY,
    double posZ,
    double atX,
    double atY,
    double atZ,
    double upX,
    double upY,
    double upZ,
    double velocityX,
    double velocityY,
    double velocityZ,
  ) {
    return _set3dListenerParameters(
      posX,
      posY,
      posZ,
      atX,
      atY,
      atZ,
      upX,
      upY,
      upZ,
      velocityX,
      velocityY,
      velocityZ,
    );
  }

  late final _set3dListenerParametersPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
          )>>('set3dListenerParameters');
  late final _set3dListenerParameters = _set3dListenerParametersPtr.asFunction<
      void Function(
        double,
        double,
        double,
        double,
        double,
        double,
        double,
        double,
        double,
        double,
        double,
        double,
      )>();

  @override
  void set3dListenerPosition(double posX, double posY, double posZ) {
    return _set3dListenerPosition(posX, posY, posZ);
  }

  late final _set3dListenerPositionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Float,
            ffi.Float,
            ffi.Float,
          )>>('set3dListenerPosition');
  late final _set3dListenerPosition = _set3dListenerPositionPtr
      .asFunction<void Function(double, double, double)>();

  @override
  void set3dListenerAt(double atX, double atY, double atZ) {
    return _set3dListenerAt(atX, atY, atZ);
  }

  late final _set3dListenerAtPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Float,
            ffi.Float,
            ffi.Float,
          )>>('set3dListenerAt');
  late final _set3dListenerAt =
      _set3dListenerAtPtr.asFunction<void Function(double, double, double)>();

  @override
  void set3dListenerUp(double upX, double upY, double upZ) {
    return _set3dListenerUp(upX, upY, upZ);
  }

  late final _set3dListenerUpPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Float,
            ffi.Float,
            ffi.Float,
          )>>('set3dListenerUp');
  late final _set3dListenerUp =
      _set3dListenerUpPtr.asFunction<void Function(double, double, double)>();

  @override
  void set3dListenerVelocity(
    double velocityX,
    double velocityY,
    double velocityZ,
  ) {
    return _set3dListenerVelocity(velocityX, velocityY, velocityZ);
  }

  late final _set3dListenerVelocityPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.Float,
            ffi.Float,
            ffi.Float,
          )>>('set3dListenerVelocity');
  late final _set3dListenerVelocity = _set3dListenerVelocityPtr
      .asFunction<void Function(double, double, double)>();

  @override
  void set3dSourceParameters(
    SoundHandle handle,
    double posX,
    double posY,
    double posZ,
    double velocityX,
    double velocityY,
    double velocityZ,
  ) {
    return _set3dSourceParameters(
      handle.id,
      posX,
      posY,
      posZ,
      velocityX,
      velocityY,
      velocityZ,
    );
  }

  late final _set3dSourceParametersPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.UnsignedInt,
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
            ffi.Float,
          )>>('set3dSourceParameters');
  late final _set3dSourceParameters = _set3dSourceParametersPtr.asFunction<
      void Function(int, double, double, double, double, double, double)>();

  @override
  void set3dSourcePosition(
      SoundHandle handle, double posX, double posY, double posZ) {
    return _set3dSourcePosition(handle.id, posX, posY, posZ);
  }

  late final _set3dSourcePositionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.UnsignedInt,
            ffi.Float,
            ffi.Float,
            ffi.Float,
          )>>('set3dSourcePosition');
  late final _set3dSourcePosition = _set3dSourcePositionPtr
      .asFunction<void Function(int, double, double, double)>();

  @override
  void set3dSourceVelocity(
    SoundHandle handle,
    double velocityX,
    double velocityY,
    double velocityZ,
  ) {
    return _set3dSourceVelocity(handle.id, velocityX, velocityY, velocityZ);
  }

  late final _set3dSourceVelocityPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.UnsignedInt,
            ffi.Float,
            ffi.Float,
            ffi.Float,
          )>>('set3dSourceVelocity');
  late final _set3dSourceVelocity = _set3dSourceVelocityPtr
      .asFunction<void Function(int, double, double, double)>();

  @override
  void set3dSourceMinMaxDistance(
    SoundHandle handle,
    double minDistance,
    double maxDistance,
  ) {
    return _set3dSourceMinMaxDistance(handle.id, minDistance, maxDistance);
  }

  late final _set3dSourceMinMaxDistancePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.UnsignedInt,
            ffi.Float,
            ffi.Float,
          )>>('set3dSourceMinMaxDistance');
  late final _set3dSourceMinMaxDistance = _set3dSourceMinMaxDistancePtr
      .asFunction<void Function(int, double, double)>();

  @override
  void set3dSourceAttenuation(
    SoundHandle handle,
    int attenuationModel,
    double attenuationRolloffFactor,
  ) {
    return _set3dSourceAttenuation(
      handle.id,
      attenuationModel,
      attenuationRolloffFactor,
    );
  }

  late final _set3dSourceAttenuationPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(
            ffi.UnsignedInt,
            ffi.UnsignedInt,
            ffi.Float,
          )>>('set3dSourceAttenuation');
  late final _set3dSourceAttenuation =
      _set3dSourceAttenuationPtr.asFunction<void Function(int, int, double)>();

  @override
  void set3dSourceDopplerFactor(SoundHandle handle, double dopplerFactor) {
    return _set3dSourceDopplerFactor(handle.id, dopplerFactor);
  }

  late final _set3dSourceDopplerFactorPtr = _lookup<
      ffi.NativeFunction<ffi.Void Function(ffi.UnsignedInt, ffi.Float)>>(
    'set3dSourceDopplerFactor',
  );
  late final _set3dSourceDopplerFactor =
      _set3dSourceDopplerFactorPtr.asFunction<void Function(int, double)>();

  // ///////////////////////////////////////
  // waveform audio data
  // ///////////////////////////////////////
  @override
  Float32List readSamplesFromFile(
    String completeFileName,
    int numSamplesNeeded, {
    double startTime = 0,
    double endTime = -1,
    bool average = false,
  }) {
    final pSamples =
        calloc<ffi.Float>(numSamplesNeeded * ffi.sizeOf<ffi.Float>());
    final error = _readSamplesFromFile(
      completeFileName.toNativeUtf8(),
      startTime,
      endTime,
      numSamplesNeeded,
      average,
      pSamples,
    );
    final samples = pSamples.asTypedList(numSamplesNeeded).asUnmodifiableView();

    /// Seems freeing this pointer is not needed because "samples" gets
    /// undefined after using "free"!? It will be GC-ed.
    // calloc.free(pSamples);
    if (ReadSamplesErrors.fromValue(error) !=
        ReadSamplesErrors.readSamplesNoError) {
      throw SoLoudCppException.fromReadSampleError(
          ReadSamplesErrors.fromValue(error));
    }
    return samples;
  }

  late final _readSamplesFromFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<Utf8>,
              ffi.Float,
              ffi.Float,
              ffi.UnsignedLong,
              ffi.Bool,
              ffi.Pointer<ffi.Float>)>>('readSamplesFromFile');
  late final _readSamplesFromFile = _readSamplesFromFilePtr.asFunction<
      int Function(ffi.Pointer<Utf8>, double, double, int, bool,
          ffi.Pointer<ffi.Float>)>();

  @override
  Float32List readSamplesFromMem(
    Uint8List buffer,
    int numSamplesNeeded, {
    double startTime = 0,
    double endTime = -1,
    bool average = false,
  }) {
    final pSamples =
        calloc<ffi.Float>(numSamplesNeeded * ffi.sizeOf<ffi.Float>());
    final ffi.Pointer<ffi.Uint8> bufferPtr = calloc(buffer.length);
    for (var i = 0; i < buffer.length; i++) {
      bufferPtr[i] = buffer[i];
    }
    final error = _readSamplesFromMem(
      bufferPtr,
      buffer.length,
      startTime,
      endTime,
      numSamplesNeeded,
      average,
      pSamples,
    );
    final samples = pSamples.asTypedList(numSamplesNeeded).asUnmodifiableView();

    /// Seems freeing this pointer is not needed because "samples" gets
    /// undefined after using "free"!? It will be GC-ed.
    // calloc.free(pSamples);
    if (ReadSamplesErrors.fromValue(error) !=
        ReadSamplesErrors.readSamplesNoError) {
      throw SoLoudCppException.fromReadSampleError(
          ReadSamplesErrors.fromValue(error));
    }
    return samples;
  }

  late final _readSamplesFromMemPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Uint8>,
              ffi.UnsignedLong,
              ffi.Float,
              ffi.Float,
              ffi.UnsignedLong,
              ffi.Bool,
              ffi.Pointer<ffi.Float>)>>('readSamplesFromMem');
  late final _readSamplesFromMem = _readSamplesFromMemPtr.asFunction<
      int Function(ffi.Pointer<ffi.Uint8>, int, double, double, int, bool,
          ffi.Pointer<ffi.Float>)>();
}
