/// Type safe representation of HTTP headers.
enum HttpHeaderName {
  accept('accept'),
  acceptCharset('accept-charset'),
  acceptEncoding('accept-encoding'),
  acceptLanguage('accept-language'),
  acceptRanges('accept-ranges'),
  accessControlAllowCredentials('access-control-allow-credentials'),
  accessControlAllowHeaders('access-control-allow-headers'),
  accessControlAllowMethods('access-control-allow-methods'),
  accessControlAllowOrigin('access-control-allow-origin'),
  accessControlExposeHeaders('access-control-expose-headers'),
  accessControlMaxAge('access-control-max-age'),
  accessControlRequestHeaders('access-control-request-headers'),
  accessControlRequestMethod('access-control-request-method'),
  age('age'),
  allow('allow'),
  altSvc('alt-svc'),
  authorization('authorization'),
  cacheControl('cache-control'),
  cacheStatus('cache-status'),
  cdnCacheControl('cdn-cache-control'),
  connection('connection'),
  contentDisposition('content-disposition'),
  contentEncoding('content-encoding'),
  contentLanguage('content-language'),
  contentLength('content-length'),
  contentLocation('content-location'),
  contentRange('content-range'),
  contentSecurityPolicy('content-security-policy'),
  contentSecurityPolicyReportOnly('content-security-policy-report-only'),
  contentType('content-type'),
  cookie('cookie'),
  dnt('dnt'),
  date('date'),
  etag('etag'),
  expect('expect'),
  expires('expires'),
  forwarded('forwarded'),
  from('from'),
  host('host'),
  ifMatch('if-match'),
  ifModifiedSince('if-modified-since'),
  ifNoneMatch('if-none-match'),
  ifRange('if-range'),
  ifUnmodifiedSince('if-unmodified-since'),
  lastModified('last-modified'),
  link('link'),
  location('location'),
  maxForwards('max-forwards'),
  origin('origin'),
  pragma('pragma'),
  proxyAuthenticate('proxy-authenticate'),
  proxyAuthorization('proxy-authorization'),
  publicKeyPins('public-key-pins'),
  publicKeyPinsReportOnly('public-key-pins-report-only'),
  range('range'),
  referer('referer'),
  referrerPolicy('referrer-policy'),
  refresh('refresh'),
  retryAfter('retry-after'),
  secWebSocketAccept('sec-websocket-accept'),
  secWebSocketExtensions('sec-websocket-extensions'),
  secWebSocketKey('sec-websocket-key'),
  secWebSocketProtocol('sec-websocket-protocol'),
  secWebSocketVersion('sec-websocket-version'),
  server('server'),
  setCookie('set-cookie'),
  strictTransportSecurity('strict-transport-security'),
  te('te'),
  trailer('trailer'),
  transferEncoding('transfer-encoding'),
  userAgent('user-agent'),
  upgrade('upgrade'),
  upgradeInsecureRequests('upgrade-insecure-requests'),
  vary('vary'),
  via('via'),
  warning('warning'),
  wwwAuthenticate('www-authenticate'),
  xContentTypeOptions('x-content-type-options'),
  xDnsPrefetchControl('x-dns-prefetch-control'),
  xFrameOptions('x-frame-options'),
  xXssProtection('x-xss-protection');

  final String httpName;

  const HttpHeaderName(this.httpName);
}
