// ignore_for_file: always_specify_types
// ignore_for_file: camel_case_types
// ignore_for_file: non_constant_identifier_names

// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint
import 'dart:ffi' as ffi;

/// Bindings for `src/lodepng_flutter.h`.
///
/// Regenerate bindings with `dart run ffigen --config ffigen.yaml`.
///
class LodepngFlutterBindings {
  /// Holds the symbol lookup function.
  final ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
      _lookup;

  /// The symbols are looked up in [dynamicLibrary].
  LodepngFlutterBindings(ffi.DynamicLibrary dynamicLibrary)
      : _lookup = dynamicLibrary.lookup;

  /// The symbols are looked up with [lookup].
  LodepngFlutterBindings.fromLookup(
      ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
          lookup)
      : _lookup = lookup;

  late final ffi.Pointer<ffi.Pointer<ffi.Char>> _LODEPNG_VERSION_STRING =
      _lookup<ffi.Pointer<ffi.Char>>('LODEPNG_VERSION_STRING');

  ffi.Pointer<ffi.Char> get LODEPNG_VERSION_STRING =>
      _LODEPNG_VERSION_STRING.value;

  set LODEPNG_VERSION_STRING(ffi.Pointer<ffi.Char> value) =>
      _LODEPNG_VERSION_STRING.value = value;

  /// Converts PNG data in memory to raw pixel data.
  /// out: Output parameter. Pointer to buffer that will contain the raw pixel data.
  /// After decoding, its size is w * h * (bytes per pixel) bytes larger than
  /// initially. Bytes per pixel depends on colortype and bitdepth.
  /// Must be freed after usage with free(*out).
  /// Note: for 16-bit per channel colors, uses big endian format like PNG does.
  /// w: Output parameter. Pointer to width of pixel data.
  /// h: Output parameter. Pointer to height of pixel data.
  /// in: Memory buffer with the PNG file.
  /// insize: size of the in buffer.
  /// colortype: the desired color type for the raw output image. See explanation on PNG color types.
  /// bitdepth: the desired bit depth for the raw output image. See explanation on PNG color types.
  /// Return value: LodePNG error code (0 means no error).
  int lodepng_decode_memory(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.UnsignedInt> w,
    ffi.Pointer<ffi.UnsignedInt> h,
    ffi.Pointer<ffi.UnsignedChar> in1,
    int insize,
    int colortype,
    int bitdepth,
  ) {
    return _lodepng_decode_memory(
      out,
      w,
      h,
      in1,
      insize,
      colortype,
      bitdepth,
    );
  }

  late final _lodepng_decode_memoryPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size,
              ffi.Int32,
              ffi.UnsignedInt)>>('lodepng_decode_memory');
  late final _lodepng_decode_memory = _lodepng_decode_memoryPtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedChar>,
          int,
          int,
          int)>();

  /// Same as lodepng_decode_memory, but always decodes to 32-bit RGBA raw image
  int lodepng_decode32(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.UnsignedInt> w,
    ffi.Pointer<ffi.UnsignedInt> h,
    ffi.Pointer<ffi.UnsignedChar> in1,
    int insize,
  ) {
    return _lodepng_decode32(
      out,
      w,
      h,
      in1,
      insize,
    );
  }

  late final _lodepng_decode32Ptr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size)>>('lodepng_decode32');
  late final _lodepng_decode32 = _lodepng_decode32Ptr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedChar>,
          int)>();

  /// Same as lodepng_decode_memory, but always decodes to 24-bit RGB raw image
  int lodepng_decode24(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.UnsignedInt> w,
    ffi.Pointer<ffi.UnsignedInt> h,
    ffi.Pointer<ffi.UnsignedChar> in1,
    int insize,
  ) {
    return _lodepng_decode24(
      out,
      w,
      h,
      in1,
      insize,
    );
  }

  late final _lodepng_decode24Ptr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size)>>('lodepng_decode24');
  late final _lodepng_decode24 = _lodepng_decode24Ptr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedChar>,
          int)>();

  /// Load PNG from disk, from file with given name.
  /// Same as the other decode functions, but instead takes a filename as input.
  ///
  /// NOTE: Wide-character filenames are not supported, you can use an external method
  /// to handle such files and decode in-memory.
  int lodepng_decode_file(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.UnsignedInt> w,
    ffi.Pointer<ffi.UnsignedInt> h,
    ffi.Pointer<ffi.Char> filename,
    int colortype,
    int bitdepth,
  ) {
    return _lodepng_decode_file(
      out,
      w,
      h,
      filename,
      colortype,
      bitdepth,
    );
  }

  late final _lodepng_decode_filePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.Char>,
              ffi.Int32,
              ffi.UnsignedInt)>>('lodepng_decode_file');
  late final _lodepng_decode_file = _lodepng_decode_filePtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.Char>,
          int,
          int)>();

  /// Same as lodepng_decode_file, but always decodes to 32-bit RGBA raw image.
  ///
  /// NOTE: Wide-character filenames are not supported, you can use an external method
  /// to handle such files and decode in-memory.
  int lodepng_decode32_file(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.UnsignedInt> w,
    ffi.Pointer<ffi.UnsignedInt> h,
    ffi.Pointer<ffi.Char> filename,
  ) {
    return _lodepng_decode32_file(
      out,
      w,
      h,
      filename,
    );
  }

  late final _lodepng_decode32_filePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.Char>)>>('lodepng_decode32_file');
  late final _lodepng_decode32_file = _lodepng_decode32_filePtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.Char>)>();

  /// Same as lodepng_decode_file, but always decodes to 24-bit RGB raw image.
  ///
  /// NOTE: Wide-character filenames are not supported, you can use an external method
  /// to handle such files and decode in-memory.
  int lodepng_decode24_file(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.UnsignedInt> w,
    ffi.Pointer<ffi.UnsignedInt> h,
    ffi.Pointer<ffi.Char> filename,
  ) {
    return _lodepng_decode24_file(
      out,
      w,
      h,
      filename,
    );
  }

  late final _lodepng_decode24_filePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.Char>)>>('lodepng_decode24_file');
  late final _lodepng_decode24_file = _lodepng_decode24_filePtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.Char>)>();

  /// Converts raw pixel data into a PNG image in memory. The colortype and bitdepth
  /// of the output PNG image cannot be chosen, they are automatically determined
  /// by the colortype, bitdepth and content of the input pixel data.
  /// Note: for 16-bit per channel colors, needs big endian format like PNG does.
  /// out: Output parameter. Pointer to buffer that will contain the PNG image data.
  /// Must be freed after usage with free(*out).
  /// outsize: Output parameter. Pointer to the size in bytes of the out buffer.
  /// image: The raw pixel data to encode. The size of this buffer should be
  /// w * h * (bytes per pixel), bytes per pixel depends on colortype and bitdepth.
  /// w: width of the raw pixel data in pixels.
  /// h: height of the raw pixel data in pixels.
  /// colortype: the color type of the raw input image. See explanation on PNG color types.
  /// bitdepth: the bit depth of the raw input image. See explanation on PNG color types.
  /// Return value: LodePNG error code (0 means no error).
  int lodepng_encode_memory(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.Size> outsize,
    ffi.Pointer<ffi.UnsignedChar> image,
    int w,
    int h,
    int colortype,
    int bitdepth,
  ) {
    return _lodepng_encode_memory(
      out,
      outsize,
      image,
      w,
      h,
      colortype,
      bitdepth,
    );
  }

  late final _lodepng_encode_memoryPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.UnsignedInt,
              ffi.UnsignedInt,
              ffi.Int32,
              ffi.UnsignedInt)>>('lodepng_encode_memory');
  late final _lodepng_encode_memory = _lodepng_encode_memoryPtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.Size>,
          ffi.Pointer<ffi.UnsignedChar>,
          int,
          int,
          int,
          int)>();

  /// Same as lodepng_encode_memory, but always encodes from 32-bit RGBA raw image.
  int lodepng_encode32(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.Size> outsize,
    ffi.Pointer<ffi.UnsignedChar> image,
    int w,
    int h,
  ) {
    return _lodepng_encode32(
      out,
      outsize,
      image,
      w,
      h,
    );
  }

  late final _lodepng_encode32Ptr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.UnsignedInt,
              ffi.UnsignedInt)>>('lodepng_encode32');
  late final _lodepng_encode32 = _lodepng_encode32Ptr.asFunction<
      int Function(ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.Size>, ffi.Pointer<ffi.UnsignedChar>, int, int)>();

  /// Same as lodepng_encode_memory, but always encodes from 24-bit RGB raw image.
  int lodepng_encode24(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.Size> outsize,
    ffi.Pointer<ffi.UnsignedChar> image,
    int w,
    int h,
  ) {
    return _lodepng_encode24(
      out,
      outsize,
      image,
      w,
      h,
    );
  }

  late final _lodepng_encode24Ptr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.UnsignedInt,
              ffi.UnsignedInt)>>('lodepng_encode24');
  late final _lodepng_encode24 = _lodepng_encode24Ptr.asFunction<
      int Function(ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.Size>, ffi.Pointer<ffi.UnsignedChar>, int, int)>();

  /// Converts raw pixel data into a PNG file on disk.
  /// Same as the other encode functions, but instead takes a filename as output.
  ///
  /// NOTE: This overwrites existing files without warning!
  ///
  /// NOTE: Wide-character filenames are not supported, you can use an external method
  /// to handle such files and encode in-memory.
  int lodepng_encode_file(
    ffi.Pointer<ffi.Char> filename,
    ffi.Pointer<ffi.UnsignedChar> image,
    int w,
    int h,
    int colortype,
    int bitdepth,
  ) {
    return _lodepng_encode_file(
      filename,
      image,
      w,
      h,
      colortype,
      bitdepth,
    );
  }

  late final _lodepng_encode_filePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.UnsignedInt,
              ffi.UnsignedInt,
              ffi.Int32,
              ffi.UnsignedInt)>>('lodepng_encode_file');
  late final _lodepng_encode_file = _lodepng_encode_filePtr.asFunction<
      int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.UnsignedChar>, int,
          int, int, int)>();

  /// Same as lodepng_encode_file, but always encodes from 32-bit RGBA raw image.
  ///
  /// NOTE: Wide-character filenames are not supported, you can use an external method
  /// to handle such files and encode in-memory.
  int lodepng_encode32_file(
    ffi.Pointer<ffi.Char> filename,
    ffi.Pointer<ffi.UnsignedChar> image,
    int w,
    int h,
  ) {
    return _lodepng_encode32_file(
      filename,
      image,
      w,
      h,
    );
  }

  late final _lodepng_encode32_filePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.UnsignedInt,
              ffi.UnsignedInt)>>('lodepng_encode32_file');
  late final _lodepng_encode32_file = _lodepng_encode32_filePtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.UnsignedChar>, int, int)>();

  /// Same as lodepng_encode_file, but always encodes from 24-bit RGB raw image.
  ///
  /// NOTE: Wide-character filenames are not supported, you can use an external method
  /// to handle such files and encode in-memory.
  int lodepng_encode24_file(
    ffi.Pointer<ffi.Char> filename,
    ffi.Pointer<ffi.UnsignedChar> image,
    int w,
    int h,
  ) {
    return _lodepng_encode24_file(
      filename,
      image,
      w,
      h,
    );
  }

  late final _lodepng_encode24_filePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.UnsignedInt,
              ffi.UnsignedInt)>>('lodepng_encode24_file');
  late final _lodepng_encode24_file = _lodepng_encode24_filePtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.UnsignedChar>, int, int)>();

  /// Returns an English description of the numerical error code.
  ffi.Pointer<ffi.Char> lodepng_error_text(
    int code,
  ) {
    return _lodepng_error_text(
      code,
    );
  }

  late final _lodepng_error_textPtr = _lookup<
          ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.UnsignedInt)>>(
      'lodepng_error_text');
  late final _lodepng_error_text =
      _lodepng_error_textPtr.asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  late final ffi.Pointer<LodePNGDecompressSettings>
      _lodepng_default_decompress_settings =
      _lookup<LodePNGDecompressSettings>('lodepng_default_decompress_settings');

  LodePNGDecompressSettings get lodepng_default_decompress_settings =>
      _lodepng_default_decompress_settings.ref;

  void lodepng_decompress_settings_init(
    ffi.Pointer<LodePNGDecompressSettings> settings,
  ) {
    return _lodepng_decompress_settings_init(
      settings,
    );
  }

  late final _lodepng_decompress_settings_initPtr = _lookup<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<LodePNGDecompressSettings>)>>(
      'lodepng_decompress_settings_init');
  late final _lodepng_decompress_settings_init =
      _lodepng_decompress_settings_initPtr
          .asFunction<void Function(ffi.Pointer<LodePNGDecompressSettings>)>();

  late final ffi.Pointer<LodePNGCompressSettings>
      _lodepng_default_compress_settings =
      _lookup<LodePNGCompressSettings>('lodepng_default_compress_settings');

  LodePNGCompressSettings get lodepng_default_compress_settings =>
      _lodepng_default_compress_settings.ref;

  void lodepng_compress_settings_init(
    ffi.Pointer<LodePNGCompressSettings> settings,
  ) {
    return _lodepng_compress_settings_init(
      settings,
    );
  }

  late final _lodepng_compress_settings_initPtr = _lookup<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<LodePNGCompressSettings>)>>(
      'lodepng_compress_settings_init');
  late final _lodepng_compress_settings_init =
      _lodepng_compress_settings_initPtr
          .asFunction<void Function(ffi.Pointer<LodePNGCompressSettings>)>();

  /// init, cleanup and copy functions to use with this struct
  void lodepng_color_mode_init(
    ffi.Pointer<LodePNGColorMode> info,
  ) {
    return _lodepng_color_mode_init(
      info,
    );
  }

  late final _lodepng_color_mode_initPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<LodePNGColorMode>)>>(
      'lodepng_color_mode_init');
  late final _lodepng_color_mode_init = _lodepng_color_mode_initPtr
      .asFunction<void Function(ffi.Pointer<LodePNGColorMode>)>();

  void lodepng_color_mode_cleanup(
    ffi.Pointer<LodePNGColorMode> info,
  ) {
    return _lodepng_color_mode_cleanup(
      info,
    );
  }

  late final _lodepng_color_mode_cleanupPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<LodePNGColorMode>)>>(
      'lodepng_color_mode_cleanup');
  late final _lodepng_color_mode_cleanup = _lodepng_color_mode_cleanupPtr
      .asFunction<void Function(ffi.Pointer<LodePNGColorMode>)>();

  /// return value is error code (0 means no error)
  int lodepng_color_mode_copy(
    ffi.Pointer<LodePNGColorMode> dest,
    ffi.Pointer<LodePNGColorMode> source,
  ) {
    return _lodepng_color_mode_copy(
      dest,
      source,
    );
  }

  late final _lodepng_color_mode_copyPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(ffi.Pointer<LodePNGColorMode>,
              ffi.Pointer<LodePNGColorMode>)>>('lodepng_color_mode_copy');
  late final _lodepng_color_mode_copy = _lodepng_color_mode_copyPtr.asFunction<
      int Function(
          ffi.Pointer<LodePNGColorMode>, ffi.Pointer<LodePNGColorMode>)>();

  /// Makes a temporary LodePNGColorMode that does not need cleanup (no palette)
  LodePNGColorMode lodepng_color_mode_make(
    int colortype,
    int bitdepth,
  ) {
    return _lodepng_color_mode_make(
      colortype,
      bitdepth,
    );
  }

  late final _lodepng_color_mode_makePtr = _lookup<
      ffi.NativeFunction<
          LodePNGColorMode Function(
              ffi.Int32, ffi.UnsignedInt)>>('lodepng_color_mode_make');
  late final _lodepng_color_mode_make = _lodepng_color_mode_makePtr
      .asFunction<LodePNGColorMode Function(int, int)>();

  void lodepng_palette_clear(
    ffi.Pointer<LodePNGColorMode> info,
  ) {
    return _lodepng_palette_clear(
      info,
    );
  }

  late final _lodepng_palette_clearPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<LodePNGColorMode>)>>(
      'lodepng_palette_clear');
  late final _lodepng_palette_clear = _lodepng_palette_clearPtr
      .asFunction<void Function(ffi.Pointer<LodePNGColorMode>)>();

  /// add 1 color to the palette
  int lodepng_palette_add(
    ffi.Pointer<LodePNGColorMode> info,
    int r,
    int g,
    int b,
    int a,
  ) {
    return _lodepng_palette_add(
      info,
      r,
      g,
      b,
      a,
    );
  }

  late final _lodepng_palette_addPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGColorMode>,
              ffi.UnsignedChar,
              ffi.UnsignedChar,
              ffi.UnsignedChar,
              ffi.UnsignedChar)>>('lodepng_palette_add');
  late final _lodepng_palette_add = _lodepng_palette_addPtr.asFunction<
      int Function(ffi.Pointer<LodePNGColorMode>, int, int, int, int)>();

  /// get the total amount of bits per pixel, based on colortype and bitdepth in the struct
  int lodepng_get_bpp(
    ffi.Pointer<LodePNGColorMode> info,
  ) {
    return _lodepng_get_bpp(
      info,
    );
  }

  late final _lodepng_get_bppPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGColorMode>)>>('lodepng_get_bpp');
  late final _lodepng_get_bpp = _lodepng_get_bppPtr
      .asFunction<int Function(ffi.Pointer<LodePNGColorMode>)>();

  /// get the amount of color channels used, based on colortype in the struct.
  /// If a palette is used, it counts as 1 channel.
  int lodepng_get_channels(
    ffi.Pointer<LodePNGColorMode> info,
  ) {
    return _lodepng_get_channels(
      info,
    );
  }

  late final _lodepng_get_channelsPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGColorMode>)>>('lodepng_get_channels');
  late final _lodepng_get_channels = _lodepng_get_channelsPtr
      .asFunction<int Function(ffi.Pointer<LodePNGColorMode>)>();

  /// is it a grayscale type? (only colortype 0 or 4)
  int lodepng_is_greyscale_type(
    ffi.Pointer<LodePNGColorMode> info,
  ) {
    return _lodepng_is_greyscale_type(
      info,
    );
  }

  late final _lodepng_is_greyscale_typePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGColorMode>)>>('lodepng_is_greyscale_type');
  late final _lodepng_is_greyscale_type = _lodepng_is_greyscale_typePtr
      .asFunction<int Function(ffi.Pointer<LodePNGColorMode>)>();

  /// has it got an alpha channel? (only colortype 2 or 6)
  int lodepng_is_alpha_type(
    ffi.Pointer<LodePNGColorMode> info,
  ) {
    return _lodepng_is_alpha_type(
      info,
    );
  }

  late final _lodepng_is_alpha_typePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGColorMode>)>>('lodepng_is_alpha_type');
  late final _lodepng_is_alpha_type = _lodepng_is_alpha_typePtr
      .asFunction<int Function(ffi.Pointer<LodePNGColorMode>)>();

  /// has it got a palette? (only colortype 3)
  int lodepng_is_palette_type(
    ffi.Pointer<LodePNGColorMode> info,
  ) {
    return _lodepng_is_palette_type(
      info,
    );
  }

  late final _lodepng_is_palette_typePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGColorMode>)>>('lodepng_is_palette_type');
  late final _lodepng_is_palette_type = _lodepng_is_palette_typePtr
      .asFunction<int Function(ffi.Pointer<LodePNGColorMode>)>();

  /// only returns true if there is a palette and there is a value in the palette with alpha < 255.
  /// Loops through the palette to check this.
  int lodepng_has_palette_alpha(
    ffi.Pointer<LodePNGColorMode> info,
  ) {
    return _lodepng_has_palette_alpha(
      info,
    );
  }

  late final _lodepng_has_palette_alphaPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGColorMode>)>>('lodepng_has_palette_alpha');
  late final _lodepng_has_palette_alpha = _lodepng_has_palette_alphaPtr
      .asFunction<int Function(ffi.Pointer<LodePNGColorMode>)>();

  /// Check if the given color info indicates the possibility of having non-opaque pixels in the PNG image.
  /// Returns true if the image can have translucent or invisible pixels (it still be opaque if it doesn't use such pixels).
  /// Returns false if the image can only have opaque pixels.
  /// In detail, it returns true only if it's a color type with alpha, or has a palette with non-opaque values,
  /// or if "key_defined" is true.
  int lodepng_can_have_alpha(
    ffi.Pointer<LodePNGColorMode> info,
  ) {
    return _lodepng_can_have_alpha(
      info,
    );
  }

  late final _lodepng_can_have_alphaPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGColorMode>)>>('lodepng_can_have_alpha');
  late final _lodepng_can_have_alpha = _lodepng_can_have_alphaPtr
      .asFunction<int Function(ffi.Pointer<LodePNGColorMode>)>();

  /// Returns the byte size of a raw image buffer with given width, height and color mode
  int lodepng_get_raw_size(
    int w,
    int h,
    ffi.Pointer<LodePNGColorMode> color,
  ) {
    return _lodepng_get_raw_size(
      w,
      h,
      color,
    );
  }

  late final _lodepng_get_raw_sizePtr = _lookup<
      ffi.NativeFunction<
          ffi.Size Function(ffi.UnsignedInt, ffi.UnsignedInt,
              ffi.Pointer<LodePNGColorMode>)>>('lodepng_get_raw_size');
  late final _lodepng_get_raw_size = _lodepng_get_raw_sizePtr
      .asFunction<int Function(int, int, ffi.Pointer<LodePNGColorMode>)>();

  /// init, cleanup and copy functions to use with this struct
  void lodepng_info_init(
    ffi.Pointer<LodePNGInfo> info,
  ) {
    return _lodepng_info_init(
      info,
    );
  }

  late final _lodepng_info_initPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<LodePNGInfo>)>>(
          'lodepng_info_init');
  late final _lodepng_info_init = _lodepng_info_initPtr
      .asFunction<void Function(ffi.Pointer<LodePNGInfo>)>();

  void lodepng_info_cleanup(
    ffi.Pointer<LodePNGInfo> info,
  ) {
    return _lodepng_info_cleanup(
      info,
    );
  }

  late final _lodepng_info_cleanupPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<LodePNGInfo>)>>(
          'lodepng_info_cleanup');
  late final _lodepng_info_cleanup = _lodepng_info_cleanupPtr
      .asFunction<void Function(ffi.Pointer<LodePNGInfo>)>();

  /// return value is error code (0 means no error)
  int lodepng_info_copy(
    ffi.Pointer<LodePNGInfo> dest,
    ffi.Pointer<LodePNGInfo> source,
  ) {
    return _lodepng_info_copy(
      dest,
      source,
    );
  }

  late final _lodepng_info_copyPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(ffi.Pointer<LodePNGInfo>,
              ffi.Pointer<LodePNGInfo>)>>('lodepng_info_copy');
  late final _lodepng_info_copy = _lodepng_info_copyPtr.asFunction<
      int Function(ffi.Pointer<LodePNGInfo>, ffi.Pointer<LodePNGInfo>)>();

  int lodepng_add_text(
    ffi.Pointer<LodePNGInfo> info,
    ffi.Pointer<ffi.Char> key,
    ffi.Pointer<ffi.Char> str,
  ) {
    return _lodepng_add_text(
      info,
      key,
      str,
    );
  }

  late final _lodepng_add_textPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGInfo>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('lodepng_add_text');
  late final _lodepng_add_text = _lodepng_add_textPtr.asFunction<
      int Function(ffi.Pointer<LodePNGInfo>, ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>)>();

  void lodepng_clear_text(
    ffi.Pointer<LodePNGInfo> info,
  ) {
    return _lodepng_clear_text(
      info,
    );
  }

  late final _lodepng_clear_textPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<LodePNGInfo>)>>(
          'lodepng_clear_text');
  late final _lodepng_clear_text = _lodepng_clear_textPtr
      .asFunction<void Function(ffi.Pointer<LodePNGInfo>)>();

  int lodepng_add_itext(
    ffi.Pointer<LodePNGInfo> info,
    ffi.Pointer<ffi.Char> key,
    ffi.Pointer<ffi.Char> langtag,
    ffi.Pointer<ffi.Char> transkey,
    ffi.Pointer<ffi.Char> str,
  ) {
    return _lodepng_add_itext(
      info,
      key,
      langtag,
      transkey,
      str,
    );
  }

  late final _lodepng_add_itextPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGInfo>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('lodepng_add_itext');
  late final _lodepng_add_itext = _lodepng_add_itextPtr.asFunction<
      int Function(
          ffi.Pointer<LodePNGInfo>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.Char>)>();

  void lodepng_clear_itext(
    ffi.Pointer<LodePNGInfo> info,
  ) {
    return _lodepng_clear_itext(
      info,
    );
  }

  late final _lodepng_clear_itextPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<LodePNGInfo>)>>(
          'lodepng_clear_itext');
  late final _lodepng_clear_itext = _lodepng_clear_itextPtr
      .asFunction<void Function(ffi.Pointer<LodePNGInfo>)>();

  /// replaces if exists
  int lodepng_set_icc(
    ffi.Pointer<LodePNGInfo> info,
    ffi.Pointer<ffi.Char> name,
    ffi.Pointer<ffi.UnsignedChar> profile,
    int profile_size,
  ) {
    return _lodepng_set_icc(
      info,
      name,
      profile,
      profile_size,
    );
  }

  late final _lodepng_set_iccPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGInfo>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.UnsignedInt)>>('lodepng_set_icc');
  late final _lodepng_set_icc = _lodepng_set_iccPtr.asFunction<
      int Function(ffi.Pointer<LodePNGInfo>, ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.UnsignedChar>, int)>();

  void lodepng_clear_icc(
    ffi.Pointer<LodePNGInfo> info,
  ) {
    return _lodepng_clear_icc(
      info,
    );
  }

  late final _lodepng_clear_iccPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<LodePNGInfo>)>>(
          'lodepng_clear_icc');
  late final _lodepng_clear_icc = _lodepng_clear_iccPtr
      .asFunction<void Function(ffi.Pointer<LodePNGInfo>)>();

  /// Converts raw buffer from one color type to another color type, based on
  /// LodePNGColorMode structs to describe the input and output color type.
  /// See the reference manual at the end of this header file to see which color conversions are supported.
  /// return value = LodePNG error code (0 if all went ok, an error if the conversion isn't supported)
  /// The out buffer must have size (w * h * bpp + 7) / 8, where bpp is the bits per pixel
  /// of the output color type (lodepng_get_bpp).
  /// For < 8 bpp images, there should not be padding bits at the end of scanlines.
  /// For 16-bit per channel colors, uses big endian format like PNG does.
  /// Return value is LodePNG error code
  int lodepng_convert(
    ffi.Pointer<ffi.UnsignedChar> out,
    ffi.Pointer<ffi.UnsignedChar> in1,
    ffi.Pointer<LodePNGColorMode> mode_out,
    ffi.Pointer<LodePNGColorMode> mode_in,
    int w,
    int h,
  ) {
    return _lodepng_convert(
      out,
      in1,
      mode_out,
      mode_in,
      w,
      h,
    );
  }

  late final _lodepng_convertPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<LodePNGColorMode>,
              ffi.Pointer<LodePNGColorMode>,
              ffi.UnsignedInt,
              ffi.UnsignedInt)>>('lodepng_convert');
  late final _lodepng_convert = _lodepng_convertPtr.asFunction<
      int Function(
          ffi.Pointer<ffi.UnsignedChar>,
          ffi.Pointer<ffi.UnsignedChar>,
          ffi.Pointer<LodePNGColorMode>,
          ffi.Pointer<LodePNGColorMode>,
          int,
          int)>();

  void lodepng_decoder_settings_init(
    ffi.Pointer<LodePNGDecoderSettings> settings,
  ) {
    return _lodepng_decoder_settings_init(
      settings,
    );
  }

  late final _lodepng_decoder_settings_initPtr = _lookup<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<LodePNGDecoderSettings>)>>(
      'lodepng_decoder_settings_init');
  late final _lodepng_decoder_settings_init = _lodepng_decoder_settings_initPtr
      .asFunction<void Function(ffi.Pointer<LodePNGDecoderSettings>)>();

  void lodepng_color_stats_init(
    ffi.Pointer<LodePNGColorStats> stats,
  ) {
    return _lodepng_color_stats_init(
      stats,
    );
  }

  late final _lodepng_color_stats_initPtr = _lookup<
          ffi
          .NativeFunction<ffi.Void Function(ffi.Pointer<LodePNGColorStats>)>>(
      'lodepng_color_stats_init');
  late final _lodepng_color_stats_init = _lodepng_color_stats_initPtr
      .asFunction<void Function(ffi.Pointer<LodePNGColorStats>)>();

  /// Get a LodePNGColorStats of the image. The stats must already have been inited.
  /// Returns error code (e.g. alloc fail) or 0 if ok.
  int lodepng_compute_color_stats(
    ffi.Pointer<LodePNGColorStats> stats,
    ffi.Pointer<ffi.UnsignedChar> image,
    int w,
    int h,
    ffi.Pointer<LodePNGColorMode> mode_in,
  ) {
    return _lodepng_compute_color_stats(
      stats,
      image,
      w,
      h,
      mode_in,
    );
  }

  late final _lodepng_compute_color_statsPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGColorStats>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.UnsignedInt,
              ffi.UnsignedInt,
              ffi.Pointer<LodePNGColorMode>)>>('lodepng_compute_color_stats');
  late final _lodepng_compute_color_stats =
      _lodepng_compute_color_statsPtr.asFunction<
          int Function(
              ffi.Pointer<LodePNGColorStats>,
              ffi.Pointer<ffi.UnsignedChar>,
              int,
              int,
              ffi.Pointer<LodePNGColorMode>)>();

  void lodepng_encoder_settings_init(
    ffi.Pointer<LodePNGEncoderSettings> settings,
  ) {
    return _lodepng_encoder_settings_init(
      settings,
    );
  }

  late final _lodepng_encoder_settings_initPtr = _lookup<
          ffi.NativeFunction<
              ffi.Void Function(ffi.Pointer<LodePNGEncoderSettings>)>>(
      'lodepng_encoder_settings_init');
  late final _lodepng_encoder_settings_init = _lodepng_encoder_settings_initPtr
      .asFunction<void Function(ffi.Pointer<LodePNGEncoderSettings>)>();

  /// init, cleanup and copy functions to use with this struct
  void lodepng_state_init(
    ffi.Pointer<LodePNGState> state,
  ) {
    return _lodepng_state_init(
      state,
    );
  }

  late final _lodepng_state_initPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<LodePNGState>)>>(
          'lodepng_state_init');
  late final _lodepng_state_init = _lodepng_state_initPtr
      .asFunction<void Function(ffi.Pointer<LodePNGState>)>();

  void lodepng_state_cleanup(
    ffi.Pointer<LodePNGState> state,
  ) {
    return _lodepng_state_cleanup(
      state,
    );
  }

  late final _lodepng_state_cleanupPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<LodePNGState>)>>(
          'lodepng_state_cleanup');
  late final _lodepng_state_cleanup = _lodepng_state_cleanupPtr
      .asFunction<void Function(ffi.Pointer<LodePNGState>)>();

  void lodepng_state_copy(
    ffi.Pointer<LodePNGState> dest,
    ffi.Pointer<LodePNGState> source,
  ) {
    return _lodepng_state_copy(
      dest,
      source,
    );
  }

  late final _lodepng_state_copyPtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<LodePNGState>,
              ffi.Pointer<LodePNGState>)>>('lodepng_state_copy');
  late final _lodepng_state_copy = _lodepng_state_copyPtr.asFunction<
      void Function(ffi.Pointer<LodePNGState>, ffi.Pointer<LodePNGState>)>();

  /// Same as lodepng_decode_memory, but uses a LodePNGState to allow custom settings and
  /// getting much more information about the PNG image and color mode.
  int lodepng_decode(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.UnsignedInt> w,
    ffi.Pointer<ffi.UnsignedInt> h,
    ffi.Pointer<LodePNGState> state,
    ffi.Pointer<ffi.UnsignedChar> in1,
    int insize,
  ) {
    return _lodepng_decode(
      out,
      w,
      h,
      state,
      in1,
      insize,
    );
  }

  late final _lodepng_decodePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<LodePNGState>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size)>>('lodepng_decode');
  late final _lodepng_decode = _lodepng_decodePtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<LodePNGState>,
          ffi.Pointer<ffi.UnsignedChar>,
          int)>();

  /// Read the PNG header, but not the actual data. This returns only the information
  /// that is in the IHDR chunk of the PNG, such as width, height and color type. The
  /// information is placed in the info_png field of the LodePNGState.
  int lodepng_inspect(
    ffi.Pointer<ffi.UnsignedInt> w,
    ffi.Pointer<ffi.UnsignedInt> h,
    ffi.Pointer<LodePNGState> state,
    ffi.Pointer<ffi.UnsignedChar> in1,
    int insize,
  ) {
    return _lodepng_inspect(
      w,
      h,
      state,
      in1,
      insize,
    );
  }

  late final _lodepng_inspectPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<LodePNGState>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size)>>('lodepng_inspect');
  late final _lodepng_inspect = _lodepng_inspectPtr.asFunction<
      int Function(ffi.Pointer<ffi.UnsignedInt>, ffi.Pointer<ffi.UnsignedInt>,
          ffi.Pointer<LodePNGState>, ffi.Pointer<ffi.UnsignedChar>, int)>();

  /// Reads one metadata chunk (other than IHDR, which is handled by lodepng_inspect)
  /// of the PNG file and outputs what it read in the state. Returns error code on failure.
  /// Use lodepng_inspect first with a new state, then e.g. lodepng_chunk_find_const
  /// to find the desired chunk type, and if non null use lodepng_inspect_chunk (with
  /// chunk_pointer - start_of_file as pos).
  /// Supports most metadata chunks from the PNG standard (gAMA, bKGD, tEXt, ...).
  /// Ignores unsupported, unknown, non-metadata or IHDR chunks (without error).
  /// Requirements: &in[pos] must point to start of a chunk, must use regular
  /// lodepng_inspect first since format of most other chunks depends on IHDR, and if
  /// there is a PLTE chunk, that one must be inspected before tRNS or bKGD.
  int lodepng_inspect_chunk(
    ffi.Pointer<LodePNGState> state,
    int pos,
    ffi.Pointer<ffi.UnsignedChar> in1,
    int insize,
  ) {
    return _lodepng_inspect_chunk(
      state,
      pos,
      in1,
      insize,
    );
  }

  late final _lodepng_inspect_chunkPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<LodePNGState>,
              ffi.Size,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size)>>('lodepng_inspect_chunk');
  late final _lodepng_inspect_chunk = _lodepng_inspect_chunkPtr.asFunction<
      int Function(ffi.Pointer<LodePNGState>, int,
          ffi.Pointer<ffi.UnsignedChar>, int)>();

  /// This function allocates the out buffer with standard malloc and stores the size in *outsize.
  int lodepng_encode(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.Size> outsize,
    ffi.Pointer<ffi.UnsignedChar> image,
    int w,
    int h,
    ffi.Pointer<LodePNGState> state,
  ) {
    return _lodepng_encode(
      out,
      outsize,
      image,
      w,
      h,
      state,
    );
  }

  late final _lodepng_encodePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.UnsignedInt,
              ffi.UnsignedInt,
              ffi.Pointer<LodePNGState>)>>('lodepng_encode');
  late final _lodepng_encode = _lodepng_encodePtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.Size>,
          ffi.Pointer<ffi.UnsignedChar>,
          int,
          int,
          ffi.Pointer<LodePNGState>)>();

  /// Gets the length of the data of the chunk. Total chunk length has 12 bytes more.
  /// There must be at least 4 bytes to read from. If the result value is too large,
  /// it may be corrupt data.
  int lodepng_chunk_length(
    ffi.Pointer<ffi.UnsignedChar> chunk,
  ) {
    return _lodepng_chunk_length(
      chunk,
    );
  }

  late final _lodepng_chunk_lengthPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_length');
  late final _lodepng_chunk_length = _lodepng_chunk_lengthPtr
      .asFunction<int Function(ffi.Pointer<ffi.UnsignedChar>)>();

  /// puts the 4-byte type in null terminated string
  void lodepng_chunk_type(
    ffi.Pointer<ffi.Char> type,
    ffi.Pointer<ffi.UnsignedChar> chunk,
  ) {
    return _lodepng_chunk_type(
      type,
      chunk,
    );
  }

  late final _lodepng_chunk_typePtr = _lookup<
      ffi.NativeFunction<
          ffi.Void Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_type');
  late final _lodepng_chunk_type = _lodepng_chunk_typePtr.asFunction<
      void Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.UnsignedChar>)>();

  /// check if the type is the given type
  int lodepng_chunk_type_equals(
    ffi.Pointer<ffi.UnsignedChar> chunk,
    ffi.Pointer<ffi.Char> type,
  ) {
    return _lodepng_chunk_type_equals(
      chunk,
      type,
    );
  }

  late final _lodepng_chunk_type_equalsPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedChar Function(ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Char>)>>('lodepng_chunk_type_equals');
  late final _lodepng_chunk_type_equals =
      _lodepng_chunk_type_equalsPtr.asFunction<
          int Function(ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.Char>)>();

  /// 0: it's one of the critical chunk types, 1: it's an ancillary chunk (see PNG standard)
  int lodepng_chunk_ancillary(
    ffi.Pointer<ffi.UnsignedChar> chunk,
  ) {
    return _lodepng_chunk_ancillary(
      chunk,
    );
  }

  late final _lodepng_chunk_ancillaryPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedChar Function(
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_ancillary');
  late final _lodepng_chunk_ancillary = _lodepng_chunk_ancillaryPtr
      .asFunction<int Function(ffi.Pointer<ffi.UnsignedChar>)>();

  /// 0: public, 1: private (see PNG standard)
  int lodepng_chunk_private(
    ffi.Pointer<ffi.UnsignedChar> chunk,
  ) {
    return _lodepng_chunk_private(
      chunk,
    );
  }

  late final _lodepng_chunk_privatePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedChar Function(
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_private');
  late final _lodepng_chunk_private = _lodepng_chunk_privatePtr
      .asFunction<int Function(ffi.Pointer<ffi.UnsignedChar>)>();

  /// 0: the chunk is unsafe to copy, 1: the chunk is safe to copy (see PNG standard)
  int lodepng_chunk_safetocopy(
    ffi.Pointer<ffi.UnsignedChar> chunk,
  ) {
    return _lodepng_chunk_safetocopy(
      chunk,
    );
  }

  late final _lodepng_chunk_safetocopyPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedChar Function(
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_safetocopy');
  late final _lodepng_chunk_safetocopy = _lodepng_chunk_safetocopyPtr
      .asFunction<int Function(ffi.Pointer<ffi.UnsignedChar>)>();

  /// get pointer to the data of the chunk, where the input points to the header of the chunk
  ffi.Pointer<ffi.UnsignedChar> lodepng_chunk_data(
    ffi.Pointer<ffi.UnsignedChar> chunk,
  ) {
    return _lodepng_chunk_data(
      chunk,
    );
  }

  late final _lodepng_chunk_dataPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_data');
  late final _lodepng_chunk_data = _lodepng_chunk_dataPtr.asFunction<
      ffi.Pointer<ffi.UnsignedChar> Function(ffi.Pointer<ffi.UnsignedChar>)>();

  ffi.Pointer<ffi.UnsignedChar> lodepng_chunk_data_const(
    ffi.Pointer<ffi.UnsignedChar> chunk,
  ) {
    return _lodepng_chunk_data_const(
      chunk,
    );
  }

  late final _lodepng_chunk_data_constPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_data_const');
  late final _lodepng_chunk_data_const =
      _lodepng_chunk_data_constPtr.asFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(
              ffi.Pointer<ffi.UnsignedChar>)>();

  /// returns 0 if the crc is correct, 1 if it's incorrect (0 for OK as usual!)
  int lodepng_chunk_check_crc(
    ffi.Pointer<ffi.UnsignedChar> chunk,
  ) {
    return _lodepng_chunk_check_crc(
      chunk,
    );
  }

  late final _lodepng_chunk_check_crcPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_check_crc');
  late final _lodepng_chunk_check_crc = _lodepng_chunk_check_crcPtr
      .asFunction<int Function(ffi.Pointer<ffi.UnsignedChar>)>();

  /// generates the correct CRC from the data and puts it in the last 4 bytes of the chunk
  void lodepng_chunk_generate_crc(
    ffi.Pointer<ffi.UnsignedChar> chunk,
  ) {
    return _lodepng_chunk_generate_crc(
      chunk,
    );
  }

  late final _lodepng_chunk_generate_crcPtr = _lookup<
          ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.UnsignedChar>)>>(
      'lodepng_chunk_generate_crc');
  late final _lodepng_chunk_generate_crc = _lodepng_chunk_generate_crcPtr
      .asFunction<void Function(ffi.Pointer<ffi.UnsignedChar>)>();

  /// Iterate to next chunks, allows iterating through all chunks of the PNG file.
  /// Input must be at the beginning of a chunk (result of a previous lodepng_chunk_next call,
  /// or the 8th byte of a PNG file which always has the first chunk), or alternatively may
  /// point to the first byte of the PNG file (which is not a chunk but the magic header, the
  /// function will then skip over it and return the first real chunk).
  /// Will output pointer to the start of the next chunk, or at or beyond end of the file if there
  /// is no more chunk after this or possibly if the chunk is corrupt.
  /// Start this process at the 8th byte of the PNG file.
  /// In a non-corrupt PNG file, the last chunk should have name "IEND".
  ffi.Pointer<ffi.UnsignedChar> lodepng_chunk_next(
    ffi.Pointer<ffi.UnsignedChar> chunk,
    ffi.Pointer<ffi.UnsignedChar> end,
  ) {
    return _lodepng_chunk_next(
      chunk,
      end,
    );
  }

  late final _lodepng_chunk_nextPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_next');
  late final _lodepng_chunk_next = _lodepng_chunk_nextPtr.asFunction<
      ffi.Pointer<ffi.UnsignedChar> Function(
          ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.UnsignedChar>)>();

  ffi.Pointer<ffi.UnsignedChar> lodepng_chunk_next_const(
    ffi.Pointer<ffi.UnsignedChar> chunk,
    ffi.Pointer<ffi.UnsignedChar> end,
  ) {
    return _lodepng_chunk_next_const(
      chunk,
      end,
    );
  }

  late final _lodepng_chunk_next_constPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_next_const');
  late final _lodepng_chunk_next_const =
      _lodepng_chunk_next_constPtr.asFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(
              ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.UnsignedChar>)>();

  /// Finds the first chunk with the given type in the range [chunk, end), or returns NULL if not found.
  ffi.Pointer<ffi.UnsignedChar> lodepng_chunk_find(
    ffi.Pointer<ffi.UnsignedChar> chunk,
    ffi.Pointer<ffi.UnsignedChar> end,
    ffi.Pointer<ffi.Char> type,
  ) {
    return _lodepng_chunk_find(
      chunk,
      end,
      type,
    );
  }

  late final _lodepng_chunk_findPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Char>)>>('lodepng_chunk_find');
  late final _lodepng_chunk_find = _lodepng_chunk_findPtr.asFunction<
      ffi.Pointer<ffi.UnsignedChar> Function(ffi.Pointer<ffi.UnsignedChar>,
          ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.Char>)>();

  ffi.Pointer<ffi.UnsignedChar> lodepng_chunk_find_const(
    ffi.Pointer<ffi.UnsignedChar> chunk,
    ffi.Pointer<ffi.UnsignedChar> end,
    ffi.Pointer<ffi.Char> type,
  ) {
    return _lodepng_chunk_find_const(
      chunk,
      end,
      type,
    );
  }

  late final _lodepng_chunk_find_constPtr = _lookup<
      ffi.NativeFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Char>)>>('lodepng_chunk_find_const');
  late final _lodepng_chunk_find_const =
      _lodepng_chunk_find_constPtr.asFunction<
          ffi.Pointer<ffi.UnsignedChar> Function(ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.Char>)>();

  /// Appends chunk to the data in out. The given chunk should already have its chunk header.
  /// The out variable and outsize are updated to reflect the new reallocated buffer.
  /// Returns error code (0 if it went ok)
  int lodepng_chunk_append(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.Size> outsize,
    ffi.Pointer<ffi.UnsignedChar> chunk,
  ) {
    return _lodepng_chunk_append(
      out,
      outsize,
      chunk,
    );
  }

  late final _lodepng_chunk_appendPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_append');
  late final _lodepng_chunk_append = _lodepng_chunk_appendPtr.asFunction<
      int Function(ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.Size>, ffi.Pointer<ffi.UnsignedChar>)>();

  /// Appends new chunk to out. The chunk to append is given by giving its length, type
  /// and data separately. The type is a 4-letter string.
  /// The out variable and outsize are updated to reflect the new reallocated buffer.
  /// Returne error code (0 if it went ok)
  int lodepng_chunk_create(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.Size> outsize,
    int length,
    ffi.Pointer<ffi.Char> type,
    ffi.Pointer<ffi.UnsignedChar> data,
  ) {
    return _lodepng_chunk_create(
      out,
      outsize,
      length,
      type,
      data,
    );
  }

  late final _lodepng_chunk_createPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Size,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>)>>('lodepng_chunk_create');
  late final _lodepng_chunk_create = _lodepng_chunk_createPtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.Size>,
          int,
          ffi.Pointer<ffi.Char>,
          ffi.Pointer<ffi.UnsignedChar>)>();

  /// Calculate CRC32 of buffer
  int lodepng_crc32(
    ffi.Pointer<ffi.UnsignedChar> buf,
    int len,
  ) {
    return _lodepng_crc32(
      buf,
      len,
    );
  }

  late final _lodepng_crc32Ptr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.UnsignedChar>, ffi.Size)>>('lodepng_crc32');
  late final _lodepng_crc32 = _lodepng_crc32Ptr
      .asFunction<int Function(ffi.Pointer<ffi.UnsignedChar>, int)>();

  /// Inflate a buffer. Inflate is the decompression step of deflate. Out buffer must be freed after use.
  int lodepng_inflate(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.Size> outsize,
    ffi.Pointer<ffi.UnsignedChar> in1,
    int insize,
    ffi.Pointer<LodePNGDecompressSettings> settings,
  ) {
    return _lodepng_inflate(
      out,
      outsize,
      in1,
      insize,
      settings,
    );
  }

  late final _lodepng_inflatePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size,
              ffi.Pointer<LodePNGDecompressSettings>)>>('lodepng_inflate');
  late final _lodepng_inflate = _lodepng_inflatePtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.Size>,
          ffi.Pointer<ffi.UnsignedChar>,
          int,
          ffi.Pointer<LodePNGDecompressSettings>)>();

  /// Decompresses Zlib data. Reallocates the out buffer and appends the data. The
  /// data must be according to the zlib specification.
  /// Either, *out must be NULL and *outsize must be 0, or, *out must be a valid
  /// buffer and *outsize its size in bytes. out must be freed by user after usage.
  int lodepng_zlib_decompress(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.Size> outsize,
    ffi.Pointer<ffi.UnsignedChar> in1,
    int insize,
    ffi.Pointer<LodePNGDecompressSettings> settings,
  ) {
    return _lodepng_zlib_decompress(
      out,
      outsize,
      in1,
      insize,
      settings,
    );
  }

  late final _lodepng_zlib_decompressPtr = _lookup<
          ffi.NativeFunction<
              ffi.UnsignedInt Function(
                  ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
                  ffi.Pointer<ffi.Size>,
                  ffi.Pointer<ffi.UnsignedChar>,
                  ffi.Size,
                  ffi.Pointer<LodePNGDecompressSettings>)>>(
      'lodepng_zlib_decompress');
  late final _lodepng_zlib_decompress = _lodepng_zlib_decompressPtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.Size>,
          ffi.Pointer<ffi.UnsignedChar>,
          int,
          ffi.Pointer<LodePNGDecompressSettings>)>();

  /// Compresses data with Zlib. Reallocates the out buffer and appends the data.
  /// Zlib adds a small header and trailer around the deflate data.
  /// The data is output in the format of the zlib specification.
  /// Either, *out must be NULL and *outsize must be 0, or, *out must be a valid
  /// buffer and *outsize its size in bytes. out must be freed by user after usage.
  int lodepng_zlib_compress(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.Size> outsize,
    ffi.Pointer<ffi.UnsignedChar> in1,
    int insize,
    ffi.Pointer<LodePNGCompressSettings> settings,
  ) {
    return _lodepng_zlib_compress(
      out,
      outsize,
      in1,
      insize,
      settings,
    );
  }

  late final _lodepng_zlib_compressPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size,
              ffi.Pointer<LodePNGCompressSettings>)>>('lodepng_zlib_compress');
  late final _lodepng_zlib_compress = _lodepng_zlib_compressPtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.Size>,
          ffi.Pointer<ffi.UnsignedChar>,
          int,
          ffi.Pointer<LodePNGCompressSettings>)>();

  /// Find length-limited Huffman code for given frequencies. This function is in the
  /// public interface only for tests, it's used internally by lodepng_deflate.
  int lodepng_huffman_code_lengths(
    ffi.Pointer<ffi.UnsignedInt> lengths,
    ffi.Pointer<ffi.UnsignedInt> frequencies,
    int numcodes,
    int maxbitlen,
  ) {
    return _lodepng_huffman_code_lengths(
      lengths,
      frequencies,
      numcodes,
      maxbitlen,
    );
  }

  late final _lodepng_huffman_code_lengthsPtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>,
              ffi.Size,
              ffi.UnsignedInt)>>('lodepng_huffman_code_lengths');
  late final _lodepng_huffman_code_lengths =
      _lodepng_huffman_code_lengthsPtr.asFunction<
          int Function(ffi.Pointer<ffi.UnsignedInt>,
              ffi.Pointer<ffi.UnsignedInt>, int, int)>();

  /// Compress a buffer with deflate. See RFC 1951. Out buffer must be freed after use.
  int lodepng_deflate(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.Size> outsize,
    ffi.Pointer<ffi.UnsignedChar> in1,
    int insize,
    ffi.Pointer<LodePNGCompressSettings> settings,
  ) {
    return _lodepng_deflate(
      out,
      outsize,
      in1,
      insize,
      settings,
    );
  }

  late final _lodepng_deflatePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size,
              ffi.Pointer<LodePNGCompressSettings>)>>('lodepng_deflate');
  late final _lodepng_deflate = _lodepng_deflatePtr.asFunction<
      int Function(
          ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.Size>,
          ffi.Pointer<ffi.UnsignedChar>,
          int,
          ffi.Pointer<LodePNGCompressSettings>)>();

  /// Load a file from disk into buffer. The function allocates the out buffer, and
  /// after usage you should free it.
  /// out: output parameter, contains pointer to loaded buffer.
  /// outsize: output parameter, size of the allocated out buffer
  /// filename: the path to the file to load
  /// return value: error code (0 means ok)
  ///
  /// NOTE: Wide-character filenames are not supported, you can use an external method
  /// to handle such files and decode in-memory.
  int lodepng_load_file(
    ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>> out,
    ffi.Pointer<ffi.Size> outsize,
    ffi.Pointer<ffi.Char> filename,
  ) {
    return _lodepng_load_file(
      out,
      outsize,
      filename,
    );
  }

  late final _lodepng_load_filePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.Char>)>>('lodepng_load_file');
  late final _lodepng_load_file = _lodepng_load_filePtr.asFunction<
      int Function(ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
          ffi.Pointer<ffi.Size>, ffi.Pointer<ffi.Char>)>();

  /// Save a file from buffer to disk. Warning, if it exists, this function overwrites
  /// the file without warning!
  /// buffer: the buffer to write
  /// buffersize: size of the buffer to write
  /// filename: the path to the file to save to
  /// return value: error code (0 means ok)
  ///
  /// NOTE: Wide-character filenames are not supported, you can use an external method
  /// to handle such files and encode in-memory
  int lodepng_save_file(
    ffi.Pointer<ffi.UnsignedChar> buffer,
    int buffersize,
    ffi.Pointer<ffi.Char> filename,
  ) {
    return _lodepng_save_file(
      buffer,
      buffersize,
      filename,
    );
  }

  late final _lodepng_save_filePtr = _lookup<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(ffi.Pointer<ffi.UnsignedChar>, ffi.Size,
              ffi.Pointer<ffi.Char>)>>('lodepng_save_file');
  late final _lodepng_save_file = _lodepng_save_filePtr.asFunction<
      int Function(
          ffi.Pointer<ffi.UnsignedChar>, int, ffi.Pointer<ffi.Char>)>();

  void freePtr(
    ffi.Pointer<ffi.Void> p,
  ) {
    return _freePtr(
      p,
    );
  }

  late final _freePtrPtr =
      _lookup<ffi.NativeFunction<ffi.Void Function(ffi.Pointer<ffi.Void>)>>(
          'freePtr');
  late final _freePtr =
      _freePtrPtr.asFunction<void Function(ffi.Pointer<ffi.Void>)>();
}

/// The PNG color types (also used for raw image).
abstract class LodePNGColorType {
  /// grayscale: 1,2,4,8,16 bit
  static const int LCT_GREY = 0;

  /// RGB: 8,16 bit
  static const int LCT_RGB = 2;

  /// palette: 1,2,4,8 bit
  static const int LCT_PALETTE = 3;

  /// grayscale with alpha: 8,16 bit
  static const int LCT_GREY_ALPHA = 4;

  /// RGB with alpha: 8,16 bit
  static const int LCT_RGBA = 6;

  /// LCT_MAX_OCTET_VALUE lets the compiler allow this enum to represent any invalid
  /// byte value from 0 to 255 that could be present in an invalid PNG file header. Do
  /// not use, compare with or set the name LCT_MAX_OCTET_VALUE, instead either use
  /// the valid color type names above, or numeric values like 1 or 7 when checking for
  /// particular disallowed color type byte values, or cast to integer to print it.
  static const int LCT_MAX_OCTET_VALUE = 255;
}

final class LodePNGDecompressSettings extends ffi.Struct {
  /// if 1, continue and don't give an error message if the Adler32 checksum is corrupted
  @ffi.UnsignedInt()
  external int ignore_adler32;

  /// ignore complement of len checksum in uncompressed blocks
  @ffi.UnsignedInt()
  external int ignore_nlen;

  /// Maximum decompressed size, beyond this the decoder may (and is encouraged to) stop decoding,
  /// return an error, output a data size > max_output_size and all the data up to that point. This is
  /// not hard limit nor a guarantee, but can prevent excessive memory usage. This setting is
  /// ignored by the PNG decoder, but is used by the deflate/zlib decoder and can be used by custom ones.
  /// Set to 0 to impose no limit (the default).
  @ffi.Size()
  external int max_output_size;

  /// use custom zlib decoder instead of built in one (default: null).
  /// Should return 0 if success, any non-0 if error (numeric value not exposed).
  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size,
              ffi.Pointer<LodePNGDecompressSettings>)>> custom_zlib;

  /// use custom deflate decoder instead of built in one (default: null)
  /// if custom_zlib is not null, custom_inflate is ignored (the zlib format uses deflate).
  /// Should return 0 if success, any non-0 if error (numeric value not exposed).
  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size,
              ffi.Pointer<LodePNGDecompressSettings>)>> custom_inflate;

  /// optional custom settings for custom functions
  external ffi.Pointer<ffi.Void> custom_context;
}

final class LodePNGCompressSettings extends ffi.Struct {
  /// the block type for LZ (0, 1, 2 or 3, see zlib standard). Should be 2 for proper compression.
  @ffi.UnsignedInt()
  external int btype;

  /// whether or not to use LZ77. Should be 1 for proper compression.
  @ffi.UnsignedInt()
  external int use_lz77;

  /// must be a power of two <= 32768. higher compresses more but is slower. Default value: 2048.
  @ffi.UnsignedInt()
  external int windowsize;

  /// minimum lz77 length. 3 is normally best, 6 can be better for some PNGs. Default: 0
  @ffi.UnsignedInt()
  external int minmatch;

  /// stop searching if >= this length found. Set to 258 for best compression. Default: 128
  @ffi.UnsignedInt()
  external int nicematch;

  /// use lazy matching: better compression but a bit slower. Default: true
  @ffi.UnsignedInt()
  external int lazymatching;

  /// use custom zlib encoder instead of built in one (default: null)
  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size,
              ffi.Pointer<LodePNGCompressSettings>)>> custom_zlib;

  /// use custom deflate encoder instead of built in one (default: null)
  /// if custom_zlib is used, custom_deflate is ignored since only the built in
  /// zlib function will call custom_deflate
  external ffi.Pointer<
      ffi.NativeFunction<
          ffi.UnsignedInt Function(
              ffi.Pointer<ffi.Pointer<ffi.UnsignedChar>>,
              ffi.Pointer<ffi.Size>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Size,
              ffi.Pointer<LodePNGCompressSettings>)>> custom_deflate;

  /// optional custom settings for custom functions
  external ffi.Pointer<ffi.Void> custom_context;
}

/// Color mode of an image. Contains all information required to decode the pixel
/// bits to RGBA colors. This information is the same as used in the PNG file
/// format, and is used both for PNG and raw image data in LodePNG.
final class LodePNGColorMode extends ffi.Struct {
  /// color type, see PNG standard or documentation further in this header file
  @ffi.Int32()
  external int colortype;

  /// bits per sample, see PNG standard or documentation further in this header file
  @ffi.UnsignedInt()
  external int bitdepth;

  /// palette in RGBARGBA... order. Must be either 0, or when allocated must have 1024 bytes
  external ffi.Pointer<ffi.UnsignedChar> palette;

  /// palette size in number of colors (amount of used bytes is 4 * palettesize)
  @ffi.Size()
  external int palettesize;

  /// is a transparent color key given? 0 = false, 1 = true
  @ffi.UnsignedInt()
  external int key_defined;

  /// red/grayscale component of color key
  @ffi.UnsignedInt()
  external int key_r;

  /// green component of color key
  @ffi.UnsignedInt()
  external int key_g;

  /// blue component of color key
  @ffi.UnsignedInt()
  external int key_b;
}

/// The information of a Time chunk in PNG.
final class LodePNGTime extends ffi.Struct {
  /// 2 bytes used (0-65535)
  @ffi.UnsignedInt()
  external int year;

  /// 1-12
  @ffi.UnsignedInt()
  external int month;

  /// 1-31
  @ffi.UnsignedInt()
  external int day;

  /// 0-23
  @ffi.UnsignedInt()
  external int hour;

  /// 0-59
  @ffi.UnsignedInt()
  external int minute;

  /// 0-60 (to allow for leap seconds)
  @ffi.UnsignedInt()
  external int second;
}

/// Information about the PNG image, except pixels, width and height.
final class LodePNGInfo extends ffi.Struct {
  /// compression method of the original file. Always 0.
  @ffi.UnsignedInt()
  external int compression_method;

  /// filter method of the original file
  @ffi.UnsignedInt()
  external int filter_method;

  /// interlace method of the original file: 0=none, 1=Adam7
  @ffi.UnsignedInt()
  external int interlace_method;

  /// color type and bits, palette and transparency of the PNG file
  external LodePNGColorMode color;

  /// is a suggested background color given?
  @ffi.UnsignedInt()
  external int background_defined;

  /// red/gray/palette component of suggested background color
  @ffi.UnsignedInt()
  external int background_r;

  /// green component of suggested background color
  @ffi.UnsignedInt()
  external int background_g;

  /// blue component of suggested background color
  @ffi.UnsignedInt()
  external int background_b;

  /// the amount of texts in these char** buffers (there may be more texts in itext)
  @ffi.Size()
  external int text_num;

  /// the keyword of a text chunk (e.g. "Comment")
  external ffi.Pointer<ffi.Pointer<ffi.Char>> text_keys;

  /// the actual text
  external ffi.Pointer<ffi.Pointer<ffi.Char>> text_strings;

  /// the amount of international texts in this PNG
  @ffi.Size()
  external int itext_num;

  /// the English keyword of the text chunk (e.g. "Comment")
  external ffi.Pointer<ffi.Pointer<ffi.Char>> itext_keys;

  /// language tag for this text's language, ISO/IEC 646 string, e.g. ISO 639 language tag
  external ffi.Pointer<ffi.Pointer<ffi.Char>> itext_langtags;

  /// keyword translated to the international language - UTF-8 string
  external ffi.Pointer<ffi.Pointer<ffi.Char>> itext_transkeys;

  /// the actual international text - UTF-8 string
  external ffi.Pointer<ffi.Pointer<ffi.Char>> itext_strings;

  /// set to 1 to make the encoder generate a tIME chunk
  @ffi.UnsignedInt()
  external int time_defined;

  external LodePNGTime time;

  /// if 0, there is no pHYs chunk and the values below are undefined, if 1 else there is one
  @ffi.UnsignedInt()
  external int phys_defined;

  /// pixels per unit in x direction
  @ffi.UnsignedInt()
  external int phys_x;

  /// pixels per unit in y direction
  @ffi.UnsignedInt()
  external int phys_y;

  /// may be 0 (unknown unit) or 1 (metre)
  @ffi.UnsignedInt()
  external int phys_unit;

  /// Whether a gAMA chunk is present (0 = not present, 1 = present).
  @ffi.UnsignedInt()
  external int gama_defined;

  /// Gamma exponent times 100000
  @ffi.UnsignedInt()
  external int gama_gamma;

  /// Whether a cHRM chunk is present (0 = not present, 1 = present).
  @ffi.UnsignedInt()
  external int chrm_defined;

  /// White Point x times 100000
  @ffi.UnsignedInt()
  external int chrm_white_x;

  /// White Point y times 100000
  @ffi.UnsignedInt()
  external int chrm_white_y;

  /// Red x times 100000
  @ffi.UnsignedInt()
  external int chrm_red_x;

  /// Red y times 100000
  @ffi.UnsignedInt()
  external int chrm_red_y;

  /// Green x times 100000
  @ffi.UnsignedInt()
  external int chrm_green_x;

  /// Green y times 100000
  @ffi.UnsignedInt()
  external int chrm_green_y;

  /// Blue x times 100000
  @ffi.UnsignedInt()
  external int chrm_blue_x;

  /// Blue y times 100000
  @ffi.UnsignedInt()
  external int chrm_blue_y;

  /// Whether an sRGB chunk is present (0 = not present, 1 = present).
  @ffi.UnsignedInt()
  external int srgb_defined;

  /// Rendering intent: 0=perceptual, 1=rel. colorimetric, 2=saturation, 3=abs. colorimetric
  @ffi.UnsignedInt()
  external int srgb_intent;

  /// Whether an iCCP chunk is present (0 = not present, 1 = present).
  @ffi.UnsignedInt()
  external int iccp_defined;

  /// Null terminated string with profile name, 1-79 bytes
  external ffi.Pointer<ffi.Char> iccp_name;

  /// The ICC profile in iccp_profile_size bytes.
  /// Don't allocate this buffer yourself. Use the init/cleanup functions
  /// correctly and use lodepng_set_icc and lodepng_clear_icc.
  external ffi.Pointer<ffi.UnsignedChar> iccp_profile;

  /// The size of iccp_profile in bytes
  @ffi.UnsignedInt()
  external int iccp_profile_size;

  /// is significant bits given? if not, the values below are unused
  @ffi.UnsignedInt()
  external int sbit_defined;

  /// red or gray component of significant bits
  @ffi.UnsignedInt()
  external int sbit_r;

  /// green component of significant bits
  @ffi.UnsignedInt()
  external int sbit_g;

  /// blue component of significant bits
  @ffi.UnsignedInt()
  external int sbit_b;

  /// alpha component of significant bits
  @ffi.UnsignedInt()
  external int sbit_a;

  /// unknown chunks: chunks not known by LodePNG, passed on byte for byte.
  ///
  /// There are 3 buffers, one for each position in the PNG where unknown chunks can appear.
  /// Each buffer contains all unknown chunks for that position consecutively.
  /// The 3 positions are:
  /// 0: between IHDR and PLTE, 1: between PLTE and IDAT, 2: between IDAT and IEND.
  ///
  /// For encoding, do not store critical chunks or known chunks that are enabled with a "_defined" flag
  /// above in here, since the encoder will blindly follow this and could then encode an invalid PNG file
  /// (such as one with two IHDR chunks or the disallowed combination of sRGB with iCCP). But do use
  /// this if you wish to store an ancillary chunk that is not supported by LodePNG (such as sPLT or hIST),
  /// or any non-standard PNG chunk.
  ///
  /// Do not allocate or traverse this data yourself. Use the chunk traversing functions declared
  /// later, such as lodepng_chunk_next and lodepng_chunk_append, to read/write this struct.
  @ffi.Array.multi([3])
  external ffi.Array<ffi.Pointer<ffi.UnsignedChar>> unknown_chunks_data;

  /// size in bytes of the unknown chunks, given for protection
  @ffi.Array.multi([3])
  external ffi.Array<ffi.Size> unknown_chunks_size;
}

/// Settings for the decoder. This contains settings for the PNG and the Zlib
/// decoder, but not the Info settings from the Info structs.
final class LodePNGDecoderSettings extends ffi.Struct {
  /// in here is the setting to ignore Adler32 checksums
  external LodePNGDecompressSettings zlibsettings;

  /// ignore CRC checksums
  @ffi.UnsignedInt()
  external int ignore_crc;

  /// ignore unknown critical chunks
  @ffi.UnsignedInt()
  external int ignore_critical;

  /// ignore issues at end of file if possible (missing IEND chunk, too large chunk, ...)
  @ffi.UnsignedInt()
  external int ignore_end;

  /// whether to convert the PNG to the color type you want. Default: yes
  @ffi.UnsignedInt()
  external int color_convert;

  /// if false but remember_unknown_chunks is true, they're stored in the unknown chunks
  @ffi.UnsignedInt()
  external int read_text_chunks;

  /// store all bytes from unknown chunks in the LodePNGInfo (off by default, useful for a png editor)
  @ffi.UnsignedInt()
  external int remember_unknown_chunks;

  /// maximum size for decompressed text chunks. If a text chunk's text is larger than this, an error is returned,
  /// unless reading text chunks is disabled or this limit is set higher or disabled. Set to 0 to allow any size.
  /// By default it is a value that prevents unreasonably large strings from hogging memory.
  @ffi.Size()
  external int max_text_size;

  /// maximum size for compressed ICC chunks. If the ICC profile is larger than this, an error will be returned. Set to
  /// 0 to allow any size. By default this is a value that prevents ICC profiles that would be much larger than any
  /// legitimate profile could be to hog memory.
  @ffi.Size()
  external int max_icc_size;
}

/// automatically use color type with less bits per pixel if losslessly possible. Default: AUTO
abstract class LodePNGFilterStrategy {
  /// every filter at zero
  static const int LFS_ZERO = 0;

  /// every filter at 1, 2, 3 or 4 (paeth), unlike LFS_ZERO not a good choice, but for testing
  static const int LFS_ONE = 1;
  static const int LFS_TWO = 2;
  static const int LFS_THREE = 3;
  static const int LFS_FOUR = 4;

  /// Use filter that gives minimum sum, as described in the official PNG filter heuristic.
  static const int LFS_MINSUM = 5;

  /// Use the filter type that gives smallest Shannon entropy for this scanline. Depending
  /// on the image, this is better or worse than minsum.
  static const int LFS_ENTROPY = 6;

  /// Brute-force-search PNG filters by compressing each filter for each scanline.
  /// Experimental, very slow, and only rarely gives better compression than MINSUM.
  static const int LFS_BRUTE_FORCE = 7;

  /// use predefined_filters buffer: you specify the filter type for each scanline
  static const int LFS_PREDEFINED = 8;
}

/// Gives characteristics about the integer RGBA colors of the image (count, alpha channel usage, bit depth, ...),
/// which helps decide which color model to use for encoding.
/// Used internally by default if "auto_convert" is enabled. Public because it's useful for custom algorithms.
final class LodePNGColorStats extends ffi.Struct {
  /// not grayscale
  @ffi.UnsignedInt()
  external int colored;

  /// image is not opaque and color key is possible instead of full alpha
  @ffi.UnsignedInt()
  external int key;

  /// key values, always as 16-bit, in 8-bit case the byte is duplicated, e.g. 65535 means 255
  @ffi.UnsignedShort()
  external int key_r;

  @ffi.UnsignedShort()
  external int key_g;

  @ffi.UnsignedShort()
  external int key_b;

  /// image is not opaque and alpha channel or alpha palette required
  @ffi.UnsignedInt()
  external int alpha;

  /// amount of colors, up to 257. Not valid if bits == 16 or allow_palette is disabled.
  @ffi.UnsignedInt()
  external int numcolors;

  /// Remembers up to the first 256 RGBA colors, in no particular order, only valid when numcolors is valid
  @ffi.Array.multi([1024])
  external ffi.Array<ffi.UnsignedChar> palette;

  /// bits per channel (not for palette). 1,2 or 4 for grayscale only. 16 if 16-bit per channel required.
  @ffi.UnsignedInt()
  external int bits;

  @ffi.Size()
  external int numpixels;

  /// default 1. if 0, disallow choosing palette colortype in auto_choose_color, and don't count numcolors
  @ffi.UnsignedInt()
  external int allow_palette;

  /// default 1. if 0, choose RGB or RGBA even if the image only has gray colors
  @ffi.UnsignedInt()
  external int allow_greyscale;
}

/// Settings for the encoder.
final class LodePNGEncoderSettings extends ffi.Struct {
  /// settings for the zlib encoder, such as window size, ...
  external LodePNGCompressSettings zlibsettings;

  /// automatically choose output PNG color type. If false, must explicitely choose the output color
  /// type in state.info_png.color.colortype, info_png.color.bitdepth and optionally its palette.
  /// Default: true
  @ffi.UnsignedInt()
  external int auto_convert;

  /// If true, follows the official PNG heuristic: if the PNG uses a palette or lower than
  /// 8 bit depth, set all filters to zero. Otherwise use the filter_strategy. Note that to
  /// completely follow the official PNG heuristic, filter_palette_zero must be true and
  /// filter_strategy must be LFS_MINSUM
  @ffi.UnsignedInt()
  external int filter_palette_zero;

  /// Which filter strategy to use when not using zeroes due to filter_palette_zero.
  /// Set filter_palette_zero to 0 to ensure always using your chosen strategy. Default: LFS_MINSUM
  @ffi.Int32()
  external int filter_strategy;

  /// used if filter_strategy is LFS_PREDEFINED. In that case, this must point to a buffer with
  /// the same length as the amount of scanlines in the image, and each value must <= 5. You
  /// have to cleanup this buffer, LodePNG will never free it. Don't forget that filter_palette_zero
  /// must be set to 0 to ensure this is also used on palette or low bitdepth images.
  external ffi.Pointer<ffi.UnsignedChar> predefined_filters;

  /// force creating a PLTE chunk if colortype is 2 or 6 (= a suggested palette).
  /// If colortype is 3, PLTE is always created. If color type is explicitely set
  /// to a grayscale type (1 or 4), this is not done and is ignored. If enabling this,
  /// a palette must be present in the info_png.
  /// NOTE: enabling this may worsen compression if auto_convert is used to choose
  /// optimal color mode, because it cannot use grayscale color modes in this case
  @ffi.UnsignedInt()
  external int force_palette;

  /// add LodePNG identifier and version as a text chunk, for debugging
  @ffi.UnsignedInt()
  external int add_id;

  /// encode text chunks as zTXt chunks instead of tEXt chunks, and use compression in iTXt chunks
  @ffi.UnsignedInt()
  external int text_compression;
}

/// The settings, state and information for extended encoding and decoding.
final class LodePNGState extends ffi.Struct {
  /// the decoding settings
  external LodePNGDecoderSettings decoder;

  /// the encoding settings
  external LodePNGEncoderSettings encoder;

  /// specifies the format in which you would like to get the raw pixel buffer
  external LodePNGColorMode info_raw;

  /// info of the PNG image obtained after decoding
  external LodePNGInfo info_png;

  @ffi.UnsignedInt()
  external int error;
}
