import 'package:flutter/material.dart';
import 'package:flutter/services.dart' show Clipboard, ClipboardData;
import '../localization/language/languages.dart';
import 'package:url_launcher/url_launcher.dart';

class Donate extends StatelessWidget {
  static const String bitcoinAdress = '15ZpNzqbYFx9P7wg4U438JMwZr2q3W6fkS';
  static const String urlPayPal = 'https://www.paypal.com/donate?hosted_button_id=986PSAHLH6N4L';

  @override
  Widget build(BuildContext context) {
    Languages lang = Languages.of(context);

    void _launchURL(String url) async {
      if (await canLaunch(url)) {
        await launch(url);
      } else {
        ScaffoldMessenger.of(context).showSnackBar(SnackBar(
          content: const Text('Could not launch PayPal payment website.'),
        ));
      }
    }

    return Scaffold(
      appBar: AppBar(
        title: Text(lang.donar),
        leading: IconButton(
          icon: const Icon(Icons.close),
          onPressed: () => Navigator.of(context).pop(),
        ),
      ),
      body: SingleChildScrollView(
        child: Padding(
          padding: const EdgeInsets.all(20.0),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Center(
                child: Column(
                  children: [
                    Text('Call Counter', style: Theme.of(context).textTheme.headline5),
                    const Icon(Icons.local_cafe_outlined, size: 60.0, color: Color(0xFF80DEEA)),
                    const Text('Buy Me a Coffee'),
                  ],
                ),
              ),
              const SizedBox(height: 20.0),
              Text(lang.textDonate, style: Theme.of(context).textTheme.subtitle1),
              const SizedBox(height: 20),
              const Text('Scan this QR code with your wallet application:'),
              const SizedBox(height: 10.0),
              Center(
                child: FractionallySizedBox(
                  widthFactor: 0.5,
                  child: Image.asset('assets/images/Bitcoin_QR.png'),
                ),
              ),
              const SizedBox(height: 20),
              const Text('Or copy the BTC Wallet Address:'),
              const SizedBox(height: 10),
              FittedBox(
                fit: BoxFit.fitWidth,
                child: Container(
                  decoration: BoxDecoration(
                      borderRadius: const BorderRadius.all(Radius.circular(8.0)),
                      border: Border.all(color: Colors.white54, style: BorderStyle.solid)),
                  child: Row(
                    children: [
                      Container(
                        height: 50,
                        padding: EdgeInsets.all(8.0),
                        decoration: ShapeDecoration(
                          color: Colors.white12,
                          shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.only(
                              bottomLeft: Radius.circular(8),
                              topLeft: Radius.circular(8),
                              bottomRight: Radius.zero,
                              topRight: Radius.zero,
                            ),
                          ),
                        ),
                        child: const Align(alignment: Alignment.center, child: Text(bitcoinAdress)),
                      ),
                      Container(
                        height: 50,
                        decoration: BoxDecoration(
                          border: Border(
                            left: BorderSide(color: Colors.white54, style: BorderStyle.solid),
                          ),
                        ),
                        child: IconButton(
                          icon: const Icon(Icons.copy),
                          onPressed: () async {
                            await Clipboard.setData(ClipboardData(text: bitcoinAdress));
                            ScaffoldMessenger.of(context).showSnackBar(SnackBar(
                              content: const Text('BTC Address copied to Clipboard.'),
                            ));
                          },
                        ),
                      ),
                    ],
                  ),
                ),
              ),
              const SizedBox(height: 10),
              Text(lang.textPaypal, style: Theme.of(context).textTheme.subtitle1),
              const SizedBox(height: 10),
              Align(
                alignment: Alignment.center,
                child: FractionallySizedBox(
                  widthFactor: 0.4,
                  child: ElevatedButton(
                    style: TextButton.styleFrom(
                      backgroundColor: Colors.white,
                      elevation: 10.0,
                      padding: const EdgeInsets.all(10),
                    ),
                    onPressed: () => _launchURL(urlPayPal),
                    child: Image.asset('assets/images/paypal_logo.png'),
                  ),
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
