/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Canvas;
import android.util.Pair;
import com.androidplot.Plot;
import com.androidplot.PlotListener;
import com.androidplot.xy.XYSeries;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SimpleXYSeries
implements XYSeries,
PlotListener {
    private static final String TAG = SimpleXYSeries.class.getName();
    private volatile LinkedList<Number> xVals = new LinkedList();
    private volatile LinkedList<Number> yVals = new LinkedList();
    private volatile String title = null;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    @Override
    public void onBeforeDraw(Plot source, Canvas canvas) {
        this.lock.readLock().lock();
    }

    @Override
    public void onAfterDraw(Plot source, Canvas canvas) {
        this.lock.readLock().unlock();
    }

    public SimpleXYSeries(String title) {
        this.title = title;
    }

    public SimpleXYSeries(List<? extends Number> model, ArrayFormat format, String title) {
        this(title);
        this.setModel(model, format);
    }

    public SimpleXYSeries(List<? extends Number> xVals, List<? extends Number> yVals, String title) {
        this(title);
        if (xVals == null || yVals == null) {
            throw new IllegalArgumentException("Neither the xVals nor the yVals parameters may be null.");
        }
        if (xVals.size() != yVals.size()) {
            throw new IllegalArgumentException("xVals and yVals List parameters must be of the same size.");
        }
        this.xVals.addAll(xVals);
        this.yVals.addAll(yVals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useImplicitXVals() {
        this.lock.writeLock().lock();
        try {
            this.xVals = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setModel(List<? extends Number> model, ArrayFormat format) {
        this.lock.writeLock().lock();
        try {
            this.xVals = null;
            this.yVals.clear();
            if (model == null || model.size() == 0) {
                return;
            }
            switch (format) {
                case Y_VALS_ONLY: {
                    for (Number number : model) {
                        this.yVals.add(number);
                    }
                    break;
                }
                case XY_VALS_INTERLEAVED: {
                    void var4_7;
                    if (this.xVals == null) {
                        this.xVals = new LinkedList();
                    }
                    if (model.size() % 2 != 0) {
                        throw new IndexOutOfBoundsException("Cannot auto-generate series from odd-sized xy List.");
                    }
                    int sz = model.size() / 2;
                    boolean bl = false;
                    int j = 0;
                    while (var4_7 < sz) {
                        this.xVals.add(model.get(j));
                        this.yVals.add(model.get(j + 1));
                        ++var4_7;
                        j += 2;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected enum value: " + (Object)((Object)format));
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setX(Number value, int index) {
        this.lock.writeLock().lock();
        try {
            this.xVals.set(index, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setY(Number value, int index) {
        this.lock.writeLock().lock();
        try {
            this.yVals.set(index, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXY(Number xVal, Number yVal, int index) {
        this.lock.writeLock().lock();
        try {
            this.yVals.set(index, yVal);
            this.xVals.set(index, xVal);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(Number x, Number y) {
        this.lock.writeLock().lock();
        try {
            if (this.xVals != null) {
                this.xVals.addFirst(x);
            }
            this.yVals.addFirst(y);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Number, Number> removeFirst() {
        this.lock.writeLock().lock();
        try {
            if (this.size() <= 0) {
                throw new NoSuchElementException();
            }
            Pair pair = new Pair((Object)(this.xVals != null ? (Number)this.xVals.removeFirst() : (Number)0), (Object)this.yVals.removeFirst());
            return pair;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(Number x, Number y) {
        this.lock.writeLock().lock();
        try {
            if (this.xVals != null) {
                this.xVals.addLast(x);
            }
            this.yVals.addLast(y);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Number, Number> removeLast() {
        this.lock.writeLock().lock();
        try {
            if (this.size() <= 0) {
                throw new NoSuchElementException();
            }
            Pair pair = new Pair((Object)(this.xVals != null ? (Number)this.xVals.removeLast() : (Number)(this.yVals.size() - 1)), (Object)this.yVals.removeLast());
            return pair;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String title) {
        this.lock.writeLock().lock();
        try {
            this.title = title;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.yVals != null ? this.yVals.size() : 0;
    }

    @Override
    public Number getX(int index) {
        return this.xVals != null ? (Number)this.xVals.get(index) : (Number)index;
    }

    @Override
    public Number getY(int index) {
        return this.yVals.get(index);
    }

    public static enum ArrayFormat {
        Y_VALS_ONLY,
        XY_VALS_INTERLEAVED;

    }
}

