/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Pair;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.util.ValPixConverter;
import com.androidplot.xy.LineAndPointFormatter;
import com.androidplot.xy.PointLabelFormatter;
import com.androidplot.xy.PointLabeler;
import com.androidplot.xy.RectRegion;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYRegionFormatter;
import com.androidplot.xy.XYSeries;
import com.androidplot.xy.XYSeriesRenderer;
import java.util.ArrayList;
import java.util.List;

public class LineAndPointRenderer<FormatterType extends LineAndPointFormatter>
extends XYSeriesRenderer<FormatterType> {
    public LineAndPointRenderer(XYPlot plot) {
        super(plot);
    }

    @Override
    public void onRender(Canvas canvas, RectF plotArea) throws PlotRenderException {
        List seriesList = ((XYPlot)this.getPlot()).getSeriesListForRenderer(this.getClass());
        if (seriesList != null) {
            for (XYSeries series : seriesList) {
                this.drawSeries(canvas, plotArea, series, (LineAndPointFormatter)this.getFormatter(series));
            }
        }
    }

    @Override
    public void doDrawLegendIcon(Canvas canvas, RectF rect, LineAndPointFormatter formatter) {
        float centerY = rect.centerY();
        float centerX = rect.centerX();
        if (formatter.getFillPaint() != null) {
            canvas.drawRect(rect, formatter.getFillPaint());
        }
        if (formatter.getLinePaint() != null) {
            canvas.drawLine(rect.left, rect.bottom, rect.right, rect.top, formatter.getLinePaint());
        }
        if (formatter.getVertexPaint() != null) {
            canvas.drawPoint(centerX, centerY, formatter.getVertexPaint());
        }
    }

    protected void appendToPath(Path path, PointF thisPoint, PointF lastPoint) {
        path.lineTo(thisPoint.x, thisPoint.y);
    }

    protected void drawSeries(Canvas canvas, RectF plotArea, XYSeries series, LineAndPointFormatter formatter) {
        PointF lastPoint = null;
        PointF firstPoint = null;
        Paint linePaint = formatter.getLinePaint();
        Path path = null;
        ArrayList<Pair> points = new ArrayList<Pair>(series.size());
        for (int i = 0; i < series.size(); ++i) {
            PointF thisPoint;
            Number y = series.getY(i);
            Number x = series.getX(i);
            if (y != null && x != null) {
                thisPoint = ValPixConverter.valToPix(x, y, plotArea, ((XYPlot)this.getPlot()).getCalculatedMinX(), ((XYPlot)this.getPlot()).getCalculatedMaxX(), ((XYPlot)this.getPlot()).getCalculatedMinY(), ((XYPlot)this.getPlot()).getCalculatedMaxY());
                points.add(new Pair((Object)thisPoint, (Object)i));
            } else {
                thisPoint = null;
            }
            if (linePaint != null && thisPoint != null) {
                if (firstPoint == null) {
                    path = new Path();
                    firstPoint = thisPoint;
                    path.moveTo(firstPoint.x, firstPoint.y);
                }
                if (lastPoint != null) {
                    this.appendToPath(path, thisPoint, lastPoint);
                }
                lastPoint = thisPoint;
                continue;
            }
            if (lastPoint != null) {
                this.renderPath(canvas, plotArea, path, firstPoint, lastPoint, formatter);
            }
            firstPoint = null;
            lastPoint = null;
        }
        if (linePaint != null && firstPoint != null) {
            this.renderPath(canvas, plotArea, path, firstPoint, lastPoint, formatter);
        }
        Paint vertexPaint = formatter.getVertexPaint();
        PointLabelFormatter plf = formatter.getPointLabelFormatter();
        if (vertexPaint != null || plf != null) {
            for (Pair p : points) {
                PointLabeler pointLabeler = formatter.getPointLabeler();
                if (vertexPaint != null) {
                    canvas.drawPoint(((PointF)p.first).x, ((PointF)p.first).y, formatter.getVertexPaint());
                }
                if (plf == null || pointLabeler == null) continue;
                canvas.drawText(pointLabeler.getLabel(series, (Integer)p.second), ((PointF)p.first).x + plf.hOffset, ((PointF)p.first).y + plf.vOffset, plf.getTextPaint());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderPath(Canvas canvas, RectF plotArea, Path path, PointF firstPoint, PointF lastPoint, LineAndPointFormatter formatter) {
        Path outlinePath = new Path(path);
        switch (formatter.getFillDirection()) {
            case BOTTOM: {
                path.lineTo(lastPoint.x, plotArea.bottom);
                path.lineTo(firstPoint.x, plotArea.bottom);
                path.close();
                break;
            }
            case TOP: {
                path.lineTo(lastPoint.x, plotArea.top);
                path.lineTo(firstPoint.x, plotArea.top);
                path.close();
                break;
            }
            case RANGE_ORIGIN: {
                float originPix = ValPixConverter.valToPix(((XYPlot)this.getPlot()).getRangeOrigin().doubleValue(), ((XYPlot)this.getPlot()).getCalculatedMinY().doubleValue(), ((XYPlot)this.getPlot()).getCalculatedMaxY().doubleValue(), plotArea.height(), true);
                path.lineTo(lastPoint.x, originPix += plotArea.top);
                path.lineTo(firstPoint.x, originPix);
                path.close();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Fill direction not yet implemented: " + (Object)((Object)formatter.getFillDirection()));
            }
        }
        if (formatter.getFillPaint() != null) {
            canvas.drawPath(path, formatter.getFillPaint());
        }
        double minX = ((XYPlot)this.getPlot()).getCalculatedMinX().doubleValue();
        double maxX = ((XYPlot)this.getPlot()).getCalculatedMaxX().doubleValue();
        double minY = ((XYPlot)this.getPlot()).getCalculatedMinY().doubleValue();
        double maxY = ((XYPlot)this.getPlot()).getCalculatedMaxY().doubleValue();
        for (RectRegion r : RectRegion.regionsWithin(formatter.getRegions().elements(), minX, maxX, minY, maxY)) {
            Object f = formatter.getRegionFormatter(r);
            RectF regionRect = r.getRectF(plotArea, minX, maxX, minY, maxY);
            if (regionRect == null) continue;
            try {
                canvas.save(31);
                canvas.clipPath(path);
                canvas.drawRect(regionRect, ((XYRegionFormatter)f).getPaint());
            }
            finally {
                canvas.restore();
            }
        }
        if (formatter.getLinePaint() != null) {
            canvas.drawPath(outlinePath, formatter.getLinePaint());
        }
        path.rewind();
    }
}

