/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Paint;
import com.androidplot.ui.SeriesRenderer;
import com.androidplot.util.PixelUtils;
import com.androidplot.xy.FillDirection;
import com.androidplot.xy.LineAndPointRenderer;
import com.androidplot.xy.PointLabelFormatter;
import com.androidplot.xy.PointLabeler;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYRegionFormatter;
import com.androidplot.xy.XYSeries;
import com.androidplot.xy.XYSeriesFormatter;

public class LineAndPointFormatter
extends XYSeriesFormatter<XYRegionFormatter> {
    private static final float DEFAULT_LINE_STROKE_WIDTH_DP = 1.5f;
    private static final float DEFAULT_VERTEX_STROKE_WIDTH_DP = 4.5f;
    private PointLabeler pointLabeler = new PointLabeler(){

        @Override
        public String getLabel(XYSeries series, int index) {
            return series.getY(index) + "";
        }
    };
    protected FillDirection fillDirection = FillDirection.BOTTOM;
    protected Paint linePaint;
    protected Paint vertexPaint;
    protected Paint fillPaint;
    private PointLabelFormatter pointLabelFormatter;

    public FillDirection getFillDirection() {
        return this.fillDirection;
    }

    public void setFillDirection(FillDirection fillDirection) {
        this.fillDirection = fillDirection;
    }

    public LineAndPointFormatter() {
        this(-65536, -16711936, -16776961, null);
    }

    public LineAndPointFormatter(Integer lineColor, Integer vertexColor, Integer fillColor, PointLabelFormatter plf) {
        this(lineColor, vertexColor, fillColor, plf, FillDirection.BOTTOM);
    }

    public LineAndPointFormatter(Integer lineColor, Integer vertexColor, Integer fillColor, PointLabelFormatter plf, FillDirection fillDir) {
        this.initLinePaint(-16777216);
        this.initLinePaint(lineColor);
        this.initVertexPaint(vertexColor);
        this.initFillPaint(fillColor);
        this.setFillDirection(fillDir);
        this.setPointLabelFormatter(plf);
    }

    @Override
    public Class<? extends SeriesRenderer> getRendererClass() {
        return LineAndPointRenderer.class;
    }

    @Override
    public SeriesRenderer getRendererInstance(XYPlot plot) {
        return new LineAndPointRenderer(plot);
    }

    protected void initLinePaint(Integer lineColor) {
        if (lineColor == null) {
            this.linePaint = null;
        } else {
            this.linePaint = new Paint();
            this.linePaint.setAntiAlias(true);
            this.linePaint.setStrokeWidth(PixelUtils.dpToPix(1.5f));
            this.linePaint.setColor(lineColor.intValue());
            this.linePaint.setStyle(Paint.Style.STROKE);
        }
    }

    protected void initVertexPaint(Integer vertexColor) {
        if (vertexColor == null) {
            this.vertexPaint = null;
        } else {
            this.vertexPaint = new Paint();
            this.vertexPaint.setAntiAlias(true);
            this.vertexPaint.setStrokeWidth(PixelUtils.dpToPix(4.5f));
            this.vertexPaint.setColor(vertexColor.intValue());
            this.vertexPaint.setStrokeCap(Paint.Cap.ROUND);
        }
    }

    protected void initFillPaint(Integer fillColor) {
        if (fillColor == null) {
            this.fillPaint = null;
        } else {
            this.fillPaint = new Paint();
            this.fillPaint.setAntiAlias(true);
            this.fillPaint.setColor(fillColor.intValue());
        }
    }

    public void enableShadows() {
        this.linePaint.setShadowLayer(1.0f, 3.0f, 3.0f, -16777216);
        this.vertexPaint.setShadowLayer(1.0f, 3.0f, 3.0f, -16777216);
    }

    public void disableShadows() {
        this.linePaint.setShadowLayer(0.0f, 0.0f, 0.0f, -16777216);
        this.vertexPaint.setShadowLayer(0.0f, 0.0f, 0.0f, -16777216);
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public void setLinePaint(Paint linePaint) {
        this.linePaint = linePaint;
    }

    public Paint getVertexPaint() {
        return this.vertexPaint;
    }

    public void setVertexPaint(Paint vertexPaint) {
        this.vertexPaint = vertexPaint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public PointLabelFormatter getPointLabelFormatter() {
        return this.pointLabelFormatter;
    }

    public void setPointLabelFormatter(PointLabelFormatter pointLabelFormatter) {
        this.pointLabelFormatter = pointLabelFormatter;
    }

    public PointLabeler getPointLabeler() {
        return this.pointLabeler;
    }

    public void setPointLabeler(PointLabeler pointLabeler) {
        this.pointLabeler = pointLabeler;
    }
}

