/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Canvas;
import android.graphics.RectF;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.util.ValPixConverter;
import com.androidplot.xy.BarFormatter;
import com.androidplot.xy.PointLabelFormatter;
import com.androidplot.xy.PointLabeler;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYSeries;
import com.androidplot.xy.XYSeriesRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BarRenderer<T extends BarFormatter>
extends XYSeriesRenderer<T> {
    private BarRenderStyle renderStyle = BarRenderStyle.OVERLAID;
    private BarWidthStyle widthStyle = BarWidthStyle.FIXED_WIDTH;
    private float barWidth = 5.0f;
    private float barGap = 1.0f;
    private Comparator<Bar> barComparator = new BarComparator();

    public BarRenderer(XYPlot plot) {
        super(plot);
    }

    public void setBarWidth(float barWidth) {
        this.barWidth = barWidth;
    }

    public void setBarGap(float barGap) {
        this.barGap = barGap;
    }

    public void setBarRenderStyle(BarRenderStyle renderStyle) {
        this.renderStyle = renderStyle;
    }

    public void setBarWidthStyle(BarWidthStyle widthStyle) {
        this.widthStyle = widthStyle;
    }

    public void setBarWidthStyle(BarWidthStyle style, float value) {
        this.setBarWidthStyle(style);
        switch (style) {
            case FIXED_WIDTH: {
                this.setBarWidth(value);
                break;
            }
            case VARIABLE_WIDTH: {
                this.setBarGap(value);
                break;
            }
        }
    }

    public void setBarComparator(Comparator<Bar> barComparator) {
        this.barComparator = barComparator;
    }

    @Override
    public void doDrawLegendIcon(Canvas canvas, RectF rect, BarFormatter formatter) {
        canvas.drawRect(rect, formatter.getFillPaint());
        canvas.drawRect(rect, formatter.getBorderPaint());
    }

    public T getFormatter(int index, XYSeries series) {
        return (T)((BarFormatter)this.getFormatter(series));
    }

    @Override
    public void onRender(Canvas canvas, RectF plotArea) throws PlotRenderException {
        List sl = ((XYPlot)this.getPlot()).getSeriesListForRenderer(this.getClass());
        TreeMap<Integer, BarGroup> axisMap = new TreeMap<Integer, BarGroup>();
        if (sl == null) {
            return;
        }
        for (XYSeries series : sl) {
            for (int i = 0; i < series.size(); ++i) {
                BarGroup barGroup;
                if (series.getX(i) == null) continue;
                Bar b = new Bar(series, i, plotArea);
                if (axisMap.containsKey(b.intX)) {
                    barGroup = (BarGroup)axisMap.get(b.intX);
                } else {
                    barGroup = new BarGroup(b.intX, plotArea);
                    axisMap.put(b.intX, barGroup);
                }
                barGroup.addBar(b);
            }
        }
        BarGroup prev = null;
        for (Map.Entry mapEntry : axisMap.entrySet()) {
            BarGroup current = (BarGroup)mapEntry.getValue();
            current.prev = prev;
            prev = current;
        }
        int gap = (int)this.barGap;
        float f_rough_width = (plotArea.width() - (float)((axisMap.size() - 1) * gap)) / (float)(axisMap.size() - 1);
        int rough_width = (int)f_rough_width;
        if (rough_width < 0) {
            rough_width = 0;
        }
        if (gap > rough_width) {
            gap = rough_width / 2;
        }
        block12: for (Number key : axisMap.keySet()) {
            BarGroup barGroup = (BarGroup)axisMap.get(key);
            switch (this.widthStyle) {
                case FIXED_WIDTH: {
                    barGroup.leftX = barGroup.intX - (int)(this.barWidth / 2.0f);
                    barGroup.width = (int)this.barWidth;
                    barGroup.rightX = barGroup.leftX + barGroup.width;
                    break;
                }
                case VARIABLE_WIDTH: {
                    if (barGroup.prev != null) {
                        if (barGroup.intX - barGroup.prev.intX - gap - 1 > (int)((double)rough_width * 1.5)) {
                            barGroup.leftX = barGroup.intX - rough_width / 2;
                            barGroup.width = rough_width;
                            barGroup.rightX = barGroup.leftX + barGroup.width;
                            break;
                        }
                        barGroup.leftX = barGroup.prev.rightX + gap + 1;
                        if (barGroup.leftX > barGroup.intX) {
                            barGroup.leftX = barGroup.intX;
                        }
                        barGroup.rightX = barGroup.intX + rough_width / 2;
                        barGroup.width = barGroup.rightX - barGroup.leftX;
                        break;
                    }
                    barGroup.leftX = barGroup.intX - rough_width / 2;
                    barGroup.width = rough_width;
                    barGroup.rightX = barGroup.leftX + barGroup.width;
                    break;
                }
            }
            switch (this.renderStyle) {
                case OVERLAID: {
                    Collections.sort(barGroup.bars, this.barComparator);
                    for (Bar b : barGroup.bars) {
                        BarFormatter formatter = b.formatter();
                        PointLabelFormatter plf = formatter.getPointLabelFormatter();
                        PointLabeler pointLabeler = null;
                        if (formatter != null) {
                            pointLabeler = formatter.getPointLabeler();
                        }
                        if (b.barGroup.width >= 2) {
                            canvas.drawRect((float)b.barGroup.leftX, (float)b.intY, (float)b.barGroup.rightX, b.barGroup.plotArea.bottom, formatter.getFillPaint());
                        }
                        canvas.drawRect((float)b.barGroup.leftX, (float)b.intY, (float)b.barGroup.rightX, b.barGroup.plotArea.bottom, formatter.getBorderPaint());
                        if (plf == null || pointLabeler == null) continue;
                        canvas.drawText(pointLabeler.getLabel(b.series, b.seriesIndex), (float)b.intX + plf.hOffset, (float)b.intY + plf.vOffset, plf.getTextPaint());
                    }
                    continue block12;
                }
                case SIDE_BY_SIDE: {
                    int width = barGroup.width / barGroup.bars.size();
                    int leftX = barGroup.leftX;
                    Collections.sort(barGroup.bars, this.barComparator);
                    for (Bar b : barGroup.bars) {
                        BarFormatter formatter = b.formatter();
                        PointLabelFormatter plf = formatter.getPointLabelFormatter();
                        PointLabeler pointLabeler = null;
                        if (formatter != null) {
                            pointLabeler = formatter.getPointLabeler();
                        }
                        if (b.barGroup.width >= 2) {
                            canvas.drawRect((float)leftX, (float)b.intY, (float)(leftX + width), b.barGroup.plotArea.bottom, formatter.getFillPaint());
                        }
                        canvas.drawRect((float)leftX, (float)b.intY, (float)(leftX + width), b.barGroup.plotArea.bottom, formatter.getBorderPaint());
                        if (plf != null && pointLabeler != null) {
                            canvas.drawText(pointLabeler.getLabel(b.series, b.seriesIndex), (float)(leftX + width / 2) + plf.hOffset, (float)b.intY + plf.vOffset, plf.getTextPaint());
                        }
                        leftX += width;
                    }
                    continue block12;
                }
                case STACKED: {
                    int bottom = (int)barGroup.plotArea.bottom;
                    Collections.sort(barGroup.bars, this.barComparator);
                    for (Bar b : barGroup.bars) {
                        BarFormatter formatter = b.formatter();
                        PointLabelFormatter plf = formatter.getPointLabelFormatter();
                        PointLabeler pointLabeler = null;
                        if (formatter != null) {
                            pointLabeler = formatter.getPointLabeler();
                        }
                        int height = (int)b.barGroup.plotArea.bottom - b.intY;
                        int top = bottom - height;
                        if (b.barGroup.width >= 2) {
                            canvas.drawRect((float)b.barGroup.leftX, (float)top, (float)b.barGroup.rightX, (float)bottom, formatter.getFillPaint());
                        }
                        canvas.drawRect((float)b.barGroup.leftX, (float)top, (float)b.barGroup.rightX, (float)bottom, formatter.getBorderPaint());
                        if (plf != null && pointLabeler != null) {
                            canvas.drawText(pointLabeler.getLabel(b.series, b.seriesIndex), (float)b.intX + plf.hOffset, (float)top + plf.vOffset, plf.getTextPaint());
                        }
                        bottom = top;
                    }
                    continue block12;
                }
            }
        }
    }

    public class BarComparator
    implements Comparator<Bar> {
        @Override
        public int compare(Bar bar1, Bar bar2) {
            switch (BarRenderer.this.renderStyle) {
                case OVERLAID: {
                    return Integer.valueOf(bar1.intY).compareTo(bar2.intY);
                }
                case SIDE_BY_SIDE: {
                    return bar1.series.getTitle().compareToIgnoreCase(bar2.series.getTitle());
                }
                case STACKED: {
                    return bar1.series.getTitle().compareToIgnoreCase(bar2.series.getTitle());
                }
            }
            return 0;
        }
    }

    private class BarGroup {
        public ArrayList<Bar> bars = new ArrayList();
        public int intX;
        public int width;
        public int leftX;
        public int rightX;
        public RectF plotArea;
        public BarGroup prev;

        public BarGroup(int intX, RectF plotArea) {
            this.intX = intX;
            this.plotArea = plotArea;
        }

        public void addBar(Bar bar) {
            bar.barGroup = this;
            this.bars.add(bar);
        }
    }

    public class Bar {
        public final XYSeries series;
        public final int seriesIndex;
        public final double yVal;
        public final double xVal;
        public final int intX;
        public final int intY;
        public final float pixX;
        public final float pixY;
        protected BarGroup barGroup;

        public Bar(XYSeries series, int seriesIndex, RectF plotArea) {
            this.series = series;
            this.seriesIndex = seriesIndex;
            this.xVal = series.getX(seriesIndex).doubleValue();
            this.pixX = ValPixConverter.valToPix(this.xVal, ((XYPlot)BarRenderer.this.getPlot()).getCalculatedMinX().doubleValue(), ((XYPlot)BarRenderer.this.getPlot()).getCalculatedMaxX().doubleValue(), plotArea.width(), false) + plotArea.left;
            this.intX = (int)this.pixX;
            if (series.getY(seriesIndex) != null) {
                this.yVal = series.getY(seriesIndex).doubleValue();
                this.pixY = ValPixConverter.valToPix(this.yVal, ((XYPlot)BarRenderer.this.getPlot()).getCalculatedMinY().doubleValue(), ((XYPlot)BarRenderer.this.getPlot()).getCalculatedMaxY().doubleValue(), plotArea.height(), true) + plotArea.top;
                this.intY = (int)this.pixY;
            } else {
                this.yVal = 0.0;
                this.pixY = plotArea.bottom;
                this.intY = (int)this.pixY;
            }
        }

        public BarFormatter formatter() {
            return BarRenderer.this.getFormatter(this.seriesIndex, this.series);
        }
    }

    public static enum BarWidthStyle {
        FIXED_WIDTH,
        VARIABLE_WIDTH;

    }

    public static enum BarRenderStyle {
        OVERLAID,
        STACKED,
        SIDE_BY_SIDE;

    }
}

