/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.util;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.androidplot.Plot;
import com.androidplot.PlotListener;

public class PlotStatistics
implements PlotListener {
    long minRenderTimeMs;
    long maxRenderTimeMs;
    long avgRenderTimeMs;
    long fps;
    long updateDelayMs;
    long longestRenderMs = 0L;
    long shortestRenderMs = 0L;
    long lastStart = 0L;
    long lastLatency = 0L;
    long lastAnnotation;
    long latencySamples = 0L;
    long latencySum = 0L;
    String annotationString = "";
    private Paint paint = new Paint();
    private boolean annotatePlotEnabled;

    public PlotStatistics(long updateDelayMs, boolean annotatePlotEnabled) {
        this.paint.setTextAlign(Paint.Align.CENTER);
        this.paint.setColor(-1);
        this.paint.setTextSize(30.0f);
        this.resetCounters();
        this.updateDelayMs = updateDelayMs;
        this.annotatePlotEnabled = annotatePlotEnabled;
    }

    public void setAnnotatePlotEnabled(boolean enabled) {
        this.annotatePlotEnabled = enabled;
    }

    private void resetCounters() {
        this.longestRenderMs = 0L;
        this.shortestRenderMs = 999999999L;
        this.latencySamples = 0L;
        this.latencySum = 0L;
    }

    private void annotatePlot(Plot source, Canvas canvas) {
        long nowMs = System.currentTimeMillis();
        long msSinceUpdate = nowMs - this.lastAnnotation;
        if (msSinceUpdate >= this.updateDelayMs) {
            float avgLatency = this.latencySamples > 0L ? (float)(this.latencySum / this.latencySamples) : 0.0f;
            String overallFPS = String.format("%.2f", Float.valueOf(this.latencySamples > 0L ? 1000.0f / (float)msSinceUpdate * (float)this.latencySamples : 0.0f));
            String potentialFPS = String.format("%.2f", Float.valueOf(this.latencySamples > 0L ? 1000.0f / avgLatency : 0.0f));
            this.annotationString = "FPS (potential): " + potentialFPS + " FPS (actual): " + overallFPS + " Latency (ms) Avg: " + this.lastLatency + " \nMin: " + this.shortestRenderMs + " Max: " + this.longestRenderMs;
            this.lastAnnotation = nowMs;
            this.resetCounters();
        }
        RectF r = source.getDisplayDimensions().canvasRect;
        if (this.annotatePlotEnabled) {
            canvas.drawText(this.annotationString, r.centerX(), r.centerY(), this.paint);
        }
    }

    @Override
    public void onBeforeDraw(Plot source, Canvas canvas) {
        this.lastStart = System.currentTimeMillis();
    }

    @Override
    public void onAfterDraw(Plot source, Canvas canvas) {
        this.lastLatency = System.currentTimeMillis() - this.lastStart;
        if (this.lastLatency < this.shortestRenderMs) {
            this.shortestRenderMs = this.lastLatency;
        }
        if (this.lastLatency > this.longestRenderMs) {
            this.longestRenderMs = this.lastLatency;
        }
        this.latencySum += this.lastLatency;
        ++this.latencySamples;
        this.annotatePlot(source, canvas);
    }
}

