/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.util;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.graphics.Color;
import android.util.Log;
import com.androidplot.util.PixelUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParserException;

public abstract class Configurator {
    private static final String TAG = Configurator.class.getName();
    protected static final String CFG_ELEMENT_NAME = "config";

    protected static int parseResId(Context ctx, String prefix, String value) {
        String[] split = value.split("/");
        if (split.length > 1 && split[0].equalsIgnoreCase(prefix)) {
            String pack = split[0].replace("@", "");
            String name = split[1];
            return ctx.getResources().getIdentifier(name, pack, ctx.getPackageName());
        }
        throw new IllegalArgumentException();
    }

    protected static int parseIntAttr(Context ctx, String value) {
        try {
            return ctx.getResources().getColor(Configurator.parseResId(ctx, "@color", value));
        }
        catch (IllegalArgumentException e1) {
            try {
                return Color.parseColor((String)value);
            }
            catch (IllegalArgumentException e2) {
                return Integer.parseInt(value);
            }
        }
    }

    protected static float parseFloatAttr(Context ctx, String value) {
        try {
            return ctx.getResources().getDimension(Configurator.parseResId(ctx, "@dimen", value));
        }
        catch (IllegalArgumentException e1) {
            try {
                return PixelUtils.stringToDimension(value);
            }
            catch (Exception e2) {
                return Float.parseFloat(value);
            }
        }
    }

    protected static String parseStringAttr(Context ctx, String value) {
        try {
            return ctx.getResources().getString(Configurator.parseResId(ctx, "@string", value));
        }
        catch (IllegalArgumentException e1) {
            return value;
        }
    }

    protected static Method getSetter(Class clazz, String fieldId) throws NoSuchMethodException {
        Method[] methods = clazz.getMethods();
        String methodName = "set" + fieldId;
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            return method;
        }
        throw new NoSuchMethodException("No such public method (case insensitive): " + methodName + " in " + clazz);
    }

    protected static Method getGetter(Class clazz, String fieldId) throws NoSuchMethodException {
        Log.d((String)TAG, (String)("Attempting to find getter for " + fieldId + " in class " + clazz.getName()));
        String firstLetter = fieldId.substring(0, 1);
        String methodName = "get" + firstLetter.toUpperCase() + fieldId.substring(1, fieldId.length());
        return clazz.getMethod(methodName, new Class[0]);
    }

    protected static Object getObjectContaining(Object obj, String path) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (obj == null) {
            throw new NullPointerException("Attempt to call getObjectContaining(Object obj, String path) on a null Object instance.  Path was: " + path);
        }
        Log.d((String)TAG, (String)("Looking up object containing: " + path));
        int separatorIndex = path.indexOf(".");
        if (separatorIndex > 0) {
            String lhs = path.substring(0, separatorIndex);
            String rhs = path.substring(separatorIndex + 1, path.length());
            Method m = Configurator.getGetter(obj.getClass(), lhs);
            if (m == null) {
                throw new NullPointerException("No getter found for field: " + lhs + " within " + obj.getClass());
            }
            Log.d((String)TAG, (String)("Invoking " + m.getName() + " on instance of " + obj.getClass().getName()));
            Object o = m.invoke(obj, new Object[0]);
            return Configurator.getObjectContaining(o, rhs);
        }
        return obj;
    }

    private static Object[] inflateParams(Context ctx, Class[] params, String[] vals) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object[] out = new Object[params.length];
        int i = 0;
        for (Class param : params) {
            if (Enum.class.isAssignableFrom(param)) {
                out[i] = param.getMethod("valueOf", String.class).invoke(null, vals[i].toUpperCase());
            } else if (param.equals(Float.TYPE)) {
                out[i] = Float.valueOf(Configurator.parseFloatAttr(ctx, vals[i]));
            } else if (param.equals(Integer.TYPE)) {
                out[i] = Configurator.parseIntAttr(ctx, vals[i]);
            } else if (param.equals(Boolean.TYPE)) {
                out[i] = Boolean.valueOf(vals[i]);
            } else if (param.equals(String.class)) {
                out[i] = Configurator.parseStringAttr(ctx, vals[i]);
            } else {
                throw new IllegalArgumentException("Error inflating XML: Setter requires param of unsupported type: " + param);
            }
            ++i;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(Context ctx, Object obj, int xmlFileId) {
        XmlResourceParser xrp = ctx.getResources().getXml(xmlFileId);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            while (xrp.getEventType() != 1) {
                xrp.next();
                String name = xrp.getName();
                if (xrp.getEventType() != 2) continue;
                if (!name.equalsIgnoreCase(CFG_ELEMENT_NAME)) break;
                for (int i = 0; i < xrp.getAttributeCount(); ++i) {
                    params.put(xrp.getAttributeName(i), xrp.getAttributeValue(i));
                }
            }
            Configurator.configure(ctx, obj, params);
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            xrp.close();
        }
    }

    public static void configure(Context ctx, Object obj, HashMap<String, String> params) {
        for (String key : params.keySet()) {
            try {
                Configurator.configure(ctx, obj, key, params.get(key));
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                Log.w((String)TAG, (String)("Error inflating XML: Setter for field \"" + key + "\" does not exist. "));
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void configure(Context ctx, Object obj, String key, String value) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Object o = Configurator.getObjectContaining(obj, key);
        if (o == null) return;
        int idx = key.lastIndexOf(".");
        String fieldId = idx > 0 ? key.substring(idx + 1, key.length()) : key;
        Method m = Configurator.getSetter(o.getClass(), fieldId);
        Class[] paramTypes = m.getParameterTypes();
        if (paramTypes.length < 1) throw new IllegalArgumentException("Error inflating XML: no setter method found for param \"" + fieldId + "\".");
        String[] paramStrs = value.split("\\|");
        if (paramStrs.length != paramTypes.length) throw new IllegalArgumentException("Error inflating XML: Unexpected number of argments passed to \"" + m.getName() + "\".  Expected: " + paramTypes.length + " Got: " + paramStrs.length);
        Object[] oa = Configurator.inflateParams(ctx, paramTypes, paramStrs);
        Log.d((String)TAG, (String)("Invoking " + m.getName() + " with arg(s) " + Configurator.argArrToString(oa)));
        m.invoke(o, oa);
    }

    protected static String argArrToString(Object[] args) {
        String out = "";
        for (Object obj : args) {
            out = out + (obj == null ? (out = out + "[null] ") : "[" + obj.getClass() + ": " + obj + "] ");
        }
        return out;
    }
}

