/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui;

abstract class LayoutMetric<LayoutType extends Enum> {
    private LayoutType layoutType;
    private float value;

    public LayoutMetric(float value, LayoutType layoutType) {
        this.validatePair(value, layoutType);
        this.set(value, layoutType);
    }

    protected abstract void validatePair(float var1, LayoutType var2);

    public void set(float value, LayoutType layoutType) {
        this.validatePair(value, layoutType);
        this.value = value;
        this.layoutType = layoutType;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.validatePair(value, this.layoutType);
        this.value = value;
    }

    public abstract float getPixelValue(float var1);

    public LayoutType getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(LayoutType layoutType) {
        this.validatePair(this.value, layoutType);
        this.layoutType = layoutType;
    }
}

