/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.MotionEvent;
import android.view.View;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.ui.PositionMetrics;
import com.androidplot.ui.Resizable;
import com.androidplot.ui.widget.Widget;
import com.androidplot.util.DisplayDimensions;
import com.androidplot.util.ZLinkedList;

public class LayoutManager
extends ZLinkedList<Widget>
implements View.OnTouchListener,
Resizable {
    private boolean drawAnchorsEnabled = false;
    private Paint anchorPaint;
    private boolean drawOutlinesEnabled = false;
    private Paint outlinePaint;
    private boolean drawOutlineShadowsEnabled = false;
    private Paint outlineShadowPaint;
    private boolean drawMarginsEnabled = false;
    private Paint marginPaint;
    private boolean drawPaddingEnabled = false;
    private Paint paddingPaint;
    private DisplayDimensions displayDims = new DisplayDimensions();

    public synchronized void onPostInit() {
        for (Widget w : this.elements()) {
            w.onPostInit();
        }
    }

    public LayoutManager() {
        this.anchorPaint = new Paint();
        this.anchorPaint.setStyle(Paint.Style.FILL);
        this.anchorPaint.setColor(-16711936);
        this.outlinePaint = new Paint();
        this.outlinePaint.setColor(-16711936);
        this.outlinePaint.setStyle(Paint.Style.STROKE);
        this.marginPaint = new Paint();
        this.marginPaint.setColor(-256);
        this.marginPaint.setStyle(Paint.Style.FILL);
        this.marginPaint.setAlpha(200);
        this.paddingPaint = new Paint();
        this.paddingPaint.setColor(-16776961);
        this.paddingPaint.setStyle(Paint.Style.FILL);
        this.paddingPaint.setAlpha(200);
    }

    public void setMarkupEnabled(boolean enabled) {
        this.setDrawOutlinesEnabled(enabled);
        this.setDrawAnchorsEnabled(enabled);
        this.setDrawMarginsEnabled(enabled);
        this.setDrawPaddingEnabled(enabled);
        this.setDrawOutlineShadowsEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Canvas canvas) throws PlotRenderException {
        if (this.isDrawMarginsEnabled()) {
            this.drawSpacing(canvas, this.displayDims.canvasRect, this.displayDims.marginatedRect, this.marginPaint);
        }
        if (this.isDrawPaddingEnabled()) {
            this.drawSpacing(canvas, this.displayDims.marginatedRect, this.displayDims.paddedRect, this.paddingPaint);
        }
        for (Widget widget : this.elements()) {
            try {
                canvas.save(31);
                PositionMetrics metrics = widget.getPositionMetrics();
                float elementWidth = widget.getWidthPix(this.displayDims.paddedRect.width());
                float elementHeight = widget.getHeightPix(this.displayDims.paddedRect.height());
                PointF coords = widget.getElementCoordinates(elementHeight, elementWidth, this.displayDims.paddedRect, metrics);
                DisplayDimensions dims = widget.getWidgetDimensions();
                if (this.drawOutlineShadowsEnabled) {
                    canvas.drawRect(dims.canvasRect, this.outlineShadowPaint);
                }
                if (widget.isClippingEnabled()) {
                    canvas.clipRect(dims.canvasRect, Region.Op.INTERSECT);
                }
                widget.draw(canvas, dims.canvasRect);
                if (this.drawMarginsEnabled) {
                    this.drawSpacing(canvas, dims.canvasRect, dims.marginatedRect, this.getMarginPaint());
                }
                if (this.drawPaddingEnabled) {
                    this.drawSpacing(canvas, dims.marginatedRect, dims.paddedRect, this.getPaddingPaint());
                }
                if (this.drawAnchorsEnabled) {
                    PointF anchorCoords = Widget.getAnchorCoordinates(coords.x, coords.y, elementWidth, elementHeight, metrics.getAnchor());
                    this.drawAnchor(canvas, anchorCoords);
                }
                if (!this.drawOutlinesEnabled) continue;
                this.outlinePaint.setAntiAlias(true);
                canvas.drawRect(dims.canvasRect, this.outlinePaint);
            }
            finally {
                canvas.restore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawSpacing(Canvas canvas, RectF outer, RectF inner, Paint paint) {
        try {
            canvas.save(31);
            canvas.clipRect(inner, Region.Op.DIFFERENCE);
            canvas.drawRect(outer, paint);
        }
        finally {
            canvas.restore();
        }
    }

    protected void drawAnchor(Canvas canvas, PointF coords) {
        float anchorSize = 4.0f;
        canvas.drawRect(coords.x - anchorSize, coords.y - anchorSize, coords.x + anchorSize, coords.y + anchorSize, this.anchorPaint);
    }

    public boolean isDrawOutlinesEnabled() {
        return this.drawOutlinesEnabled;
    }

    public void setDrawOutlinesEnabled(boolean drawOutlinesEnabled) {
        this.drawOutlinesEnabled = drawOutlinesEnabled;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint outlinePaint) {
        this.outlinePaint = outlinePaint;
    }

    public boolean isDrawAnchorsEnabled() {
        return this.drawAnchorsEnabled;
    }

    public void setDrawAnchorsEnabled(boolean drawAnchorsEnabled) {
        this.drawAnchorsEnabled = drawAnchorsEnabled;
    }

    public boolean isDrawMarginsEnabled() {
        return this.drawMarginsEnabled;
    }

    public void setDrawMarginsEnabled(boolean drawMarginsEnabled) {
        this.drawMarginsEnabled = drawMarginsEnabled;
    }

    public Paint getMarginPaint() {
        return this.marginPaint;
    }

    public void setMarginPaint(Paint marginPaint) {
        this.marginPaint = marginPaint;
    }

    public boolean isDrawPaddingEnabled() {
        return this.drawPaddingEnabled;
    }

    public void setDrawPaddingEnabled(boolean drawPaddingEnabled) {
        this.drawPaddingEnabled = drawPaddingEnabled;
    }

    public Paint getPaddingPaint() {
        return this.paddingPaint;
    }

    public void setPaddingPaint(Paint paddingPaint) {
        this.paddingPaint = paddingPaint;
    }

    public boolean isDrawOutlineShadowsEnabled() {
        return this.drawOutlineShadowsEnabled;
    }

    public void setDrawOutlineShadowsEnabled(boolean drawOutlineShadowsEnabled) {
        this.drawOutlineShadowsEnabled = drawOutlineShadowsEnabled;
        if (drawOutlineShadowsEnabled && this.outlineShadowPaint == null) {
            this.outlineShadowPaint = new Paint();
            this.outlineShadowPaint.setColor(-12303292);
            this.outlineShadowPaint.setStyle(Paint.Style.FILL);
            this.outlineShadowPaint.setShadowLayer(3.0f, 5.0f, 5.0f, -16777216);
        }
    }

    public Paint getOutlineShadowPaint() {
        return this.outlineShadowPaint;
    }

    public void setOutlineShadowPaint(Paint outlineShadowPaint) {
        this.outlineShadowPaint = outlineShadowPaint;
    }

    public boolean onTouch(View v, MotionEvent event) {
        return false;
    }

    public void refreshLayout() {
        for (Widget widget : this.elements()) {
            widget.layout(this.displayDims);
        }
    }

    @Override
    public void layout(DisplayDimensions dims) {
        this.displayDims = dims;
        this.refreshLayout();
    }
}

