/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot;

public class LineRegion {
    private Number minVal;
    private Number maxVal;

    public LineRegion(Number val1, Number v2) {
        if (val1.doubleValue() < v2.doubleValue()) {
            this.setMinVal(val1);
            this.setMaxVal(v2);
        } else {
            this.setMinVal(v2);
            this.setMaxVal(val1);
        }
    }

    public static Number measure(Number val1, Number val2) {
        return new LineRegion(val1, val2).length();
    }

    public Number length() {
        return this.maxVal.doubleValue() - this.minVal.doubleValue();
    }

    public boolean contains(Number value) {
        return value.doubleValue() >= this.minVal.doubleValue() && value.doubleValue() <= this.maxVal.doubleValue();
    }

    public boolean intersects(LineRegion lineRegion) {
        return this.intersects(lineRegion.getMinVal(), lineRegion.getMaxVal());
    }

    public boolean intersects(Number line2Min, Number line2Max) {
        if (line2Min.doubleValue() <= this.minVal.doubleValue() && line2Max.doubleValue() >= this.maxVal.doubleValue()) {
            return true;
        }
        return this.contains(line2Min) || this.contains(line2Max);
    }

    public Number getMinVal() {
        return this.minVal;
    }

    public void setMinVal(Number minVal) {
        if (minVal == null) {
            throw new NullPointerException("Region values can never be null.");
        }
        this.minVal = minVal;
    }

    public Number getMaxVal() {
        return this.maxVal;
    }

    public void setMaxVal(Number maxVal) {
        if (maxVal == null) {
            throw new NullPointerException("Region values can never be null.");
        }
        this.maxVal = maxVal;
    }
}

