/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.androidplot.Plot;
import com.androidplot.xy.BoundaryMode;
import com.androidplot.xy.XYPlot;

public class XYPlotZoomPan
extends XYPlot
implements View.OnTouchListener {
    private static final float MIN_DIST_2_FING = 5.0f;
    private State mode = State.NONE;
    private float minXLimit = Float.MAX_VALUE;
    private float maxXLimit = Float.MAX_VALUE;
    private float minYLimit = Float.MAX_VALUE;
    private float maxYLimit = Float.MAX_VALUE;
    private float lastMinX = Float.MAX_VALUE;
    private float lastMaxX = Float.MAX_VALUE;
    private float lastMinY = Float.MAX_VALUE;
    private float lastMaxY = Float.MAX_VALUE;
    private PointF firstFingerPos;
    private float mDistX;
    private boolean mZoomEnabled;
    private boolean mZoomVertically;
    private boolean mZoomHorizontally;
    private boolean mCalledBySelf;
    private boolean mZoomEnabledInit;
    private boolean mZoomVerticallyInit;
    private boolean mZoomHorizontallyInit;

    public XYPlotZoomPan(Context context, String title, Plot.RenderMode mode) {
        super(context, title, mode);
        this.setZoomEnabled(true);
    }

    public XYPlotZoomPan(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.mZoomEnabled || !this.mZoomEnabledInit) {
            this.setZoomEnabled(true);
        }
        if (!this.mZoomHorizontallyInit) {
            this.mZoomHorizontally = true;
        }
        if (!this.mZoomVerticallyInit) {
            this.mZoomVertically = true;
        }
    }

    public XYPlotZoomPan(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.mZoomEnabled || !this.mZoomEnabledInit) {
            this.setZoomEnabled(true);
        }
        if (!this.mZoomHorizontallyInit) {
            this.mZoomHorizontally = true;
        }
        if (!this.mZoomVerticallyInit) {
            this.mZoomVertically = true;
        }
    }

    public XYPlotZoomPan(Context context, String title) {
        super(context, title);
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        if (l != this) {
            this.mZoomEnabled = false;
        }
        super.setOnTouchListener(l);
    }

    public boolean getZoomVertically() {
        return this.mZoomVertically;
    }

    public void setZoomVertically(boolean zoomVertically) {
        this.mZoomVertically = zoomVertically;
        this.mZoomVerticallyInit = true;
    }

    public boolean getZoomHorizontally() {
        return this.mZoomHorizontally;
    }

    public void setZoomHorizontally(boolean zoomHorizontally) {
        this.mZoomHorizontally = zoomHorizontally;
        this.mZoomHorizontallyInit = true;
    }

    public void setZoomEnabled(boolean enabled) {
        if (enabled) {
            this.setOnTouchListener(this);
        } else {
            this.setOnTouchListener(null);
        }
        this.mZoomEnabled = enabled;
        this.mZoomEnabledInit = true;
    }

    public boolean getZoomEnabled() {
        return this.mZoomEnabled;
    }

    private float getMinXLimit() {
        if (this.minXLimit == Float.MAX_VALUE) {
            this.lastMinX = this.minXLimit = this.getCalculatedMinX().floatValue();
        }
        return this.minXLimit;
    }

    private float getMaxXLimit() {
        if (this.maxXLimit == Float.MAX_VALUE) {
            this.lastMaxX = this.maxXLimit = this.getCalculatedMaxX().floatValue();
        }
        return this.maxXLimit;
    }

    private float getMinYLimit() {
        if (this.minYLimit == Float.MAX_VALUE) {
            this.lastMinY = this.minYLimit = this.getCalculatedMinY().floatValue();
        }
        return this.minYLimit;
    }

    private float getMaxYLimit() {
        if (this.maxYLimit == Float.MAX_VALUE) {
            this.lastMaxY = this.maxYLimit = this.getCalculatedMaxY().floatValue();
        }
        return this.maxYLimit;
    }

    private float getLastMinX() {
        if (this.lastMinX == Float.MAX_VALUE) {
            this.lastMinX = this.getCalculatedMinX().floatValue();
        }
        return this.lastMinX;
    }

    private float getLastMaxX() {
        if (this.lastMaxX == Float.MAX_VALUE) {
            this.lastMaxX = this.getCalculatedMaxX().floatValue();
        }
        return this.lastMaxX;
    }

    private float getLastMinY() {
        if (this.lastMinY == Float.MAX_VALUE) {
            this.lastMinY = this.getCalculatedMinY().floatValue();
        }
        return this.lastMinY;
    }

    private float getLastMaxY() {
        if (this.lastMaxY == Float.MAX_VALUE) {
            this.lastMaxY = this.getCalculatedMaxY().floatValue();
        }
        return this.lastMaxY;
    }

    @Override
    public synchronized void setDomainBoundaries(Number lowerBoundary, BoundaryMode lowerBoundaryMode, Number upperBoundary, BoundaryMode upperBoundaryMode) {
        super.setDomainBoundaries(lowerBoundary, lowerBoundaryMode, upperBoundary, upperBoundaryMode);
        if (this.mCalledBySelf) {
            this.mCalledBySelf = false;
        } else {
            this.minXLimit = lowerBoundaryMode == BoundaryMode.FIXED ? lowerBoundary.floatValue() : this.getCalculatedMinX().floatValue();
            this.maxXLimit = upperBoundaryMode == BoundaryMode.FIXED ? upperBoundary.floatValue() : this.getCalculatedMaxX().floatValue();
            this.lastMinX = this.minXLimit;
            this.lastMaxX = this.maxXLimit;
        }
    }

    @Override
    public synchronized void setRangeBoundaries(Number lowerBoundary, BoundaryMode lowerBoundaryMode, Number upperBoundary, BoundaryMode upperBoundaryMode) {
        super.setRangeBoundaries(lowerBoundary, lowerBoundaryMode, upperBoundary, upperBoundaryMode);
        if (this.mCalledBySelf) {
            this.mCalledBySelf = false;
        } else {
            this.minYLimit = lowerBoundaryMode == BoundaryMode.FIXED ? lowerBoundary.floatValue() : this.getCalculatedMinY().floatValue();
            this.maxYLimit = upperBoundaryMode == BoundaryMode.FIXED ? upperBoundary.floatValue() : this.getCalculatedMaxY().floatValue();
            this.lastMinY = this.minYLimit;
            this.lastMaxY = this.maxYLimit;
        }
    }

    @Override
    public synchronized void setDomainBoundaries(Number lowerBoundary, Number upperBoundary, BoundaryMode mode) {
        super.setDomainBoundaries(lowerBoundary, upperBoundary, mode);
        if (this.mCalledBySelf) {
            this.mCalledBySelf = false;
        } else {
            this.minXLimit = mode == BoundaryMode.FIXED ? lowerBoundary.floatValue() : this.getCalculatedMinX().floatValue();
            this.maxXLimit = mode == BoundaryMode.FIXED ? upperBoundary.floatValue() : this.getCalculatedMaxX().floatValue();
            this.lastMinX = this.minXLimit;
            this.lastMaxX = this.maxXLimit;
        }
    }

    @Override
    public synchronized void setRangeBoundaries(Number lowerBoundary, Number upperBoundary, BoundaryMode mode) {
        super.setRangeBoundaries(lowerBoundary, upperBoundary, mode);
        if (this.mCalledBySelf) {
            this.mCalledBySelf = false;
        } else {
            this.minYLimit = mode == BoundaryMode.FIXED ? lowerBoundary.floatValue() : this.getCalculatedMinY().floatValue();
            this.maxYLimit = mode == BoundaryMode.FIXED ? upperBoundary.floatValue() : this.getCalculatedMaxY().floatValue();
            this.lastMinY = this.minYLimit;
            this.lastMaxY = this.maxYLimit;
        }
    }

    public boolean onTouch(View view, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.firstFingerPos = new PointF(event.getX(), event.getY());
                this.mode = State.ONE_FINGER_DRAG;
                break;
            }
            case 5: {
                this.mDistX = this.getXDistance(event);
                if (!(this.mDistX > 5.0f) && !(this.mDistX < -5.0f)) break;
                this.mode = State.TWO_FINGERS_DRAG;
                break;
            }
            case 6: {
                this.mode = State.NONE;
                break;
            }
            case 2: {
                if (this.mode == State.ONE_FINGER_DRAG) {
                    this.pan(event);
                    break;
                }
                if (this.mode != State.TWO_FINGERS_DRAG) break;
                this.zoom(event);
            }
        }
        return true;
    }

    private float getXDistance(MotionEvent event) {
        return event.getX(0) - event.getX(1);
    }

    private void pan(MotionEvent motionEvent) {
        PointF oldFirstFinger = this.firstFingerPos;
        this.firstFingerPos = new PointF(motionEvent.getX(), motionEvent.getY());
        PointF newX = new PointF();
        if (this.mZoomHorizontally) {
            this.calculatePan(oldFirstFinger, newX, true);
            this.mCalledBySelf = true;
            super.setDomainBoundaries(Float.valueOf(newX.x), Float.valueOf(newX.y), BoundaryMode.FIXED);
            this.lastMinX = newX.x;
            this.lastMaxX = newX.y;
        }
        if (this.mZoomVertically) {
            this.calculatePan(oldFirstFinger, newX, false);
            this.mCalledBySelf = true;
            super.setRangeBoundaries(Float.valueOf(newX.x), Float.valueOf(newX.y), BoundaryMode.FIXED);
            this.lastMinY = newX.x;
            this.lastMaxY = newX.y;
        }
        this.redraw();
    }

    private void calculatePan(PointF oldFirstFinger, PointF newX, boolean horizontal) {
        float offset;
        if (horizontal) {
            newX.x = this.getLastMinX();
            newX.y = this.getLastMaxX();
            offset = (oldFirstFinger.x - this.firstFingerPos.x) * ((newX.y - newX.x) / (float)this.getWidth());
        } else {
            newX.x = this.getLastMinY();
            newX.y = this.getLastMaxY();
            offset = -(oldFirstFinger.y - this.firstFingerPos.y) * ((newX.y - newX.x) / (float)this.getHeight());
        }
        newX.x += offset;
        newX.y += offset;
        float diff = newX.y - newX.x;
        if (horizontal) {
            if (newX.x < this.getMinXLimit()) {
                newX.x = this.getMinXLimit();
                newX.y = newX.x + diff;
            }
            if (newX.y > this.getMaxXLimit()) {
                newX.y = this.getMaxXLimit();
                newX.x = newX.y - diff;
            }
        } else {
            if (newX.x < this.getMinYLimit()) {
                newX.x = this.getMinYLimit();
                newX.y = newX.x + diff;
            }
            if (newX.y > this.getMaxYLimit()) {
                newX.y = this.getMaxYLimit();
                newX.x = newX.y - diff;
            }
        }
    }

    private void zoom(MotionEvent motionEvent) {
        float oldDist = this.mDistX;
        float newDist = this.getXDistance(motionEvent);
        if (oldDist > 0.0f && newDist < 0.0f || oldDist < 0.0f && newDist > 0.0f) {
            return;
        }
        this.mDistX = newDist;
        float scale = oldDist / this.mDistX;
        if (Float.isInfinite(scale) || Float.isNaN(scale) || (double)scale > -0.001 && (double)scale < 0.001) {
            return;
        }
        PointF newX = new PointF();
        if (this.mZoomHorizontally) {
            this.calculateZoom(scale, newX, true);
            this.mCalledBySelf = true;
            super.setDomainBoundaries(Float.valueOf(newX.x), Float.valueOf(newX.y), BoundaryMode.FIXED);
            this.lastMinX = newX.x;
            this.lastMaxX = newX.y;
        }
        if (this.mZoomVertically) {
            this.calculateZoom(scale, newX, false);
            this.mCalledBySelf = true;
            super.setRangeBoundaries(Float.valueOf(newX.x), Float.valueOf(newX.y), BoundaryMode.FIXED);
            this.lastMinY = newX.x;
            this.lastMaxY = newX.y;
        }
        this.redraw();
    }

    private void calculateZoom(float scale, PointF newX, boolean horizontal) {
        float span;
        float calcMax;
        if (horizontal) {
            calcMax = this.getLastMaxX();
            span = calcMax - this.getLastMinX();
        } else {
            calcMax = this.getLastMaxY();
            span = calcMax - this.getLastMinY();
        }
        float midPoint = calcMax - span / 2.0f;
        float offset = span * scale / 2.0f;
        newX.x = midPoint - offset;
        newX.y = midPoint + offset;
        if (horizontal) {
            if (newX.x < this.getMinXLimit()) {
                newX.x = this.getMinXLimit();
            }
            if (newX.y > this.getMaxXLimit()) {
                newX.y = this.getMaxXLimit();
            }
        } else {
            if (newX.x < this.getMinYLimit()) {
                newX.x = this.getMinYLimit();
            }
            if (newX.y > this.getMaxYLimit()) {
                newX.y = this.getMaxYLimit();
            }
        }
    }

    private static enum State {
        NONE,
        ONE_FINGER_DRAG,
        TWO_FINGERS_DRAG;

    }
}

