/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.util;

import com.androidplot.util.ZIndexable;
import com.androidplot.util.ZLinkedList;
import java.util.HashMap;
import java.util.List;

public class ZHash<KeyType, ValueType>
implements ZIndexable<KeyType> {
    private HashMap<KeyType, ValueType> hash = new HashMap();
    private ZLinkedList<KeyType> zlist = new ZLinkedList();

    public int size() {
        return this.zlist.size();
    }

    public ValueType get(KeyType key) {
        return this.hash.get(key);
    }

    public List<KeyType> getKeysAsList() {
        return this.zlist;
    }

    public synchronized void addToTop(KeyType key, ValueType value) {
        if (this.hash.containsKey(key)) {
            this.hash.put(key, value);
        } else {
            this.hash.put(key, value);
            this.zlist.addToTop(key);
        }
    }

    public synchronized void addToBottom(KeyType key, ValueType value) {
        if (this.hash.containsKey(key)) {
            this.hash.put(key, value);
        } else {
            this.hash.put(key, value);
            this.zlist.addToBottom(key);
        }
    }

    @Override
    public synchronized boolean moveToTop(KeyType element) {
        if (!this.hash.containsKey(element)) {
            return false;
        }
        return this.zlist.moveToTop(element);
    }

    @Override
    public synchronized boolean moveAbove(KeyType objectToMove, KeyType reference) {
        if (objectToMove == reference) {
            throw new IllegalArgumentException("Illegal argument to moveAbove(A, B); A cannot be equal to B.");
        }
        if (!this.hash.containsKey(reference) || !this.hash.containsKey(objectToMove)) {
            return false;
        }
        return this.zlist.moveAbove(objectToMove, reference);
    }

    @Override
    public synchronized boolean moveBeneath(KeyType objectToMove, KeyType reference) {
        if (objectToMove == reference) {
            throw new IllegalArgumentException("Illegal argument to moveBeaneath(A, B); A cannot be equal to B.");
        }
        if (!this.hash.containsKey(reference) || !this.hash.containsKey(objectToMove)) {
            return false;
        }
        return this.zlist.moveBeneath(objectToMove, reference);
    }

    @Override
    public synchronized boolean moveToBottom(KeyType key) {
        if (!this.hash.containsKey(key)) {
            return false;
        }
        return this.zlist.moveToBottom(key);
    }

    @Override
    public synchronized boolean moveUp(KeyType key) {
        if (!this.hash.containsKey(key)) {
            return false;
        }
        return this.zlist.moveUp(key);
    }

    @Override
    public synchronized boolean moveDown(KeyType key) {
        if (!this.hash.containsKey(key)) {
            return false;
        }
        return this.zlist.moveDown(key);
    }

    @Override
    public List<KeyType> elements() {
        return this.zlist;
    }

    public List<KeyType> keys() {
        return this.elements();
    }

    public synchronized boolean remove(KeyType key) {
        if (this.hash.containsKey(key)) {
            this.hash.remove(key);
            this.zlist.remove(key);
            return true;
        }
        return false;
    }
}

