/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui;

import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.Region;
import com.androidplot.Plot;
import com.androidplot.Series;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.ui.Formatter;
import com.androidplot.ui.SeriesAndFormatterList;

public abstract class SeriesRenderer<PlotType extends Plot, SeriesType extends Series, SeriesFormatterType extends Formatter> {
    private PlotType plot;

    public SeriesRenderer(PlotType plot) {
        this.plot = plot;
    }

    public PlotType getPlot() {
        return this.plot;
    }

    public void setPlot(PlotType plot) {
        this.plot = plot;
    }

    public SeriesAndFormatterList<SeriesType, SeriesFormatterType> getSeriesAndFormatterList() {
        return ((Plot)this.plot).getSeriesAndFormatterListForRenderer(this.getClass());
    }

    public SeriesFormatterType getFormatter(SeriesType series) {
        return (SeriesFormatterType)((Plot)this.plot).getFormatter(series, this.getClass());
    }

    public void render(Canvas canvas, RectF plotArea) throws PlotRenderException {
        this.onRender(canvas, plotArea);
    }

    public abstract void onRender(Canvas var1, RectF var2) throws PlotRenderException;

    protected abstract void doDrawLegendIcon(Canvas var1, RectF var2, SeriesFormatterType var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSeriesLegendIcon(Canvas canvas, RectF rect, SeriesFormatterType formatter) {
        try {
            canvas.save(31);
            canvas.clipRect(rect, Region.Op.INTERSECT);
            this.doDrawLegendIcon(canvas, rect, formatter);
        }
        finally {
            canvas.restore();
        }
    }
}

