/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui;

import com.androidplot.ui.LayoutMetric;

public abstract class PositionMetric<LayoutType extends Enum>
extends LayoutMetric<LayoutType> {
    public PositionMetric(float value, LayoutType layoutType) {
        super(value, layoutType);
    }

    protected static void validateValue(float value, LayoutMode layoutMode) throws IllegalArgumentException {
        switch (layoutMode) {
            case ABSOLUTE: {
                break;
            }
            case RELATIVE: {
                if (!(value < -1.0f) && !(value > 1.0f)) break;
                throw new IllegalArgumentException("Relative layout values must be within the range of -1 to 1.");
            }
            default: {
                throw new IllegalArgumentException("Unknown LayoutMode: " + (Object)((Object)layoutMode));
            }
        }
    }

    protected float getAbsolutePosition(float size, Origin origin) {
        switch (origin) {
            case FROM_BEGINING: {
                return this.getValue();
            }
            case FROM_CENTER: {
                return size / 2.0f + this.getValue();
            }
            case FROM_END: {
                return size - this.getValue();
            }
        }
        throw new IllegalArgumentException("Unsupported Origin: " + (Object)((Object)origin));
    }

    protected float getRelativePosition(float size, Origin origin) {
        switch (origin) {
            case FROM_BEGINING: {
                return size * this.getValue();
            }
            case FROM_CENTER: {
                return size / 2.0f + size / 2.0f * this.getValue();
            }
            case FROM_END: {
                return size + size * this.getValue();
            }
        }
        throw new IllegalArgumentException("Unsupported Origin: " + (Object)((Object)origin));
    }

    protected static enum LayoutMode {
        ABSOLUTE,
        RELATIVE;

    }

    protected static enum Origin {
        FROM_BEGINING,
        FROM_CENTER,
        FROM_END;

    }
}

