/*
 * Copyright 2012 AndroidPlot.com
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package com.androidplot.xy;

import android.graphics.Paint;
import com.androidplot.ui.DataRenderer;

public class BezierLineAndPointFormatter extends LineAndPointFormatter {
    /*public BezierLineAndPointFormatter(Paint linePaint, Paint vertexPaint, Paint fillPaint) {
        super(linePaint, vertexPaint, fillPaint);
    }*/

    public BezierLineAndPointFormatter(Integer lineColor, Integer vertexColor, Integer fillColor) {
        super(lineColor, vertexColor, fillColor);
    }

    public BezierLineAndPointFormatter(Integer lineColor, Integer vertexColor, Integer fillColor, FillDirection fillDir) {
        super(lineColor, vertexColor, fillColor, fillDir);
    }

    @Override
    public Class<? extends DataRenderer> getRendererClass() {
        return BezierLineAndPointRenderer.class;
    }

    @Override
    public DataRenderer getRendererInstance(XYPlot plot) {
        return new BezierLineAndPointRenderer(plot);
    }
}
