/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.PointF;
import android.util.AttributeSet;
import com.androidplot.Plot;
import com.androidplot.series.XYSeries;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.ui.DynamicTableModel;
import com.androidplot.ui.SizeLayoutType;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.TextOrientationType;
import com.androidplot.ui.widget.DomainLabelWidget;
import com.androidplot.ui.widget.RangeLabelWidget;
import com.androidplot.util.PixelUtils;
import com.androidplot.xy.BoundaryMode;
import com.androidplot.xy.RectRegion;
import com.androidplot.xy.XLayoutStyle;
import com.androidplot.xy.XValueMarker;
import com.androidplot.xy.XYFramingModel;
import com.androidplot.xy.XYGraphWidget;
import com.androidplot.xy.XYLegendWidget;
import com.androidplot.xy.XYSeriesFormatter;
import com.androidplot.xy.XYSeriesRenderer;
import com.androidplot.xy.XYStepMode;
import com.androidplot.xy.YLayoutStyle;
import com.androidplot.xy.YValueMarker;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;

public class XYPlot
extends Plot<XYSeries, XYSeriesFormatter, XYSeriesRenderer> {
    private BoundaryMode g;
    private BoundaryMode h;
    private XYLegendWidget i;
    private XYGraphWidget j;
    private DomainLabelWidget k;
    private RangeLabelWidget l;
    private XYStepMode m = XYStepMode.SUBDIVIDE;
    private double n = 10.0;
    private XYStepMode o = XYStepMode.SUBDIVIDE;
    private double p = 10.0;
    private String q = "domain";
    private String r = "range";
    private Number s;
    private Number t;
    private Number u;
    private Number v;
    private Number w;
    private Number x;
    private Number y;
    private Number z;
    private Number A;
    private Number B;
    private Number C;
    private Number D;
    private Number E = null;
    private Number F = null;
    private Number G = null;
    private Number H = null;
    private Number I = null;
    private Number J = null;
    private Number K = null;
    private Number L = null;
    private XYFramingModel M = XYFramingModel.EDGE;
    private XYFramingModel N = XYFramingModel.EDGE;
    private Number O;
    private Number P;
    private Number Q;
    private Number R;
    private Number S = null;
    private Number T = null;
    private BoundaryMode U = BoundaryMode.AUTO;
    private BoundaryMode V = BoundaryMode.AUTO;
    private BoundaryMode W = BoundaryMode.AUTO;
    private BoundaryMode Z = BoundaryMode.AUTO;
    private boolean aa = true;
    private boolean ab = true;
    ArrayList<YValueMarker> e;
    ArrayList<XValueMarker> f;
    private RectRegion ac;

    public XYPlot(Context context, String string) {
        super(context, string);
        this.a(context, null);
    }

    public XYPlot(Context context, String string, Plot.RenderMode renderMode) {
        super(context, string, renderMode);
        this.a(context, null);
    }

    public XYPlot(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.a(context, attributeSet);
    }

    public XYPlot(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.a(context, attributeSet);
    }

    private void a(Context context, AttributeSet attributeSet) {
        this.i = new XYLegendWidget(this, new SizeMetrics(PixelUtils.dpToPix(10.0f), SizeLayoutType.ABSOLUTE, 0.5f, SizeLayoutType.RELATIVE), new DynamicTableModel(0, 1), new SizeMetrics(PixelUtils.dpToPix(7.0f), SizeLayoutType.ABSOLUTE, PixelUtils.dpToPix(7.0f), SizeLayoutType.ABSOLUTE));
        this.j = new XYGraphWidget(this, new SizeMetrics(PixelUtils.dpToPix(18.0f), SizeLayoutType.FILL, PixelUtils.dpToPix(10.0f), SizeLayoutType.FILL));
        context = new Paint();
        context.setColor(-12303292);
        context.setStyle(Paint.Style.FILL);
        this.j.setBackgroundPaint((Paint)context);
        this.k = new DomainLabelWidget(this, new SizeMetrics(PixelUtils.dpToPix(10.0f), SizeLayoutType.ABSOLUTE, PixelUtils.dpToPix(80.0f), SizeLayoutType.ABSOLUTE), TextOrientationType.HORIZONTAL);
        this.l = new RangeLabelWidget(this, new SizeMetrics(PixelUtils.dpToPix(50.0f), SizeLayoutType.ABSOLUTE, PixelUtils.dpToPix(10.0f), SizeLayoutType.ABSOLUTE), TextOrientationType.VERTICAL_ASCENDING);
        this.getLayoutManager().position(this.i, PixelUtils.dpToPix(40.0f), XLayoutStyle.ABSOLUTE_FROM_RIGHT, PixelUtils.dpToPix(0.0f), YLayoutStyle.ABSOLUTE_FROM_BOTTOM, AnchorPosition.RIGHT_BOTTOM);
        this.getLayoutManager().position(this.j, PixelUtils.dpToPix(0.0f), XLayoutStyle.ABSOLUTE_FROM_RIGHT, PixelUtils.dpToPix(0.0f), YLayoutStyle.ABSOLUTE_FROM_CENTER, AnchorPosition.RIGHT_MIDDLE);
        this.getLayoutManager().position(this.k, PixelUtils.dpToPix(20.0f), XLayoutStyle.ABSOLUTE_FROM_LEFT, PixelUtils.dpToPix(0.0f), YLayoutStyle.ABSOLUTE_FROM_BOTTOM, AnchorPosition.LEFT_BOTTOM);
        this.getLayoutManager().position(this.l, PixelUtils.dpToPix(0.0f), XLayoutStyle.ABSOLUTE_FROM_LEFT, PixelUtils.dpToPix(0.0f), YLayoutStyle.ABSOLUTE_FROM_CENTER, AnchorPosition.LEFT_MIDDLE);
        this.getLayoutManager().moveToTop(this.getTitleWidget());
        this.getLayoutManager().moveToTop(this.getLegendWidget());
        this.j.setMarginTop(PixelUtils.dpToPix(3.0f));
        this.j.setMarginRight(PixelUtils.dpToPix(3.0f));
        this.getTitleWidget().pack();
        this.getDomainLabelWidget().pack();
        this.getRangeLabelWidget().pack();
        this.setPlotMarginLeft(PixelUtils.dpToPix(2.0f));
        this.setPlotMarginRight(PixelUtils.dpToPix(2.0f));
        this.setPlotMarginBottom(PixelUtils.dpToPix(2.0f));
        this.f = new ArrayList();
        this.e = new ArrayList();
        this.setDefaultBounds(new RectRegion(-1, 1, -1, 1));
        if (this.getClass().equals(XYPlot.class) && attributeSet != null) {
            this.a(attributeSet);
        }
    }

    public void setGridPadding(float f, float f2, float f3, float f4) {
        this.getGraphWidget().setGridPaddingTop(f2);
        this.getGraphWidget().setGridPaddingBottom(f4);
        this.getGraphWidget().setGridPaddingLeft(f);
        this.getGraphWidget().setGridPaddingRight(f3);
    }

    @Override
    protected final void a() {
        this.calculateMinMaxVals();
    }

    public boolean containsPoint(float f, float f2) {
        if (this.getGraphWidget().getGridRect() != null) {
            return this.getGraphWidget().getGridRect().contains(f, f2);
        }
        return false;
    }

    public boolean containsPoint(PointF pointF) {
        return this.containsPoint(pointF.x, pointF.y);
    }

    public void setCursorPosition(PointF pointF) {
        this.getGraphWidget().setCursorPosition(pointF);
    }

    public void setCursorPosition(float f, float f2) {
        this.getGraphWidget().setCursorPosition(f, f2);
    }

    public Number getYVal(PointF pointF) {
        return this.getGraphWidget().getYVal(pointF);
    }

    public Number getXVal(PointF pointF) {
        return this.getGraphWidget().getXVal(pointF);
    }

    private static boolean a(double d, Number number, Number number2) {
        boolean bl;
        boolean bl2 = number == null || d >= number.doubleValue();
        boolean bl3 = bl = number2 == null || d <= number2.doubleValue();
        return bl2 && bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void calculateMinMaxVals() {
        this.A = this.w;
        this.B = this.x;
        this.C = this.y;
        this.D = this.z;
        this.w = this.s;
        this.x = this.t;
        this.y = this.u;
        this.z = this.v;
        Iterator iterator = this.getSeriesSet().iterator();
        while (true) {
            XYPlot xYPlot;
            XYSeries xYSeries;
            if (iterator.hasNext()) {
                XYSeries xYSeries2 = xYSeries = (XYSeries)iterator.next();
                // MONITORENTER : xYSeries
            } else {
                switch (this.M) {
                    case ORIGIN: {
                        this.updateDomainMinMaxForOriginModel();
                        break;
                    }
                    case EDGE: {
                        xYPlot = this;
                        switch (xYPlot.U) {
                            case FIXED: {
                                break;
                            }
                            case AUTO: {
                                break;
                            }
                            case GROW: {
                                if (xYPlot.B == null || xYPlot.x.doubleValue() > xYPlot.B.doubleValue()) break;
                                xYPlot.x = xYPlot.B;
                                break;
                            }
                            case SHRINNK: {
                                if (xYPlot.B == null || xYPlot.x.doubleValue() < xYPlot.B.doubleValue()) break;
                                xYPlot.x = xYPlot.B;
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("DomainUpperBoundaryMode not yet implemented: " + (Object)((Object)xYPlot.U));
                            }
                        }
                        switch (xYPlot.V) {
                            case FIXED: {
                                break;
                            }
                            case AUTO: {
                                break;
                            }
                            case GROW: {
                                if (xYPlot.A == null || xYPlot.w.doubleValue() < xYPlot.A.doubleValue()) break;
                                xYPlot.w = xYPlot.A;
                                break;
                            }
                            case SHRINNK: {
                                if (xYPlot.A == null || xYPlot.w.doubleValue() > xYPlot.A.doubleValue()) break;
                                xYPlot.w = xYPlot.A;
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("DomainLowerBoundaryMode not supported: " + (Object)((Object)xYPlot.V));
                            }
                        }
                        this.w = XYPlot.a(this.w, this.I, this.J);
                        this.x = XYPlot.a(this.x, this.K, this.L);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Domain Framing Model not yet supported: " + (Object)((Object)this.M));
                    }
                }
                switch (this.N) {
                    case ORIGIN: {
                        this.updateRangeMinMaxForOriginModel();
                        break;
                    }
                    case EDGE: {
                        this.updateRangeMinMaxForEdgeModel();
                        this.y = XYPlot.a(this.y, this.G, this.H);
                        this.z = XYPlot.a(this.z, this.E, this.F);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Range Framing Model not yet supported: " + (Object)((Object)this.M));
                    }
                }
                this.Q = this.O != null ? (Number)this.O : (Number)this.getCalculatedMinX();
                this.R = this.P != null ? (Number)this.P : (Number)this.getCalculatedMinY();
                return;
            }
            for (int i = 0; i < xYSeries.size(); ++i) {
                Number number;
                Number number2 = xYSeries.getX(i);
                Number number3 = number = xYSeries.getY(i);
                Number number4 = number2;
                xYPlot = this;
                if (!(number4 == null || number3 == null ? false : XYPlot.a(number3.doubleValue(), xYPlot.u, xYPlot.v) && XYPlot.a(number4.doubleValue(), xYPlot.s, xYPlot.t))) continue;
                if (this.s == null && number2 != null && (this.w == null || number2.doubleValue() < this.w.doubleValue())) {
                    this.w = number2;
                }
                if (this.t == null && number2 != null && (this.x == null || number2.doubleValue() > this.x.doubleValue())) {
                    this.x = number2;
                }
                if (this.u == null && number != null && (this.y == null || number.doubleValue() < this.y.doubleValue())) {
                    this.y = number;
                }
                if (this.v != null || number == null || this.z != null && !(number.doubleValue() > this.z.doubleValue())) continue;
                this.z = number;
            }
            // MONITOREXIT : xYSeries2
        }
    }

    public void updateRangeMinMaxForEdgeModel() {
        switch (this.W) {
            case FIXED: {
                break;
            }
            case AUTO: {
                break;
            }
            case GROW: {
                if (this.D == null || this.z.doubleValue() > this.D.doubleValue()) break;
                this.z = this.D;
                break;
            }
            case SHRINNK: {
                if (this.D == null || this.z.doubleValue() < this.D.doubleValue()) break;
                this.z = this.D;
                break;
            }
            default: {
                throw new UnsupportedOperationException("RangeUpperBoundaryMode not supported: " + (Object)((Object)this.W));
            }
        }
        switch (this.Z) {
            case FIXED: {
                return;
            }
            case AUTO: {
                return;
            }
            case GROW: {
                if (this.C == null || this.y.doubleValue() < this.C.doubleValue()) break;
                this.y = this.C;
                return;
            }
            case SHRINNK: {
                if (this.C == null || this.y.doubleValue() > this.C.doubleValue()) break;
                this.y = this.C;
                return;
            }
            default: {
                throw new UnsupportedOperationException("RangeLowerBoundaryMode not supported: " + (Object)((Object)this.Z));
            }
        }
    }

    private static Number a(Number number, Number number2, Number number3) {
        number = number2 == null || number.doubleValue() > number2.doubleValue() ? (Number)number : (Number)number2;
        number = number3 == null || number.doubleValue() < number3.doubleValue() ? (Number)number : (Number)number3;
        return number;
    }

    public void centerOnDomainOrigin(Number number) {
        this.centerOnDomainOrigin(number, null, BoundaryMode.AUTO);
    }

    public void centerOnDomainOrigin(Number number, Number number2, BoundaryMode boundaryMode) {
        if (number == null) {
            throw new NullPointerException("Origin param cannot be null.");
        }
        this.M = XYFramingModel.ORIGIN;
        this.setUserDomainOrigin(number);
        this.S = number2;
        this.g = boundaryMode;
        if (this.g == BoundaryMode.FIXED) {
            double d = this.O.doubleValue();
            double d2 = this.S.doubleValue();
            this.t = d + d2;
            this.s = d - d2;
            return;
        }
        this.t = null;
        this.s = null;
    }

    public void centerOnRangeOrigin(Number number) {
        this.centerOnRangeOrigin(number, null, BoundaryMode.AUTO);
    }

    public void centerOnRangeOrigin(Number number, Number number2, BoundaryMode boundaryMode) {
        if (number == null) {
            throw new NullPointerException("Origin param cannot be null.");
        }
        this.N = XYFramingModel.ORIGIN;
        this.setUserRangeOrigin(number);
        this.T = number2;
        this.h = boundaryMode;
        if (this.h == BoundaryMode.FIXED) {
            double d = this.P.doubleValue();
            double d2 = this.T.doubleValue();
            this.v = d + d2;
            this.u = d - d2;
            return;
        }
        this.v = null;
        this.u = null;
    }

    private static double a(double d, double d2) {
        if (d > d2) {
            return d - d2;
        }
        return d2 - d;
    }

    public void updateDomainMinMaxForOriginModel() {
        double d;
        double d2 = this.O.doubleValue();
        double d3 = XYPlot.a(this.x.doubleValue(), d2);
        double d4 = d3 > (d = XYPlot.a(this.w.doubleValue(), d2)) ? d3 : d;
        double d5 = d2 - d4;
        double d6 = d2 + d4;
        switch (this.g) {
            case AUTO: {
                this.w = d5;
                this.x = d6;
                return;
            }
            case FIXED: {
                return;
            }
            case GROW: {
                this.w = this.A == null || d5 < this.A.doubleValue() ? (Number)d5 : (Number)this.A;
                if (this.B == null || d6 > this.B.doubleValue()) {
                    this.x = d6;
                    return;
                }
                this.x = this.B;
                return;
            }
            case SHRINNK: {
                this.w = this.A == null || d5 > this.A.doubleValue() ? (Number)d5 : (Number)this.A;
                if (this.B == null || d6 < this.B.doubleValue()) {
                    this.x = d6;
                    return;
                }
                this.x = this.B;
                return;
            }
        }
        throw new UnsupportedOperationException("Domain Origin Boundary Mode not yet supported: " + (Object)((Object)this.g));
    }

    public void updateRangeMinMaxForOriginModel() {
        switch (this.h) {
            case AUTO: {
                double d = this.P.doubleValue();
                double d2 = XYPlot.a(this.z.doubleValue(), d);
                double d3 = XYPlot.a(this.y.doubleValue(), d);
                if (d2 > d3) {
                    this.y = d - d2;
                    this.z = d + d2;
                    return;
                }
                this.y = d - d3;
                this.z = d + d3;
                return;
            }
        }
        throw new UnsupportedOperationException("Range Origin Boundary Mode not yet supported: " + (Object)((Object)this.h));
    }

    public int getTicksPerRangeLabel() {
        return this.j.getTicksPerRangeLabel();
    }

    public void setTicksPerRangeLabel(int n) {
        this.j.setTicksPerRangeLabel(n);
    }

    public int getTicksPerDomainLabel() {
        return this.j.getTicksPerDomainLabel();
    }

    public void setTicksPerDomainLabel(int n) {
        this.j.setTicksPerDomainLabel(n);
    }

    public XYStepMode getDomainStepMode() {
        return this.m;
    }

    public void setDomainStepMode(XYStepMode xYStepMode) {
        this.m = xYStepMode;
    }

    public double getDomainStepValue() {
        return this.n;
    }

    public void setDomainStepValue(double d) {
        this.n = d;
    }

    public void setDomainStep(XYStepMode xYStepMode, double d) {
        this.setDomainStepMode(xYStepMode);
        this.setDomainStepValue(d);
    }

    public XYStepMode getRangeStepMode() {
        return this.o;
    }

    public void setRangeStepMode(XYStepMode xYStepMode) {
        this.o = xYStepMode;
    }

    public double getRangeStepValue() {
        return this.p;
    }

    public void setRangeStepValue(double d) {
        this.p = d;
    }

    public void setRangeStep(XYStepMode xYStepMode, double d) {
        this.setRangeStepMode(xYStepMode);
        this.setRangeStepValue(d);
    }

    public String getDomainLabel() {
        return this.q;
    }

    public void setDomainLabel(String string) {
        this.q = string;
        if (this.getDomainLabelWidget() != null) {
            this.getDomainLabelWidget().pack();
        }
    }

    public String getRangeLabel() {
        return this.r;
    }

    public void setRangeLabel(String string) {
        this.r = string;
        if (this.getRangeLabelWidget() != null) {
            this.getRangeLabelWidget().pack();
        }
    }

    public XYLegendWidget getLegendWidget() {
        return this.i;
    }

    public void setLegendWidget(XYLegendWidget xYLegendWidget) {
        this.i = xYLegendWidget;
    }

    public XYGraphWidget getGraphWidget() {
        return this.j;
    }

    public void setGraphWidget(XYGraphWidget xYGraphWidget) {
        this.j = xYGraphWidget;
    }

    public DomainLabelWidget getDomainLabelWidget() {
        return this.k;
    }

    public void setDomainLabelWidget(DomainLabelWidget domainLabelWidget) {
        this.k = domainLabelWidget;
    }

    public RangeLabelWidget getRangeLabelWidget() {
        return this.l;
    }

    public void setRangeLabelWidget(RangeLabelWidget rangeLabelWidget) {
        this.l = rangeLabelWidget;
    }

    public Format getRangeValueFormat() {
        return this.j.getRangeValueFormat();
    }

    public void setRangeValueFormat(Format format) {
        this.j.setRangeValueFormat(format);
    }

    public Format getDomainValueFormat() {
        return this.j.getDomainValueFormat();
    }

    public void setDomainValueFormat(Format format) {
        this.j.setDomainValueFormat(format);
    }

    public synchronized void setDomainBoundaries(Number number, Number number2, BoundaryMode boundaryMode) {
        this.setDomainBoundaries(number, boundaryMode, number2, boundaryMode);
    }

    public synchronized void setDomainBoundaries(Number number, BoundaryMode boundaryMode, Number number2, BoundaryMode boundaryMode2) {
        this.setDomainLowerBoundary(number, boundaryMode);
        this.setDomainUpperBoundary(number2, boundaryMode2);
    }

    public synchronized void setRangeBoundaries(Number number, Number number2, BoundaryMode boundaryMode) {
        this.setRangeBoundaries(number, boundaryMode, number2, boundaryMode);
    }

    public synchronized void setRangeBoundaries(Number number, BoundaryMode boundaryMode, Number number2, BoundaryMode boundaryMode2) {
        this.setRangeLowerBoundary(number, boundaryMode);
        this.setRangeUpperBoundary(number2, boundaryMode2);
    }

    private synchronized void a(BoundaryMode boundaryMode) {
        this.U = boundaryMode;
    }

    private synchronized void a(Number number) {
        this.t = number;
    }

    public synchronized void setDomainUpperBoundary(Number object, BoundaryMode boundaryMode) {
        this.a(boundaryMode == BoundaryMode.FIXED ? object : null);
        this.a(boundaryMode);
        object = XYFramingModel.EDGE;
        v0.M = object;
    }

    private synchronized void b(BoundaryMode boundaryMode) {
        this.V = boundaryMode;
    }

    private synchronized void b(Number number) {
        this.s = number;
    }

    public synchronized void setDomainLowerBoundary(Number object, BoundaryMode boundaryMode) {
        this.b(boundaryMode == BoundaryMode.FIXED ? object : null);
        this.b(boundaryMode);
        object = XYFramingModel.EDGE;
        v0.M = object;
    }

    private synchronized void c(BoundaryMode boundaryMode) {
        this.W = boundaryMode;
    }

    private synchronized void c(Number number) {
        this.v = number;
    }

    public synchronized void setRangeUpperBoundary(Number object, BoundaryMode boundaryMode) {
        this.c(boundaryMode == BoundaryMode.FIXED ? object : null);
        this.c(boundaryMode);
        object = XYFramingModel.EDGE;
        v0.N = object;
    }

    private synchronized void d(BoundaryMode boundaryMode) {
        this.Z = boundaryMode;
    }

    private synchronized void d(Number number) {
        this.u = number;
    }

    public synchronized void setRangeLowerBoundary(Number object, BoundaryMode boundaryMode) {
        this.d(boundaryMode == BoundaryMode.FIXED ? object : null);
        this.d(boundaryMode);
        object = XYFramingModel.EDGE;
        v0.N = object;
    }

    public Number getDomainOrigin() {
        return this.Q;
    }

    public Number getRangeOrigin() {
        return this.R;
    }

    public synchronized void setUserDomainOrigin(Number number) {
        if (number == null) {
            throw new NullPointerException("Origin value cannot be null.");
        }
        this.O = number;
    }

    public synchronized void setUserRangeOrigin(Number number) {
        if (number == null) {
            throw new NullPointerException("Origin value cannot be null.");
        }
        this.P = number;
    }

    public XYFramingModel getDomainFramingModel() {
        return this.M;
    }

    public XYFramingModel getRangeFramingModel() {
        return this.N;
    }

    public Number getCalculatedMinX() {
        if (this.w != null) {
            return this.w;
        }
        return this.getDefaultBounds().getMinX();
    }

    public Number getCalculatedMaxX() {
        if (this.x != null) {
            return this.x;
        }
        return this.getDefaultBounds().getMaxX();
    }

    public Number getCalculatedMinY() {
        if (this.y != null) {
            return this.y;
        }
        return this.getDefaultBounds().getMinY();
    }

    public Number getCalculatedMaxY() {
        if (this.z != null) {
            return this.z;
        }
        return this.getDefaultBounds().getMaxY();
    }

    public boolean isDrawDomainOriginEnabled() {
        return this.aa;
    }

    public void setDrawDomainOriginEnabled(boolean bl) {
        this.aa = bl;
    }

    public boolean isDrawRangeOriginEnabled() {
        return this.ab;
    }

    public void setDrawRangeOriginEnabled(boolean bl) {
        this.ab = bl;
    }

    public boolean addMarker(YValueMarker yValueMarker) {
        if (this.e.contains(yValueMarker)) {
            return false;
        }
        return this.e.add(yValueMarker);
    }

    public YValueMarker removeMarker(YValueMarker yValueMarker) {
        int n = this.e.indexOf(yValueMarker);
        if (n == -1) {
            return null;
        }
        return this.e.remove(n);
    }

    public int removeMarkers() {
        int n = this.removeXMarkers();
        return n += this.removeYMarkers();
    }

    public int removeYMarkers() {
        int n = this.e.size();
        this.e.clear();
        return n;
    }

    public boolean addMarker(XValueMarker xValueMarker) {
        return !this.f.contains(xValueMarker) && this.f.add(xValueMarker);
    }

    public XValueMarker removeMarker(XValueMarker xValueMarker) {
        int n = this.f.indexOf(xValueMarker);
        if (n == -1) {
            return null;
        }
        return this.f.remove(n);
    }

    public int removeXMarkers() {
        int n = this.f.size();
        this.f.clear();
        return n;
    }

    public RectRegion getDefaultBounds() {
        return this.ac;
    }

    public void setDefaultBounds(RectRegion rectRegion) {
        this.ac = rectRegion;
    }

    public Number getRangeTopMin() {
        return this.E;
    }

    public synchronized void setRangeTopMin(Number number) {
        this.E = number;
    }

    public Number getRangeTopMax() {
        return this.F;
    }

    public synchronized void setRangeTopMax(Number number) {
        this.F = number;
    }

    public Number getRangeBottomMin() {
        return this.G;
    }

    public synchronized void setRangeBottomMin(Number number) {
        this.G = number;
    }

    public Number getRangeBottomMax() {
        return this.H;
    }

    public synchronized void setRangeBottomMax(Number number) {
        this.H = number;
    }

    public Number getDomainLeftMin() {
        return this.I;
    }

    public synchronized void setDomainLeftMin(Number number) {
        this.I = number;
    }

    public Number getDomainLeftMax() {
        return this.J;
    }

    public synchronized void setDomainLeftMax(Number number) {
        this.J = number;
    }

    public Number getDomainRightMin() {
        return this.K;
    }

    public synchronized void setDomainRightMin(Number number) {
        this.K = number;
    }

    public Number getDomainRightMax() {
        return this.L;
    }

    public synchronized void setDomainRightMax(Number number) {
        this.L = number;
    }
}

