/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.widget.Widget;
import com.androidplot.util.FontUtils;
import com.androidplot.util.ValPixConverter;
import com.androidplot.util.ZHash;
import com.androidplot.util.ZIndexable;
import com.androidplot.xy.AxisValueLabelFormatter;
import com.androidplot.xy.RectRegion;
import com.androidplot.xy.ValueMarker;
import com.androidplot.xy.XPositionMetric;
import com.androidplot.xy.XValueMarker;
import com.androidplot.xy.XYAxisType;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYSeriesRenderer;
import com.androidplot.xy.XYStep;
import com.androidplot.xy.XYStepCalculator;
import com.androidplot.xy.YPositionMetric;
import com.androidplot.xy.YValueMarker;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Iterator;

public class XYGraphWidget
extends Widget {
    private float a = 15.0f;
    private float b = 41.0f;
    private float c = -5.0f;
    private float d = 0.0f;
    private float e = 1.0f;
    private float f = 0.0f;
    private int g = 1;
    private int h = 1;
    private float i = 0.0f;
    private float j = 0.0f;
    private float k = 0.0f;
    private float l = 0.0f;
    private int m = 5;
    private int n = 5;
    private Paint o = new Paint();
    private Paint p;
    private Paint q;
    private Paint r;
    private Paint s;
    private Paint t;
    private Paint u;
    private Paint v;
    private Paint w;
    private Paint x;
    private XYPlot y;
    private Format z;
    private Format A;
    private Paint B;
    private Paint C;
    private Paint D;
    private Paint E;
    private RectF F;
    private RectF G;
    private float H;
    private float I;
    private boolean J = true;
    private boolean K = true;
    private boolean L = true;
    private boolean M = true;
    private ZHash<RectRegion, AxisValueLabelFormatter> N;

    public XYGraphWidget(XYPlot xYPlot, SizeMetrics sizeMetrics) {
        super(sizeMetrics);
        this.o.setColor(Color.rgb((int)140, (int)140, (int)140));
        this.o.setStyle(Paint.Style.FILL);
        this.p = new Paint();
        this.p.setColor(Color.rgb((int)180, (int)180, (int)180));
        this.p.setAntiAlias(true);
        this.p.setStyle(Paint.Style.STROKE);
        this.q = this.p;
        this.r = this.p;
        this.B = new Paint();
        this.B.setColor(-1);
        this.B.setAntiAlias(true);
        this.C = new Paint();
        this.C.setColor(-1);
        this.C.setAntiAlias(true);
        this.D = new Paint();
        this.D.setColor(-1);
        this.D.setAntiAlias(true);
        this.D.setTextAlign(Paint.Align.CENTER);
        this.E = new Paint();
        this.E.setColor(-1);
        this.E.setAntiAlias(true);
        this.E.setTextAlign(Paint.Align.RIGHT);
        this.s = new Paint();
        this.s.setColor(-3355444);
        this.s.setAntiAlias(true);
        this.s.setTextAlign(Paint.Align.CENTER);
        this.t = new Paint();
        this.t.setColor(-3355444);
        this.t.setAntiAlias(true);
        this.t.setTextAlign(Paint.Align.RIGHT);
        this.u = new Paint();
        this.u.setColor(-256);
        this.v = new Paint();
        this.v.setColor(-256);
        this.w = new Paint();
        this.w.setColor(-256);
        this.x = new Paint();
        this.x.setColor(Color.argb((int)100, (int)50, (int)50, (int)50));
        this.setMarginTop(7.0f);
        this.setMarginRight(4.0f);
        this.setMarginBottom(4.0f);
        this.z = new DecimalFormat("0.0");
        this.A = new DecimalFormat("0.0");
        this.N = new ZHash();
        this.y = xYPlot;
    }

    public ZIndexable<RectRegion> getAxisValueLabelRegions() {
        return this.N;
    }

    public void addAxisValueLabelRegion(RectRegion rectRegion, AxisValueLabelFormatter axisValueLabelFormatter) {
        this.N.addToTop(rectRegion, axisValueLabelFormatter);
    }

    public void addDomainAxisValueLabelRegion(double d, double d2, AxisValueLabelFormatter axisValueLabelFormatter) {
        this.addAxisValueLabelRegion(new RectRegion(d, d2, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, null), axisValueLabelFormatter);
    }

    public void addRangeAxisValueLabelRegion(double d, double d2, AxisValueLabelFormatter axisValueLabelFormatter) {
        this.addAxisValueLabelRegion(new RectRegion(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, d, d2, null), axisValueLabelFormatter);
    }

    public AxisValueLabelFormatter getAxisValueLabelFormatterForVal(double d, double d2) {
        for (RectRegion rectRegion : this.N.elements()) {
            if (!rectRegion.containsValue(d, d2)) continue;
            return this.N.get(rectRegion);
        }
        return null;
    }

    public AxisValueLabelFormatter getAxisValueLabelFormatterForDomainVal(double d) {
        for (RectRegion rectRegion : this.N.elements()) {
            if (!rectRegion.containsDomainValue(d)) continue;
            return this.N.get(rectRegion);
        }
        return null;
    }

    public AxisValueLabelFormatter getAxisValueLabelFormatterForRangeVal(double d) {
        for (RectRegion rectRegion : this.N.elements()) {
            if (!rectRegion.containsRangeValue(d)) continue;
            return this.N.get(rectRegion);
        }
        return null;
    }

    public RectF getGridRect() {
        return this.G;
    }

    private String a(Number number) {
        return this.z.format(number);
    }

    private String b(Number number) {
        return this.A.format(number);
    }

    public Double getYVal(PointF pointF) {
        return this.getYVal(pointF.y);
    }

    public Double getYVal(float f) {
        if (this.y.getCalculatedMinY() == null || this.y.getCalculatedMaxY() == null) {
            return null;
        }
        return ValPixConverter.pixToVal(f - this.G.top, this.y.getCalculatedMinY().doubleValue(), this.y.getCalculatedMaxY().doubleValue(), this.G.height(), true);
    }

    public Double getXVal(PointF pointF) {
        return this.getXVal(pointF.x);
    }

    public Double getXVal(float f) {
        if (this.y.getCalculatedMinX() == null || this.y.getCalculatedMaxX() == null) {
            return null;
        }
        return ValPixConverter.pixToVal(f - this.G.left, this.y.getCalculatedMinX().doubleValue(), this.y.getCalculatedMaxX().doubleValue(), this.G.width(), false);
    }

    @Override
    protected void doOnDraw(Canvas canvas, RectF object) throws PlotRenderException {
        RectF rectF = object;
        object = this;
        rectF = this.F = new RectF(rectF.left + (((XYGraphWidget)object).L ? ((XYGraphWidget)object).b : 1.0f), rectF.top + (((XYGraphWidget)object).M ? 1.0f : ((XYGraphWidget)object).a), rectF.right - (((XYGraphWidget)object).L ? 1.0f : ((XYGraphWidget)object).b), rectF.bottom - (((XYGraphWidget)object).M ? ((XYGraphWidget)object).a : 1.0f));
        object = this;
        this.G = new RectF(rectF.left + ((XYGraphWidget)object).k, rectF.top + ((XYGraphWidget)object).i, rectF.right - ((XYGraphWidget)object).l, rectF.bottom - ((XYGraphWidget)object).j);
        if (this.G.height() > 0.0f && this.G.width() > 0.0f && this.y.getCalculatedMinX() != null && this.y.getCalculatedMaxX() != null && this.y.getCalculatedMinY() != null && this.y.getCalculatedMaxY() != null) {
            this.a(canvas);
            this.c(canvas);
            rectF = canvas;
            object = this;
            boolean bl = false;
            if (((XYGraphWidget)object).u != null && ((XYGraphWidget)object).H <= ((XYGraphWidget)object).G.right && ((XYGraphWidget)object).H >= ((XYGraphWidget)object).G.left) {
                bl = true;
                rectF.drawLine(((XYGraphWidget)object).H, ((XYGraphWidget)object).G.top, ((XYGraphWidget)object).H, ((XYGraphWidget)object).G.bottom, ((XYGraphWidget)object).u);
            }
            boolean bl2 = false;
            if (((XYGraphWidget)object).v != null && ((XYGraphWidget)object).I >= ((XYGraphWidget)object).G.top && ((XYGraphWidget)object).I <= ((XYGraphWidget)object).G.bottom) {
                bl2 = true;
                rectF.drawLine(((XYGraphWidget)object).G.left, ((XYGraphWidget)object).I, ((XYGraphWidget)object).G.right, ((XYGraphWidget)object).I, ((XYGraphWidget)object).v);
            }
            if (((XYGraphWidget)object).J && ((XYGraphWidget)object).w != null && bl2 && bl) {
                String string = "X=" + ((XYGraphWidget)object).getDomainValueFormat().format(((XYGraphWidget)object).getDomainCursorVal());
                string = string + " Y=" + ((XYGraphWidget)object).getRangeValueFormat().format(((XYGraphWidget)object).getRangeCursorVal());
                RectF rectF2 = new RectF(FontUtils.getPackedStringDimensions(string, ((XYGraphWidget)object).w));
                rectF2.offsetTo(((XYGraphWidget)object).H, ((XYGraphWidget)object).I - rectF2.height());
                if (rectF2.right >= ((XYGraphWidget)object).G.right) {
                    rectF2.offsetTo(((XYGraphWidget)object).H - rectF2.width(), rectF2.top);
                }
                if (rectF2.top <= ((XYGraphWidget)object).G.top) {
                    rectF2.offsetTo(rectF2.left, ((XYGraphWidget)object).I);
                }
                if (((XYGraphWidget)object).x != null) {
                    rectF.drawRect(rectF2, ((XYGraphWidget)object).x);
                }
                rectF.drawText(string, rectF2.left, rectF2.bottom, ((XYGraphWidget)object).w);
            }
            if (this.isDrawMarkersEnabled()) {
                this.b(canvas);
            }
        }
    }

    private void a(Canvas canvas, XYAxisType xYAxisType, Number number, float f, float f2, Paint paint) {
        XYGraphWidget xYGraphWidget;
        AxisValueLabelFormatter axisValueLabelFormatter = null;
        String string = null;
        double d = number.doubleValue();
        switch (xYAxisType) {
            case DOMAIN: {
                axisValueLabelFormatter = xYGraphWidget.getAxisValueLabelFormatterForDomainVal(d);
                string = xYGraphWidget.b(number);
                break;
            }
            case RANGE: {
                axisValueLabelFormatter = xYGraphWidget.getAxisValueLabelFormatterForRangeVal(d);
                string = xYGraphWidget.a(number);
            }
        }
        if (axisValueLabelFormatter != null) {
            xYGraphWidget = new Paint(paint);
            xYGraphWidget.setColor(axisValueLabelFormatter.getColor());
        } else {
            xYGraphWidget = paint;
        }
        canvas.drawText(string, f, f2, (Paint)xYGraphWidget);
    }

    private void a(Canvas canvas, float f, Number number, Paint paint, Paint paint2, boolean bl) {
        if (!bl) {
            if (paint2 != null) {
                if (this.M) {
                    canvas.drawLine(f, this.F.top, f, this.F.bottom + (float)this.m, paint2);
                } else {
                    canvas.drawLine(f, this.F.top - (float)this.m, f, this.F.bottom, paint2);
                }
            }
            if (paint != null) {
                float f2 = FontUtils.getFontHeight(paint);
                f2 = this.M ? this.F.bottom + (float)this.m + this.c + f2 : this.F.top - (float)this.m - this.c;
                this.a(canvas, XYAxisType.DOMAIN, number, f + this.d, f2, paint);
                return;
            }
        } else if (paint2 != null) {
            canvas.drawLine(f, this.F.top, f, this.F.bottom, paint2);
        }
    }

    public void drawRangeTick(Canvas canvas, float f, Number number, Paint paint, Paint paint2, boolean bl) {
        if (!bl) {
            if (paint2 != null) {
                if (this.L) {
                    canvas.drawLine(this.F.left - (float)this.n, f, this.F.right, f, paint2);
                } else {
                    canvas.drawLine(this.F.left, f, this.F.right + (float)this.n, f, paint2);
                }
            }
            if (paint != null) {
                float f2 = this.L ? this.F.left - ((float)this.n + this.e) : this.F.right + ((float)this.n + this.e);
                this.a(canvas, XYAxisType.RANGE, number, f2, f - this.f, paint);
                return;
            }
        } else if (paint2 != null) {
            canvas.drawLine(this.F.left, f, this.F.right, f, paint2);
        }
    }

    private void a(Canvas canvas) throws PlotRenderException {
        float f;
        double d;
        float f2;
        if (this.o != null) {
            canvas.drawRect(this.F, this.o);
        }
        if (this.y.getDomainOrigin() != null) {
            double d2 = this.y.getDomainOrigin().doubleValue();
            f2 = ValPixConverter.valToPix(d2, this.y.getCalculatedMinX().doubleValue(), this.y.getCalculatedMaxX().doubleValue(), this.G.width(), false);
            f2 += this.G.left;
        } else {
            f2 = this.G.left;
        }
        XYStep xYStep = XYStepCalculator.getStep(this.y, XYAxisType.DOMAIN, this.G, (Number)this.y.getCalculatedMinX().doubleValue(), (Number)this.y.getCalculatedMaxX().doubleValue());
        if (f2 >= this.G.left && f2 <= this.G.right) {
            if (this.B != null) {
                this.B.setTextAlign(Paint.Align.CENTER);
            }
            this.a(canvas, f2, (Number)this.y.getDomainOrigin().doubleValue(), this.D, this.B, false);
        }
        int n = 1;
        float f3 = f2 - xYStep.getStepPix();
        while (f3 >= this.G.left) {
            d = this.y.getDomainOrigin().doubleValue() - (double)n * xYStep.getStepVal();
            if (f3 >= this.G.left && f3 <= this.G.right) {
                if (n % this.getTicksPerDomainLabel() == 0) {
                    this.a(canvas, f3, (Number)d, this.s, this.r, false);
                } else {
                    this.a(canvas, f3, (Number)d, this.s, this.r, true);
                }
            }
            f3 = f2 - (float)(++n) * xYStep.getStepPix();
        }
        n = 1;
        f3 = f2 + xYStep.getStepPix();
        while (f3 <= this.G.right) {
            d = this.y.getDomainOrigin().doubleValue() + (double)n * xYStep.getStepVal();
            if (f3 >= this.G.left && f3 <= this.G.right) {
                if (n % this.getTicksPerDomainLabel() == 0) {
                    this.a(canvas, f3, (Number)d, this.s, this.r, false);
                } else {
                    this.a(canvas, f3, (Number)d, this.s, this.r, true);
                }
            }
            f3 = f2 + (float)(++n) * xYStep.getStepPix();
        }
        if (this.y.getRangeOrigin() != null) {
            d = this.y.getRangeOrigin().doubleValue();
            f = ValPixConverter.valToPix(d, this.y.getCalculatedMinY().doubleValue(), this.y.getCalculatedMaxY().doubleValue(), this.G.height(), true);
            f += this.G.top;
        } else {
            f = this.G.bottom;
        }
        XYStep xYStep2 = XYStepCalculator.getStep(this.y, XYAxisType.RANGE, this.G, (Number)this.y.getCalculatedMinY().doubleValue(), (Number)this.y.getCalculatedMaxY().doubleValue());
        if (f >= this.G.top && f <= this.G.bottom) {
            if (this.C != null) {
                this.C.setTextAlign(Paint.Align.RIGHT);
            }
            this.drawRangeTick(canvas, f, this.y.getRangeOrigin().doubleValue(), this.E, this.C, false);
        }
        int n2 = 1;
        f2 = f - xYStep2.getStepPix();
        while (f2 >= this.G.top) {
            double d3 = this.y.getRangeOrigin().doubleValue() + (double)n2 * xYStep2.getStepVal();
            if (f2 >= this.G.top && f2 <= this.G.bottom) {
                if (n2 % this.getTicksPerRangeLabel() == 0) {
                    this.drawRangeTick(canvas, f2, d3, this.t, this.q, false);
                } else {
                    this.drawRangeTick(canvas, f2, d3, this.t, this.q, true);
                }
            }
            f2 = f - (float)(++n2) * xYStep2.getStepPix();
        }
        n2 = 1;
        f2 = f + xYStep2.getStepPix();
        while (f2 <= this.G.bottom) {
            double d4 = this.y.getRangeOrigin().doubleValue() - (double)n2 * xYStep2.getStepVal();
            if (f2 >= this.G.top && f2 <= this.G.bottom) {
                if (n2 % this.getTicksPerRangeLabel() == 0) {
                    this.drawRangeTick(canvas, f2, d4, this.t, this.q, false);
                } else {
                    this.drawRangeTick(canvas, f2, d4, this.t, this.q, true);
                }
            }
            f2 = f + (float)(++n2) * xYStep2.getStepPix();
        }
    }

    private void a(Canvas canvas, String string, ValueMarker valueMarker, float f, float f2) {
        RectF rectF = new RectF(FontUtils.getStringDimensions(string, valueMarker.getTextPaint()));
        rectF.offsetTo(f += 2.0f, (f2 -= 2.0f) - rectF.height());
        if (rectF.right > this.G.right) {
            rectF.offset(-(rectF.right - this.G.right), 0.0f);
        }
        if (rectF.top < this.G.top) {
            rectF.offset(0.0f, this.G.top - rectF.top);
        }
        canvas.drawText(string, rectF.left, rectF.bottom, valueMarker.getTextPaint());
    }

    private void b(Canvas canvas) {
        float f;
        float d;
        Iterator iterator = this.y;
        for (YValueMarker valueMarker : ((XYPlot)((Object)iterator)).e) {
            if (valueMarker.getValue() == null) continue;
            double d2 = valueMarker.getValue().doubleValue();
            d = ValPixConverter.valToPix(d2, this.y.getCalculatedMinY().doubleValue(), this.y.getCalculatedMaxY().doubleValue(), this.G.height(), true);
            canvas.drawLine(this.G.left, d += this.G.top, this.G.right, d, valueMarker.getLinePaint());
            f = ((XPositionMetric)valueMarker.getTextPosition()).getPixelValue(this.G.width());
            f += this.G.left;
            if (valueMarker.getText() != null) {
                this.a(canvas, valueMarker.getText(), valueMarker, f, d);
                continue;
            }
            this.a(canvas, this.a(valueMarker.getValue()), valueMarker, f, d);
        }
        iterator = this.y;
        for (XValueMarker xValueMarker : ((XYPlot)((Object)iterator)).f) {
            if (xValueMarker.getValue() == null) continue;
            double d3 = xValueMarker.getValue().doubleValue();
            d = ValPixConverter.valToPix(d3, this.y.getCalculatedMinX().doubleValue(), this.y.getCalculatedMaxX().doubleValue(), this.G.width(), false);
            canvas.drawLine(d += this.G.left, this.G.top, d, this.G.bottom, xValueMarker.getLinePaint());
            f = ((YPositionMetric)xValueMarker.getTextPosition()).getPixelValue(this.G.height());
            f += this.G.top;
            if (xValueMarker.getText() != null) {
                this.a(canvas, xValueMarker.getText(), xValueMarker, d, f);
                continue;
            }
            this.a(canvas, this.b(xValueMarker.getValue()), xValueMarker, d, f);
        }
    }

    private void c(Canvas canvas) throws PlotRenderException {
        try {
            canvas.save(31);
            canvas.clipRect(this.F, Region.Op.INTERSECT);
            for (XYSeriesRenderer xYSeriesRenderer : this.y.getRendererList()) {
                xYSeriesRenderer.render(canvas, this.G);
            }
            return;
        }
        finally {
            canvas.restore();
        }
    }

    public float getDomainLabelWidth() {
        return this.a;
    }

    public void setDomainLabelWidth(float f) {
        this.a = f;
    }

    public float getRangeLabelWidth() {
        return this.b;
    }

    public void setRangeLabelWidth(float f) {
        this.b = f;
    }

    public float getDomainLabelVerticalOffset() {
        return this.c;
    }

    public void setDomainLabelVerticalOffset(float f) {
        this.c = f;
    }

    public float getDomainLabelHorizontalOffset() {
        return this.d;
    }

    public void setDomainLabelHorizontalOffset(float f) {
        this.d = f;
    }

    public float getRangeLabelHorizontalOffset() {
        return this.e;
    }

    public void setRangeLabelHorizontalOffset(float f) {
        this.e = f;
    }

    public float getRangeLabelVerticalOffset() {
        return this.f;
    }

    public void setRangeLabelVerticalOffset(float f) {
        this.f = f;
    }

    public Paint getGridBackgroundPaint() {
        return this.o;
    }

    public void setGridBackgroundPaint(Paint paint) {
        this.o = paint;
    }

    public Paint getDomainLabelPaint() {
        return this.s;
    }

    public void setDomainLabelPaint(Paint paint) {
        this.s = paint;
    }

    public Paint getRangeLabelPaint() {
        return this.t;
    }

    public void setRangeLabelPaint(Paint paint) {
        this.t = paint;
    }

    public Paint getGridLinePaint() {
        return this.p;
    }

    public void setGridLinePaint(Paint paint) {
        if (paint == null) {
            this.p = null;
        } else {
            this.p = new Paint(paint);
            this.p.setStyle(Paint.Style.STROKE);
        }
        this.r = this.p;
        this.q = this.p;
    }

    public Paint getGridDomainLinePaint() {
        if (this.r == this.q) {
            this.r = new Paint(this.q);
            this.r.setStyle(Paint.Style.STROKE);
        }
        return this.r;
    }

    public void setGridDomainLinePaint(Paint paint) {
        if (paint == null) {
            this.r = null;
            return;
        }
        this.r = new Paint(paint);
        this.r.setStyle(Paint.Style.STROKE);
    }

    public Paint getGridRangeLinePaint() {
        if (this.r == this.q) {
            this.r = new Paint(this.q);
            this.r.setStyle(Paint.Style.STROKE);
        }
        return this.q;
    }

    public void setGridRangeLinePaint(Paint paint) {
        if (paint == null) {
            this.q = null;
            return;
        }
        this.q = new Paint(paint);
        this.q.setStyle(Paint.Style.STROKE);
    }

    public Format getRangeValueFormat() {
        return this.z;
    }

    public void setRangeValueFormat(Format format) {
        this.z = format;
    }

    public Format getDomainValueFormat() {
        return this.A;
    }

    public void setDomainValueFormat(Format format) {
        this.A = format;
    }

    public int getDomainLabelTickExtension() {
        return this.m;
    }

    public void setDomainLabelTickExtension(int n) {
        this.m = n;
    }

    public int getRangeLabelTickExtension() {
        return this.n;
    }

    public void setRangeLabelTickExtension(int n) {
        this.n = n;
    }

    public int getTicksPerRangeLabel() {
        return this.g;
    }

    public void setTicksPerRangeLabel(int n) {
        this.g = n;
    }

    public int getTicksPerDomainLabel() {
        return this.h;
    }

    public void setTicksPerDomainLabel(int n) {
        this.h = n;
    }

    @Deprecated
    public int getRangeTicksPerLabel() {
        return this.g;
    }

    @Deprecated
    public void setRangeTicksPerLabel(int n) {
        this.g = n;
    }

    public void setGridPaddingTop(float f) {
        this.i = f;
    }

    public float getGridPaddingBottom() {
        return this.j;
    }

    public void setGridPaddingBottom(float f) {
        this.j = f;
    }

    public float getGridPaddingLeft() {
        return this.k;
    }

    public void setGridPaddingLeft(float f) {
        this.k = f;
    }

    public float getGridPaddingRight() {
        return this.l;
    }

    public void setGridPaddingRight(float f) {
        this.l = f;
    }

    public float getGridPaddingTop() {
        return this.i;
    }

    public void setGridPadding(float f, float f2, float f3, float f4) {
        this.setGridPaddingLeft(f);
        this.setGridPaddingTop(f2);
        this.setGridPaddingRight(f3);
        this.setGridPaddingBottom(f4);
    }

    public Paint getDomainOriginLinePaint() {
        return this.B;
    }

    public void setDomainOriginLinePaint(Paint paint) {
        this.B = paint;
    }

    public Paint getRangeOriginLinePaint() {
        return this.C;
    }

    public void setRangeOriginLinePaint(Paint paint) {
        this.C = paint;
    }

    public Paint getDomainOriginLabelPaint() {
        return this.D;
    }

    public void setDomainOriginLabelPaint(Paint paint) {
        this.D = paint;
    }

    public Paint getRangeOriginLabelPaint() {
        return this.E;
    }

    public void setRangeOriginLabelPaint(Paint paint) {
        this.E = paint;
    }

    public void setCursorPosition(float f, float f2) {
        this.setDomainCursorPosition(f);
        this.setRangeCursorPosition(f2);
    }

    public void setCursorPosition(PointF pointF) {
        this.setCursorPosition(pointF.x, pointF.y);
    }

    public float getDomainCursorPosition() {
        return this.H;
    }

    public Double getDomainCursorVal() {
        return this.getXVal(this.getDomainCursorPosition());
    }

    public void setDomainCursorPosition(float f) {
        this.H = f;
    }

    public float getRangeCursorPosition() {
        return this.I;
    }

    public Double getRangeCursorVal() {
        return this.getYVal(this.getRangeCursorPosition());
    }

    public void setRangeCursorPosition(float f) {
        this.I = f;
    }

    public Paint getCursorLabelPaint() {
        return this.w;
    }

    public void setCursorLabelPaint(Paint paint) {
        this.w = paint;
    }

    public Paint getCursorLabelBackgroundPaint() {
        return this.x;
    }

    public void setCursorLabelBackgroundPaint(Paint paint) {
        this.x = paint;
    }

    public boolean isDrawMarkersEnabled() {
        return this.K;
    }

    public void setDrawMarkersEnabled(boolean bl) {
        this.K = bl;
    }

    public boolean isRangeAxisLeft() {
        return this.L;
    }

    public void setRangeAxisLeft(boolean bl) {
        this.L = bl;
    }

    public boolean isDomainAxisBottom() {
        return this.M;
    }

    public void setDomainAxisBottom(boolean bl) {
        this.M = bl;
    }

    public void setRangeAxisPosition(boolean bl, boolean bl2, int n, String string) {
        this.setRangeAxisLeft(bl);
        if (bl2) {
            this.setRangeLabelWidth(1.0f);
            this.setRangeLabelHorizontalOffset(-2.0f);
            this.setRangeLabelVerticalOffset(2.0f);
            Paint paint = this.getRangeLabelPaint();
            if (paint != null) {
                paint.setTextAlign(bl ? Paint.Align.LEFT : Paint.Align.RIGHT);
            }
            if ((paint = this.getRangeOriginLabelPaint()) != null) {
                paint.setTextAlign(bl ? Paint.Align.LEFT : Paint.Align.RIGHT);
            }
            this.setRangeLabelTickExtension(0);
            return;
        }
        this.setRangeLabelWidth(1.0f);
        this.setRangeLabelHorizontalOffset(1.0f);
        this.setRangeLabelTickExtension(n);
        Paint paint = this.getRangeLabelPaint();
        if (paint != null) {
            paint.setTextAlign(!bl ? Paint.Align.LEFT : Paint.Align.RIGHT);
            paint = FontUtils.getPackedStringDimensions(string, paint);
            this.setRangeLabelVerticalOffset(paint.top / 2);
            this.setRangeLabelWidth(paint.right + this.getRangeLabelTickExtension());
        }
        if ((paint = this.getRangeOriginLabelPaint()) != null) {
            paint.setTextAlign(!bl ? Paint.Align.LEFT : Paint.Align.RIGHT);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDomainAxisPosition(boolean bl, boolean bl2, int n, String string) {
        this.setDomainAxisBottom(bl);
        if (bl2) {
            this.setDomainLabelWidth(1.0f);
            this.setDomainLabelVerticalOffset(2.0f);
            this.setDomainLabelTickExtension(0);
            Paint paint = this.getDomainLabelPaint();
            if (paint == null) return;
            FontUtils.getFontHeight(paint);
            paint = FontUtils.getPackedStringDimensions(string, paint);
            if (bl) {
                this.setDomainLabelVerticalOffset(2 * paint.top);
                return;
            }
            this.setDomainLabelVerticalOffset((float)paint.top - 1.0f);
            return;
        }
        this.setDomainLabelWidth(1.0f);
        this.setDomainLabelTickExtension(n);
        Paint paint = this.getDomainLabelPaint();
        if (paint == null) return;
        float f = FontUtils.getFontHeight(paint);
        FontUtils.getPackedStringDimensions(string, paint);
        if (bl) {
            this.setDomainLabelVerticalOffset(-4.0f);
        } else {
            this.setDomainLabelVerticalOffset(1.0f);
        }
        this.setDomainLabelWidth(f + (float)this.getDomainLabelTickExtension());
    }

    public static enum XYPlotOrientation {
        HORIZONTAL,
        VERTICAL;

    }
}

