/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Canvas;
import android.util.Pair;
import com.androidplot.Plot;
import com.androidplot.PlotEvent;
import com.androidplot.PlotListener;
import com.androidplot.series.XYSeries;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SimpleXYSeries
implements PlotListener,
XYSeries {
    private volatile LinkedList<Number> a = new LinkedList();
    private volatile LinkedList<Number> b = new LinkedList();
    private volatile String c = null;
    private ReentrantReadWriteLock d = new ReentrantReadWriteLock();

    @Override
    public void onPlotUpdate(PlotEvent plotEvent) {
    }

    @Override
    public void onBeforeDraw(Plot plot, Canvas canvas) {
        this.d.readLock().lock();
    }

    @Override
    public void onAfterDraw(Plot plot, Canvas canvas) {
        this.d.readLock().unlock();
    }

    public SimpleXYSeries(String string) {
        this.c = string;
    }

    public SimpleXYSeries(List<? extends Number> list, ArrayFormat arrayFormat, String string) {
        this(string);
        this.setModel(list, arrayFormat);
    }

    public SimpleXYSeries(List<? extends Number> list, List<? extends Number> list2, String string) {
        this(string);
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("Neither the xVals nor the yVals parameters may be null.");
        }
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("xVals and yVals List parameters must be of the same size.");
        }
        this.a.addAll(list);
        this.b.addAll(list2);
    }

    public void useImplicitXVals() {
        this.d.writeLock().lock();
        try {
            this.a = null;
            return;
        }
        finally {
            this.d.writeLock().unlock();
        }
    }

    public void setModel(List<? extends Number> list, ArrayFormat arrayFormat) {
        this.d.writeLock().lock();
        try {
            this.a = null;
            this.b.clear();
            if (list == null || list.size() == 0) {
                return;
            }
            switch (arrayFormat) {
                case Y_VALS_ONLY: {
                    for (int i = 0; i < list.size(); ++i) {
                        this.b.add(list.get(i));
                    }
                    break;
                }
                case XY_VALS_INTERLEAVED: {
                    if (this.a == null) {
                        this.a = new LinkedList();
                    }
                    if (list.size() % 2 != 0) {
                        throw new IndexOutOfBoundsException("Cannot auto-generate series from odd-sized xy List.");
                    }
                    int n = list.size() / 2;
                    int n2 = 0;
                    int n3 = 0;
                    while (n2 < n) {
                        this.a.add(list.get(n3));
                        this.b.add(list.get(n3 + 1));
                        ++n2;
                        n3 += 2;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected enum value: " + (Object)((Object)arrayFormat));
                }
            }
            return;
        }
        finally {
            this.d.writeLock().unlock();
        }
    }

    public void setX(Number number, int n) {
        this.d.writeLock().lock();
        try {
            this.a.set(n, number);
            return;
        }
        finally {
            this.d.writeLock().unlock();
        }
    }

    public void setY(Number number, int n) {
        this.d.writeLock().lock();
        try {
            this.b.set(n, number);
            return;
        }
        finally {
            this.d.writeLock().unlock();
        }
    }

    public void setXY(Number number, Number number2, int n) {
        this.d.writeLock().lock();
        try {
            this.b.set(n, number2);
            this.a.set(n, number);
            return;
        }
        finally {
            this.d.writeLock().unlock();
        }
    }

    public void addFirst(Number number, Number number2) {
        this.d.writeLock().lock();
        try {
            if (this.a != null) {
                this.a.addFirst(number);
            }
            this.b.addFirst(number2);
            return;
        }
        finally {
            this.d.writeLock().unlock();
        }
    }

    public Pair<Number, Number> removeFirst() {
        this.d.writeLock().lock();
        try {
            if (this.size() <= 0) {
                throw new NoSuchElementException();
            }
            Pair pair = new Pair((Object)(this.a != null ? (Number)this.a.removeFirst() : (Number)0), (Object)this.b.removeFirst());
            return pair;
        }
        finally {
            this.d.writeLock().unlock();
        }
    }

    public void addLast(Number number, Number number2) {
        this.d.writeLock().lock();
        try {
            if (this.a != null) {
                this.a.addLast(number);
            }
            this.b.addLast(number2);
            return;
        }
        finally {
            this.d.writeLock().unlock();
        }
    }

    public Pair<Number, Number> removeLast() {
        this.d.writeLock().lock();
        try {
            if (this.size() <= 0) {
                throw new NoSuchElementException();
            }
            Pair pair = new Pair((Object)(this.a != null ? (Number)this.a.removeLast() : (Number)(this.b.size() - 1)), (Object)this.b.removeLast());
            return pair;
        }
        finally {
            this.d.writeLock().unlock();
        }
    }

    @Override
    public String getTitle() {
        return this.c;
    }

    public void setTitle(String string) {
        this.d.writeLock().lock();
        try {
            this.c = string;
            return;
        }
        finally {
            this.d.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        if (this.b != null) {
            return this.b.size();
        }
        return 0;
    }

    @Override
    public Number getX(int n) {
        if (this.a != null) {
            return this.a.get(n);
        }
        return n;
    }

    @Override
    public Number getY(int n) {
        return this.b.get(n);
    }

    public static enum ArrayFormat {
        Y_VALS_ONLY,
        XY_VALS_INTERLEAVED;

    }
}

