/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.series.XYSeries;
import com.androidplot.ui.DataRenderer;
import com.androidplot.util.ValPixConverter;
import com.androidplot.xy.BarFormatter;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYSeriesRenderer;
import com.androidplot.xy.c;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BarRenderer<T extends BarFormatter>
extends XYSeriesRenderer<T> {
    private BarWidthStyle a = BarWidthStyle.FIXED_WIDTH;
    private float b = 5.0f;
    private static final Comparator c = new c();

    public BarRenderer(XYPlot xYPlot) {
        super(xYPlot);
    }

    public void setBarWidth(float f) {
        this.b = f;
    }

    @Override
    public void onRender(Canvas canvas, RectF rectF) throws PlotRenderException {
        int n;
        List list = ((XYPlot)this.getPlot()).getSeriesListForRenderer(this.getClass());
        if (list == null) {
            return;
        }
        int n2 = 0;
        for (XYSeries xYSeries : list) {
            n = xYSeries.size();
            if (n <= n2) continue;
            n2 = n;
        }
        int n3 = n2;
        if (n3 == 0) {
            return;
        }
        TreeMap<Number, XYSeries> treeMap = new TreeMap<Number, XYSeries>(c);
        for (n = 0; n < n3; ++n) {
            treeMap.clear();
            Object object = ((XYPlot)this.getPlot()).getSeriesListForRenderer(this.getClass());
            object = object.iterator();
            while (object.hasNext()) {
                XYSeries xYSeries = (XYSeries)object.next();
                if (n >= xYSeries.size()) continue;
                treeMap.put(xYSeries.getY(n), xYSeries);
            }
            this.a(canvas, rectF, treeMap, n);
        }
    }

    @Override
    public void doDrawLegendIcon(Canvas canvas, RectF rectF, BarFormatter barFormatter) {
        canvas.drawRect(rectF, barFormatter.getFillPaint());
        canvas.drawRect(rectF, barFormatter.getBorderPaint());
    }

    private void a(Canvas canvas, RectF rectF, TreeMap<Number, XYSeries> objectArray, int n) {
        Paint paint = new Paint();
        paint.setColor(-65536);
        objectArray = objectArray.entrySet().toArray();
        block3: for (int i = objectArray.length - 1; i >= 0; --i) {
            Object object = (XYSeries)((Map.Entry)objectArray[i]).getValue();
            int n2 = n;
            RectF rectF2 = rectF;
            Canvas canvas2 = canvas;
            BarRenderer barRenderer = this;
            Number number = object.getX(n2);
            Number number2 = object.getY(n2);
            XYSeries xYSeries = object;
            object = barRenderer;
            object = (BarFormatter)((DataRenderer)object).getFormatter(xYSeries);
            if (number2 == null || number == null) continue;
            switch (barRenderer.a) {
                case FIXED_WIDTH: {
                    float f = barRenderer.b / 2.0f;
                    float f2 = ValPixConverter.valToPix(number.doubleValue(), ((XYPlot)barRenderer.getPlot()).getCalculatedMinX().doubleValue(), ((XYPlot)barRenderer.getPlot()).getCalculatedMaxX().doubleValue(), rectF2.width(), false) + rectF2.left;
                    float f3 = ValPixConverter.valToPix(number2.doubleValue(), ((XYPlot)barRenderer.getPlot()).getCalculatedMinY().doubleValue(), ((XYPlot)barRenderer.getPlot()).getCalculatedMaxY().doubleValue(), rectF2.height(), true) + rectF2.top;
                    canvas2.drawRect(f2 - f, f3, f2 + f, rectF2.bottom, ((BarFormatter)object).getFillPaint());
                    canvas2.drawRect(f2 - f, f3, f2 + f, rectF2.bottom, ((BarFormatter)object).getBorderPaint());
                    continue block3;
                }
                default: {
                    throw new UnsupportedOperationException("Not yet implemented.");
                }
            }
        }
    }

    public static enum BarWidthStyle {
        FIXED_WIDTH,
        FIXED_SPACING;

    }

    public static enum BarRenderStyle {
        STACKED,
        SIDE_BY_SIDE;

    }
}

