/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.util;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PixelUtils {
    private static DisplayMetrics a;
    public static final Map<String, Integer> dimensionConstantLookup;
    private static final Pattern b;

    public static void init(Context context) {
        a = context.getResources().getDisplayMetrics();
    }

    public static PointF add(PointF pointF, PointF pointF2) {
        return new PointF(pointF.x + pointF2.x, pointF.y + pointF2.y);
    }

    public static PointF sub(PointF pointF, PointF pointF2) {
        return new PointF(pointF.x - pointF2.x, pointF.y - pointF2.y);
    }

    public static RectF sink(RectF rectF) {
        return PixelUtils.nearestPixRect(rectF.left, rectF.top, rectF.right, rectF.bottom);
    }

    public static RectF nearestPixRect(float f, float f2, float f3, float f4) {
        return new RectF((float)((int)(f + 0.5f)), (float)((int)(f2 + 0.5f)), (float)((int)(f3 + 0.5f)), (float)((int)(f4 + 0.5f)));
    }

    public static float dpToPix(float f) {
        return TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)a);
    }

    public static float spToPix(float f) {
        return TypedValue.applyDimension((int)2, (float)f, (DisplayMetrics)a);
    }

    public static float fractionToPixH(float f) {
        return (float)PixelUtils.a.heightPixels * f;
    }

    public static float fractionToPixW(float f) {
        return (float)PixelUtils.a.widthPixels * f;
    }

    public static float stringToDimension(String object) {
        float f;
        if (((Matcher)(object = b.matcher((CharSequence)object))).matches()) {
            f = Float.valueOf(((Matcher)object).group(1)).floatValue();
            object = ((Matcher)object).group(3).toLowerCase();
            if ((object = dimensionConstantLookup.get(object)) == null) {
                throw new NumberFormatException();
            }
        } else {
            throw new NumberFormatException();
        }
        object = new a(f, (Integer)object);
        return TypedValue.applyDimension((int)((a)object).b, (float)((a)object).a, (DisplayMetrics)a);
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("px", 0);
        hashMap.put("dip", 1);
        hashMap.put("dp", 1);
        hashMap.put("sp", 2);
        hashMap.put("pt", 3);
        hashMap.put("in", 4);
        hashMap.put("mm", 5);
        dimensionConstantLookup = Collections.unmodifiableMap(hashMap);
        b = Pattern.compile("^\\s*(\\d+(\\.\\d+)*)\\s*([a-zA-Z]+)\\s*$");
    }

    private static final class a {
        float a;
        int b;

        public a(float f, int n) {
            this.a = f;
            this.b = n;
        }
    }
}

