/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.MotionEvent;
import android.view.View;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.ui.PositionMetrics;
import com.androidplot.ui.Resizable;
import com.androidplot.ui.widget.Widget;
import com.androidplot.util.DisplayDimensions;
import com.androidplot.util.PixelUtils;
import com.androidplot.util.ZHash;
import com.androidplot.xy.XLayoutStyle;
import com.androidplot.xy.YLayoutStyle;
import java.util.HashMap;

public class LayoutManager
extends ZHash<Widget, PositionMetrics>
implements View.OnTouchListener,
Resizable {
    private boolean a = false;
    private Paint b;
    private boolean c = false;
    private Paint d;
    private boolean e = false;
    private Paint f;
    private boolean g = false;
    private Paint h;
    private boolean i = false;
    private Paint j;
    private DisplayDimensions k = new DisplayDimensions();
    private HashMap<Widget, DisplayDimensions> l = new HashMap();

    public LayoutManager() {
        this.b = new Paint();
        this.b.setStyle(Paint.Style.FILL);
        this.b.setColor(-16711936);
        this.d = new Paint();
        this.d.setColor(-16711936);
        this.d.setStyle(Paint.Style.STROKE);
        this.f = new Paint();
        this.f.setColor(-12303292);
        this.f.setStyle(Paint.Style.FILL);
        this.f.setShadowLayer(3.0f, 5.0f, 5.0f, -16777216);
        this.h = new Paint();
        this.h.setColor(-256);
        this.h.setStyle(Paint.Style.FILL);
        this.h.setAlpha(200);
        this.j = new Paint();
        this.j.setColor(-16776961);
        this.j.setStyle(Paint.Style.FILL);
        this.j.setAlpha(200);
    }

    public void setMarkupEnabled(boolean bl) {
        this.setDrawOutlinesEnabled(bl);
        this.setDrawAnchorsEnabled(bl);
        this.setDrawMarginsEnabled(bl);
        this.setDrawPaddingEnabled(bl);
        this.setDrawOutlineShadowsEnabled(bl);
    }

    public AnchorPosition getElementAnchor(Widget widget) {
        return ((PositionMetrics)this.get(widget)).getAnchor();
    }

    public boolean setElementAnchor(Widget widget, AnchorPosition anchorPosition) {
        if ((this = (PositionMetrics)((ZHash)this).get(widget)) == null) {
            return false;
        }
        ((PositionMetrics)this).setAnchor(anchorPosition);
        return true;
    }

    public static PointF getAnchorCoordinates(RectF rectF, AnchorPosition anchorPosition) {
        return PixelUtils.add(new PointF(rectF.left, rectF.top), LayoutManager.getAnchorOffset(rectF.width(), rectF.height(), anchorPosition));
    }

    public static PointF getAnchorCoordinates(float f, float f2, float f3, float f4, AnchorPosition anchorPosition) {
        return LayoutManager.getAnchorCoordinates(new RectF(f, f2, f + f3, f2 + f4), anchorPosition);
    }

    public static PointF getAnchorOffset(float f, float f2, AnchorPosition anchorPosition) {
        PointF pointF = new PointF();
        switch (anchorPosition) {
            case LEFT_TOP: {
                break;
            }
            case LEFT_MIDDLE: {
                pointF.set(0.0f, f2 / 2.0f);
                break;
            }
            case LEFT_BOTTOM: {
                pointF.set(0.0f, f2);
                break;
            }
            case RIGHT_TOP: {
                pointF.set(f, 0.0f);
                break;
            }
            case RIGHT_BOTTOM: {
                pointF.set(f, f2);
                break;
            }
            case RIGHT_MIDDLE: {
                pointF.set(f, f2 / 2.0f);
                break;
            }
            case TOP_MIDDLE: {
                pointF.set(f / 2.0f, 0.0f);
                break;
            }
            case BOTTOM_MIDDLE: {
                pointF.set(f / 2.0f, f2);
                break;
            }
            case CENTER: {
                pointF.set(f / 2.0f, f2 / 2.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported anchor location: " + (Object)((Object)anchorPosition));
            }
        }
        return pointF;
    }

    public PointF getElementCoordinates(float f, float f2, RectF rectF, PositionMetrics positionMetrics) {
        float f3 = positionMetrics.getxPositionMetric().getPixelValue(rectF.width()) + rectF.left;
        float f4 = positionMetrics.getyPositionMetric().getPixelValue(rectF.height()) + rectF.top;
        PointF pointF = new PointF(f3, f4);
        return PixelUtils.sub(pointF, LayoutManager.getAnchorOffset(f2, f, positionMetrics.getAnchor()));
    }

    public void draw(Canvas canvas) throws PlotRenderException {
        if (this.isDrawMarginsEnabled()) {
            LayoutManager.a(canvas, this.k.canvasRect, this.k.marginatedRect, this.h);
        }
        if (this.isDrawPaddingEnabled()) {
            LayoutManager.a(canvas, this.k.marginatedRect, this.k.paddedRect, this.j);
        }
        for (Resizable resizable : this.getKeysAsList()) {
            try {
                canvas.save(31);
                PositionMetrics positionMetrics = (PositionMetrics)this.get(resizable);
                float f = resizable.getWidthPix(this.k.paddedRect.width());
                float f2 = resizable.getHeightPix(this.k.paddedRect.height());
                PointF pointF = this.getElementCoordinates(f2, f, this.k.paddedRect, positionMetrics);
                DisplayDimensions displayDimensions = this.l.get(resizable);
                if (this.e) {
                    canvas.drawRect(displayDimensions.canvasRect, this.f);
                }
                if (resizable.isClippingEnabled()) {
                    canvas.clipRect(displayDimensions.canvasRect, Region.Op.INTERSECT);
                }
                resizable.draw(canvas, displayDimensions.canvasRect);
                if (this.g) {
                    LayoutManager.a(canvas, displayDimensions.canvasRect, displayDimensions.marginatedRect, this.getMarginPaint());
                }
                if (this.i) {
                    LayoutManager.a(canvas, displayDimensions.marginatedRect, displayDimensions.paddedRect, this.getPaddingPaint());
                }
                if (this.a) {
                    Widget widget = resizable = LayoutManager.getAnchorCoordinates(pointF.x, pointF.y, f, f2, positionMetrics.getAnchor());
                    positionMetrics = canvas;
                    resizable = this;
                    f2 = 4.0f;
                    positionMetrics.drawRect(((PointF)widget).x - f2, ((PointF)widget).y - f2, ((PointF)widget).x + f2, ((PointF)widget).y + f2, ((LayoutManager)resizable).b);
                }
                if (!this.c) continue;
                this.d.setAntiAlias(true);
                canvas.drawRect(displayDimensions.canvasRect, this.d);
            }
            finally {
                canvas.restore();
            }
        }
    }

    private static void a(Canvas canvas, RectF rectF, RectF rectF2, Paint paint) {
        try {
            canvas.save(31);
            canvas.clipRect(rectF2, Region.Op.DIFFERENCE);
            canvas.drawRect(rectF, paint);
            return;
        }
        finally {
            canvas.restore();
        }
    }

    public void position(Widget widget, float f, XLayoutStyle xLayoutStyle, float f2, YLayoutStyle yLayoutStyle) {
        this.position(widget, f, xLayoutStyle, f2, yLayoutStyle, AnchorPosition.LEFT_TOP);
    }

    public void position(Widget widget, float f, XLayoutStyle xLayoutStyle, float f2, YLayoutStyle yLayoutStyle, AnchorPosition anchorPosition) {
        this.addToTop(widget, new PositionMetrics(f, xLayoutStyle, f2, yLayoutStyle, anchorPosition));
    }

    public boolean isDrawOutlinesEnabled() {
        return this.c;
    }

    public void setDrawOutlinesEnabled(boolean bl) {
        this.c = bl;
    }

    public Paint getOutlinePaint() {
        return this.d;
    }

    public void setOutlinePaint(Paint paint) {
        this.d = paint;
    }

    public boolean isDrawAnchorsEnabled() {
        return this.a;
    }

    public void setDrawAnchorsEnabled(boolean bl) {
        this.a = bl;
    }

    public boolean isDrawMarginsEnabled() {
        return this.g;
    }

    public void setDrawMarginsEnabled(boolean bl) {
        this.g = bl;
    }

    public Paint getMarginPaint() {
        return this.h;
    }

    public void setMarginPaint(Paint paint) {
        this.h = paint;
    }

    public boolean isDrawPaddingEnabled() {
        return this.i;
    }

    public void setDrawPaddingEnabled(boolean bl) {
        this.i = bl;
    }

    public Paint getPaddingPaint() {
        return this.j;
    }

    public void setPaddingPaint(Paint paint) {
        this.j = paint;
    }

    public boolean isDrawOutlineShadowsEnabled() {
        return this.e;
    }

    public void setDrawOutlineShadowsEnabled(boolean bl) {
        this.e = bl;
    }

    public Paint getOutlineShadowPaint() {
        return this.f;
    }

    public void setOutlineShadowPaint(Paint paint) {
        this.f = paint;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        return false;
    }

    @Override
    public void layout(DisplayDimensions object) {
        this.k = object;
        this.l.clear();
        for (Widget widget : this.getKeysAsList()) {
            Object object2 = (PositionMetrics)this.get(widget);
            float f = widget.getWidthPix(this.k.paddedRect.width());
            float f2 = widget.getHeightPix(this.k.paddedRect.height());
            object2 = this.getElementCoordinates(f2, f, this.k.paddedRect, (PositionMetrics)object2);
            object2 = new RectF(((PointF)object2).x, ((PointF)object2).y, ((PointF)object2).x + f, ((PointF)object2).y + f2);
            RectF rectF = widget.getMarginatedRect((RectF)object2);
            RectF rectF2 = widget.getPaddedRect(rectF);
            object2 = new DisplayDimensions((RectF)object2, rectF, rectF2);
            this.l.put(widget, (DisplayDimensions)object2);
            widget.layout((DisplayDimensions)object2);
        }
    }
}

