/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.os.Build;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import com.androidplot.PlotEvent;
import com.androidplot.PlotListener;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.series.Series;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.ui.BoxModel;
import com.androidplot.ui.DataRenderer;
import com.androidplot.ui.Formatter;
import com.androidplot.ui.LayoutManager;
import com.androidplot.ui.Resizable;
import com.androidplot.ui.SeriesAndFormatterList;
import com.androidplot.ui.SizeLayoutType;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.TextOrientationType;
import com.androidplot.ui.widget.TitleWidget;
import com.androidplot.ui.widget.Widget;
import com.androidplot.util.Configurator;
import com.androidplot.util.DisplayDimensions;
import com.androidplot.util.PixelUtils;
import com.androidplot.xy.XLayoutStyle;
import com.androidplot.xy.YLayoutStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class Plot<SeriesType extends Series, FormatterType extends Formatter, RendererType extends DataRenderer>
extends View
implements Resizable {
    private String e = "My Plot";
    private BoxModel f = new BoxModel(3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f);
    private BorderStyle g = BorderStyle.SQUARE;
    private float h = 15.0f;
    private float i = 15.0f;
    private boolean j = true;
    private Paint k;
    private Paint l;
    private LayoutManager m;
    private TitleWidget n;
    private DisplayDimensions o = new DisplayDimensions();
    private RenderMode p = RenderMode.USE_MAIN_THREAD;
    final BufferedCanvas a;
    final Object b;
    private LinkedList<RendererType> q;
    private LinkedHashMap<Class, SeriesAndFormatterList<SeriesType, FormatterType>> r;
    private final ArrayList<PlotListener> s;
    private Thread t;
    boolean c;
    boolean d;

    public DisplayDimensions getDisplayDimensions() {
        return this.o;
    }

    public Plot(Context context, String string) {
        this(context, string, RenderMode.USE_BACKGROUND_THREAD);
    }

    public Plot(Context context, String string, RenderMode renderMode) {
        super(context);
        new Canvas();
        this.a = new BufferedCanvas(this);
        this.b = new Object();
        this.c = false;
        this.d = true;
        this.s = new ArrayList();
        this.r = new LinkedHashMap();
        this.q = new LinkedList();
        this.k = new Paint();
        this.k.setColor(Color.rgb((int)150, (int)150, (int)150));
        this.k.setStyle(Paint.Style.STROKE);
        this.k.setStrokeWidth(1.0f);
        this.k.setAntiAlias(true);
        this.l = new Paint();
        this.l.setColor(-12303292);
        this.l.setStyle(Paint.Style.FILL);
        this.e = string;
        this.p = renderMode;
        this.b();
    }

    public Plot(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        new Canvas();
        this.a = new BufferedCanvas(this);
        this.b = new Object();
        this.c = false;
        this.d = true;
        this.s = new ArrayList();
        this.r = new LinkedHashMap();
        this.q = new LinkedList();
        this.k = new Paint();
        this.k.setColor(Color.rgb((int)150, (int)150, (int)150));
        this.k.setStyle(Paint.Style.STROKE);
        this.k.setStrokeWidth(1.0f);
        this.k.setAntiAlias(true);
        this.l = new Paint();
        this.l.setColor(-12303292);
        this.l.setStyle(Paint.Style.FILL);
        this.b();
    }

    public Plot(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        new Canvas();
        this.a = new BufferedCanvas(this);
        this.b = new Object();
        this.c = false;
        this.d = true;
        this.s = new ArrayList();
        this.r = new LinkedHashMap();
        this.q = new LinkedList();
        this.k = new Paint();
        this.k.setColor(Color.rgb((int)150, (int)150, (int)150));
        this.k.setStyle(Paint.Style.STROKE);
        this.k.setStrokeWidth(1.0f);
        this.k.setAntiAlias(true);
        this.l = new Paint();
        this.l.setColor(-12303292);
        this.l.setStyle(Paint.Style.FILL);
        this.b();
    }

    public void setRenderMode(RenderMode renderMode) {
    }

    private void b() {
        PixelUtils.init(this.getContext());
        this.n = new TitleWidget(this, new SizeMetrics(25.0f, SizeLayoutType.ABSOLUTE, 100.0f, SizeLayoutType.ABSOLUTE), TextOrientationType.HORIZONTAL);
        this.m = new LayoutManager();
        this.m.position(this.n, 0.0f, XLayoutStyle.RELATIVE_TO_CENTER, 0.0f, YLayoutStyle.ABSOLUTE_FROM_TOP, AnchorPosition.TOP_MIDDLE);
        if (this.p == RenderMode.USE_BACKGROUND_THREAD) {
            this.t = new Thread(new Runnable(this){
                private /* synthetic */ Plot a;
                {
                    this.a = plot;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public final void run() {
                    boolean bl = true;
                    Plot plot = this.a;
                    this.a.c = bl;
                    while (true) {
                        plot = this.a;
                        if (!plot.c) break;
                        boolean bl2 = false;
                        Object object = this.a;
                        this.a.d = false;
                        plot = this.a;
                        object = plot.a;
                        synchronized (object) {
                            plot = this.a;
                            plot = plot.a.getCanvas();
                            this.a.a((Canvas)plot);
                            plot = this.a;
                            plot.a.swap();
                        }
                        plot = this.a;
                        object = plot.b;
                        synchronized (object) {
                            this.a.postInvalidate();
                            plot = this.a;
                            if (plot.c) {
                                try {
                                    plot = this.a;
                                    plot.b.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    bl = false;
                                    plot = this.a;
                                    this.a.c = this.a.c;
                                }
                            }
                        }
                    }
                    System.out.println("AndroidPlot render thread finished.");
                }
            });
        }
    }

    protected final void a(AttributeSet attributeSet) {
        if (attributeSet != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < attributeSet.getAttributeCount(); ++i) {
                String string = attributeSet.getAttributeName(i);
                if (!string.toUpperCase().startsWith("androidplot".toUpperCase())) continue;
                hashMap.put(string.substring("androidplot".length() + 1), attributeSet.getAttributeValue(i));
            }
            Configurator.configure(this.getContext(), (Object)this, hashMap);
        }
    }

    public RenderMode getRenderMode() {
        return this.p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(PlotListener plotListener) {
        ArrayList<PlotListener> arrayList = this.s;
        synchronized (arrayList) {
            return !this.s.contains(plotListener) && this.s.add(plotListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(PlotListener plotListener) {
        ArrayList<PlotListener> arrayList = this.s;
        synchronized (arrayList) {
            return this.s.remove(plotListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Canvas canvas, PlotEvent plotEvent) {
        ArrayList<PlotListener> arrayList = this.s;
        synchronized (arrayList) {
            for (PlotListener plotListener : this.s) {
                plotListener.onAfterDraw(this, canvas);
                plotListener.onPlotUpdate(plotEvent);
            }
            return;
        }
    }

    public void position(Widget widget, float f, XLayoutStyle xLayoutStyle, float f2, YLayoutStyle yLayoutStyle) {
        this.m.position(widget, f, xLayoutStyle, f2, yLayoutStyle, AnchorPosition.LEFT_TOP);
    }

    public void position(Widget widget, float f, XLayoutStyle xLayoutStyle, float f2, YLayoutStyle yLayoutStyle, AnchorPosition anchorPosition) {
        this.m.position(widget, f, xLayoutStyle, f2, yLayoutStyle, anchorPosition);
    }

    public synchronized boolean addSeries(SeriesType SeriesType, FormatterType FormatterType) {
        Class<DataRenderer> clazz = ((Formatter)FormatterType).getRendererClass();
        SeriesAndFormatterList<SeriesType, FormatterType> seriesAndFormatterList = this.r.get(clazz);
        if (seriesAndFormatterList == null) {
            if (this.getRenderer(clazz) == null) {
                this.q.add(((Formatter)FormatterType).getRendererInstance((Plot)this));
            }
            seriesAndFormatterList = new SeriesAndFormatterList();
            this.r.put(clazz, seriesAndFormatterList);
        }
        if (SeriesType instanceof PlotListener) {
            this.addListener((PlotListener)SeriesType);
        }
        if (seriesAndFormatterList.contains(SeriesType)) {
            return false;
        }
        seriesAndFormatterList.add(SeriesType, FormatterType);
        return true;
    }

    public synchronized boolean removeSeries(SeriesType SeriesType, Class clazz) {
        boolean bl = this.r.get(clazz).remove(SeriesType);
        if (this.r.get(clazz).size() <= 0) {
            this.r.remove(clazz);
        }
        if (SeriesType instanceof PlotListener) {
            this.removeListener((PlotListener)SeriesType);
        }
        return bl;
    }

    public synchronized void removeSeries(SeriesType SeriesType) {
        for (Class clazz : this.r.keySet()) {
            this.r.get(clazz).remove(SeriesType);
        }
        Iterator<Object> iterator = this.r.values().iterator();
        while (iterator.hasNext()) {
            if (((SeriesAndFormatterList)iterator.next()).size() > 0) continue;
            iterator.remove();
        }
        if (SeriesType instanceof PlotListener) {
            this.removeListener((PlotListener)SeriesType);
        }
    }

    public void clear() {
        Iterator<SeriesAndFormatterList<SeriesType, FormatterType>> iterator = ((Plot)((Object)iterator)).r.values().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean isEmpty() {
        return this.r.isEmpty();
    }

    public FormatterType getFormatter(SeriesType SeriesType, Class clazz) {
        return (FormatterType)((Formatter)this.r.get(clazz).getFormatter(SeriesType));
    }

    public boolean setFormatter(SeriesType SeriesType, Class clazz, FormatterType FormatterType) {
        throw new UnsupportedOperationException();
    }

    public SeriesAndFormatterList<SeriesType, FormatterType> getSeriesAndFormatterListForRenderer(Class clazz) {
        return this.r.get(clazz);
    }

    public Set<SeriesType> getSeriesSet() {
        LinkedHashSet<Series> linkedHashSet = new LinkedHashSet<Series>();
        for (Iterator iterator : this.getRendererList()) {
            if ((iterator = this.getSeriesListForRenderer(iterator.getClass())) == null) continue;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Series series = (Series)iterator.next();
                linkedHashSet.add(series);
            }
        }
        return linkedHashSet;
    }

    public List<SeriesType> getSeriesListForRenderer(Class clazz) {
        SeriesAndFormatterList<SeriesType, FormatterType> seriesAndFormatterList = ((Plot)((Object)seriesAndFormatterList)).r.get(clazz);
        if (seriesAndFormatterList == null) {
            return null;
        }
        return seriesAndFormatterList.getSeriesList();
    }

    public RendererType getRenderer(Class clazz) {
        for (DataRenderer dataRenderer : ((Plot)this).q) {
            if (dataRenderer.getClass() != clazz) continue;
            return (RendererType)dataRenderer;
        }
        return null;
    }

    public List<RendererType> getRendererList() {
        return this.q;
    }

    @Deprecated
    public void disableAllMarkup() {
    }

    public void setMarkupEnabled(boolean bl) {
        this.m.setMarkupEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw() {
        if (this.p == RenderMode.USE_BACKGROUND_THREAD) {
            if (this.d) {
                Object object = this.b;
                synchronized (object) {
                    this.b.notify();
                }
            }
        } else {
            if (this.p == RenderMode.USE_MAIN_THREAD) {
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    this.invalidate();
                    return;
                }
                this.postInvalidate();
                return;
            }
            throw new IllegalArgumentException("Unsupported Render Mode: " + (Object)((Object)this.p));
        }
    }

    @Deprecated
    protected abstract void a();

    @Override
    public synchronized void layout(DisplayDimensions displayDimensions) {
        this.o = displayDimensions;
        this.m.layout(this.o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.b;
        synchronized (object) {
            this.c = false;
            this.b.notify();
            return;
        }
    }

    protected synchronized void onSizeChanged(int n, int n2, int n3, int n4) {
        PixelUtils.init(this.getContext());
        if (Build.VERSION.SDK_INT >= 11 && this.isHardwareAccelerated()) {
            this.setLayerType(1, null);
        }
        this.a.resize(n2, n);
        RectF rectF = new RectF(0.0f, 0.0f, (float)n, (float)n2);
        RectF rectF2 = this.f.getMarginatedRect(rectF);
        RectF rectF3 = this.f.getPaddedRect(rectF2);
        this.layout(new DisplayDimensions(rectF, rectF2, rectF3));
        super.onSizeChanged(n, n2, n3, n4);
        if (this.t != null && !this.t.isAlive()) {
            this.t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        if (((Plot)object).p == RenderMode.USE_BACKGROUND_THREAD) {
            BufferedCanvas bufferedCanvas = ((Plot)object).a;
            synchronized (bufferedCanvas) {
                Object object = ((Plot)object).a;
                object = ((BufferedCanvas)object).a;
                if (object != null) {
                    canvas.drawBitmap((Bitmap)object, 0.0f, 0.0f, null);
                }
            }
        } else {
            if (((Plot)object).p == RenderMode.USE_MAIN_THREAD) {
                ((Plot)object).a(canvas);
                return;
            }
            throw new IllegalArgumentException("Unsupported Render Mode: " + (Object)((Object)((Plot)object).p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final synchronized void a(Canvas canvas) {
        this.getSeriesSet();
        try {
            this.a();
            Canvas canvas2 = canvas;
            Object object = this;
            RectF rectF = ((Plot)object).s;
            synchronized (rectF) {
                for (PlotListener plotListener : ((Plot)object).s) {
                    plotListener.onBeforeDraw((Plot)object, canvas2);
                }
            }
            try {
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                if (this.l != null) {
                    rectF = this.o.marginatedRect;
                    canvas2 = canvas;
                    object = this;
                    switch (((Plot)object).g) {
                        case ROUNDED: {
                            canvas2.drawRoundRect(rectF, ((Plot)object).h, ((Plot)object).i, ((Plot)object).l);
                            break;
                        }
                        case SQUARE: {
                            canvas2.drawRect(rectF, ((Plot)object).l);
                        }
                    }
                }
                this.m.draw(canvas);
                if (!this.isDrawBorderEnabled() || this.getBorderPaint() == null) return;
                rectF = this.o.marginatedRect;
                canvas2 = canvas;
                object = this;
                switch (((Plot)object).g) {
                    case ROUNDED: {
                        canvas2.drawRoundRect(rectF, ((Plot)object).h, ((Plot)object).i, ((Plot)object).k);
                        return;
                    }
                    case SQUARE: {
                        canvas2.drawRect(rectF, ((Plot)object).k);
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (PlotRenderException plotRenderException) {
                object = plotRenderException;
                plotRenderException.printStackTrace();
            }
            return;
        }
        finally {
            this.d = true;
            this.a(canvas, new PlotEvent(this, PlotEvent.Type.PLOT_REDRAWN));
        }
    }

    public void setBorderStyle(BorderStyle borderStyle, Float f, Float f2) {
        if (borderStyle == BorderStyle.ROUNDED) {
            if (f == null || f2 == null) {
                throw new IllegalArgumentException("radiusX and radiusY cannot be null when using BorderStyle.ROUNDED");
            }
            this.h = f.floatValue();
            this.i = f2.floatValue();
        }
        this.g = borderStyle;
    }

    public String getTitle() {
        return this.e;
    }

    public void setTitle(String string) {
        this.e = string;
        if (this.n != null) {
            this.n.pack();
        }
    }

    public LayoutManager getLayoutManager() {
        return this.m;
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        this.m = layoutManager;
    }

    public boolean isDrawBorderEnabled() {
        return this.j;
    }

    public void setDrawBorderEnabled(boolean bl) {
        this.j = bl;
    }

    public TitleWidget getTitleWidget() {
        return this.n;
    }

    public void setTitleWidget(TitleWidget titleWidget) {
        this.n = titleWidget;
    }

    public Paint getBackgroundPaint() {
        return this.l;
    }

    public void setBackgroundPaint(Paint paint) {
        this.l = paint;
    }

    public void setPlotMargins(float f, float f2, float f3, float f4) {
        this.setPlotMarginLeft(f);
        this.setPlotMarginTop(f2);
        this.setPlotMarginRight(f3);
        this.setPlotMarginBottom(f4);
    }

    public void setPlotPadding(float f, float f2, float f3, float f4) {
        this.setPlotPaddingLeft(f);
        this.setPlotPaddingTop(f2);
        this.setPlotPaddingRight(f3);
        this.setPlotPaddingBottom(f4);
    }

    public float getPlotMarginTop() {
        return this.f.getMarginTop();
    }

    public void setPlotMarginTop(float f) {
        this.f.setMarginTop(f);
    }

    public float getPlotMarginBottom() {
        return this.f.getMarginBottom();
    }

    public void setPlotMarginBottom(float f) {
        this.f.setMarginBottom(f);
    }

    public float getPlotMarginLeft() {
        return this.f.getMarginLeft();
    }

    public void setPlotMarginLeft(float f) {
        this.f.setMarginLeft(f);
    }

    public float getPlotMarginRight() {
        return this.f.getMarginRight();
    }

    public void setPlotMarginRight(float f) {
        this.f.setMarginRight(f);
    }

    public float getPlotPaddingTop() {
        return this.f.getPaddingTop();
    }

    public void setPlotPaddingTop(float f) {
        this.f.setPaddingTop(f);
    }

    public float getPlotPaddingBottom() {
        return this.f.getPaddingBottom();
    }

    public void setPlotPaddingBottom(float f) {
        this.f.setPaddingBottom(f);
    }

    public float getPlotPaddingLeft() {
        return this.f.getPaddingLeft();
    }

    public void setPlotPaddingLeft(float f) {
        this.f.setPaddingLeft(f);
    }

    public float getPlotPaddingRight() {
        return this.f.getPaddingRight();
    }

    public void setPlotPaddingRight(float f) {
        this.f.setPaddingRight(f);
    }

    public Paint getBorderPaint() {
        return this.k;
    }

    public void setBorderPaint(Paint paint) {
        if (paint == null) {
            this.k = null;
            return;
        }
        this.k = new Paint(paint);
        this.k.setStyle(Paint.Style.STROKE);
    }

    private class BufferedCanvas {
        private volatile Bitmap b;
        volatile Bitmap a;
        private Canvas c = new Canvas();

        private BufferedCanvas(Plot plot, byte by) {
        }

        public final synchronized void swap() {
            Bitmap bitmap = this.b;
            this.b = this.a;
            this.a = bitmap;
        }

        public final synchronized void resize(int n, int n2) {
            if (n2 <= 0 || n <= 0) {
                this.b = null;
                this.a = null;
                return;
            }
            this.b = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)Bitmap.Config.ARGB_4444);
            this.a = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        }

        public final synchronized Canvas getCanvas() {
            if (this.b != null) {
                this.c.setBitmap(this.b);
                return this.c;
            }
            return null;
        }

        public final Bitmap getBitmap() {
            return this.a;
        }

        /* synthetic */ BufferedCanvas(Plot plot) {
            this(plot, 0);
        }
    }

    public static enum RenderMode {
        USE_BACKGROUND_THREAD,
        USE_MAIN_THREAD;

    }

    public static enum BorderStyle {
        ROUNDED,
        SQUARE,
        NONE;

    }
}

