/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot;

public class LineRegion {
    private Number a;
    private Number b;

    public LineRegion(Number number, Number number2) {
        if (number.doubleValue() < number2.doubleValue()) {
            this.setMinVal(number);
            this.setMaxVal(number2);
            return;
        }
        this.setMinVal(number2);
        this.setMaxVal(number);
    }

    public static Number measure(Number number, Number number2) {
        return new LineRegion(number, number2).length();
    }

    public Number length() {
        return this.b.doubleValue() - this.a.doubleValue();
    }

    public boolean contains(Number number) {
        return number.doubleValue() >= this.a.doubleValue() && number.doubleValue() <= this.b.doubleValue();
    }

    public boolean intersects(LineRegion lineRegion) {
        return this.intersects(lineRegion.getMinVal(), lineRegion.getMaxVal());
    }

    public boolean intersects(Number number, Number number2) {
        if (number.doubleValue() <= this.a.doubleValue() && number2.doubleValue() >= this.b.doubleValue()) {
            return true;
        }
        return this.contains(number) || this.contains(number2);
    }

    public Number getMinVal() {
        return this.a;
    }

    public void setMinVal(Number number) {
        if (number == null) {
            throw new NullPointerException("Region values can never be null.");
        }
        this.a = number;
    }

    public Number getMaxVal() {
        return this.b;
    }

    public void setMaxVal(Number number) {
        if (number == null) {
            throw new NullPointerException("Region values can never be null.");
        }
        this.b = number;
    }
}

