import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:yaga/managers/settings_manager.dart';
import 'package:yaga/model/preferences/preference.dart';
import 'package:yaga/utils/service_locator.dart';

class PreferenceListTileWidget<T extends Preference> extends StatelessWidget {
  final T initData;
  final Widget Function(BuildContext, T) listTileBuilder;

  const PreferenceListTileWidget({
    required this.initData,
    required this.listTileBuilder,
  });

  @override
  Widget build(BuildContext context) {
    return StreamBuilder<T>(
      stream: getIt
          .get<SettingsManager>()
          .updateSettingCommand
          .where((event) => event.key == initData.key)
          .map((event) => event as T),
      initialData: initData,
      builder: (BuildContext context, AsyncSnapshot<T> snapshot) {
        return listTileBuilder(context, snapshot.data!);
      },
    );
  }
}
