import 'package:flutter/material.dart';
import 'package:rx_command/rx_command.dart';
import 'package:yaga/managers/settings_manager.dart';
import 'package:yaga/model/preferences/choice_preference.dart';
import 'package:yaga/model/preferences/preference.dart';
import 'package:yaga/model/route_args/choice_selector_screen_arguments.dart';
import 'package:yaga/services/shared_preferences_service.dart';
import 'package:yaga/utils/service_locator.dart';
import 'package:yaga/views/screens/choice_selector_screen.dart';
import 'package:yaga/views/widgets/preferences/preference_list_tile_widget.dart';

class ChoicePreferenceWidget extends StatelessWidget {
  final ChoicePreference _choicePreference;
  final RxCommand<Preference, dynamic>? onChangeCommand;

  const ChoicePreferenceWidget(this._choicePreference, this.onChangeCommand);

  //todo: generalize this for all preferences
  void _notifyChange(ChoicePreference pref) {
    if (onChangeCommand != null) {
      onChangeCommand!(pref);
      return;
    }
    getIt.get<SettingsManager>().persistStringSettingCommand(pref);
  }

  @override
  Widget build(BuildContext context) {
    return PreferenceListTileWidget<ChoicePreference>(
        initData: getIt
            .get<SharedPreferencesService>()
            .loadPreferenceFromString(_choicePreference),
        listTileBuilder: (context, pref) => ListTile(
              title: Text(pref.title!),
              subtitle: Text(pref.choices[pref.value]!),
              onTap: () => Navigator.pushNamed(
                  context, ChoiceSelectorScreen.route,
                  arguments:
                      ChoiceSelectorScreenArguments(pref, (String value) {
                    Navigator.pop(context);
                    _notifyChange(pref.rebuild((b) => b..value = value));
                  }, () => Navigator.pop(context))),
            ));
  }
}
