// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v9.2.5), do not edit directly.
// See also: https://pub.dev/packages/pigeon

package io.flutter.plugins.webviewflutter;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/** Generated class from Pigeon. */
@SuppressWarnings({"unused", "unchecked", "CodeBlock2Expr", "RedundantSuppression", "serial"})
public class GeneratedAndroidWebView {

  /** Error class for passing custom error details to Flutter via a thrown PlatformException. */
  public static class FlutterError extends RuntimeException {

    /** The error code. */
    public final String code;

    /** The error details. Must be a datatype supported by the api codec. */
    public final Object details;

    public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) {
      super(message);
      this.code = code;
      this.details = details;
    }
  }

  @NonNull
  protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
    ArrayList<Object> errorList = new ArrayList<Object>(3);
    if (exception instanceof FlutterError) {
      FlutterError error = (FlutterError) exception;
      errorList.add(error.code);
      errorList.add(error.getMessage());
      errorList.add(error.details);
    } else {
      errorList.add(exception.toString());
      errorList.add(exception.getClass().getSimpleName());
      errorList.add(
          "Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString(exception));
    }
    return errorList;
  }

  /**
   * Mode of how to select files for a file chooser.
   *
   * <p>See
   * https://developer.android.com/reference/android/webkit/WebChromeClient.FileChooserParams.
   */
  public enum FileChooserMode {
    /**
     * Open single file and requires that the file exists before allowing the user to pick it.
     *
     * <p>See
     * https://developer.android.com/reference/android/webkit/WebChromeClient.FileChooserParams#MODE_OPEN.
     */
    OPEN(0),
    /**
     * Similar to [open] but allows multiple files to be selected.
     *
     * <p>See
     * https://developer.android.com/reference/android/webkit/WebChromeClient.FileChooserParams#MODE_OPEN_MULTIPLE.
     */
    OPEN_MULTIPLE(1),
    /**
     * Allows picking a nonexistent file and saving it.
     *
     * <p>See
     * https://developer.android.com/reference/android/webkit/WebChromeClient.FileChooserParams#MODE_SAVE.
     */
    SAVE(2);

    final int index;

    private FileChooserMode(final int index) {
      this.index = index;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class FileChooserModeEnumData {
    private @NonNull FileChooserMode value;

    public @NonNull FileChooserMode getValue() {
      return value;
    }

    public void setValue(@NonNull FileChooserMode setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"value\" is null.");
      }
      this.value = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    FileChooserModeEnumData() {}

    public static final class Builder {

      private @Nullable FileChooserMode value;

      public @NonNull Builder setValue(@NonNull FileChooserMode setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull FileChooserModeEnumData build() {
        FileChooserModeEnumData pigeonReturn = new FileChooserModeEnumData();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(value == null ? null : value.index);
      return toListResult;
    }

    static @NonNull FileChooserModeEnumData fromList(@NonNull ArrayList<Object> list) {
      FileChooserModeEnumData pigeonResult = new FileChooserModeEnumData();
      Object value = list.get(0);
      pigeonResult.setValue(value == null ? null : FileChooserMode.values()[(int) value]);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class WebResourceRequestData {
    private @NonNull String url;

    public @NonNull String getUrl() {
      return url;
    }

    public void setUrl(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"url\" is null.");
      }
      this.url = setterArg;
    }

    private @NonNull Boolean isForMainFrame;

    public @NonNull Boolean getIsForMainFrame() {
      return isForMainFrame;
    }

    public void setIsForMainFrame(@NonNull Boolean setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"isForMainFrame\" is null.");
      }
      this.isForMainFrame = setterArg;
    }

    private @Nullable Boolean isRedirect;

    public @Nullable Boolean getIsRedirect() {
      return isRedirect;
    }

    public void setIsRedirect(@Nullable Boolean setterArg) {
      this.isRedirect = setterArg;
    }

    private @NonNull Boolean hasGesture;

    public @NonNull Boolean getHasGesture() {
      return hasGesture;
    }

    public void setHasGesture(@NonNull Boolean setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"hasGesture\" is null.");
      }
      this.hasGesture = setterArg;
    }

    private @NonNull String method;

    public @NonNull String getMethod() {
      return method;
    }

    public void setMethod(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"method\" is null.");
      }
      this.method = setterArg;
    }

    private @NonNull Map<String, String> requestHeaders;

    public @NonNull Map<String, String> getRequestHeaders() {
      return requestHeaders;
    }

    public void setRequestHeaders(@NonNull Map<String, String> setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"requestHeaders\" is null.");
      }
      this.requestHeaders = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    WebResourceRequestData() {}

    public static final class Builder {

      private @Nullable String url;

      public @NonNull Builder setUrl(@NonNull String setterArg) {
        this.url = setterArg;
        return this;
      }

      private @Nullable Boolean isForMainFrame;

      public @NonNull Builder setIsForMainFrame(@NonNull Boolean setterArg) {
        this.isForMainFrame = setterArg;
        return this;
      }

      private @Nullable Boolean isRedirect;

      public @NonNull Builder setIsRedirect(@Nullable Boolean setterArg) {
        this.isRedirect = setterArg;
        return this;
      }

      private @Nullable Boolean hasGesture;

      public @NonNull Builder setHasGesture(@NonNull Boolean setterArg) {
        this.hasGesture = setterArg;
        return this;
      }

      private @Nullable String method;

      public @NonNull Builder setMethod(@NonNull String setterArg) {
        this.method = setterArg;
        return this;
      }

      private @Nullable Map<String, String> requestHeaders;

      public @NonNull Builder setRequestHeaders(@NonNull Map<String, String> setterArg) {
        this.requestHeaders = setterArg;
        return this;
      }

      public @NonNull WebResourceRequestData build() {
        WebResourceRequestData pigeonReturn = new WebResourceRequestData();
        pigeonReturn.setUrl(url);
        pigeonReturn.setIsForMainFrame(isForMainFrame);
        pigeonReturn.setIsRedirect(isRedirect);
        pigeonReturn.setHasGesture(hasGesture);
        pigeonReturn.setMethod(method);
        pigeonReturn.setRequestHeaders(requestHeaders);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(6);
      toListResult.add(url);
      toListResult.add(isForMainFrame);
      toListResult.add(isRedirect);
      toListResult.add(hasGesture);
      toListResult.add(method);
      toListResult.add(requestHeaders);
      return toListResult;
    }

    static @NonNull WebResourceRequestData fromList(@NonNull ArrayList<Object> list) {
      WebResourceRequestData pigeonResult = new WebResourceRequestData();
      Object url = list.get(0);
      pigeonResult.setUrl((String) url);
      Object isForMainFrame = list.get(1);
      pigeonResult.setIsForMainFrame((Boolean) isForMainFrame);
      Object isRedirect = list.get(2);
      pigeonResult.setIsRedirect((Boolean) isRedirect);
      Object hasGesture = list.get(3);
      pigeonResult.setHasGesture((Boolean) hasGesture);
      Object method = list.get(4);
      pigeonResult.setMethod((String) method);
      Object requestHeaders = list.get(5);
      pigeonResult.setRequestHeaders((Map<String, String>) requestHeaders);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class WebResourceErrorData {
    private @NonNull Long errorCode;

    public @NonNull Long getErrorCode() {
      return errorCode;
    }

    public void setErrorCode(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"errorCode\" is null.");
      }
      this.errorCode = setterArg;
    }

    private @NonNull String description;

    public @NonNull String getDescription() {
      return description;
    }

    public void setDescription(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"description\" is null.");
      }
      this.description = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    WebResourceErrorData() {}

    public static final class Builder {

      private @Nullable Long errorCode;

      public @NonNull Builder setErrorCode(@NonNull Long setterArg) {
        this.errorCode = setterArg;
        return this;
      }

      private @Nullable String description;

      public @NonNull Builder setDescription(@NonNull String setterArg) {
        this.description = setterArg;
        return this;
      }

      public @NonNull WebResourceErrorData build() {
        WebResourceErrorData pigeonReturn = new WebResourceErrorData();
        pigeonReturn.setErrorCode(errorCode);
        pigeonReturn.setDescription(description);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(errorCode);
      toListResult.add(description);
      return toListResult;
    }

    static @NonNull WebResourceErrorData fromList(@NonNull ArrayList<Object> list) {
      WebResourceErrorData pigeonResult = new WebResourceErrorData();
      Object errorCode = list.get(0);
      pigeonResult.setErrorCode(
          (errorCode == null)
              ? null
              : ((errorCode instanceof Integer) ? (Integer) errorCode : (Long) errorCode));
      Object description = list.get(1);
      pigeonResult.setDescription((String) description);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class WebViewPoint {
    private @NonNull Long x;

    public @NonNull Long getX() {
      return x;
    }

    public void setX(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"x\" is null.");
      }
      this.x = setterArg;
    }

    private @NonNull Long y;

    public @NonNull Long getY() {
      return y;
    }

    public void setY(@NonNull Long setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"y\" is null.");
      }
      this.y = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    WebViewPoint() {}

    public static final class Builder {

      private @Nullable Long x;

      public @NonNull Builder setX(@NonNull Long setterArg) {
        this.x = setterArg;
        return this;
      }

      private @Nullable Long y;

      public @NonNull Builder setY(@NonNull Long setterArg) {
        this.y = setterArg;
        return this;
      }

      public @NonNull WebViewPoint build() {
        WebViewPoint pigeonReturn = new WebViewPoint();
        pigeonReturn.setX(x);
        pigeonReturn.setY(y);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(x);
      toListResult.add(y);
      return toListResult;
    }

    static @NonNull WebViewPoint fromList(@NonNull ArrayList<Object> list) {
      WebViewPoint pigeonResult = new WebViewPoint();
      Object x = list.get(0);
      pigeonResult.setX((x == null) ? null : ((x instanceof Integer) ? (Integer) x : (Long) x));
      Object y = list.get(1);
      pigeonResult.setY((y == null) ? null : ((y instanceof Integer) ? (Integer) y : (Long) y));
      return pigeonResult;
    }
  }

  public interface Result<T> {
    @SuppressWarnings("UnknownNullness")
    void success(T result);

    void error(@NonNull Throwable error);
  }
  /**
   * Host API for managing the native `InstanceManager`.
   *
   * <p>Generated interface from Pigeon that represents a handler of messages from Flutter.
   */
  public interface InstanceManagerHostApi {
    /**
     * Clear the native `InstanceManager`.
     *
     * <p>This is typically only used after a hot restart.
     */
    void clear();

    /** The codec used by InstanceManagerHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `InstanceManagerHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable InstanceManagerHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.InstanceManagerHostApi.clear", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  api.clear();
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /**
   * Handles methods calls to the native Java Object class.
   *
   * <p>Also handles calls to remove the reference to an instance with `dispose`.
   *
   * <p>See https://docs.oracle.com/javase/7/docs/api/java/lang/Object.html.
   *
   * <p>Generated interface from Pigeon that represents a handler of messages from Flutter.
   */
  public interface JavaObjectHostApi {

    void dispose(@NonNull Long identifier);

    /** The codec used by JavaObjectHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `JavaObjectHostApi` to handle messages through the `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable JavaObjectHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.JavaObjectHostApi.dispose", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                try {
                  api.dispose((identifierArg == null) ? null : identifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /**
   * Handles callbacks methods for the native Java Object class.
   *
   * <p>See https://docs.oracle.com/javase/7/docs/api/java/lang/Object.html.
   *
   * <p>Generated class from Pigeon that represents Flutter messages that can be called from Java.
   */
  public static class JavaObjectFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public JavaObjectFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by JavaObjectFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void dispose(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.JavaObjectFlutterApi.dispose", getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }
  /**
   * Host API for `CookieManager`.
   *
   * <p>This class may handle instantiating and adding native object instances that are attached to
   * a Dart instance or handle method calls on the associated native class or an instance of the
   * class.
   *
   * <p>Generated interface from Pigeon that represents a handler of messages from Flutter.
   */
  public interface CookieManagerHostApi {
    /** Handles attaching `CookieManager.instance` to a native instance. */
    void attachInstance(@NonNull Long instanceIdentifier);
    /** Handles Dart method `CookieManager.setCookie`. */
    void setCookie(@NonNull Long identifier, @NonNull String url, @NonNull String value);
    /** Handles Dart method `CookieManager.removeAllCookies`. */
    void removeAllCookies(@NonNull Long identifier, @NonNull Result<Boolean> result);
    /** Handles Dart method `CookieManager.setAcceptThirdPartyCookies`. */
    void setAcceptThirdPartyCookies(
        @NonNull Long identifier, @NonNull Long webViewIdentifier, @NonNull Boolean accept);

    /** The codec used by CookieManagerHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `CookieManagerHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable CookieManagerHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.CookieManagerHostApi.attachInstance",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdentifierArg = (Number) args.get(0);
                try {
                  api.attachInstance(
                      (instanceIdentifierArg == null) ? null : instanceIdentifierArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.CookieManagerHostApi.setCookie", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                String urlArg = (String) args.get(1);
                String valueArg = (String) args.get(2);
                try {
                  api.setCookie(
                      (identifierArg == null) ? null : identifierArg.longValue(), urlArg, valueArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.CookieManagerHostApi.removeAllCookies",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Result<Boolean> resultCallback =
                    new Result<Boolean>() {
                      public void success(Boolean result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.removeAllCookies(
                    (identifierArg == null) ? null : identifierArg.longValue(), resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.CookieManagerHostApi.setAcceptThirdPartyCookies",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number identifierArg = (Number) args.get(0);
                Number webViewIdentifierArg = (Number) args.get(1);
                Boolean acceptArg = (Boolean) args.get(2);
                try {
                  api.setAcceptThirdPartyCookies(
                      (identifierArg == null) ? null : identifierArg.longValue(),
                      (webViewIdentifierArg == null) ? null : webViewIdentifierArg.longValue(),
                      acceptArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class WebViewHostApiCodec extends StandardMessageCodec {
    public static final WebViewHostApiCodec INSTANCE = new WebViewHostApiCodec();

    private WebViewHostApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return WebViewPoint.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof WebViewPoint) {
        stream.write(128);
        writeValue(stream, ((WebViewPoint) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface WebViewHostApi {

    void create(@NonNull Long instanceId);

    void loadData(
        @NonNull Long instanceId,
        @NonNull String data,
        @Nullable String mimeType,
        @Nullable String encoding);

    void loadDataWithBaseUrl(
        @NonNull Long instanceId,
        @Nullable String baseUrl,
        @NonNull String data,
        @Nullable String mimeType,
        @Nullable String encoding,
        @Nullable String historyUrl);

    void loadUrl(
        @NonNull Long instanceId, @NonNull String url, @NonNull Map<String, String> headers);

    void postUrl(@NonNull Long instanceId, @NonNull String url, @NonNull byte[] data);

    @Nullable
    String getUrl(@NonNull Long instanceId);

    @NonNull
    Boolean canGoBack(@NonNull Long instanceId);

    @NonNull
    Boolean canGoForward(@NonNull Long instanceId);

    void goBack(@NonNull Long instanceId);

    void goForward(@NonNull Long instanceId);

    void reload(@NonNull Long instanceId);

    void clearCache(@NonNull Long instanceId, @NonNull Boolean includeDiskFiles);

    void evaluateJavascript(
        @NonNull Long instanceId, @NonNull String javascriptString, @NonNull Result<String> result);

    @Nullable
    String getTitle(@NonNull Long instanceId);

    void scrollTo(@NonNull Long instanceId, @NonNull Long x, @NonNull Long y);

    void scrollBy(@NonNull Long instanceId, @NonNull Long x, @NonNull Long y);

    @NonNull
    Long getScrollX(@NonNull Long instanceId);

    @NonNull
    Long getScrollY(@NonNull Long instanceId);

    @NonNull
    WebViewPoint getScrollPosition(@NonNull Long instanceId);

    void setWebContentsDebuggingEnabled(@NonNull Boolean enabled);

    void setWebViewClient(@NonNull Long instanceId, @NonNull Long webViewClientInstanceId);

    void addJavaScriptChannel(@NonNull Long instanceId, @NonNull Long javaScriptChannelInstanceId);

    void removeJavaScriptChannel(
        @NonNull Long instanceId, @NonNull Long javaScriptChannelInstanceId);

    void setDownloadListener(@NonNull Long instanceId, @Nullable Long listenerInstanceId);

    void setWebChromeClient(@NonNull Long instanceId, @Nullable Long clientInstanceId);

    void setBackgroundColor(@NonNull Long instanceId, @NonNull Long color);

    /** The codec used by WebViewHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return WebViewHostApiCodec.INSTANCE;
    }
    /** Sets up an instance of `WebViewHostApi` to handle messages through the `binaryMessenger`. */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable WebViewHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  api.create((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.loadData", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                String dataArg = (String) args.get(1);
                String mimeTypeArg = (String) args.get(2);
                String encodingArg = (String) args.get(3);
                try {
                  api.loadData(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      dataArg,
                      mimeTypeArg,
                      encodingArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebViewHostApi.loadDataWithBaseUrl",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                String baseUrlArg = (String) args.get(1);
                String dataArg = (String) args.get(2);
                String mimeTypeArg = (String) args.get(3);
                String encodingArg = (String) args.get(4);
                String historyUrlArg = (String) args.get(5);
                try {
                  api.loadDataWithBaseUrl(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      baseUrlArg,
                      dataArg,
                      mimeTypeArg,
                      encodingArg,
                      historyUrlArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.loadUrl", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                String urlArg = (String) args.get(1);
                Map<String, String> headersArg = (Map<String, String>) args.get(2);
                try {
                  api.loadUrl(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      urlArg,
                      headersArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.postUrl", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                String urlArg = (String) args.get(1);
                byte[] dataArg = (byte[]) args.get(2);
                try {
                  api.postUrl(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), urlArg, dataArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.getUrl", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  String output =
                      api.getUrl((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.canGoBack", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  Boolean output =
                      api.canGoBack((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.canGoForward", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  Boolean output =
                      api.canGoForward((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.goBack", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  api.goBack((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.goForward", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  api.goForward((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.reload", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  api.reload((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.clearCache", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean includeDiskFilesArg = (Boolean) args.get(1);
                try {
                  api.clearCache(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      includeDiskFilesArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebViewHostApi.evaluateJavascript",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                String javascriptStringArg = (String) args.get(1);
                Result<String> resultCallback =
                    new Result<String>() {
                      public void success(String result) {
                        wrapped.add(0, result);
                        reply.reply(wrapped);
                      }

                      public void error(Throwable error) {
                        ArrayList<Object> wrappedError = wrapError(error);
                        reply.reply(wrappedError);
                      }
                    };

                api.evaluateJavascript(
                    (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                    javascriptStringArg,
                    resultCallback);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.getTitle", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  String output =
                      api.getTitle((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.scrollTo", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Number xArg = (Number) args.get(1);
                Number yArg = (Number) args.get(2);
                try {
                  api.scrollTo(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      (xArg == null) ? null : xArg.longValue(),
                      (yArg == null) ? null : yArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.scrollBy", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Number xArg = (Number) args.get(1);
                Number yArg = (Number) args.get(2);
                try {
                  api.scrollBy(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      (xArg == null) ? null : xArg.longValue(),
                      (yArg == null) ? null : yArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.getScrollX", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getScrollX((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.getScrollY", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  Long output =
                      api.getScrollY((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.getScrollPosition", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  WebViewPoint output =
                      api.getScrollPosition(
                          (instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebViewHostApi.setWebContentsDebuggingEnabled",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean enabledArg = (Boolean) args.get(0);
                try {
                  api.setWebContentsDebuggingEnabled(enabledArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewHostApi.setWebViewClient", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Number webViewClientInstanceIdArg = (Number) args.get(1);
                try {
                  api.setWebViewClient(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      (webViewClientInstanceIdArg == null)
                          ? null
                          : webViewClientInstanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebViewHostApi.addJavaScriptChannel",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Number javaScriptChannelInstanceIdArg = (Number) args.get(1);
                try {
                  api.addJavaScriptChannel(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      (javaScriptChannelInstanceIdArg == null)
                          ? null
                          : javaScriptChannelInstanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebViewHostApi.removeJavaScriptChannel",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Number javaScriptChannelInstanceIdArg = (Number) args.get(1);
                try {
                  api.removeJavaScriptChannel(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      (javaScriptChannelInstanceIdArg == null)
                          ? null
                          : javaScriptChannelInstanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebViewHostApi.setDownloadListener",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Number listenerInstanceIdArg = (Number) args.get(1);
                try {
                  api.setDownloadListener(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      (listenerInstanceIdArg == null) ? null : listenerInstanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebViewHostApi.setWebChromeClient",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Number clientInstanceIdArg = (Number) args.get(1);
                try {
                  api.setWebChromeClient(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      (clientInstanceIdArg == null) ? null : clientInstanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebViewHostApi.setBackgroundColor",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Number colorArg = (Number) args.get(1);
                try {
                  api.setBackgroundColor(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      (colorArg == null) ? null : colorArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /**
   * Flutter API for `WebView`.
   *
   * <p>This class may handle instantiating and adding Dart instances that are attached to a native
   * instance or receiving callback methods from an overridden native class.
   *
   * <p>See https://developer.android.com/reference/android/webkit/WebView.
   *
   * <p>Generated class from Pigeon that represents Flutter messages that can be called from Java.
   */
  public static class WebViewFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public WebViewFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by WebViewFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /** Create a new Dart instance and add it to the `InstanceManager`. */
    public void create(@NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.WebViewFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface WebSettingsHostApi {

    void create(@NonNull Long instanceId, @NonNull Long webViewInstanceId);

    void setDomStorageEnabled(@NonNull Long instanceId, @NonNull Boolean flag);

    void setJavaScriptCanOpenWindowsAutomatically(@NonNull Long instanceId, @NonNull Boolean flag);

    void setSupportMultipleWindows(@NonNull Long instanceId, @NonNull Boolean support);

    void setJavaScriptEnabled(@NonNull Long instanceId, @NonNull Boolean flag);

    void setUserAgentString(@NonNull Long instanceId, @Nullable String userAgentString);

    void setMediaPlaybackRequiresUserGesture(@NonNull Long instanceId, @NonNull Boolean require);

    void setSupportZoom(@NonNull Long instanceId, @NonNull Boolean support);

    void setLoadWithOverviewMode(@NonNull Long instanceId, @NonNull Boolean overview);

    void setUseWideViewPort(@NonNull Long instanceId, @NonNull Boolean use);

    void setDisplayZoomControls(@NonNull Long instanceId, @NonNull Boolean enabled);

    void setBuiltInZoomControls(@NonNull Long instanceId, @NonNull Boolean enabled);

    void setAllowFileAccess(@NonNull Long instanceId, @NonNull Boolean enabled);

    void setTextZoom(@NonNull Long instanceId, @NonNull Long textZoom);

    /** The codec used by WebSettingsHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `WebSettingsHostApi` to handle messages through the `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable WebSettingsHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebSettingsHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Number webViewInstanceIdArg = (Number) args.get(1);
                try {
                  api.create(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      (webViewInstanceIdArg == null) ? null : webViewInstanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setDomStorageEnabled",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean flagArg = (Boolean) args.get(1);
                try {
                  api.setDomStorageEnabled(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), flagArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setJavaScriptCanOpenWindowsAutomatically",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean flagArg = (Boolean) args.get(1);
                try {
                  api.setJavaScriptCanOpenWindowsAutomatically(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), flagArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setSupportMultipleWindows",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean supportArg = (Boolean) args.get(1);
                try {
                  api.setSupportMultipleWindows(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), supportArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setJavaScriptEnabled",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean flagArg = (Boolean) args.get(1);
                try {
                  api.setJavaScriptEnabled(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), flagArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setUserAgentString",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                String userAgentStringArg = (String) args.get(1);
                try {
                  api.setUserAgentString(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      userAgentStringArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setMediaPlaybackRequiresUserGesture",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean requireArg = (Boolean) args.get(1);
                try {
                  api.setMediaPlaybackRequiresUserGesture(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), requireArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setSupportZoom",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean supportArg = (Boolean) args.get(1);
                try {
                  api.setSupportZoom(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), supportArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setLoadWithOverviewMode",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean overviewArg = (Boolean) args.get(1);
                try {
                  api.setLoadWithOverviewMode(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), overviewArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setUseWideViewPort",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean useArg = (Boolean) args.get(1);
                try {
                  api.setUseWideViewPort(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), useArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setDisplayZoomControls",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean enabledArg = (Boolean) args.get(1);
                try {
                  api.setDisplayZoomControls(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), enabledArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setBuiltInZoomControls",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean enabledArg = (Boolean) args.get(1);
                try {
                  api.setBuiltInZoomControls(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), enabledArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebSettingsHostApi.setAllowFileAccess",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean enabledArg = (Boolean) args.get(1);
                try {
                  api.setAllowFileAccess(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), enabledArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebSettingsHostApi.setTextZoom", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Number textZoomArg = (Number) args.get(1);
                try {
                  api.setTextZoom(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      (textZoomArg == null) ? null : textZoomArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface JavaScriptChannelHostApi {

    void create(@NonNull Long instanceId, @NonNull String channelName);

    /** The codec used by JavaScriptChannelHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `JavaScriptChannelHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable JavaScriptChannelHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.JavaScriptChannelHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                String channelNameArg = (String) args.get(1);
                try {
                  api.create(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), channelNameArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class JavaScriptChannelFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public JavaScriptChannelFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by JavaScriptChannelFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void postMessage(
        @NonNull Long instanceIdArg, @NonNull String messageArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.JavaScriptChannelFlutterApi.postMessage",
              getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(instanceIdArg, messageArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface WebViewClientHostApi {

    void create(@NonNull Long instanceId);

    void setSynchronousReturnValueForShouldOverrideUrlLoading(
        @NonNull Long instanceId, @NonNull Boolean value);

    /** The codec used by WebViewClientHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `WebViewClientHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable WebViewClientHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebViewClientHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  api.create((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebViewClientHostApi.setSynchronousReturnValueForShouldOverrideUrlLoading",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean valueArg = (Boolean) args.get(1);
                try {
                  api.setSynchronousReturnValueForShouldOverrideUrlLoading(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), valueArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class WebViewClientFlutterApiCodec extends StandardMessageCodec {
    public static final WebViewClientFlutterApiCodec INSTANCE = new WebViewClientFlutterApiCodec();

    private WebViewClientFlutterApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return WebResourceErrorData.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 129:
          return WebResourceRequestData.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof WebResourceErrorData) {
        stream.write(128);
        writeValue(stream, ((WebResourceErrorData) value).toList());
      } else if (value instanceof WebResourceRequestData) {
        stream.write(129);
        writeValue(stream, ((WebResourceRequestData) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class WebViewClientFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public WebViewClientFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by WebViewClientFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return WebViewClientFlutterApiCodec.INSTANCE;
    }

    public void onPageStarted(
        @NonNull Long instanceIdArg,
        @NonNull Long webViewInstanceIdArg,
        @NonNull String urlArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.WebViewClientFlutterApi.onPageStarted",
              getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(instanceIdArg, webViewInstanceIdArg, urlArg)),
          channelReply -> callback.reply(null));
    }

    public void onPageFinished(
        @NonNull Long instanceIdArg,
        @NonNull Long webViewInstanceIdArg,
        @NonNull String urlArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.WebViewClientFlutterApi.onPageFinished",
              getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(instanceIdArg, webViewInstanceIdArg, urlArg)),
          channelReply -> callback.reply(null));
    }

    public void onReceivedRequestError(
        @NonNull Long instanceIdArg,
        @NonNull Long webViewInstanceIdArg,
        @NonNull WebResourceRequestData requestArg,
        @NonNull WebResourceErrorData errorArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.WebViewClientFlutterApi.onReceivedRequestError",
              getCodec());
      channel.send(
          new ArrayList<Object>(
              Arrays.asList(instanceIdArg, webViewInstanceIdArg, requestArg, errorArg)),
          channelReply -> callback.reply(null));
    }

    public void onReceivedError(
        @NonNull Long instanceIdArg,
        @NonNull Long webViewInstanceIdArg,
        @NonNull Long errorCodeArg,
        @NonNull String descriptionArg,
        @NonNull String failingUrlArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.WebViewClientFlutterApi.onReceivedError",
              getCodec());
      channel.send(
          new ArrayList<Object>(
              Arrays.asList(
                  instanceIdArg,
                  webViewInstanceIdArg,
                  errorCodeArg,
                  descriptionArg,
                  failingUrlArg)),
          channelReply -> callback.reply(null));
    }

    public void requestLoading(
        @NonNull Long instanceIdArg,
        @NonNull Long webViewInstanceIdArg,
        @NonNull WebResourceRequestData requestArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.WebViewClientFlutterApi.requestLoading",
              getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(instanceIdArg, webViewInstanceIdArg, requestArg)),
          channelReply -> callback.reply(null));
    }

    public void urlLoading(
        @NonNull Long instanceIdArg,
        @NonNull Long webViewInstanceIdArg,
        @NonNull String urlArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.WebViewClientFlutterApi.urlLoading", getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(instanceIdArg, webViewInstanceIdArg, urlArg)),
          channelReply -> callback.reply(null));
    }

    public void doUpdateVisitedHistory(
        @NonNull Long instanceIdArg,
        @NonNull Long webViewInstanceIdArg,
        @NonNull String urlArg,
        @NonNull Boolean isReloadArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.WebViewClientFlutterApi.doUpdateVisitedHistory",
              getCodec());
      channel.send(
          new ArrayList<Object>(
              Arrays.asList(instanceIdArg, webViewInstanceIdArg, urlArg, isReloadArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface DownloadListenerHostApi {

    void create(@NonNull Long instanceId);

    /** The codec used by DownloadListenerHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `DownloadListenerHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable DownloadListenerHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.DownloadListenerHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  api.create((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class DownloadListenerFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public DownloadListenerFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by DownloadListenerFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void onDownloadStart(
        @NonNull Long instanceIdArg,
        @NonNull String urlArg,
        @NonNull String userAgentArg,
        @NonNull String contentDispositionArg,
        @NonNull String mimetypeArg,
        @NonNull Long contentLengthArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.DownloadListenerFlutterApi.onDownloadStart",
              getCodec());
      channel.send(
          new ArrayList<Object>(
              Arrays.asList(
                  instanceIdArg,
                  urlArg,
                  userAgentArg,
                  contentDispositionArg,
                  mimetypeArg,
                  contentLengthArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface WebChromeClientHostApi {

    void create(@NonNull Long instanceId);

    void setSynchronousReturnValueForOnShowFileChooser(
        @NonNull Long instanceId, @NonNull Boolean value);

    /** The codec used by WebChromeClientHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `WebChromeClientHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable WebChromeClientHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebChromeClientHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  api.create((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.WebChromeClientHostApi.setSynchronousReturnValueForOnShowFileChooser",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                Boolean valueArg = (Boolean) args.get(1);
                try {
                  api.setSynchronousReturnValueForOnShowFileChooser(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), valueArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface FlutterAssetManagerHostApi {

    @NonNull
    List<String> list(@NonNull String path);

    @NonNull
    String getAssetFilePathByName(@NonNull String name);

    /** The codec used by FlutterAssetManagerHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `FlutterAssetManagerHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable FlutterAssetManagerHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.FlutterAssetManagerHostApi.list", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String pathArg = (String) args.get(0);
                try {
                  List<String> output = api.list(pathArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.FlutterAssetManagerHostApi.getAssetFilePathByName",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                String nameArg = (String) args.get(0);
                try {
                  String output = api.getAssetFilePathByName(nameArg);
                  wrapped.add(0, output);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class WebChromeClientFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public WebChromeClientFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by WebChromeClientFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }

    public void onProgressChanged(
        @NonNull Long instanceIdArg,
        @NonNull Long webViewInstanceIdArg,
        @NonNull Long progressArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.WebChromeClientFlutterApi.onProgressChanged",
              getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(instanceIdArg, webViewInstanceIdArg, progressArg)),
          channelReply -> callback.reply(null));
    }

    public void onShowFileChooser(
        @NonNull Long instanceIdArg,
        @NonNull Long webViewInstanceIdArg,
        @NonNull Long paramsInstanceIdArg,
        @NonNull Reply<List<String>> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.WebChromeClientFlutterApi.onShowFileChooser",
              getCodec());
      channel.send(
          new ArrayList<Object>(
              Arrays.asList(instanceIdArg, webViewInstanceIdArg, paramsInstanceIdArg)),
          channelReply -> {
            @SuppressWarnings("ConstantConditions")
            List<String> output = (List<String>) channelReply;
            callback.reply(output);
          });
    }
    /** Callback to Dart function `WebChromeClient.onPermissionRequest`. */
    public void onPermissionRequest(
        @NonNull Long instanceIdArg,
        @NonNull Long requestInstanceIdArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.WebChromeClientFlutterApi.onPermissionRequest",
              getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(instanceIdArg, requestInstanceIdArg)),
          channelReply -> callback.reply(null));
    }
    /** Callback to Dart function `WebChromeClient.onGeolocationPermissionsShowPrompt`. */
    public void onGeolocationPermissionsShowPrompt(
        @NonNull Long instanceIdArg,
        @NonNull Long paramsInstanceIdArg,
        @NonNull String originArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.WebChromeClientFlutterApi.onGeolocationPermissionsShowPrompt",
              getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(instanceIdArg, paramsInstanceIdArg, originArg)),
          channelReply -> callback.reply(null));
    }
    /** Callback to Dart function `WebChromeClient.onGeolocationPermissionsHidePrompt`. */
    public void onGeolocationPermissionsHidePrompt(
        @NonNull Long identifierArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.WebChromeClientFlutterApi.onGeolocationPermissionsHidePrompt",
              getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(identifierArg)),
          channelReply -> callback.reply(null));
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface WebStorageHostApi {

    void create(@NonNull Long instanceId);

    void deleteAllData(@NonNull Long instanceId);

    /** The codec used by WebStorageHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `WebStorageHostApi` to handle messages through the `binaryMessenger`.
     */
    static void setup(@NonNull BinaryMessenger binaryMessenger, @Nullable WebStorageHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebStorageHostApi.create", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  api.create((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.WebStorageHostApi.deleteAllData", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  api.deleteAllData((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class FileChooserParamsFlutterApiCodec extends StandardMessageCodec {
    public static final FileChooserParamsFlutterApiCodec INSTANCE =
        new FileChooserParamsFlutterApiCodec();

    private FileChooserParamsFlutterApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return FileChooserModeEnumData.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof FileChooserModeEnumData) {
        stream.write(128);
        writeValue(stream, ((FileChooserModeEnumData) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /**
   * Handles callbacks methods for the native Java FileChooserParams class.
   *
   * <p>See
   * https://developer.android.com/reference/android/webkit/WebChromeClient.FileChooserParams.
   *
   * <p>Generated class from Pigeon that represents Flutter messages that can be called from Java.
   */
  public static class FileChooserParamsFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public FileChooserParamsFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by FileChooserParamsFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return FileChooserParamsFlutterApiCodec.INSTANCE;
    }

    public void create(
        @NonNull Long instanceIdArg,
        @NonNull Boolean isCaptureEnabledArg,
        @NonNull List<String> acceptTypesArg,
        @NonNull FileChooserModeEnumData modeArg,
        @Nullable String filenameHintArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.FileChooserParamsFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(
              Arrays.asList(
                  instanceIdArg, isCaptureEnabledArg, acceptTypesArg, modeArg, filenameHintArg)),
          channelReply -> callback.reply(null));
    }
  }
  /**
   * Host API for `PermissionRequest`.
   *
   * <p>This class may handle instantiating and adding native object instances that are attached to
   * a Dart instance or handle method calls on the associated native class or an instance of the
   * class.
   *
   * <p>See https://developer.android.com/reference/android/webkit/PermissionRequest.
   *
   * <p>Generated interface from Pigeon that represents a handler of messages from Flutter.
   */
  public interface PermissionRequestHostApi {
    /** Handles Dart method `PermissionRequest.grant`. */
    void grant(@NonNull Long instanceId, @NonNull List<String> resources);
    /** Handles Dart method `PermissionRequest.deny`. */
    void deny(@NonNull Long instanceId);

    /** The codec used by PermissionRequestHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `PermissionRequestHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger, @Nullable PermissionRequestHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.PermissionRequestHostApi.grant", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                List<String> resourcesArg = (List<String>) args.get(1);
                try {
                  api.grant(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(), resourcesArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.PermissionRequestHostApi.deny", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                try {
                  api.deny((instanceIdArg == null) ? null : instanceIdArg.longValue());
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /**
   * Flutter API for `PermissionRequest`.
   *
   * <p>This class may handle instantiating and adding Dart instances that are attached to a native
   * instance or receiving callback methods from an overridden native class.
   *
   * <p>See https://developer.android.com/reference/android/webkit/PermissionRequest.
   *
   * <p>Generated class from Pigeon that represents Flutter messages that can be called from Java.
   */
  public static class PermissionRequestFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public PermissionRequestFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by PermissionRequestFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /** Create a new Dart instance and add it to the `InstanceManager`. */
    public void create(
        @NonNull Long instanceIdArg,
        @NonNull List<String> resourcesArg,
        @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, "dev.flutter.pigeon.PermissionRequestFlutterApi.create", getCodec());
      channel.send(
          new ArrayList<Object>(Arrays.asList(instanceIdArg, resourcesArg)),
          channelReply -> callback.reply(null));
    }
  }
  /**
   * Host API for `GeolocationPermissionsCallback`.
   *
   * <p>This class may handle instantiating and adding native object instances that are attached to
   * a Dart instance or handle method calls on the associated native class or an instance of the
   * class.
   *
   * <p>See https://developer.android.com/reference/android/webkit/GeolocationPermissions.Callback.
   *
   * <p>Generated interface from Pigeon that represents a handler of messages from Flutter.
   */
  public interface GeolocationPermissionsCallbackHostApi {
    /** Handles Dart method `GeolocationPermissionsCallback.invoke`. */
    void invoke(
        @NonNull Long instanceId,
        @NonNull String origin,
        @NonNull Boolean allow,
        @NonNull Boolean retain);

    /** The codec used by GeolocationPermissionsCallbackHostApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /**
     * Sets up an instance of `GeolocationPermissionsCallbackHostApi` to handle messages through the
     * `binaryMessenger`.
     */
    static void setup(
        @NonNull BinaryMessenger binaryMessenger,
        @Nullable GeolocationPermissionsCallbackHostApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger,
                "dev.flutter.pigeon.GeolocationPermissionsCallbackHostApi.invoke",
                getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Number instanceIdArg = (Number) args.get(0);
                String originArg = (String) args.get(1);
                Boolean allowArg = (Boolean) args.get(2);
                Boolean retainArg = (Boolean) args.get(3);
                try {
                  api.invoke(
                      (instanceIdArg == null) ? null : instanceIdArg.longValue(),
                      originArg,
                      allowArg,
                      retainArg);
                  wrapped.add(0, null);
                } catch (Throwable exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /**
   * Flutter API for `GeolocationPermissionsCallback`.
   *
   * <p>This class may handle instantiating and adding Dart instances that are attached to a native
   * instance or receiving callback methods from an overridden native class.
   *
   * <p>See https://developer.android.com/reference/android/webkit/GeolocationPermissions.Callback.
   *
   * <p>Generated class from Pigeon that represents Flutter messages that can be called from Java.
   */
  public static class GeolocationPermissionsCallbackFlutterApi {
    private final @NonNull BinaryMessenger binaryMessenger;

    public GeolocationPermissionsCallbackFlutterApi(@NonNull BinaryMessenger argBinaryMessenger) {
      this.binaryMessenger = argBinaryMessenger;
    }

    /** Public interface for sending reply. */
    @SuppressWarnings("UnknownNullness")
    public interface Reply<T> {
      void reply(T reply);
    }
    /** The codec used by GeolocationPermissionsCallbackFlutterApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return new StandardMessageCodec();
    }
    /** Create a new Dart instance and add it to the `InstanceManager`. */
    public void create(@NonNull Long instanceIdArg, @NonNull Reply<Void> callback) {
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger,
              "dev.flutter.pigeon.GeolocationPermissionsCallbackFlutterApi.create",
              getCodec());
      channel.send(
          new ArrayList<Object>(Collections.singletonList(instanceIdArg)),
          channelReply -> callback.reply(null));
    }
  }
}
