Provides a [Dart Build System](https://github.com/dart-lang/build) builder for generating clients from an [OpenAPI specifications](https://swagger.io/specification/).

The builder generates code if it find files with an `.openapi.json` or `.openapi.yaml` extension in the lib directory.

# Setup

The generated code makes use of various third party packages. Please add the following dependencies to your `pubspec.yaml`.
```yaml
dependencies:
  built_collection: ^5.0.0
  built_value: ^8.0.0
  collection: ^1.0.0
  dynamite_runtime: ^0.0.1
  meta: ^1.0.0
  universal_io: ^2.0.0
  uri: ^1.0.0
dev_dependencies:
  build_runner: ^2.4.0
  built_value_generator: ^8.8.1
```

# Generating

To generate code you need to invoke the `build_runner` with the following command:
```sh
dart run build_runner build
``` 
The builder will look for any files ending with either `.openapi.json` or `.openapi.yaml` and place the generated code next to the specifications in a file ending with `.openapi.dart`.
For a full example checkout the [example package](https://github.com/nextcloud/neon/tree/main/packages/dynamite/dynamite_petstore_example) using the OpenAPI petstore specification.


# Build configuration

You can configure code generation by setting values in the `build.yaml`.

```yaml
targets:
  $default:
    builders:
      dynamite:
        options:
          # Options configure how source code is generated.
          #
          # The following are sensible default values that ignores the schemas for the coverage.
          pageWidth: 120
          analyzer_ignores:
            - camel_case_types
            - discarded_futures
            - public_member_api_docs
            - unreachable_switch_case
          coverage_ignores:
            - 'const .*\._\(\);'
            - 'factory .*\.fromJson\(Map<String, dynamic> json\) => jsonSerializers\.deserializeWith\(serializer, json\)!;'
            - 'Map<String, dynamic> toJson\(\) => jsonSerializers\.serializeWith\(serializer, this\)! as Map<String, dynamic>;'
            - 'static BuiltSet<.*> get values => _\$.*Values;'

```

# Versioning

Dynamite does not yet support the full OpenAPI specification. It currently supports the most common subset of the functionality of the versions 3.0 and 3.1.
Feel free to open an issue if you rely on any functionality not yet supported.
The version number of this package will be updated in regards to the generated code. For example if there is a breaking change in the generated code the major version of this package will be updated.

# Licensing

While the generator `dynamite` is licensed under the AGPL-3.0 this does not apply to the code generated by it which is not covered by any license.
The helper package `dynamite_runtime` is licensed under an BSD-3 clause license, allowing you to use dynamite in proprietary code bases.
Any changes to dynamite itself are still subject to the AGPL-3.0.
