# Documentation

## Terminology
There can be a lot of confusion what an `app` is. It can mean a server app conventionally written in PHP, the app implementation of one or a mobile app built with Neon.
We try to use the following naming:
- **App** as the resulting user facing app that enables one or more clients
- **Client** for the implementation of a server PHP app
- **API-Client** as the Dart client generated from the OpenAPI specifications
- **Server app** as the app running on the server conventionally built with PHP
- **Neon project** is this entire mono repository containing all the code
- **Neon framework** the Flutter Nextcloud app framework itself

## Code of Conduct 
Please read the [Code of Conduct](../CODE_OF_CONDUCT.md). This document offers some guidance to ensure Nextcloud and Neon participants can cooperate effectively in a positive and inspiring atmosphere, and to explain how together we can strengthen and support each other.

## Contributing
Please review the [guidelines for contributing](../CONTRIBUTING.md) to this repository to help you get started with our workflows and tools.

## Architecture overview 
Check out our little [overview](architecture.md) of how the Neon project is built to help you get started.

## [Login user flow](login.md)

## [Neon workflows](workflows.md)
We have documented various workflows for working with the mono repo structure like adding a new package.

## [Dependencies](dependencies.md)
How we pin and upgrade our dependencies
