export type RippleProps = {
    ripple?: boolean;
    surface?: boolean;
    unbounded?: boolean;
    disabled?: boolean;
    color?: 'primary' | 'secondary';
    /** Whether the ripple is active. Leave null to determine automatically. */
    active?: boolean;
    rippleElement?: HTMLElement;
    eventTarget?: HTMLElement;
    activeTarget?: HTMLElement;
    addClass?: (className: string) => void;
    removeClass?: (className: string) => void;
    addStyle?: (name: string, value: string) => void;
    initPromise?: Promise<void>;
};
export default function Ripple(node: HTMLElement, { ripple, surface, unbounded, disabled, color, active, rippleElement, eventTarget, activeTarget, addClass, removeClass, addStyle, initPromise, }?: RippleProps): {
    update(props: RippleProps): void;
    destroy(): void;
};
