export function dispatch(element, eventType, detail, eventInit = { bubbles: true }, 
/** This is an internal thing used by SMUI to duplicate some SMUI events as MDC events. */
duplicateEventForMDC = false) {
    if (typeof Event === 'undefined') {
        throw new Error('Event not defined.');
    }
    if (!element) {
        throw new Error('Tried to dipatch event without element.');
    }
    const event = new CustomEvent(eventType, Object.assign(Object.assign({}, eventInit), { detail }));
    element === null || element === void 0 ? void 0 : element.dispatchEvent(event);
    if (duplicateEventForMDC && eventType.startsWith('SMUI')) {
        const duplicateEvent = new CustomEvent(eventType.replace(/^SMUI/g, () => 'MDC'), Object.assign(Object.assign({}, eventInit), { detail }));
        element === null || element === void 0 ? void 0 : element.dispatchEvent(duplicateEvent);
        if (duplicateEvent.defaultPrevented) {
            event.preventDefault();
        }
    }
    return event;
}
//# sourceMappingURL=dispatch.js.map