# Contributing

Code, documentation, or resources such as icons can be contributed via [pull request](https://github.com/tmo1/sms-ie/pulls), but for any substantial changes or additions to the existing codebase, please first [open an issue](https://github.com/tmo1/sms-ie/issues) to discuss the proposed changes or additions. All contributed code should be licensed under the [GNU GPLv3](https://www.gnu.org/licenses/gpl-3.0.en.html) or later.

SMS Import / Export is integrated with [Weblate](https://weblate.org). Translations into new languages, as well as corrections, updates, and improvements to existing translations, can be submitted via [SMS Import / Export @ Hosted Weblate](https://hosted.weblate.org/engage/sms-import-export/), or by ordinary [pull requests against the SMS Import / Export repository](https://github.com/tmo1/sms-ie/pulls).

## Contributors

The primary author of SMS Import / Export is [Thomas More](https://github.com/tmo1). [Andrew Gunnerson (chenxiaolong)](https://github.com/chenxiaolong) has contributed major architectural and user experience improvements. The following individuals have contributed to the app:

### Code

 - [sxwxs](https://github.com/sxwxs): call log export support ([PR #10](https://github.com/tmo1/sms-ie/pull/10))
 - [Bindu (vbh)](https://github.com/vbh): call log import support ([PR #21](https://github.com/tmo1/sms-ie/pull/21))
 - [Jan Hustak (codingjourney)](https://github.com/codingjourney): bug fix ([PR #30](https://github.com/tmo1/sms-ie/pull/30))
 - [Dani Wang (EpicOrange)](https://github.com/EpicOrange): bug fix ([PR #39](https://github.com/tmo1/sms-ie/pull/39))
 - [Andrew Gunnerson (chenxiaolong)](https://github.com/chenxiaolong): support for running scheduled exports as a foreground service ([Issue #129](https://github.com/tmo1/sms-ie/issues/129) / [PR #131](https://github.com/tmo1/sms-ie/pull/131)); overhaul of the notification framework (PRs [#187](https://github.com/tmo1/sms-ie/pull/187), [#281](https://github.com/tmo1/sms-ie/pull/281), and [#289](https://github.com/tmo1/sms-ie/pull/289)); redesign to run all manual operations in worker processes ([PR #268](https://github.com/tmo1/sms-ie/pull/268)); add full support for edge-to-edge ([PR #279](https://github.com/tmo1/sms-ie/pull/279)); save logcat of the most recent operation to a user-accessible file ([PR #278](https://github.com/tmo1/sms-ie/pull/278)); bug fix ([PR #282](https://github.com/tmo1/sms-ie/pull/282))
 - [Biswapriyo Nath (Biswa96)](https://github.com/Biswa96): addition of [`ScrollView`](https://developer.android.com/reference/android/widget/ScrollView) to "About" screen ([PR #133](https://github.com/tmo1/sms-ie/pull/133))
 - [Andrew (andr5w)](https://github.com/andr5w): bug fix ([PR #168](https://github.com/tmo1/sms-ie/pull/168))
 - [farfromrefuge](https://github.com/farfromrefug): bug fix ([PR #231](https://github.com/tmo1/sms-ie/pull/231))
 - [Askorbinovaya Kislota](https://github.com/askorbinovaya-kislota): bug fix ([PR #236](https://github.com/tmo1/sms-ie/pull/236))
 - [MarcMush](https://github.com/MarcMush): bug fix ([PR #264](https://github.com/tmo1/sms-ie/pull/264))

### Translations (Strings)

 - [nautilusx](https://github.com/nautilusx): German
 - [baitmooth](https://github.com/baitmooth): additions to German
 - [AntoninDelFabbro](https://github.com/AntoninDelFabbro): French (and assistance with the German one)
 - [Philippe (Philippe213)](https://hosted.weblate.org/user/philippe213/): update to French
 - [mavosaure](https://github.com/mavosaure): update to French
 - [Allan Nordhøy (comradekingu)](https://github.com/comradekingu): Norwegian Bokmål
 - [poipoipoipoipoipoipoipoipoi](https://github.com/poipoipoipoipoipoipoipoipoi): Simplified Chinese
 - [Eric (hamburger1024)](https://hosted.weblate.org/user/hamburger1024/): updates to Simplified Chinese
 - [yangyangdaji](https://github.com/yangyangdaji): updates to Simplified Chinese
 - [Merlignux](https://github.com/Merlignux): Portuguese
 - [python israel (nhman-python)](https://github.com/nhman-python): Hebrew
 - [elid34 (elid)](https://github.com/elid34): update to Hebrew
 - [Артём (Artem13327)](https://hosted.weblate.org/user/Artem13327/): Russian
 - Axus Wizix: updates to Russian
 - [pjammo](https://github.com/pjammo): Italian
 - [Translator-3000](https://hosted.weblate.org/user/Translator-3000/): update to Italian
 - [jacek (TX5400)](https://hosted.weblate.org/user/TX5400/): Polish
 - [Eryk Michalak (gnu-ewm)](https://github.com/gnu-ewm): updates to Polish
 - [gallegonovato](https://github.com/gallegonovato): Spanish
 - [Bai (Baturax)](https://github.com/Baturax): Turkish
 - [Oğuz Ersen (ersen0 / oerson)](https://github.com/oersen): updates to Turkish
 - [Raman](https://hosted.weblate.org/user/deleted-56119/): Malayalam
 - Surena: Persian
 - [ngocanhtve](https://github.com/ngocanhtve): Vietnamese
 - [TamilNeram (தமிழ் நேரம்)]( https://github.com/TamilNeram): Tamil
 - [catsnote (cat)](https://github.com/catsnote): Danish
 - [Ettore Atalan (Atalanttore)](https://github.com/Atalanttore): update to German
 - [Vladi69](https://github.com/Vladi69): update to Italian
 - [Unknownman820](https://github.com/Unknownman820): Chinese (Traditional Han script)
 - [Lendary Sayajin (Bardock)](https://github.com/Bardock88): Portuguese (Brazil)
 - [rehork](https://github.com/rehork): update to Polish
 
### Translations (Fastlane)

 - [Unknownman820](https://github.com/Unknownman820): Chinese (Traditional Han Script)
 - [rehork](https://github.com/rehork): Polish

### Other

 - [Onno van den Dungen (Donnno)](https://github.com/Donnnno): application icon ([Issue #20](https://github.com/tmo1/sms-ie/issues/20) / [PR #22](https://github.com/tmo1/sms-ie/pull/22))
 - [Biswapriyo Nath (Biswa96)](https://github.com/Biswa96): monochrome icon ([issue #114](https://github.com/tmo1/sms-ie/issues/114) / [PR #132](https://github.com/tmo1/sms-ie/pull/132))
 - [Biswapriyo Nath (Biswa96)](https://github.com/Biswa96): [GitHub workflow to automatically build and upload APKs containing the latest committed code](.github/workflows/build.yml) ([PR #99](https://github.com/tmo1/sms-ie/pull/99))
 - [wittmane](https://github.com/wittmane), [dshepsis](https://github.com/dshepsis), and [sshaikh](https://github.com/sshaikh): figuring out broken `Subscription ID` handling on Android 14 ([Issue #128](https://github.com/tmo1/sms-ie/issues/128))
 - [Artem13327](https://github.com/Artem13327): [Update to automatic build and upload Github workflow](https://github.com/tmo1/sms-ie/pull/158)
 - [sta-c0000](https://github.com/sta-c0000): [Message browser tool](https://github.com/tmo1/sms-ie/pull/208)
 - [fanto666](https://github.com/fanto666)]: [Nokia Suite CSV conversion tool](https://github.com/tmo1/sms-ie/pull/240)
