# Tabletop Tools

[![Build App](https://github.com/mueller-ma/TabletopTools/actions/workflows/build.yml/badge.svg)](https://github.com/mueller-ma/TabletopTools/actions/workflows/build.yml)
[![CodeFactor](https://www.codefactor.io/repository/github/mueller-ma/tabletoptools/badge)](https://www.codefactor.io/repository/github/mueller-ma/tabletoptools)
[![Crowdin](https://badges.crowdin.net/tabletop-tools/localized.svg)](https://crowdin.com/project/tabletop-tools)

This Android app provides a few handy tools for tabletop games:
* Dice (D3, D4, D6, D8, D10, D12, D20, D100)
* [ROT13](https://en.wikipedia.org/wiki/ROT13)
* Number converter: Decimal <=> Binary <=> Hexadecimal
* Timer
* Buzzers for 1 - 4 players
* List that can be randomized

[<img alt="Get it on F-Droid" height="80" src="https://raw.githubusercontent.com/mueller-ma/android-common/main/assets/get-it-on-fdroid.png"/>](https://f-droid.org/de/packages/com.github.muellerma.tabletoptools/)[<img alt="Download from GitHub" height="80" src="https://raw.githubusercontent.com/mueller-ma/android-common/main/assets/direct-apk-download.png"/>](https://github.com/mueller-ma/TabletopTools/releases)

<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" alt="Screenshot" width=200px> <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" alt="Screenshot" width=200px> <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" alt="Screenshot" width=200px> <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" alt="Screenshot" width=200px>

## Translations

App strings and the app store description can be translated via Crowdin: https://crowdin.com/project/tabletop-tools
For the automatic rotation detection in ROT13 you need to manually copy [this file](https://github.com/mueller-ma/TabletopTools/blob/main/app/src/main/res/values/common_words.xml) and commit it.
Crowdin doesn't handle this string array well.

To request a new language, please [poke me on Crowdin](https://crowdin.com/profile/mueller-ma) or open an issue here on GitHub. 

## Credits

* Feature graphic by https://unsplash.com/@accrualbowtie
* Some icons by Google and https://materialdesignicons.com/
* Sound for the timer by https://soundbible.com/
* Sound for buzzer by https://mixkit.co
