// Autogenerated from Pigeon (v25.3.2), do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")


import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMethodCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer
private object NativeApiPigeonUtils {

  fun wrapResult(result: Any?): List<Any?> {
    return listOf(result)
  }

  fun wrapError(exception: Throwable): List<Any?> {
    return if (exception is FlutterError) {
      listOf(
        exception.code,
        exception.message,
        exception.details
      )
    } else {
      listOf(
        exception.javaClass.simpleName,
        exception.toString(),
        "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception)
      )
    }
  }
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class FlutterError (
  val code: String,
  override val message: String? = null,
  val details: Any? = null
) : Throwable()

enum class ToastDuration(val raw: Int) {
  SHORT(0),
  LONG(1);

  companion object {
    fun ofRaw(raw: Int): ToastDuration? {
      return values().firstOrNull { it.raw == raw }
    }
  }
}
private open class NativeApiPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as Long?)?.let {
          ToastDuration.ofRaw(it.toInt())
        }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }
  override fun writeValue(stream: ByteArrayOutputStream, value: Any?)   {
    when (value) {
      is ToastDuration -> {
        stream.write(129)
        writeValue(stream, value.raw)
      }
      else -> super.writeValue(stream, value)
    }
  }
}


/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface NativeApi {
  /**
   *
   * Starts the floating volume service.
   * This method starts the android service that manages the floating volume widget.
   *
   */
  fun startService(callback: (Result<Unit>) -> Unit)
  /**
   *
   * Stops the floating volume service.
   * This method stops the android service that manages the floating volume widget.
   *
   */
  fun stopService(callback: (Result<Unit>) -> Unit)
  /**
   *
   * Hides the floating volume widget.
   * This method hides the floating volume widget, but does not stop the service.
   *
   */
  fun hideFloatingVolume(callback: (Result<Unit>) -> Unit)
  /**
   *
   * Shows the floating volume widget.
   * This method shows the floating volume widget, if it is hidden.
   *
   */
  fun showFloatingVolume(callback: (Result<Unit>) -> Unit)
  /**
   *
   * Changes the maximum volume level.
   *
   */
  fun setMaxVolume(maxVolume: Long, callback: (Result<Unit>) -> Unit)
  /**
   *
   * Changes the minimum volume level.
   *
   */
  fun setMinVolume(minVolume: Long, callback: (Result<Unit>) -> Unit)
  /**
   *
   * Show a toast
   *
   */
  fun showToast(message: String, duration: ToastDuration, callback: (Result<Unit>) -> Unit)

  companion object {
    /** The codec used by NativeApi. */
    val codec: MessageCodec<Any?> by lazy {
      NativeApiPigeonCodec()
    }
    /** Sets up an instance of `NativeApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: NativeApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.floating_volume.NativeApi.startService$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.startService{ result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(NativeApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(NativeApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.floating_volume.NativeApi.stopService$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.stopService{ result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(NativeApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(NativeApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.floating_volume.NativeApi.hideFloatingVolume$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.hideFloatingVolume{ result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(NativeApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(NativeApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.floating_volume.NativeApi.showFloatingVolume$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { _, reply ->
            api.showFloatingVolume{ result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(NativeApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(NativeApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.floating_volume.NativeApi.setMaxVolume$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val maxVolumeArg = args[0] as Long
            api.setMaxVolume(maxVolumeArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(NativeApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(NativeApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.floating_volume.NativeApi.setMinVolume$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val minVolumeArg = args[0] as Long
            api.setMinVolume(minVolumeArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(NativeApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(NativeApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.floating_volume.NativeApi.showToast$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val messageArg = args[0] as String
            val durationArg = args[1] as ToastDuration
            api.showToast(messageArg, durationArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(NativeApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(NativeApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
