// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Autogenerated from Pigeon, do not edit directly.
// See also: https://pub.dev/packages/pigeon

#include "core_tests.gen.h"

struct _CoreTestsPigeonTestUnusedClass {
  GObject parent_instance;

  FlValue* a_field;
};

G_DEFINE_TYPE(CoreTestsPigeonTestUnusedClass,
              core_tests_pigeon_test_unused_class, G_TYPE_OBJECT)

static void core_tests_pigeon_test_unused_class_dispose(GObject* object) {
  CoreTestsPigeonTestUnusedClass* self =
      CORE_TESTS_PIGEON_TEST_UNUSED_CLASS(object);
  g_clear_pointer(&self->a_field, fl_value_unref);
  G_OBJECT_CLASS(core_tests_pigeon_test_unused_class_parent_class)
      ->dispose(object);
}

static void core_tests_pigeon_test_unused_class_init(
    CoreTestsPigeonTestUnusedClass* self) {}

static void core_tests_pigeon_test_unused_class_class_init(
    CoreTestsPigeonTestUnusedClassClass* klass) {
  G_OBJECT_CLASS(klass)->dispose = core_tests_pigeon_test_unused_class_dispose;
}

CoreTestsPigeonTestUnusedClass* core_tests_pigeon_test_unused_class_new(
    FlValue* a_field) {
  CoreTestsPigeonTestUnusedClass* self = CORE_TESTS_PIGEON_TEST_UNUSED_CLASS(
      g_object_new(core_tests_pigeon_test_unused_class_get_type(), nullptr));
  if (a_field != nullptr) {
    self->a_field = fl_value_ref(a_field);
  } else {
    self->a_field = nullptr;
  }
  return self;
}

FlValue* core_tests_pigeon_test_unused_class_get_a_field(
    CoreTestsPigeonTestUnusedClass* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_UNUSED_CLASS(self), nullptr);
  return self->a_field;
}

static FlValue* core_tests_pigeon_test_unused_class_to_list(
    CoreTestsPigeonTestUnusedClass* self) {
  FlValue* values = fl_value_new_list();
  fl_value_append_take(values, self->a_field != nullptr
                                   ? fl_value_ref(self->a_field)
                                   : fl_value_new_null());
  return values;
}

static CoreTestsPigeonTestUnusedClass*
core_tests_pigeon_test_unused_class_new_from_list(FlValue* values) {
  FlValue* value0 = fl_value_get_list_value(values, 0);
  FlValue* a_field = nullptr;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_field = value0;
  }
  return core_tests_pigeon_test_unused_class_new(a_field);
}

struct _CoreTestsPigeonTestAllTypes {
  GObject parent_instance;

  gboolean a_bool;
  int64_t an_int;
  int64_t an_int64;
  double a_double;
  uint8_t* a_byte_array;
  size_t a_byte_array_length;
  int32_t* a4_byte_array;
  size_t a4_byte_array_length;
  int64_t* a8_byte_array;
  size_t a8_byte_array_length;
  double* a_float_array;
  size_t a_float_array_length;
  CoreTestsPigeonTestAnEnum an_enum;
  CoreTestsPigeonTestAnotherEnum another_enum;
  gchar* a_string;
  FlValue* an_object;
  FlValue* list;
  FlValue* string_list;
  FlValue* int_list;
  FlValue* double_list;
  FlValue* bool_list;
  FlValue* enum_list;
  FlValue* object_list;
  FlValue* list_list;
  FlValue* map_list;
  FlValue* map;
  FlValue* string_map;
  FlValue* int_map;
  FlValue* enum_map;
  FlValue* object_map;
  FlValue* list_map;
  FlValue* map_map;
};

G_DEFINE_TYPE(CoreTestsPigeonTestAllTypes, core_tests_pigeon_test_all_types,
              G_TYPE_OBJECT)

static void core_tests_pigeon_test_all_types_dispose(GObject* object) {
  CoreTestsPigeonTestAllTypes* self = CORE_TESTS_PIGEON_TEST_ALL_TYPES(object);
  g_clear_pointer(&self->a_string, g_free);
  g_clear_pointer(&self->an_object, fl_value_unref);
  g_clear_pointer(&self->list, fl_value_unref);
  g_clear_pointer(&self->string_list, fl_value_unref);
  g_clear_pointer(&self->int_list, fl_value_unref);
  g_clear_pointer(&self->double_list, fl_value_unref);
  g_clear_pointer(&self->bool_list, fl_value_unref);
  g_clear_pointer(&self->enum_list, fl_value_unref);
  g_clear_pointer(&self->object_list, fl_value_unref);
  g_clear_pointer(&self->list_list, fl_value_unref);
  g_clear_pointer(&self->map_list, fl_value_unref);
  g_clear_pointer(&self->map, fl_value_unref);
  g_clear_pointer(&self->string_map, fl_value_unref);
  g_clear_pointer(&self->int_map, fl_value_unref);
  g_clear_pointer(&self->enum_map, fl_value_unref);
  g_clear_pointer(&self->object_map, fl_value_unref);
  g_clear_pointer(&self->list_map, fl_value_unref);
  g_clear_pointer(&self->map_map, fl_value_unref);
  G_OBJECT_CLASS(core_tests_pigeon_test_all_types_parent_class)
      ->dispose(object);
}

static void core_tests_pigeon_test_all_types_init(
    CoreTestsPigeonTestAllTypes* self) {}

static void core_tests_pigeon_test_all_types_class_init(
    CoreTestsPigeonTestAllTypesClass* klass) {
  G_OBJECT_CLASS(klass)->dispose = core_tests_pigeon_test_all_types_dispose;
}

CoreTestsPigeonTestAllTypes* core_tests_pigeon_test_all_types_new(
    gboolean a_bool, int64_t an_int, int64_t an_int64, double a_double,
    const uint8_t* a_byte_array, size_t a_byte_array_length,
    const int32_t* a4_byte_array, size_t a4_byte_array_length,
    const int64_t* a8_byte_array, size_t a8_byte_array_length,
    const double* a_float_array, size_t a_float_array_length,
    CoreTestsPigeonTestAnEnum an_enum,
    CoreTestsPigeonTestAnotherEnum another_enum, const gchar* a_string,
    FlValue* an_object, FlValue* list, FlValue* string_list, FlValue* int_list,
    FlValue* double_list, FlValue* bool_list, FlValue* enum_list,
    FlValue* object_list, FlValue* list_list, FlValue* map_list, FlValue* map,
    FlValue* string_map, FlValue* int_map, FlValue* enum_map,
    FlValue* object_map, FlValue* list_map, FlValue* map_map) {
  CoreTestsPigeonTestAllTypes* self = CORE_TESTS_PIGEON_TEST_ALL_TYPES(
      g_object_new(core_tests_pigeon_test_all_types_get_type(), nullptr));
  self->a_bool = a_bool;
  self->an_int = an_int;
  self->an_int64 = an_int64;
  self->a_double = a_double;
  self->a_byte_array = static_cast<uint8_t*>(
      memcpy(malloc(a_byte_array_length), a_byte_array, a_byte_array_length));
  self->a_byte_array_length = a_byte_array_length;
  self->a4_byte_array = static_cast<int32_t*>(
      memcpy(malloc(sizeof(int32_t) * a4_byte_array_length), a4_byte_array,
             sizeof(int32_t) * a4_byte_array_length));
  self->a4_byte_array_length = a4_byte_array_length;
  self->a8_byte_array = static_cast<int64_t*>(
      memcpy(malloc(sizeof(int64_t) * a8_byte_array_length), a8_byte_array,
             sizeof(int64_t) * a8_byte_array_length));
  self->a8_byte_array_length = a8_byte_array_length;
  self->a_float_array = static_cast<double*>(
      memcpy(malloc(sizeof(double) * a_float_array_length), a_float_array,
             sizeof(double) * a_float_array_length));
  self->a_float_array_length = a_float_array_length;
  self->an_enum = an_enum;
  self->another_enum = another_enum;
  self->a_string = g_strdup(a_string);
  self->an_object = fl_value_ref(an_object);
  self->list = fl_value_ref(list);
  self->string_list = fl_value_ref(string_list);
  self->int_list = fl_value_ref(int_list);
  self->double_list = fl_value_ref(double_list);
  self->bool_list = fl_value_ref(bool_list);
  self->enum_list = fl_value_ref(enum_list);
  self->object_list = fl_value_ref(object_list);
  self->list_list = fl_value_ref(list_list);
  self->map_list = fl_value_ref(map_list);
  self->map = fl_value_ref(map);
  self->string_map = fl_value_ref(string_map);
  self->int_map = fl_value_ref(int_map);
  self->enum_map = fl_value_ref(enum_map);
  self->object_map = fl_value_ref(object_map);
  self->list_map = fl_value_ref(list_map);
  self->map_map = fl_value_ref(map_map);
  return self;
}

gboolean core_tests_pigeon_test_all_types_get_a_bool(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), FALSE);
  return self->a_bool;
}

int64_t core_tests_pigeon_test_all_types_get_an_int(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), 0);
  return self->an_int;
}

int64_t core_tests_pigeon_test_all_types_get_an_int64(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), 0);
  return self->an_int64;
}

double core_tests_pigeon_test_all_types_get_a_double(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), 0.0);
  return self->a_double;
}

const uint8_t* core_tests_pigeon_test_all_types_get_a_byte_array(
    CoreTestsPigeonTestAllTypes* self, size_t* length) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  *length = self->a_byte_array_length;
  return self->a_byte_array;
}

const int32_t* core_tests_pigeon_test_all_types_get_a4_byte_array(
    CoreTestsPigeonTestAllTypes* self, size_t* length) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  *length = self->a4_byte_array_length;
  return self->a4_byte_array;
}

const int64_t* core_tests_pigeon_test_all_types_get_a8_byte_array(
    CoreTestsPigeonTestAllTypes* self, size_t* length) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  *length = self->a8_byte_array_length;
  return self->a8_byte_array;
}

const double* core_tests_pigeon_test_all_types_get_a_float_array(
    CoreTestsPigeonTestAllTypes* self, size_t* length) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  *length = self->a_float_array_length;
  return self->a_float_array;
}

CoreTestsPigeonTestAnEnum core_tests_pigeon_test_all_types_get_an_enum(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self),
                       static_cast<CoreTestsPigeonTestAnEnum>(0));
  return self->an_enum;
}

CoreTestsPigeonTestAnotherEnum
core_tests_pigeon_test_all_types_get_another_enum(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self),
                       static_cast<CoreTestsPigeonTestAnotherEnum>(0));
  return self->another_enum;
}

const gchar* core_tests_pigeon_test_all_types_get_a_string(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->a_string;
}

FlValue* core_tests_pigeon_test_all_types_get_an_object(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->an_object;
}

FlValue* core_tests_pigeon_test_all_types_get_list(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->list;
}

FlValue* core_tests_pigeon_test_all_types_get_string_list(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->string_list;
}

FlValue* core_tests_pigeon_test_all_types_get_int_list(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->int_list;
}

FlValue* core_tests_pigeon_test_all_types_get_double_list(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->double_list;
}

FlValue* core_tests_pigeon_test_all_types_get_bool_list(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->bool_list;
}

FlValue* core_tests_pigeon_test_all_types_get_enum_list(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->enum_list;
}

FlValue* core_tests_pigeon_test_all_types_get_object_list(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->object_list;
}

FlValue* core_tests_pigeon_test_all_types_get_list_list(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->list_list;
}

FlValue* core_tests_pigeon_test_all_types_get_map_list(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->map_list;
}

FlValue* core_tests_pigeon_test_all_types_get_map(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->map;
}

FlValue* core_tests_pigeon_test_all_types_get_string_map(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->string_map;
}

FlValue* core_tests_pigeon_test_all_types_get_int_map(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->int_map;
}

FlValue* core_tests_pigeon_test_all_types_get_enum_map(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->enum_map;
}

FlValue* core_tests_pigeon_test_all_types_get_object_map(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->object_map;
}

FlValue* core_tests_pigeon_test_all_types_get_list_map(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->list_map;
}

FlValue* core_tests_pigeon_test_all_types_get_map_map(
    CoreTestsPigeonTestAllTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_TYPES(self), nullptr);
  return self->map_map;
}

static FlValue* core_tests_pigeon_test_all_types_to_list(
    CoreTestsPigeonTestAllTypes* self) {
  FlValue* values = fl_value_new_list();
  fl_value_append_take(values, fl_value_new_bool(self->a_bool));
  fl_value_append_take(values, fl_value_new_int(self->an_int));
  fl_value_append_take(values, fl_value_new_int(self->an_int64));
  fl_value_append_take(values, fl_value_new_float(self->a_double));
  fl_value_append_take(
      values,
      fl_value_new_uint8_list(self->a_byte_array, self->a_byte_array_length));
  fl_value_append_take(
      values,
      fl_value_new_int32_list(self->a4_byte_array, self->a4_byte_array_length));
  fl_value_append_take(
      values,
      fl_value_new_int64_list(self->a8_byte_array, self->a8_byte_array_length));
  fl_value_append_take(
      values,
      fl_value_new_float_list(self->a_float_array, self->a_float_array_length));
  fl_value_append_take(values,
                       fl_value_new_custom(129, fl_value_new_int(self->an_enum),
                                           (GDestroyNotify)fl_value_unref));
  fl_value_append_take(
      values, fl_value_new_custom(130, fl_value_new_int(self->another_enum),
                                  (GDestroyNotify)fl_value_unref));
  fl_value_append_take(values, fl_value_new_string(self->a_string));
  fl_value_append_take(values, fl_value_ref(self->an_object));
  fl_value_append_take(values, fl_value_ref(self->list));
  fl_value_append_take(values, fl_value_ref(self->string_list));
  fl_value_append_take(values, fl_value_ref(self->int_list));
  fl_value_append_take(values, fl_value_ref(self->double_list));
  fl_value_append_take(values, fl_value_ref(self->bool_list));
  fl_value_append_take(values, fl_value_ref(self->enum_list));
  fl_value_append_take(values, fl_value_ref(self->object_list));
  fl_value_append_take(values, fl_value_ref(self->list_list));
  fl_value_append_take(values, fl_value_ref(self->map_list));
  fl_value_append_take(values, fl_value_ref(self->map));
  fl_value_append_take(values, fl_value_ref(self->string_map));
  fl_value_append_take(values, fl_value_ref(self->int_map));
  fl_value_append_take(values, fl_value_ref(self->enum_map));
  fl_value_append_take(values, fl_value_ref(self->object_map));
  fl_value_append_take(values, fl_value_ref(self->list_map));
  fl_value_append_take(values, fl_value_ref(self->map_map));
  return values;
}

static CoreTestsPigeonTestAllTypes*
core_tests_pigeon_test_all_types_new_from_list(FlValue* values) {
  FlValue* value0 = fl_value_get_list_value(values, 0);
  gboolean a_bool = fl_value_get_bool(value0);
  FlValue* value1 = fl_value_get_list_value(values, 1);
  int64_t an_int = fl_value_get_int(value1);
  FlValue* value2 = fl_value_get_list_value(values, 2);
  int64_t an_int64 = fl_value_get_int(value2);
  FlValue* value3 = fl_value_get_list_value(values, 3);
  double a_double = fl_value_get_float(value3);
  FlValue* value4 = fl_value_get_list_value(values, 4);
  const uint8_t* a_byte_array = fl_value_get_uint8_list(value4);
  size_t a_byte_array_length = fl_value_get_length(value4);
  FlValue* value5 = fl_value_get_list_value(values, 5);
  const int32_t* a4_byte_array = fl_value_get_int32_list(value5);
  size_t a4_byte_array_length = fl_value_get_length(value5);
  FlValue* value6 = fl_value_get_list_value(values, 6);
  const int64_t* a8_byte_array = fl_value_get_int64_list(value6);
  size_t a8_byte_array_length = fl_value_get_length(value6);
  FlValue* value7 = fl_value_get_list_value(values, 7);
  const double* a_float_array = fl_value_get_float_list(value7);
  size_t a_float_array_length = fl_value_get_length(value7);
  FlValue* value8 = fl_value_get_list_value(values, 8);
  CoreTestsPigeonTestAnEnum an_enum = static_cast<CoreTestsPigeonTestAnEnum>(
      fl_value_get_int(reinterpret_cast<FlValue*>(
          const_cast<gpointer>(fl_value_get_custom_value(value8)))));
  FlValue* value9 = fl_value_get_list_value(values, 9);
  CoreTestsPigeonTestAnotherEnum another_enum =
      static_cast<CoreTestsPigeonTestAnotherEnum>(
          fl_value_get_int(reinterpret_cast<FlValue*>(
              const_cast<gpointer>(fl_value_get_custom_value(value9)))));
  FlValue* value10 = fl_value_get_list_value(values, 10);
  const gchar* a_string = fl_value_get_string(value10);
  FlValue* value11 = fl_value_get_list_value(values, 11);
  FlValue* an_object = value11;
  FlValue* value12 = fl_value_get_list_value(values, 12);
  FlValue* list = value12;
  FlValue* value13 = fl_value_get_list_value(values, 13);
  FlValue* string_list = value13;
  FlValue* value14 = fl_value_get_list_value(values, 14);
  FlValue* int_list = value14;
  FlValue* value15 = fl_value_get_list_value(values, 15);
  FlValue* double_list = value15;
  FlValue* value16 = fl_value_get_list_value(values, 16);
  FlValue* bool_list = value16;
  FlValue* value17 = fl_value_get_list_value(values, 17);
  FlValue* enum_list = value17;
  FlValue* value18 = fl_value_get_list_value(values, 18);
  FlValue* object_list = value18;
  FlValue* value19 = fl_value_get_list_value(values, 19);
  FlValue* list_list = value19;
  FlValue* value20 = fl_value_get_list_value(values, 20);
  FlValue* map_list = value20;
  FlValue* value21 = fl_value_get_list_value(values, 21);
  FlValue* map = value21;
  FlValue* value22 = fl_value_get_list_value(values, 22);
  FlValue* string_map = value22;
  FlValue* value23 = fl_value_get_list_value(values, 23);
  FlValue* int_map = value23;
  FlValue* value24 = fl_value_get_list_value(values, 24);
  FlValue* enum_map = value24;
  FlValue* value25 = fl_value_get_list_value(values, 25);
  FlValue* object_map = value25;
  FlValue* value26 = fl_value_get_list_value(values, 26);
  FlValue* list_map = value26;
  FlValue* value27 = fl_value_get_list_value(values, 27);
  FlValue* map_map = value27;
  return core_tests_pigeon_test_all_types_new(
      a_bool, an_int, an_int64, a_double, a_byte_array, a_byte_array_length,
      a4_byte_array, a4_byte_array_length, a8_byte_array, a8_byte_array_length,
      a_float_array, a_float_array_length, an_enum, another_enum, a_string,
      an_object, list, string_list, int_list, double_list, bool_list, enum_list,
      object_list, list_list, map_list, map, string_map, int_map, enum_map,
      object_map, list_map, map_map);
}

struct _CoreTestsPigeonTestAllNullableTypes {
  GObject parent_instance;

  gboolean* a_nullable_bool;
  int64_t* a_nullable_int;
  int64_t* a_nullable_int64;
  double* a_nullable_double;
  uint8_t* a_nullable_byte_array;
  size_t a_nullable_byte_array_length;
  int32_t* a_nullable4_byte_array;
  size_t a_nullable4_byte_array_length;
  int64_t* a_nullable8_byte_array;
  size_t a_nullable8_byte_array_length;
  double* a_nullable_float_array;
  size_t a_nullable_float_array_length;
  CoreTestsPigeonTestAnEnum* a_nullable_enum;
  CoreTestsPigeonTestAnotherEnum* another_nullable_enum;
  gchar* a_nullable_string;
  FlValue* a_nullable_object;
  CoreTestsPigeonTestAllNullableTypes* all_nullable_types;
  FlValue* list;
  FlValue* string_list;
  FlValue* int_list;
  FlValue* double_list;
  FlValue* bool_list;
  FlValue* enum_list;
  FlValue* object_list;
  FlValue* list_list;
  FlValue* map_list;
  FlValue* recursive_class_list;
  FlValue* map;
  FlValue* string_map;
  FlValue* int_map;
  FlValue* enum_map;
  FlValue* object_map;
  FlValue* list_map;
  FlValue* map_map;
  FlValue* recursive_class_map;
};

G_DEFINE_TYPE(CoreTestsPigeonTestAllNullableTypes,
              core_tests_pigeon_test_all_nullable_types, G_TYPE_OBJECT)

static void core_tests_pigeon_test_all_nullable_types_dispose(GObject* object) {
  CoreTestsPigeonTestAllNullableTypes* self =
      CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES(object);
  g_clear_pointer(&self->a_nullable_bool, g_free);
  g_clear_pointer(&self->a_nullable_int, g_free);
  g_clear_pointer(&self->a_nullable_int64, g_free);
  g_clear_pointer(&self->a_nullable_double, g_free);
  g_clear_pointer(&self->a_nullable_enum, g_free);
  g_clear_pointer(&self->another_nullable_enum, g_free);
  g_clear_pointer(&self->a_nullable_string, g_free);
  g_clear_pointer(&self->a_nullable_object, fl_value_unref);
  g_clear_object(&self->all_nullable_types);
  g_clear_pointer(&self->list, fl_value_unref);
  g_clear_pointer(&self->string_list, fl_value_unref);
  g_clear_pointer(&self->int_list, fl_value_unref);
  g_clear_pointer(&self->double_list, fl_value_unref);
  g_clear_pointer(&self->bool_list, fl_value_unref);
  g_clear_pointer(&self->enum_list, fl_value_unref);
  g_clear_pointer(&self->object_list, fl_value_unref);
  g_clear_pointer(&self->list_list, fl_value_unref);
  g_clear_pointer(&self->map_list, fl_value_unref);
  g_clear_pointer(&self->recursive_class_list, fl_value_unref);
  g_clear_pointer(&self->map, fl_value_unref);
  g_clear_pointer(&self->string_map, fl_value_unref);
  g_clear_pointer(&self->int_map, fl_value_unref);
  g_clear_pointer(&self->enum_map, fl_value_unref);
  g_clear_pointer(&self->object_map, fl_value_unref);
  g_clear_pointer(&self->list_map, fl_value_unref);
  g_clear_pointer(&self->map_map, fl_value_unref);
  g_clear_pointer(&self->recursive_class_map, fl_value_unref);
  G_OBJECT_CLASS(core_tests_pigeon_test_all_nullable_types_parent_class)
      ->dispose(object);
}

static void core_tests_pigeon_test_all_nullable_types_init(
    CoreTestsPigeonTestAllNullableTypes* self) {}

static void core_tests_pigeon_test_all_nullable_types_class_init(
    CoreTestsPigeonTestAllNullableTypesClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_all_nullable_types_dispose;
}

CoreTestsPigeonTestAllNullableTypes*
core_tests_pigeon_test_all_nullable_types_new(
    gboolean* a_nullable_bool, int64_t* a_nullable_int,
    int64_t* a_nullable_int64, double* a_nullable_double,
    const uint8_t* a_nullable_byte_array, size_t a_nullable_byte_array_length,
    const int32_t* a_nullable4_byte_array, size_t a_nullable4_byte_array_length,
    const int64_t* a_nullable8_byte_array, size_t a_nullable8_byte_array_length,
    const double* a_nullable_float_array, size_t a_nullable_float_array_length,
    CoreTestsPigeonTestAnEnum* a_nullable_enum,
    CoreTestsPigeonTestAnotherEnum* another_nullable_enum,
    const gchar* a_nullable_string, FlValue* a_nullable_object,
    CoreTestsPigeonTestAllNullableTypes* all_nullable_types, FlValue* list,
    FlValue* string_list, FlValue* int_list, FlValue* double_list,
    FlValue* bool_list, FlValue* enum_list, FlValue* object_list,
    FlValue* list_list, FlValue* map_list, FlValue* recursive_class_list,
    FlValue* map, FlValue* string_map, FlValue* int_map, FlValue* enum_map,
    FlValue* object_map, FlValue* list_map, FlValue* map_map,
    FlValue* recursive_class_map) {
  CoreTestsPigeonTestAllNullableTypes* self =
      CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES(g_object_new(
          core_tests_pigeon_test_all_nullable_types_get_type(), nullptr));
  if (a_nullable_bool != nullptr) {
    self->a_nullable_bool = static_cast<gboolean*>(malloc(sizeof(gboolean)));
    *self->a_nullable_bool = *a_nullable_bool;
  } else {
    self->a_nullable_bool = nullptr;
  }
  if (a_nullable_int != nullptr) {
    self->a_nullable_int = static_cast<int64_t*>(malloc(sizeof(int64_t)));
    *self->a_nullable_int = *a_nullable_int;
  } else {
    self->a_nullable_int = nullptr;
  }
  if (a_nullable_int64 != nullptr) {
    self->a_nullable_int64 = static_cast<int64_t*>(malloc(sizeof(int64_t)));
    *self->a_nullable_int64 = *a_nullable_int64;
  } else {
    self->a_nullable_int64 = nullptr;
  }
  if (a_nullable_double != nullptr) {
    self->a_nullable_double = static_cast<double*>(malloc(sizeof(double)));
    *self->a_nullable_double = *a_nullable_double;
  } else {
    self->a_nullable_double = nullptr;
  }
  if (a_nullable_byte_array != nullptr) {
    self->a_nullable_byte_array = static_cast<uint8_t*>(
        memcpy(malloc(a_nullable_byte_array_length), a_nullable_byte_array,
               a_nullable_byte_array_length));
    self->a_nullable_byte_array_length = a_nullable_byte_array_length;
  } else {
    self->a_nullable_byte_array = nullptr;
    self->a_nullable_byte_array_length = 0;
  }
  if (a_nullable4_byte_array != nullptr) {
    self->a_nullable4_byte_array = static_cast<int32_t*>(
        memcpy(malloc(sizeof(int32_t) * a_nullable4_byte_array_length),
               a_nullable4_byte_array,
               sizeof(int32_t) * a_nullable4_byte_array_length));
    self->a_nullable4_byte_array_length = a_nullable4_byte_array_length;
  } else {
    self->a_nullable4_byte_array = nullptr;
    self->a_nullable4_byte_array_length = 0;
  }
  if (a_nullable8_byte_array != nullptr) {
    self->a_nullable8_byte_array = static_cast<int64_t*>(
        memcpy(malloc(sizeof(int64_t) * a_nullable8_byte_array_length),
               a_nullable8_byte_array,
               sizeof(int64_t) * a_nullable8_byte_array_length));
    self->a_nullable8_byte_array_length = a_nullable8_byte_array_length;
  } else {
    self->a_nullable8_byte_array = nullptr;
    self->a_nullable8_byte_array_length = 0;
  }
  if (a_nullable_float_array != nullptr) {
    self->a_nullable_float_array = static_cast<double*>(
        memcpy(malloc(sizeof(double) * a_nullable_float_array_length),
               a_nullable_float_array,
               sizeof(double) * a_nullable_float_array_length));
    self->a_nullable_float_array_length = a_nullable_float_array_length;
  } else {
    self->a_nullable_float_array = nullptr;
    self->a_nullable_float_array_length = 0;
  }
  if (a_nullable_enum != nullptr) {
    self->a_nullable_enum = static_cast<CoreTestsPigeonTestAnEnum*>(
        malloc(sizeof(CoreTestsPigeonTestAnEnum)));
    *self->a_nullable_enum = *a_nullable_enum;
  } else {
    self->a_nullable_enum = nullptr;
  }
  if (another_nullable_enum != nullptr) {
    self->another_nullable_enum = static_cast<CoreTestsPigeonTestAnotherEnum*>(
        malloc(sizeof(CoreTestsPigeonTestAnotherEnum)));
    *self->another_nullable_enum = *another_nullable_enum;
  } else {
    self->another_nullable_enum = nullptr;
  }
  if (a_nullable_string != nullptr) {
    self->a_nullable_string = g_strdup(a_nullable_string);
  } else {
    self->a_nullable_string = nullptr;
  }
  if (a_nullable_object != nullptr) {
    self->a_nullable_object = fl_value_ref(a_nullable_object);
  } else {
    self->a_nullable_object = nullptr;
  }
  if (all_nullable_types != nullptr) {
    self->all_nullable_types = CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES(
        g_object_ref(all_nullable_types));
  } else {
    self->all_nullable_types = nullptr;
  }
  if (list != nullptr) {
    self->list = fl_value_ref(list);
  } else {
    self->list = nullptr;
  }
  if (string_list != nullptr) {
    self->string_list = fl_value_ref(string_list);
  } else {
    self->string_list = nullptr;
  }
  if (int_list != nullptr) {
    self->int_list = fl_value_ref(int_list);
  } else {
    self->int_list = nullptr;
  }
  if (double_list != nullptr) {
    self->double_list = fl_value_ref(double_list);
  } else {
    self->double_list = nullptr;
  }
  if (bool_list != nullptr) {
    self->bool_list = fl_value_ref(bool_list);
  } else {
    self->bool_list = nullptr;
  }
  if (enum_list != nullptr) {
    self->enum_list = fl_value_ref(enum_list);
  } else {
    self->enum_list = nullptr;
  }
  if (object_list != nullptr) {
    self->object_list = fl_value_ref(object_list);
  } else {
    self->object_list = nullptr;
  }
  if (list_list != nullptr) {
    self->list_list = fl_value_ref(list_list);
  } else {
    self->list_list = nullptr;
  }
  if (map_list != nullptr) {
    self->map_list = fl_value_ref(map_list);
  } else {
    self->map_list = nullptr;
  }
  if (recursive_class_list != nullptr) {
    self->recursive_class_list = fl_value_ref(recursive_class_list);
  } else {
    self->recursive_class_list = nullptr;
  }
  if (map != nullptr) {
    self->map = fl_value_ref(map);
  } else {
    self->map = nullptr;
  }
  if (string_map != nullptr) {
    self->string_map = fl_value_ref(string_map);
  } else {
    self->string_map = nullptr;
  }
  if (int_map != nullptr) {
    self->int_map = fl_value_ref(int_map);
  } else {
    self->int_map = nullptr;
  }
  if (enum_map != nullptr) {
    self->enum_map = fl_value_ref(enum_map);
  } else {
    self->enum_map = nullptr;
  }
  if (object_map != nullptr) {
    self->object_map = fl_value_ref(object_map);
  } else {
    self->object_map = nullptr;
  }
  if (list_map != nullptr) {
    self->list_map = fl_value_ref(list_map);
  } else {
    self->list_map = nullptr;
  }
  if (map_map != nullptr) {
    self->map_map = fl_value_ref(map_map);
  } else {
    self->map_map = nullptr;
  }
  if (recursive_class_map != nullptr) {
    self->recursive_class_map = fl_value_ref(recursive_class_map);
  } else {
    self->recursive_class_map = nullptr;
  }
  return self;
}

gboolean* core_tests_pigeon_test_all_nullable_types_get_a_nullable_bool(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->a_nullable_bool;
}

int64_t* core_tests_pigeon_test_all_nullable_types_get_a_nullable_int(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->a_nullable_int;
}

int64_t* core_tests_pigeon_test_all_nullable_types_get_a_nullable_int64(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->a_nullable_int64;
}

double* core_tests_pigeon_test_all_nullable_types_get_a_nullable_double(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->a_nullable_double;
}

const uint8_t*
core_tests_pigeon_test_all_nullable_types_get_a_nullable_byte_array(
    CoreTestsPigeonTestAllNullableTypes* self, size_t* length) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  *length = self->a_nullable_byte_array_length;
  return self->a_nullable_byte_array;
}

const int32_t*
core_tests_pigeon_test_all_nullable_types_get_a_nullable4_byte_array(
    CoreTestsPigeonTestAllNullableTypes* self, size_t* length) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  *length = self->a_nullable4_byte_array_length;
  return self->a_nullable4_byte_array;
}

const int64_t*
core_tests_pigeon_test_all_nullable_types_get_a_nullable8_byte_array(
    CoreTestsPigeonTestAllNullableTypes* self, size_t* length) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  *length = self->a_nullable8_byte_array_length;
  return self->a_nullable8_byte_array;
}

const double*
core_tests_pigeon_test_all_nullable_types_get_a_nullable_float_array(
    CoreTestsPigeonTestAllNullableTypes* self, size_t* length) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  *length = self->a_nullable_float_array_length;
  return self->a_nullable_float_array;
}

CoreTestsPigeonTestAnEnum*
core_tests_pigeon_test_all_nullable_types_get_a_nullable_enum(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->a_nullable_enum;
}

CoreTestsPigeonTestAnotherEnum*
core_tests_pigeon_test_all_nullable_types_get_another_nullable_enum(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->another_nullable_enum;
}

const gchar* core_tests_pigeon_test_all_nullable_types_get_a_nullable_string(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->a_nullable_string;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_a_nullable_object(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->a_nullable_object;
}

CoreTestsPigeonTestAllNullableTypes*
core_tests_pigeon_test_all_nullable_types_get_all_nullable_types(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->all_nullable_types;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_list(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->list;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_string_list(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->string_list;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_int_list(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->int_list;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_double_list(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->double_list;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_bool_list(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->bool_list;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_enum_list(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->enum_list;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_object_list(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->object_list;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_list_list(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->list_list;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_map_list(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->map_list;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_recursive_class_list(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->recursive_class_list;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_map(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->map;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_string_map(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->string_map;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_int_map(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->int_map;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_enum_map(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->enum_map;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_object_map(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->object_map;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_list_map(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->list_map;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_map_map(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->map_map;
}

FlValue* core_tests_pigeon_test_all_nullable_types_get_recursive_class_map(
    CoreTestsPigeonTestAllNullableTypes* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES(self),
                       nullptr);
  return self->recursive_class_map;
}

static FlValue* core_tests_pigeon_test_all_nullable_types_to_list(
    CoreTestsPigeonTestAllNullableTypes* self) {
  FlValue* values = fl_value_new_list();
  fl_value_append_take(values, self->a_nullable_bool != nullptr
                                   ? fl_value_new_bool(*self->a_nullable_bool)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->a_nullable_int != nullptr
                                   ? fl_value_new_int(*self->a_nullable_int)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->a_nullable_int64 != nullptr
                                   ? fl_value_new_int(*self->a_nullable_int64)
                                   : fl_value_new_null());
  fl_value_append_take(values,
                       self->a_nullable_double != nullptr
                           ? fl_value_new_float(*self->a_nullable_double)
                           : fl_value_new_null());
  fl_value_append_take(
      values, self->a_nullable_byte_array != nullptr
                  ? fl_value_new_uint8_list(self->a_nullable_byte_array,
                                            self->a_nullable_byte_array_length)
                  : fl_value_new_null());
  fl_value_append_take(
      values, self->a_nullable4_byte_array != nullptr
                  ? fl_value_new_int32_list(self->a_nullable4_byte_array,
                                            self->a_nullable4_byte_array_length)
                  : fl_value_new_null());
  fl_value_append_take(
      values, self->a_nullable8_byte_array != nullptr
                  ? fl_value_new_int64_list(self->a_nullable8_byte_array,
                                            self->a_nullable8_byte_array_length)
                  : fl_value_new_null());
  fl_value_append_take(
      values, self->a_nullable_float_array != nullptr
                  ? fl_value_new_float_list(self->a_nullable_float_array,
                                            self->a_nullable_float_array_length)
                  : fl_value_new_null());
  fl_value_append_take(
      values,
      self->a_nullable_enum != nullptr
          ? fl_value_new_custom(129, fl_value_new_int(*self->a_nullable_enum),
                                (GDestroyNotify)fl_value_unref)
          : fl_value_new_null());
  fl_value_append_take(
      values, self->another_nullable_enum != nullptr
                  ? fl_value_new_custom(
                        130, fl_value_new_int(*self->another_nullable_enum),
                        (GDestroyNotify)fl_value_unref)
                  : fl_value_new_null());
  fl_value_append_take(values,
                       self->a_nullable_string != nullptr
                           ? fl_value_new_string(self->a_nullable_string)
                           : fl_value_new_null());
  fl_value_append_take(values, self->a_nullable_object != nullptr
                                   ? fl_value_ref(self->a_nullable_object)
                                   : fl_value_new_null());
  fl_value_append_take(
      values,
      self->all_nullable_types != nullptr
          ? fl_value_new_custom_object(133, G_OBJECT(self->all_nullable_types))
          : fl_value_new_null());
  fl_value_append_take(values, self->list != nullptr ? fl_value_ref(self->list)
                                                     : fl_value_new_null());
  fl_value_append_take(values, self->string_list != nullptr
                                   ? fl_value_ref(self->string_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->int_list != nullptr
                                   ? fl_value_ref(self->int_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->double_list != nullptr
                                   ? fl_value_ref(self->double_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->bool_list != nullptr
                                   ? fl_value_ref(self->bool_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->enum_list != nullptr
                                   ? fl_value_ref(self->enum_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->object_list != nullptr
                                   ? fl_value_ref(self->object_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->list_list != nullptr
                                   ? fl_value_ref(self->list_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->map_list != nullptr
                                   ? fl_value_ref(self->map_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->recursive_class_list != nullptr
                                   ? fl_value_ref(self->recursive_class_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->map != nullptr ? fl_value_ref(self->map)
                                                    : fl_value_new_null());
  fl_value_append_take(values, self->string_map != nullptr
                                   ? fl_value_ref(self->string_map)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->int_map != nullptr
                                   ? fl_value_ref(self->int_map)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->enum_map != nullptr
                                   ? fl_value_ref(self->enum_map)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->object_map != nullptr
                                   ? fl_value_ref(self->object_map)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->list_map != nullptr
                                   ? fl_value_ref(self->list_map)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->map_map != nullptr
                                   ? fl_value_ref(self->map_map)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->recursive_class_map != nullptr
                                   ? fl_value_ref(self->recursive_class_map)
                                   : fl_value_new_null());
  return values;
}

static CoreTestsPigeonTestAllNullableTypes*
core_tests_pigeon_test_all_nullable_types_new_from_list(FlValue* values) {
  FlValue* value0 = fl_value_get_list_value(values, 0);
  gboolean* a_nullable_bool = nullptr;
  gboolean a_nullable_bool_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_nullable_bool_value = fl_value_get_bool(value0);
    a_nullable_bool = &a_nullable_bool_value;
  }
  FlValue* value1 = fl_value_get_list_value(values, 1);
  int64_t* a_nullable_int = nullptr;
  int64_t a_nullable_int_value;
  if (fl_value_get_type(value1) != FL_VALUE_TYPE_NULL) {
    a_nullable_int_value = fl_value_get_int(value1);
    a_nullable_int = &a_nullable_int_value;
  }
  FlValue* value2 = fl_value_get_list_value(values, 2);
  int64_t* a_nullable_int64 = nullptr;
  int64_t a_nullable_int64_value;
  if (fl_value_get_type(value2) != FL_VALUE_TYPE_NULL) {
    a_nullable_int64_value = fl_value_get_int(value2);
    a_nullable_int64 = &a_nullable_int64_value;
  }
  FlValue* value3 = fl_value_get_list_value(values, 3);
  double* a_nullable_double = nullptr;
  double a_nullable_double_value;
  if (fl_value_get_type(value3) != FL_VALUE_TYPE_NULL) {
    a_nullable_double_value = fl_value_get_float(value3);
    a_nullable_double = &a_nullable_double_value;
  }
  FlValue* value4 = fl_value_get_list_value(values, 4);
  const uint8_t* a_nullable_byte_array = nullptr;
  size_t a_nullable_byte_array_length = 0;
  if (fl_value_get_type(value4) != FL_VALUE_TYPE_NULL) {
    a_nullable_byte_array = fl_value_get_uint8_list(value4);
    a_nullable_byte_array_length = fl_value_get_length(value4);
  }
  FlValue* value5 = fl_value_get_list_value(values, 5);
  const int32_t* a_nullable4_byte_array = nullptr;
  size_t a_nullable4_byte_array_length = 0;
  if (fl_value_get_type(value5) != FL_VALUE_TYPE_NULL) {
    a_nullable4_byte_array = fl_value_get_int32_list(value5);
    a_nullable4_byte_array_length = fl_value_get_length(value5);
  }
  FlValue* value6 = fl_value_get_list_value(values, 6);
  const int64_t* a_nullable8_byte_array = nullptr;
  size_t a_nullable8_byte_array_length = 0;
  if (fl_value_get_type(value6) != FL_VALUE_TYPE_NULL) {
    a_nullable8_byte_array = fl_value_get_int64_list(value6);
    a_nullable8_byte_array_length = fl_value_get_length(value6);
  }
  FlValue* value7 = fl_value_get_list_value(values, 7);
  const double* a_nullable_float_array = nullptr;
  size_t a_nullable_float_array_length = 0;
  if (fl_value_get_type(value7) != FL_VALUE_TYPE_NULL) {
    a_nullable_float_array = fl_value_get_float_list(value7);
    a_nullable_float_array_length = fl_value_get_length(value7);
  }
  FlValue* value8 = fl_value_get_list_value(values, 8);
  CoreTestsPigeonTestAnEnum* a_nullable_enum = nullptr;
  CoreTestsPigeonTestAnEnum a_nullable_enum_value;
  if (fl_value_get_type(value8) != FL_VALUE_TYPE_NULL) {
    a_nullable_enum_value = static_cast<CoreTestsPigeonTestAnEnum>(
        fl_value_get_int(reinterpret_cast<FlValue*>(
            const_cast<gpointer>(fl_value_get_custom_value(value8)))));
    a_nullable_enum = &a_nullable_enum_value;
  }
  FlValue* value9 = fl_value_get_list_value(values, 9);
  CoreTestsPigeonTestAnotherEnum* another_nullable_enum = nullptr;
  CoreTestsPigeonTestAnotherEnum another_nullable_enum_value;
  if (fl_value_get_type(value9) != FL_VALUE_TYPE_NULL) {
    another_nullable_enum_value = static_cast<CoreTestsPigeonTestAnotherEnum>(
        fl_value_get_int(reinterpret_cast<FlValue*>(
            const_cast<gpointer>(fl_value_get_custom_value(value9)))));
    another_nullable_enum = &another_nullable_enum_value;
  }
  FlValue* value10 = fl_value_get_list_value(values, 10);
  const gchar* a_nullable_string = nullptr;
  if (fl_value_get_type(value10) != FL_VALUE_TYPE_NULL) {
    a_nullable_string = fl_value_get_string(value10);
  }
  FlValue* value11 = fl_value_get_list_value(values, 11);
  FlValue* a_nullable_object = nullptr;
  if (fl_value_get_type(value11) != FL_VALUE_TYPE_NULL) {
    a_nullable_object = value11;
  }
  FlValue* value12 = fl_value_get_list_value(values, 12);
  CoreTestsPigeonTestAllNullableTypes* all_nullable_types = nullptr;
  if (fl_value_get_type(value12) != FL_VALUE_TYPE_NULL) {
    all_nullable_types = CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES(
        fl_value_get_custom_value_object(value12));
  }
  FlValue* value13 = fl_value_get_list_value(values, 13);
  FlValue* list = nullptr;
  if (fl_value_get_type(value13) != FL_VALUE_TYPE_NULL) {
    list = value13;
  }
  FlValue* value14 = fl_value_get_list_value(values, 14);
  FlValue* string_list = nullptr;
  if (fl_value_get_type(value14) != FL_VALUE_TYPE_NULL) {
    string_list = value14;
  }
  FlValue* value15 = fl_value_get_list_value(values, 15);
  FlValue* int_list = nullptr;
  if (fl_value_get_type(value15) != FL_VALUE_TYPE_NULL) {
    int_list = value15;
  }
  FlValue* value16 = fl_value_get_list_value(values, 16);
  FlValue* double_list = nullptr;
  if (fl_value_get_type(value16) != FL_VALUE_TYPE_NULL) {
    double_list = value16;
  }
  FlValue* value17 = fl_value_get_list_value(values, 17);
  FlValue* bool_list = nullptr;
  if (fl_value_get_type(value17) != FL_VALUE_TYPE_NULL) {
    bool_list = value17;
  }
  FlValue* value18 = fl_value_get_list_value(values, 18);
  FlValue* enum_list = nullptr;
  if (fl_value_get_type(value18) != FL_VALUE_TYPE_NULL) {
    enum_list = value18;
  }
  FlValue* value19 = fl_value_get_list_value(values, 19);
  FlValue* object_list = nullptr;
  if (fl_value_get_type(value19) != FL_VALUE_TYPE_NULL) {
    object_list = value19;
  }
  FlValue* value20 = fl_value_get_list_value(values, 20);
  FlValue* list_list = nullptr;
  if (fl_value_get_type(value20) != FL_VALUE_TYPE_NULL) {
    list_list = value20;
  }
  FlValue* value21 = fl_value_get_list_value(values, 21);
  FlValue* map_list = nullptr;
  if (fl_value_get_type(value21) != FL_VALUE_TYPE_NULL) {
    map_list = value21;
  }
  FlValue* value22 = fl_value_get_list_value(values, 22);
  FlValue* recursive_class_list = nullptr;
  if (fl_value_get_type(value22) != FL_VALUE_TYPE_NULL) {
    recursive_class_list = value22;
  }
  FlValue* value23 = fl_value_get_list_value(values, 23);
  FlValue* map = nullptr;
  if (fl_value_get_type(value23) != FL_VALUE_TYPE_NULL) {
    map = value23;
  }
  FlValue* value24 = fl_value_get_list_value(values, 24);
  FlValue* string_map = nullptr;
  if (fl_value_get_type(value24) != FL_VALUE_TYPE_NULL) {
    string_map = value24;
  }
  FlValue* value25 = fl_value_get_list_value(values, 25);
  FlValue* int_map = nullptr;
  if (fl_value_get_type(value25) != FL_VALUE_TYPE_NULL) {
    int_map = value25;
  }
  FlValue* value26 = fl_value_get_list_value(values, 26);
  FlValue* enum_map = nullptr;
  if (fl_value_get_type(value26) != FL_VALUE_TYPE_NULL) {
    enum_map = value26;
  }
  FlValue* value27 = fl_value_get_list_value(values, 27);
  FlValue* object_map = nullptr;
  if (fl_value_get_type(value27) != FL_VALUE_TYPE_NULL) {
    object_map = value27;
  }
  FlValue* value28 = fl_value_get_list_value(values, 28);
  FlValue* list_map = nullptr;
  if (fl_value_get_type(value28) != FL_VALUE_TYPE_NULL) {
    list_map = value28;
  }
  FlValue* value29 = fl_value_get_list_value(values, 29);
  FlValue* map_map = nullptr;
  if (fl_value_get_type(value29) != FL_VALUE_TYPE_NULL) {
    map_map = value29;
  }
  FlValue* value30 = fl_value_get_list_value(values, 30);
  FlValue* recursive_class_map = nullptr;
  if (fl_value_get_type(value30) != FL_VALUE_TYPE_NULL) {
    recursive_class_map = value30;
  }
  return core_tests_pigeon_test_all_nullable_types_new(
      a_nullable_bool, a_nullable_int, a_nullable_int64, a_nullable_double,
      a_nullable_byte_array, a_nullable_byte_array_length,
      a_nullable4_byte_array, a_nullable4_byte_array_length,
      a_nullable8_byte_array, a_nullable8_byte_array_length,
      a_nullable_float_array, a_nullable_float_array_length, a_nullable_enum,
      another_nullable_enum, a_nullable_string, a_nullable_object,
      all_nullable_types, list, string_list, int_list, double_list, bool_list,
      enum_list, object_list, list_list, map_list, recursive_class_list, map,
      string_map, int_map, enum_map, object_map, list_map, map_map,
      recursive_class_map);
}

struct _CoreTestsPigeonTestAllNullableTypesWithoutRecursion {
  GObject parent_instance;

  gboolean* a_nullable_bool;
  int64_t* a_nullable_int;
  int64_t* a_nullable_int64;
  double* a_nullable_double;
  uint8_t* a_nullable_byte_array;
  size_t a_nullable_byte_array_length;
  int32_t* a_nullable4_byte_array;
  size_t a_nullable4_byte_array_length;
  int64_t* a_nullable8_byte_array;
  size_t a_nullable8_byte_array_length;
  double* a_nullable_float_array;
  size_t a_nullable_float_array_length;
  CoreTestsPigeonTestAnEnum* a_nullable_enum;
  CoreTestsPigeonTestAnotherEnum* another_nullable_enum;
  gchar* a_nullable_string;
  FlValue* a_nullable_object;
  FlValue* list;
  FlValue* string_list;
  FlValue* int_list;
  FlValue* double_list;
  FlValue* bool_list;
  FlValue* enum_list;
  FlValue* object_list;
  FlValue* list_list;
  FlValue* map_list;
  FlValue* map;
  FlValue* string_map;
  FlValue* int_map;
  FlValue* enum_map;
  FlValue* object_map;
  FlValue* list_map;
  FlValue* map_map;
};

G_DEFINE_TYPE(CoreTestsPigeonTestAllNullableTypesWithoutRecursion,
              core_tests_pigeon_test_all_nullable_types_without_recursion,
              G_TYPE_OBJECT)

static void core_tests_pigeon_test_all_nullable_types_without_recursion_dispose(
    GObject* object) {
  CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self =
      CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(object);
  g_clear_pointer(&self->a_nullable_bool, g_free);
  g_clear_pointer(&self->a_nullable_int, g_free);
  g_clear_pointer(&self->a_nullable_int64, g_free);
  g_clear_pointer(&self->a_nullable_double, g_free);
  g_clear_pointer(&self->a_nullable_enum, g_free);
  g_clear_pointer(&self->another_nullable_enum, g_free);
  g_clear_pointer(&self->a_nullable_string, g_free);
  g_clear_pointer(&self->a_nullable_object, fl_value_unref);
  g_clear_pointer(&self->list, fl_value_unref);
  g_clear_pointer(&self->string_list, fl_value_unref);
  g_clear_pointer(&self->int_list, fl_value_unref);
  g_clear_pointer(&self->double_list, fl_value_unref);
  g_clear_pointer(&self->bool_list, fl_value_unref);
  g_clear_pointer(&self->enum_list, fl_value_unref);
  g_clear_pointer(&self->object_list, fl_value_unref);
  g_clear_pointer(&self->list_list, fl_value_unref);
  g_clear_pointer(&self->map_list, fl_value_unref);
  g_clear_pointer(&self->map, fl_value_unref);
  g_clear_pointer(&self->string_map, fl_value_unref);
  g_clear_pointer(&self->int_map, fl_value_unref);
  g_clear_pointer(&self->enum_map, fl_value_unref);
  g_clear_pointer(&self->object_map, fl_value_unref);
  g_clear_pointer(&self->list_map, fl_value_unref);
  g_clear_pointer(&self->map_map, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_all_nullable_types_without_recursion_parent_class)
      ->dispose(object);
}

static void core_tests_pigeon_test_all_nullable_types_without_recursion_init(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {}

static void
core_tests_pigeon_test_all_nullable_types_without_recursion_class_init(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursionClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_all_nullable_types_without_recursion_dispose;
}

CoreTestsPigeonTestAllNullableTypesWithoutRecursion*
core_tests_pigeon_test_all_nullable_types_without_recursion_new(
    gboolean* a_nullable_bool, int64_t* a_nullable_int,
    int64_t* a_nullable_int64, double* a_nullable_double,
    const uint8_t* a_nullable_byte_array, size_t a_nullable_byte_array_length,
    const int32_t* a_nullable4_byte_array, size_t a_nullable4_byte_array_length,
    const int64_t* a_nullable8_byte_array, size_t a_nullable8_byte_array_length,
    const double* a_nullable_float_array, size_t a_nullable_float_array_length,
    CoreTestsPigeonTestAnEnum* a_nullable_enum,
    CoreTestsPigeonTestAnotherEnum* another_nullable_enum,
    const gchar* a_nullable_string, FlValue* a_nullable_object, FlValue* list,
    FlValue* string_list, FlValue* int_list, FlValue* double_list,
    FlValue* bool_list, FlValue* enum_list, FlValue* object_list,
    FlValue* list_list, FlValue* map_list, FlValue* map, FlValue* string_map,
    FlValue* int_map, FlValue* enum_map, FlValue* object_map, FlValue* list_map,
    FlValue* map_map) {
  CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self =
      CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(g_object_new(
          core_tests_pigeon_test_all_nullable_types_without_recursion_get_type(),
          nullptr));
  if (a_nullable_bool != nullptr) {
    self->a_nullable_bool = static_cast<gboolean*>(malloc(sizeof(gboolean)));
    *self->a_nullable_bool = *a_nullable_bool;
  } else {
    self->a_nullable_bool = nullptr;
  }
  if (a_nullable_int != nullptr) {
    self->a_nullable_int = static_cast<int64_t*>(malloc(sizeof(int64_t)));
    *self->a_nullable_int = *a_nullable_int;
  } else {
    self->a_nullable_int = nullptr;
  }
  if (a_nullable_int64 != nullptr) {
    self->a_nullable_int64 = static_cast<int64_t*>(malloc(sizeof(int64_t)));
    *self->a_nullable_int64 = *a_nullable_int64;
  } else {
    self->a_nullable_int64 = nullptr;
  }
  if (a_nullable_double != nullptr) {
    self->a_nullable_double = static_cast<double*>(malloc(sizeof(double)));
    *self->a_nullable_double = *a_nullable_double;
  } else {
    self->a_nullable_double = nullptr;
  }
  if (a_nullable_byte_array != nullptr) {
    self->a_nullable_byte_array = static_cast<uint8_t*>(
        memcpy(malloc(a_nullable_byte_array_length), a_nullable_byte_array,
               a_nullable_byte_array_length));
    self->a_nullable_byte_array_length = a_nullable_byte_array_length;
  } else {
    self->a_nullable_byte_array = nullptr;
    self->a_nullable_byte_array_length = 0;
  }
  if (a_nullable4_byte_array != nullptr) {
    self->a_nullable4_byte_array = static_cast<int32_t*>(
        memcpy(malloc(sizeof(int32_t) * a_nullable4_byte_array_length),
               a_nullable4_byte_array,
               sizeof(int32_t) * a_nullable4_byte_array_length));
    self->a_nullable4_byte_array_length = a_nullable4_byte_array_length;
  } else {
    self->a_nullable4_byte_array = nullptr;
    self->a_nullable4_byte_array_length = 0;
  }
  if (a_nullable8_byte_array != nullptr) {
    self->a_nullable8_byte_array = static_cast<int64_t*>(
        memcpy(malloc(sizeof(int64_t) * a_nullable8_byte_array_length),
               a_nullable8_byte_array,
               sizeof(int64_t) * a_nullable8_byte_array_length));
    self->a_nullable8_byte_array_length = a_nullable8_byte_array_length;
  } else {
    self->a_nullable8_byte_array = nullptr;
    self->a_nullable8_byte_array_length = 0;
  }
  if (a_nullable_float_array != nullptr) {
    self->a_nullable_float_array = static_cast<double*>(
        memcpy(malloc(sizeof(double) * a_nullable_float_array_length),
               a_nullable_float_array,
               sizeof(double) * a_nullable_float_array_length));
    self->a_nullable_float_array_length = a_nullable_float_array_length;
  } else {
    self->a_nullable_float_array = nullptr;
    self->a_nullable_float_array_length = 0;
  }
  if (a_nullable_enum != nullptr) {
    self->a_nullable_enum = static_cast<CoreTestsPigeonTestAnEnum*>(
        malloc(sizeof(CoreTestsPigeonTestAnEnum)));
    *self->a_nullable_enum = *a_nullable_enum;
  } else {
    self->a_nullable_enum = nullptr;
  }
  if (another_nullable_enum != nullptr) {
    self->another_nullable_enum = static_cast<CoreTestsPigeonTestAnotherEnum*>(
        malloc(sizeof(CoreTestsPigeonTestAnotherEnum)));
    *self->another_nullable_enum = *another_nullable_enum;
  } else {
    self->another_nullable_enum = nullptr;
  }
  if (a_nullable_string != nullptr) {
    self->a_nullable_string = g_strdup(a_nullable_string);
  } else {
    self->a_nullable_string = nullptr;
  }
  if (a_nullable_object != nullptr) {
    self->a_nullable_object = fl_value_ref(a_nullable_object);
  } else {
    self->a_nullable_object = nullptr;
  }
  if (list != nullptr) {
    self->list = fl_value_ref(list);
  } else {
    self->list = nullptr;
  }
  if (string_list != nullptr) {
    self->string_list = fl_value_ref(string_list);
  } else {
    self->string_list = nullptr;
  }
  if (int_list != nullptr) {
    self->int_list = fl_value_ref(int_list);
  } else {
    self->int_list = nullptr;
  }
  if (double_list != nullptr) {
    self->double_list = fl_value_ref(double_list);
  } else {
    self->double_list = nullptr;
  }
  if (bool_list != nullptr) {
    self->bool_list = fl_value_ref(bool_list);
  } else {
    self->bool_list = nullptr;
  }
  if (enum_list != nullptr) {
    self->enum_list = fl_value_ref(enum_list);
  } else {
    self->enum_list = nullptr;
  }
  if (object_list != nullptr) {
    self->object_list = fl_value_ref(object_list);
  } else {
    self->object_list = nullptr;
  }
  if (list_list != nullptr) {
    self->list_list = fl_value_ref(list_list);
  } else {
    self->list_list = nullptr;
  }
  if (map_list != nullptr) {
    self->map_list = fl_value_ref(map_list);
  } else {
    self->map_list = nullptr;
  }
  if (map != nullptr) {
    self->map = fl_value_ref(map);
  } else {
    self->map = nullptr;
  }
  if (string_map != nullptr) {
    self->string_map = fl_value_ref(string_map);
  } else {
    self->string_map = nullptr;
  }
  if (int_map != nullptr) {
    self->int_map = fl_value_ref(int_map);
  } else {
    self->int_map = nullptr;
  }
  if (enum_map != nullptr) {
    self->enum_map = fl_value_ref(enum_map);
  } else {
    self->enum_map = nullptr;
  }
  if (object_map != nullptr) {
    self->object_map = fl_value_ref(object_map);
  } else {
    self->object_map = nullptr;
  }
  if (list_map != nullptr) {
    self->list_map = fl_value_ref(list_map);
  } else {
    self->list_map = nullptr;
  }
  if (map_map != nullptr) {
    self->map_map = fl_value_ref(map_map);
  } else {
    self->map_map = nullptr;
  }
  return self;
}

gboolean*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_a_nullable_bool(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->a_nullable_bool;
}

int64_t*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_a_nullable_int(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->a_nullable_int;
}

int64_t*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_a_nullable_int64(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->a_nullable_int64;
}

double*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_a_nullable_double(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->a_nullable_double;
}

const uint8_t*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_a_nullable_byte_array(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self, size_t* length) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  *length = self->a_nullable_byte_array_length;
  return self->a_nullable_byte_array;
}

const int32_t*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_a_nullable4_byte_array(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self, size_t* length) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  *length = self->a_nullable4_byte_array_length;
  return self->a_nullable4_byte_array;
}

const int64_t*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_a_nullable8_byte_array(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self, size_t* length) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  *length = self->a_nullable8_byte_array_length;
  return self->a_nullable8_byte_array;
}

const double*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_a_nullable_float_array(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self, size_t* length) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  *length = self->a_nullable_float_array_length;
  return self->a_nullable_float_array;
}

CoreTestsPigeonTestAnEnum*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_a_nullable_enum(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->a_nullable_enum;
}

CoreTestsPigeonTestAnotherEnum*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_another_nullable_enum(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->another_nullable_enum;
}

const gchar*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_a_nullable_string(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->a_nullable_string;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_a_nullable_object(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->a_nullable_object;
}

FlValue* core_tests_pigeon_test_all_nullable_types_without_recursion_get_list(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->list;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_string_list(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->string_list;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_int_list(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->int_list;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_double_list(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->double_list;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_bool_list(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->bool_list;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_enum_list(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->enum_list;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_object_list(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->object_list;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_list_list(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->list_list;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_map_list(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->map_list;
}

FlValue* core_tests_pigeon_test_all_nullable_types_without_recursion_get_map(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->map;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_string_map(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->string_map;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_int_map(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->int_map;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_enum_map(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->enum_map;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_object_map(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->object_map;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_list_map(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->list_map;
}

FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_get_map_map(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  g_return_val_if_fail(
      CORE_TESTS_PIGEON_TEST_IS_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(self),
      nullptr);
  return self->map_map;
}

static FlValue*
core_tests_pigeon_test_all_nullable_types_without_recursion_to_list(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* self) {
  FlValue* values = fl_value_new_list();
  fl_value_append_take(values, self->a_nullable_bool != nullptr
                                   ? fl_value_new_bool(*self->a_nullable_bool)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->a_nullable_int != nullptr
                                   ? fl_value_new_int(*self->a_nullable_int)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->a_nullable_int64 != nullptr
                                   ? fl_value_new_int(*self->a_nullable_int64)
                                   : fl_value_new_null());
  fl_value_append_take(values,
                       self->a_nullable_double != nullptr
                           ? fl_value_new_float(*self->a_nullable_double)
                           : fl_value_new_null());
  fl_value_append_take(
      values, self->a_nullable_byte_array != nullptr
                  ? fl_value_new_uint8_list(self->a_nullable_byte_array,
                                            self->a_nullable_byte_array_length)
                  : fl_value_new_null());
  fl_value_append_take(
      values, self->a_nullable4_byte_array != nullptr
                  ? fl_value_new_int32_list(self->a_nullable4_byte_array,
                                            self->a_nullable4_byte_array_length)
                  : fl_value_new_null());
  fl_value_append_take(
      values, self->a_nullable8_byte_array != nullptr
                  ? fl_value_new_int64_list(self->a_nullable8_byte_array,
                                            self->a_nullable8_byte_array_length)
                  : fl_value_new_null());
  fl_value_append_take(
      values, self->a_nullable_float_array != nullptr
                  ? fl_value_new_float_list(self->a_nullable_float_array,
                                            self->a_nullable_float_array_length)
                  : fl_value_new_null());
  fl_value_append_take(
      values,
      self->a_nullable_enum != nullptr
          ? fl_value_new_custom(129, fl_value_new_int(*self->a_nullable_enum),
                                (GDestroyNotify)fl_value_unref)
          : fl_value_new_null());
  fl_value_append_take(
      values, self->another_nullable_enum != nullptr
                  ? fl_value_new_custom(
                        130, fl_value_new_int(*self->another_nullable_enum),
                        (GDestroyNotify)fl_value_unref)
                  : fl_value_new_null());
  fl_value_append_take(values,
                       self->a_nullable_string != nullptr
                           ? fl_value_new_string(self->a_nullable_string)
                           : fl_value_new_null());
  fl_value_append_take(values, self->a_nullable_object != nullptr
                                   ? fl_value_ref(self->a_nullable_object)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->list != nullptr ? fl_value_ref(self->list)
                                                     : fl_value_new_null());
  fl_value_append_take(values, self->string_list != nullptr
                                   ? fl_value_ref(self->string_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->int_list != nullptr
                                   ? fl_value_ref(self->int_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->double_list != nullptr
                                   ? fl_value_ref(self->double_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->bool_list != nullptr
                                   ? fl_value_ref(self->bool_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->enum_list != nullptr
                                   ? fl_value_ref(self->enum_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->object_list != nullptr
                                   ? fl_value_ref(self->object_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->list_list != nullptr
                                   ? fl_value_ref(self->list_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->map_list != nullptr
                                   ? fl_value_ref(self->map_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->map != nullptr ? fl_value_ref(self->map)
                                                    : fl_value_new_null());
  fl_value_append_take(values, self->string_map != nullptr
                                   ? fl_value_ref(self->string_map)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->int_map != nullptr
                                   ? fl_value_ref(self->int_map)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->enum_map != nullptr
                                   ? fl_value_ref(self->enum_map)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->object_map != nullptr
                                   ? fl_value_ref(self->object_map)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->list_map != nullptr
                                   ? fl_value_ref(self->list_map)
                                   : fl_value_new_null());
  fl_value_append_take(values, self->map_map != nullptr
                                   ? fl_value_ref(self->map_map)
                                   : fl_value_new_null());
  return values;
}

static CoreTestsPigeonTestAllNullableTypesWithoutRecursion*
core_tests_pigeon_test_all_nullable_types_without_recursion_new_from_list(
    FlValue* values) {
  FlValue* value0 = fl_value_get_list_value(values, 0);
  gboolean* a_nullable_bool = nullptr;
  gboolean a_nullable_bool_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_nullable_bool_value = fl_value_get_bool(value0);
    a_nullable_bool = &a_nullable_bool_value;
  }
  FlValue* value1 = fl_value_get_list_value(values, 1);
  int64_t* a_nullable_int = nullptr;
  int64_t a_nullable_int_value;
  if (fl_value_get_type(value1) != FL_VALUE_TYPE_NULL) {
    a_nullable_int_value = fl_value_get_int(value1);
    a_nullable_int = &a_nullable_int_value;
  }
  FlValue* value2 = fl_value_get_list_value(values, 2);
  int64_t* a_nullable_int64 = nullptr;
  int64_t a_nullable_int64_value;
  if (fl_value_get_type(value2) != FL_VALUE_TYPE_NULL) {
    a_nullable_int64_value = fl_value_get_int(value2);
    a_nullable_int64 = &a_nullable_int64_value;
  }
  FlValue* value3 = fl_value_get_list_value(values, 3);
  double* a_nullable_double = nullptr;
  double a_nullable_double_value;
  if (fl_value_get_type(value3) != FL_VALUE_TYPE_NULL) {
    a_nullable_double_value = fl_value_get_float(value3);
    a_nullable_double = &a_nullable_double_value;
  }
  FlValue* value4 = fl_value_get_list_value(values, 4);
  const uint8_t* a_nullable_byte_array = nullptr;
  size_t a_nullable_byte_array_length = 0;
  if (fl_value_get_type(value4) != FL_VALUE_TYPE_NULL) {
    a_nullable_byte_array = fl_value_get_uint8_list(value4);
    a_nullable_byte_array_length = fl_value_get_length(value4);
  }
  FlValue* value5 = fl_value_get_list_value(values, 5);
  const int32_t* a_nullable4_byte_array = nullptr;
  size_t a_nullable4_byte_array_length = 0;
  if (fl_value_get_type(value5) != FL_VALUE_TYPE_NULL) {
    a_nullable4_byte_array = fl_value_get_int32_list(value5);
    a_nullable4_byte_array_length = fl_value_get_length(value5);
  }
  FlValue* value6 = fl_value_get_list_value(values, 6);
  const int64_t* a_nullable8_byte_array = nullptr;
  size_t a_nullable8_byte_array_length = 0;
  if (fl_value_get_type(value6) != FL_VALUE_TYPE_NULL) {
    a_nullable8_byte_array = fl_value_get_int64_list(value6);
    a_nullable8_byte_array_length = fl_value_get_length(value6);
  }
  FlValue* value7 = fl_value_get_list_value(values, 7);
  const double* a_nullable_float_array = nullptr;
  size_t a_nullable_float_array_length = 0;
  if (fl_value_get_type(value7) != FL_VALUE_TYPE_NULL) {
    a_nullable_float_array = fl_value_get_float_list(value7);
    a_nullable_float_array_length = fl_value_get_length(value7);
  }
  FlValue* value8 = fl_value_get_list_value(values, 8);
  CoreTestsPigeonTestAnEnum* a_nullable_enum = nullptr;
  CoreTestsPigeonTestAnEnum a_nullable_enum_value;
  if (fl_value_get_type(value8) != FL_VALUE_TYPE_NULL) {
    a_nullable_enum_value = static_cast<CoreTestsPigeonTestAnEnum>(
        fl_value_get_int(reinterpret_cast<FlValue*>(
            const_cast<gpointer>(fl_value_get_custom_value(value8)))));
    a_nullable_enum = &a_nullable_enum_value;
  }
  FlValue* value9 = fl_value_get_list_value(values, 9);
  CoreTestsPigeonTestAnotherEnum* another_nullable_enum = nullptr;
  CoreTestsPigeonTestAnotherEnum another_nullable_enum_value;
  if (fl_value_get_type(value9) != FL_VALUE_TYPE_NULL) {
    another_nullable_enum_value = static_cast<CoreTestsPigeonTestAnotherEnum>(
        fl_value_get_int(reinterpret_cast<FlValue*>(
            const_cast<gpointer>(fl_value_get_custom_value(value9)))));
    another_nullable_enum = &another_nullable_enum_value;
  }
  FlValue* value10 = fl_value_get_list_value(values, 10);
  const gchar* a_nullable_string = nullptr;
  if (fl_value_get_type(value10) != FL_VALUE_TYPE_NULL) {
    a_nullable_string = fl_value_get_string(value10);
  }
  FlValue* value11 = fl_value_get_list_value(values, 11);
  FlValue* a_nullable_object = nullptr;
  if (fl_value_get_type(value11) != FL_VALUE_TYPE_NULL) {
    a_nullable_object = value11;
  }
  FlValue* value12 = fl_value_get_list_value(values, 12);
  FlValue* list = nullptr;
  if (fl_value_get_type(value12) != FL_VALUE_TYPE_NULL) {
    list = value12;
  }
  FlValue* value13 = fl_value_get_list_value(values, 13);
  FlValue* string_list = nullptr;
  if (fl_value_get_type(value13) != FL_VALUE_TYPE_NULL) {
    string_list = value13;
  }
  FlValue* value14 = fl_value_get_list_value(values, 14);
  FlValue* int_list = nullptr;
  if (fl_value_get_type(value14) != FL_VALUE_TYPE_NULL) {
    int_list = value14;
  }
  FlValue* value15 = fl_value_get_list_value(values, 15);
  FlValue* double_list = nullptr;
  if (fl_value_get_type(value15) != FL_VALUE_TYPE_NULL) {
    double_list = value15;
  }
  FlValue* value16 = fl_value_get_list_value(values, 16);
  FlValue* bool_list = nullptr;
  if (fl_value_get_type(value16) != FL_VALUE_TYPE_NULL) {
    bool_list = value16;
  }
  FlValue* value17 = fl_value_get_list_value(values, 17);
  FlValue* enum_list = nullptr;
  if (fl_value_get_type(value17) != FL_VALUE_TYPE_NULL) {
    enum_list = value17;
  }
  FlValue* value18 = fl_value_get_list_value(values, 18);
  FlValue* object_list = nullptr;
  if (fl_value_get_type(value18) != FL_VALUE_TYPE_NULL) {
    object_list = value18;
  }
  FlValue* value19 = fl_value_get_list_value(values, 19);
  FlValue* list_list = nullptr;
  if (fl_value_get_type(value19) != FL_VALUE_TYPE_NULL) {
    list_list = value19;
  }
  FlValue* value20 = fl_value_get_list_value(values, 20);
  FlValue* map_list = nullptr;
  if (fl_value_get_type(value20) != FL_VALUE_TYPE_NULL) {
    map_list = value20;
  }
  FlValue* value21 = fl_value_get_list_value(values, 21);
  FlValue* map = nullptr;
  if (fl_value_get_type(value21) != FL_VALUE_TYPE_NULL) {
    map = value21;
  }
  FlValue* value22 = fl_value_get_list_value(values, 22);
  FlValue* string_map = nullptr;
  if (fl_value_get_type(value22) != FL_VALUE_TYPE_NULL) {
    string_map = value22;
  }
  FlValue* value23 = fl_value_get_list_value(values, 23);
  FlValue* int_map = nullptr;
  if (fl_value_get_type(value23) != FL_VALUE_TYPE_NULL) {
    int_map = value23;
  }
  FlValue* value24 = fl_value_get_list_value(values, 24);
  FlValue* enum_map = nullptr;
  if (fl_value_get_type(value24) != FL_VALUE_TYPE_NULL) {
    enum_map = value24;
  }
  FlValue* value25 = fl_value_get_list_value(values, 25);
  FlValue* object_map = nullptr;
  if (fl_value_get_type(value25) != FL_VALUE_TYPE_NULL) {
    object_map = value25;
  }
  FlValue* value26 = fl_value_get_list_value(values, 26);
  FlValue* list_map = nullptr;
  if (fl_value_get_type(value26) != FL_VALUE_TYPE_NULL) {
    list_map = value26;
  }
  FlValue* value27 = fl_value_get_list_value(values, 27);
  FlValue* map_map = nullptr;
  if (fl_value_get_type(value27) != FL_VALUE_TYPE_NULL) {
    map_map = value27;
  }
  return core_tests_pigeon_test_all_nullable_types_without_recursion_new(
      a_nullable_bool, a_nullable_int, a_nullable_int64, a_nullable_double,
      a_nullable_byte_array, a_nullable_byte_array_length,
      a_nullable4_byte_array, a_nullable4_byte_array_length,
      a_nullable8_byte_array, a_nullable8_byte_array_length,
      a_nullable_float_array, a_nullable_float_array_length, a_nullable_enum,
      another_nullable_enum, a_nullable_string, a_nullable_object, list,
      string_list, int_list, double_list, bool_list, enum_list, object_list,
      list_list, map_list, map, string_map, int_map, enum_map, object_map,
      list_map, map_map);
}

struct _CoreTestsPigeonTestAllClassesWrapper {
  GObject parent_instance;

  CoreTestsPigeonTestAllNullableTypes* all_nullable_types;
  CoreTestsPigeonTestAllNullableTypesWithoutRecursion*
      all_nullable_types_without_recursion;
  CoreTestsPigeonTestAllTypes* all_types;
  FlValue* class_list;
  FlValue* nullable_class_list;
  FlValue* class_map;
  FlValue* nullable_class_map;
};

G_DEFINE_TYPE(CoreTestsPigeonTestAllClassesWrapper,
              core_tests_pigeon_test_all_classes_wrapper, G_TYPE_OBJECT)

static void core_tests_pigeon_test_all_classes_wrapper_dispose(
    GObject* object) {
  CoreTestsPigeonTestAllClassesWrapper* self =
      CORE_TESTS_PIGEON_TEST_ALL_CLASSES_WRAPPER(object);
  g_clear_object(&self->all_nullable_types);
  g_clear_object(&self->all_nullable_types_without_recursion);
  g_clear_object(&self->all_types);
  g_clear_pointer(&self->class_list, fl_value_unref);
  g_clear_pointer(&self->nullable_class_list, fl_value_unref);
  g_clear_pointer(&self->class_map, fl_value_unref);
  g_clear_pointer(&self->nullable_class_map, fl_value_unref);
  G_OBJECT_CLASS(core_tests_pigeon_test_all_classes_wrapper_parent_class)
      ->dispose(object);
}

static void core_tests_pigeon_test_all_classes_wrapper_init(
    CoreTestsPigeonTestAllClassesWrapper* self) {}

static void core_tests_pigeon_test_all_classes_wrapper_class_init(
    CoreTestsPigeonTestAllClassesWrapperClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_all_classes_wrapper_dispose;
}

CoreTestsPigeonTestAllClassesWrapper*
core_tests_pigeon_test_all_classes_wrapper_new(
    CoreTestsPigeonTestAllNullableTypes* all_nullable_types,
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion*
        all_nullable_types_without_recursion,
    CoreTestsPigeonTestAllTypes* all_types, FlValue* class_list,
    FlValue* nullable_class_list, FlValue* class_map,
    FlValue* nullable_class_map) {
  CoreTestsPigeonTestAllClassesWrapper* self =
      CORE_TESTS_PIGEON_TEST_ALL_CLASSES_WRAPPER(g_object_new(
          core_tests_pigeon_test_all_classes_wrapper_get_type(), nullptr));
  self->all_nullable_types = CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES(
      g_object_ref(all_nullable_types));
  if (all_nullable_types_without_recursion != nullptr) {
    self->all_nullable_types_without_recursion =
        CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(
            g_object_ref(all_nullable_types_without_recursion));
  } else {
    self->all_nullable_types_without_recursion = nullptr;
  }
  if (all_types != nullptr) {
    self->all_types = CORE_TESTS_PIGEON_TEST_ALL_TYPES(g_object_ref(all_types));
  } else {
    self->all_types = nullptr;
  }
  self->class_list = fl_value_ref(class_list);
  if (nullable_class_list != nullptr) {
    self->nullable_class_list = fl_value_ref(nullable_class_list);
  } else {
    self->nullable_class_list = nullptr;
  }
  self->class_map = fl_value_ref(class_map);
  if (nullable_class_map != nullptr) {
    self->nullable_class_map = fl_value_ref(nullable_class_map);
  } else {
    self->nullable_class_map = nullptr;
  }
  return self;
}

CoreTestsPigeonTestAllNullableTypes*
core_tests_pigeon_test_all_classes_wrapper_get_all_nullable_types(
    CoreTestsPigeonTestAllClassesWrapper* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_CLASSES_WRAPPER(self),
                       nullptr);
  return self->all_nullable_types;
}

CoreTestsPigeonTestAllNullableTypesWithoutRecursion*
core_tests_pigeon_test_all_classes_wrapper_get_all_nullable_types_without_recursion(
    CoreTestsPigeonTestAllClassesWrapper* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_CLASSES_WRAPPER(self),
                       nullptr);
  return self->all_nullable_types_without_recursion;
}

CoreTestsPigeonTestAllTypes*
core_tests_pigeon_test_all_classes_wrapper_get_all_types(
    CoreTestsPigeonTestAllClassesWrapper* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_CLASSES_WRAPPER(self),
                       nullptr);
  return self->all_types;
}

FlValue* core_tests_pigeon_test_all_classes_wrapper_get_class_list(
    CoreTestsPigeonTestAllClassesWrapper* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_CLASSES_WRAPPER(self),
                       nullptr);
  return self->class_list;
}

FlValue* core_tests_pigeon_test_all_classes_wrapper_get_nullable_class_list(
    CoreTestsPigeonTestAllClassesWrapper* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_CLASSES_WRAPPER(self),
                       nullptr);
  return self->nullable_class_list;
}

FlValue* core_tests_pigeon_test_all_classes_wrapper_get_class_map(
    CoreTestsPigeonTestAllClassesWrapper* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_CLASSES_WRAPPER(self),
                       nullptr);
  return self->class_map;
}

FlValue* core_tests_pigeon_test_all_classes_wrapper_get_nullable_class_map(
    CoreTestsPigeonTestAllClassesWrapper* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_ALL_CLASSES_WRAPPER(self),
                       nullptr);
  return self->nullable_class_map;
}

static FlValue* core_tests_pigeon_test_all_classes_wrapper_to_list(
    CoreTestsPigeonTestAllClassesWrapper* self) {
  FlValue* values = fl_value_new_list();
  fl_value_append_take(values, fl_value_new_custom_object(
                                   133, G_OBJECT(self->all_nullable_types)));
  fl_value_append_take(
      values,
      self->all_nullable_types_without_recursion != nullptr
          ? fl_value_new_custom_object(
                134, G_OBJECT(self->all_nullable_types_without_recursion))
          : fl_value_new_null());
  fl_value_append_take(
      values, self->all_types != nullptr
                  ? fl_value_new_custom_object(132, G_OBJECT(self->all_types))
                  : fl_value_new_null());
  fl_value_append_take(values, fl_value_ref(self->class_list));
  fl_value_append_take(values, self->nullable_class_list != nullptr
                                   ? fl_value_ref(self->nullable_class_list)
                                   : fl_value_new_null());
  fl_value_append_take(values, fl_value_ref(self->class_map));
  fl_value_append_take(values, self->nullable_class_map != nullptr
                                   ? fl_value_ref(self->nullable_class_map)
                                   : fl_value_new_null());
  return values;
}

static CoreTestsPigeonTestAllClassesWrapper*
core_tests_pigeon_test_all_classes_wrapper_new_from_list(FlValue* values) {
  FlValue* value0 = fl_value_get_list_value(values, 0);
  CoreTestsPigeonTestAllNullableTypes* all_nullable_types =
      CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES(
          fl_value_get_custom_value_object(value0));
  FlValue* value1 = fl_value_get_list_value(values, 1);
  CoreTestsPigeonTestAllNullableTypesWithoutRecursion*
      all_nullable_types_without_recursion = nullptr;
  if (fl_value_get_type(value1) != FL_VALUE_TYPE_NULL) {
    all_nullable_types_without_recursion =
        CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(
            fl_value_get_custom_value_object(value1));
  }
  FlValue* value2 = fl_value_get_list_value(values, 2);
  CoreTestsPigeonTestAllTypes* all_types = nullptr;
  if (fl_value_get_type(value2) != FL_VALUE_TYPE_NULL) {
    all_types = CORE_TESTS_PIGEON_TEST_ALL_TYPES(
        fl_value_get_custom_value_object(value2));
  }
  FlValue* value3 = fl_value_get_list_value(values, 3);
  FlValue* class_list = value3;
  FlValue* value4 = fl_value_get_list_value(values, 4);
  FlValue* nullable_class_list = nullptr;
  if (fl_value_get_type(value4) != FL_VALUE_TYPE_NULL) {
    nullable_class_list = value4;
  }
  FlValue* value5 = fl_value_get_list_value(values, 5);
  FlValue* class_map = value5;
  FlValue* value6 = fl_value_get_list_value(values, 6);
  FlValue* nullable_class_map = nullptr;
  if (fl_value_get_type(value6) != FL_VALUE_TYPE_NULL) {
    nullable_class_map = value6;
  }
  return core_tests_pigeon_test_all_classes_wrapper_new(
      all_nullable_types, all_nullable_types_without_recursion, all_types,
      class_list, nullable_class_list, class_map, nullable_class_map);
}

struct _CoreTestsPigeonTestTestMessage {
  GObject parent_instance;

  FlValue* test_list;
};

G_DEFINE_TYPE(CoreTestsPigeonTestTestMessage,
              core_tests_pigeon_test_test_message, G_TYPE_OBJECT)

static void core_tests_pigeon_test_test_message_dispose(GObject* object) {
  CoreTestsPigeonTestTestMessage* self =
      CORE_TESTS_PIGEON_TEST_TEST_MESSAGE(object);
  g_clear_pointer(&self->test_list, fl_value_unref);
  G_OBJECT_CLASS(core_tests_pigeon_test_test_message_parent_class)
      ->dispose(object);
}

static void core_tests_pigeon_test_test_message_init(
    CoreTestsPigeonTestTestMessage* self) {}

static void core_tests_pigeon_test_test_message_class_init(
    CoreTestsPigeonTestTestMessageClass* klass) {
  G_OBJECT_CLASS(klass)->dispose = core_tests_pigeon_test_test_message_dispose;
}

CoreTestsPigeonTestTestMessage* core_tests_pigeon_test_test_message_new(
    FlValue* test_list) {
  CoreTestsPigeonTestTestMessage* self = CORE_TESTS_PIGEON_TEST_TEST_MESSAGE(
      g_object_new(core_tests_pigeon_test_test_message_get_type(), nullptr));
  if (test_list != nullptr) {
    self->test_list = fl_value_ref(test_list);
  } else {
    self->test_list = nullptr;
  }
  return self;
}

FlValue* core_tests_pigeon_test_test_message_get_test_list(
    CoreTestsPigeonTestTestMessage* self) {
  g_return_val_if_fail(CORE_TESTS_PIGEON_TEST_IS_TEST_MESSAGE(self), nullptr);
  return self->test_list;
}

static FlValue* core_tests_pigeon_test_test_message_to_list(
    CoreTestsPigeonTestTestMessage* self) {
  FlValue* values = fl_value_new_list();
  fl_value_append_take(values, self->test_list != nullptr
                                   ? fl_value_ref(self->test_list)
                                   : fl_value_new_null());
  return values;
}

static CoreTestsPigeonTestTestMessage*
core_tests_pigeon_test_test_message_new_from_list(FlValue* values) {
  FlValue* value0 = fl_value_get_list_value(values, 0);
  FlValue* test_list = nullptr;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    test_list = value0;
  }
  return core_tests_pigeon_test_test_message_new(test_list);
}

struct _CoreTestsPigeonTestMessageCodec {
  FlStandardMessageCodec parent_instance;
};

G_DEFINE_TYPE(CoreTestsPigeonTestMessageCodec,
              core_tests_pigeon_test_message_codec,
              fl_standard_message_codec_get_type())

static gboolean
core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_an_enum(
    FlStandardMessageCodec* codec, GByteArray* buffer, FlValue* value,
    GError** error) {
  uint8_t type = 129;
  g_byte_array_append(buffer, &type, sizeof(uint8_t));
  return fl_standard_message_codec_write_value(codec, buffer, value, error);
}

static gboolean
core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_another_enum(
    FlStandardMessageCodec* codec, GByteArray* buffer, FlValue* value,
    GError** error) {
  uint8_t type = 130;
  g_byte_array_append(buffer, &type, sizeof(uint8_t));
  return fl_standard_message_codec_write_value(codec, buffer, value, error);
}

static gboolean
core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_unused_class(
    FlStandardMessageCodec* codec, GByteArray* buffer,
    CoreTestsPigeonTestUnusedClass* value, GError** error) {
  uint8_t type = 131;
  g_byte_array_append(buffer, &type, sizeof(uint8_t));
  g_autoptr(FlValue) values =
      core_tests_pigeon_test_unused_class_to_list(value);
  return fl_standard_message_codec_write_value(codec, buffer, values, error);
}

static gboolean
core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_all_types(
    FlStandardMessageCodec* codec, GByteArray* buffer,
    CoreTestsPigeonTestAllTypes* value, GError** error) {
  uint8_t type = 132;
  g_byte_array_append(buffer, &type, sizeof(uint8_t));
  g_autoptr(FlValue) values = core_tests_pigeon_test_all_types_to_list(value);
  return fl_standard_message_codec_write_value(codec, buffer, values, error);
}

static gboolean
core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_all_nullable_types(
    FlStandardMessageCodec* codec, GByteArray* buffer,
    CoreTestsPigeonTestAllNullableTypes* value, GError** error) {
  uint8_t type = 133;
  g_byte_array_append(buffer, &type, sizeof(uint8_t));
  g_autoptr(FlValue) values =
      core_tests_pigeon_test_all_nullable_types_to_list(value);
  return fl_standard_message_codec_write_value(codec, buffer, values, error);
}

static gboolean
core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_all_nullable_types_without_recursion(
    FlStandardMessageCodec* codec, GByteArray* buffer,
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* value,
    GError** error) {
  uint8_t type = 134;
  g_byte_array_append(buffer, &type, sizeof(uint8_t));
  g_autoptr(FlValue) values =
      core_tests_pigeon_test_all_nullable_types_without_recursion_to_list(
          value);
  return fl_standard_message_codec_write_value(codec, buffer, values, error);
}

static gboolean
core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_all_classes_wrapper(
    FlStandardMessageCodec* codec, GByteArray* buffer,
    CoreTestsPigeonTestAllClassesWrapper* value, GError** error) {
  uint8_t type = 135;
  g_byte_array_append(buffer, &type, sizeof(uint8_t));
  g_autoptr(FlValue) values =
      core_tests_pigeon_test_all_classes_wrapper_to_list(value);
  return fl_standard_message_codec_write_value(codec, buffer, values, error);
}

static gboolean
core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_test_message(
    FlStandardMessageCodec* codec, GByteArray* buffer,
    CoreTestsPigeonTestTestMessage* value, GError** error) {
  uint8_t type = 136;
  g_byte_array_append(buffer, &type, sizeof(uint8_t));
  g_autoptr(FlValue) values =
      core_tests_pigeon_test_test_message_to_list(value);
  return fl_standard_message_codec_write_value(codec, buffer, values, error);
}

static gboolean core_tests_pigeon_test_message_codec_write_value(
    FlStandardMessageCodec* codec, GByteArray* buffer, FlValue* value,
    GError** error) {
  if (fl_value_get_type(value) == FL_VALUE_TYPE_CUSTOM) {
    switch (fl_value_get_custom_type(value)) {
      case 129:
        return core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_an_enum(
            codec, buffer,
            reinterpret_cast<FlValue*>(
                const_cast<gpointer>(fl_value_get_custom_value(value))),
            error);
      case 130:
        return core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_another_enum(
            codec, buffer,
            reinterpret_cast<FlValue*>(
                const_cast<gpointer>(fl_value_get_custom_value(value))),
            error);
      case 131:
        return core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_unused_class(
            codec, buffer,
            CORE_TESTS_PIGEON_TEST_UNUSED_CLASS(
                fl_value_get_custom_value_object(value)),
            error);
      case 132:
        return core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_all_types(
            codec, buffer,
            CORE_TESTS_PIGEON_TEST_ALL_TYPES(
                fl_value_get_custom_value_object(value)),
            error);
      case 133:
        return core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_all_nullable_types(
            codec, buffer,
            CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES(
                fl_value_get_custom_value_object(value)),
            error);
      case 134:
        return core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_all_nullable_types_without_recursion(
            codec, buffer,
            CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(
                fl_value_get_custom_value_object(value)),
            error);
      case 135:
        return core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_all_classes_wrapper(
            codec, buffer,
            CORE_TESTS_PIGEON_TEST_ALL_CLASSES_WRAPPER(
                fl_value_get_custom_value_object(value)),
            error);
      case 136:
        return core_tests_pigeon_test_message_codec_write_core_tests_pigeon_test_test_message(
            codec, buffer,
            CORE_TESTS_PIGEON_TEST_TEST_MESSAGE(
                fl_value_get_custom_value_object(value)),
            error);
    }
  }

  return FL_STANDARD_MESSAGE_CODEC_CLASS(
             core_tests_pigeon_test_message_codec_parent_class)
      ->write_value(codec, buffer, value, error);
}

static FlValue*
core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_an_enum(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset,
    GError** error) {
  return fl_value_new_custom(
      129, fl_standard_message_codec_read_value(codec, buffer, offset, error),
      (GDestroyNotify)fl_value_unref);
}

static FlValue*
core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_another_enum(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset,
    GError** error) {
  return fl_value_new_custom(
      130, fl_standard_message_codec_read_value(codec, buffer, offset, error),
      (GDestroyNotify)fl_value_unref);
}

static FlValue*
core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_unused_class(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset,
    GError** error) {
  g_autoptr(FlValue) values =
      fl_standard_message_codec_read_value(codec, buffer, offset, error);
  if (values == nullptr) {
    return nullptr;
  }

  g_autoptr(CoreTestsPigeonTestUnusedClass) value =
      core_tests_pigeon_test_unused_class_new_from_list(values);
  if (value == nullptr) {
    g_set_error(error, FL_MESSAGE_CODEC_ERROR, FL_MESSAGE_CODEC_ERROR_FAILED,
                "Invalid data received for MessageData");
    return nullptr;
  }

  return fl_value_new_custom_object(131, G_OBJECT(value));
}

static FlValue*
core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_all_types(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset,
    GError** error) {
  g_autoptr(FlValue) values =
      fl_standard_message_codec_read_value(codec, buffer, offset, error);
  if (values == nullptr) {
    return nullptr;
  }

  g_autoptr(CoreTestsPigeonTestAllTypes) value =
      core_tests_pigeon_test_all_types_new_from_list(values);
  if (value == nullptr) {
    g_set_error(error, FL_MESSAGE_CODEC_ERROR, FL_MESSAGE_CODEC_ERROR_FAILED,
                "Invalid data received for MessageData");
    return nullptr;
  }

  return fl_value_new_custom_object(132, G_OBJECT(value));
}

static FlValue*
core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_all_nullable_types(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset,
    GError** error) {
  g_autoptr(FlValue) values =
      fl_standard_message_codec_read_value(codec, buffer, offset, error);
  if (values == nullptr) {
    return nullptr;
  }

  g_autoptr(CoreTestsPigeonTestAllNullableTypes) value =
      core_tests_pigeon_test_all_nullable_types_new_from_list(values);
  if (value == nullptr) {
    g_set_error(error, FL_MESSAGE_CODEC_ERROR, FL_MESSAGE_CODEC_ERROR_FAILED,
                "Invalid data received for MessageData");
    return nullptr;
  }

  return fl_value_new_custom_object(133, G_OBJECT(value));
}

static FlValue*
core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_all_nullable_types_without_recursion(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset,
    GError** error) {
  g_autoptr(FlValue) values =
      fl_standard_message_codec_read_value(codec, buffer, offset, error);
  if (values == nullptr) {
    return nullptr;
  }

  g_autoptr(CoreTestsPigeonTestAllNullableTypesWithoutRecursion) value =
      core_tests_pigeon_test_all_nullable_types_without_recursion_new_from_list(
          values);
  if (value == nullptr) {
    g_set_error(error, FL_MESSAGE_CODEC_ERROR, FL_MESSAGE_CODEC_ERROR_FAILED,
                "Invalid data received for MessageData");
    return nullptr;
  }

  return fl_value_new_custom_object(134, G_OBJECT(value));
}

static FlValue*
core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_all_classes_wrapper(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset,
    GError** error) {
  g_autoptr(FlValue) values =
      fl_standard_message_codec_read_value(codec, buffer, offset, error);
  if (values == nullptr) {
    return nullptr;
  }

  g_autoptr(CoreTestsPigeonTestAllClassesWrapper) value =
      core_tests_pigeon_test_all_classes_wrapper_new_from_list(values);
  if (value == nullptr) {
    g_set_error(error, FL_MESSAGE_CODEC_ERROR, FL_MESSAGE_CODEC_ERROR_FAILED,
                "Invalid data received for MessageData");
    return nullptr;
  }

  return fl_value_new_custom_object(135, G_OBJECT(value));
}

static FlValue*
core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_test_message(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset,
    GError** error) {
  g_autoptr(FlValue) values =
      fl_standard_message_codec_read_value(codec, buffer, offset, error);
  if (values == nullptr) {
    return nullptr;
  }

  g_autoptr(CoreTestsPigeonTestTestMessage) value =
      core_tests_pigeon_test_test_message_new_from_list(values);
  if (value == nullptr) {
    g_set_error(error, FL_MESSAGE_CODEC_ERROR, FL_MESSAGE_CODEC_ERROR_FAILED,
                "Invalid data received for MessageData");
    return nullptr;
  }

  return fl_value_new_custom_object(136, G_OBJECT(value));
}

static FlValue* core_tests_pigeon_test_message_codec_read_value_of_type(
    FlStandardMessageCodec* codec, GBytes* buffer, size_t* offset, int type,
    GError** error) {
  switch (type) {
    case 129:
      return core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_an_enum(
          codec, buffer, offset, error);
    case 130:
      return core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_another_enum(
          codec, buffer, offset, error);
    case 131:
      return core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_unused_class(
          codec, buffer, offset, error);
    case 132:
      return core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_all_types(
          codec, buffer, offset, error);
    case 133:
      return core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_all_nullable_types(
          codec, buffer, offset, error);
    case 134:
      return core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_all_nullable_types_without_recursion(
          codec, buffer, offset, error);
    case 135:
      return core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_all_classes_wrapper(
          codec, buffer, offset, error);
    case 136:
      return core_tests_pigeon_test_message_codec_read_core_tests_pigeon_test_test_message(
          codec, buffer, offset, error);
    default:
      return FL_STANDARD_MESSAGE_CODEC_CLASS(
                 core_tests_pigeon_test_message_codec_parent_class)
          ->read_value_of_type(codec, buffer, offset, type, error);
  }
}

static void core_tests_pigeon_test_message_codec_init(
    CoreTestsPigeonTestMessageCodec* self) {}

static void core_tests_pigeon_test_message_codec_class_init(
    CoreTestsPigeonTestMessageCodecClass* klass) {
  FL_STANDARD_MESSAGE_CODEC_CLASS(klass)->write_value =
      core_tests_pigeon_test_message_codec_write_value;
  FL_STANDARD_MESSAGE_CODEC_CLASS(klass)->read_value_of_type =
      core_tests_pigeon_test_message_codec_read_value_of_type;
}

static CoreTestsPigeonTestMessageCodec*
core_tests_pigeon_test_message_codec_new() {
  CoreTestsPigeonTestMessageCodec* self = CORE_TESTS_PIGEON_TEST_MESSAGE_CODEC(
      g_object_new(core_tests_pigeon_test_message_codec_get_type(), nullptr));
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle {
  GObject parent_instance;

  FlBasicMessageChannel* channel;
  FlBasicMessageChannelResponseHandle* response_handle;
};

G_DEFINE_TYPE(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle,
              core_tests_pigeon_test_host_integration_core_api_response_handle,
              G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_response_handle_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_RESPONSE_HANDLE(object);
  g_clear_object(&self->channel);
  g_clear_object(&self->response_handle);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_response_handle_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_response_handle_init(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_response_handle_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandleClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_response_handle_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle*
core_tests_pigeon_test_host_integration_core_api_response_handle_new(
    FlBasicMessageChannel* channel,
    FlBasicMessageChannelResponseHandle* response_handle) {
  CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_RESPONSE_HANDLE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_response_handle_get_type(),
          nullptr));
  self->channel = FL_BASIC_MESSAGE_CHANNEL(g_object_ref(channel));
  self->response_handle =
      FL_BASIC_MESSAGE_CHANNEL_RESPONSE_HANDLE(g_object_ref(response_handle));
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiNoopResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(CoreTestsPigeonTestHostIntegrationCoreApiNoopResponse,
              core_tests_pigeon_test_host_integration_core_api_noop_response,
              G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_noop_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiNoopResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_NOOP_RESPONSE(object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_noop_response_parent_class)
      ->dispose(object);
}

static void core_tests_pigeon_test_host_integration_core_api_noop_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiNoopResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_noop_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiNoopResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_noop_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiNoopResponse*
core_tests_pigeon_test_host_integration_core_api_noop_response_new() {
  CoreTestsPigeonTestHostIntegrationCoreApiNoopResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_NOOP_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_noop_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiNoopResponse*
core_tests_pigeon_test_host_integration_core_api_noop_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiNoopResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_NOOP_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_noop_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAllTypesResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAllTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_all_types_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_all_types_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAllTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ALL_TYPES_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_all_types_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_all_types_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAllTypesResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_all_types_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAllTypesResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_all_types_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoAllTypesResponse*
core_tests_pigeon_test_host_integration_core_api_echo_all_types_response_new(
    CoreTestsPigeonTestAllTypes* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAllTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ALL_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_all_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom_object(132, G_OBJECT(return_value)));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoAllTypesResponse*
core_tests_pigeon_test_host_integration_core_api_echo_all_types_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAllTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ALL_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_all_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorResponse,
    core_tests_pigeon_test_host_integration_core_api_throw_error_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_throw_error_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ERROR_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_throw_error_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_error_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_throw_error_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_throw_error_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorResponse*
core_tests_pigeon_test_host_integration_core_api_throw_error_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ERROR_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_error_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorResponse*
core_tests_pigeon_test_host_integration_core_api_throw_error_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ERROR_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_error_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorFromVoidResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorFromVoidResponse,
    core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorFromVoidResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ERROR_FROM_VOID_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorFromVoidResponse* self) {
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorFromVoidResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorFromVoidResponse*
core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_response_new() {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorFromVoidResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ERROR_FROM_VOID_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorFromVoidResponse*
core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorFromVoidResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ERROR_FROM_VOID_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiThrowFlutterErrorResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowFlutterErrorResponse,
    core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowFlutterErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_FLUTTER_ERROR_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowFlutterErrorResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowFlutterErrorResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiThrowFlutterErrorResponse*
core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowFlutterErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_FLUTTER_ERROR_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiThrowFlutterErrorResponse*
core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowFlutterErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_FLUTTER_ERROR_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoIntResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoIntResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_int_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_int_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_INT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_int_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_int_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoIntResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_int_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoIntResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_int_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_int_response_new(
    int64_t return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_INT_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_echo_int_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_int(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_int_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_INT_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_echo_int_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoDoubleResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoDoubleResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_double_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_double_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_DOUBLE_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_double_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_double_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoDoubleResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_double_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoDoubleResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_double_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_echo_double_response_new(
    double return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_float(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_echo_double_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoBoolResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoBoolResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_bool_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_bool_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_BOOL_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_bool_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_bool_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoBoolResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_bool_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoBoolResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_bool_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoBoolResponse*
core_tests_pigeon_test_host_integration_core_api_echo_bool_response_new(
    gboolean return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_BOOL_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_echo_bool_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_bool(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoBoolResponse*
core_tests_pigeon_test_host_integration_core_api_echo_bool_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_BOOL_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_echo_bool_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoStringResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoStringResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_string_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_string_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_STRING_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_string_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_string_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoStringResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_string_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoStringResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_string_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_string_response_new(
    const gchar* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_string_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoUint8ListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoUint8ListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_UINT8_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoUint8ListResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoUint8ListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_response_new(
    const uint8_t* return_value, size_t return_value_length) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value, fl_value_new_uint8_list(return_value, return_value_length));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoObjectResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoObjectResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_object_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_object_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_OBJECT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_object_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_object_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoObjectResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_object_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoObjectResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_object_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoObjectResponse*
core_tests_pigeon_test_host_integration_core_api_echo_object_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_OBJECT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_object_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoObjectResponse*
core_tests_pigeon_test_host_integration_core_api_echo_object_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_OBJECT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_object_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoListResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoListResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_LIST_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_echo_list_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_LIST_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_echo_list_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_enum_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_enum_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ENUM_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_enum_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_enum_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumListResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_enum_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumListResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_enum_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_enum_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_enum_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoClassListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_class_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_class_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_CLASS_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_class_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_class_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoClassListResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_class_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoClassListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_class_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_class_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_class_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_ENUM_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_CLASS_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoMapResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoMapResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_MAP_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_echo_map_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_MAP_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_echo_map_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoStringMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_string_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_string_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_STRING_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_string_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_string_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoStringMapResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_string_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoStringMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_string_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_string_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_string_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoIntMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_int_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_int_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_INT_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_int_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_int_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoIntMapResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_int_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoIntMapResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_int_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_int_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_int_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_enum_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_enum_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ENUM_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_enum_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_enum_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumMapResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_enum_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumMapResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_enum_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_enum_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_enum_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoClassMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_class_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_class_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_CLASS_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_class_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_class_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoClassMapResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_class_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoClassMapResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_class_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_class_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_class_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullStringMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_STRING_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullStringMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullStringMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullIntMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_INT_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullIntMapResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullIntMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_ENUM_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumMapResponse* self) {
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_CLASS_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NON_NULL_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoClassWrapperResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoClassWrapperResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoClassWrapperResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_CLASS_WRAPPER_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoClassWrapperResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoClassWrapperResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoClassWrapperResponse*
core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_response_new(
    CoreTestsPigeonTestAllClassesWrapper* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoClassWrapperResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_CLASS_WRAPPER_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom_object(135, G_OBJECT(return_value)));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoClassWrapperResponse*
core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoClassWrapperResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_CLASS_WRAPPER_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ENUM_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_enum_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_enum_response_new(
    CoreTestsPigeonTestAnEnum return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ENUM_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_echo_enum_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom(129, fl_value_new_int(return_value),
                                           (GDestroyNotify)fl_value_unref));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ENUM_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_echo_enum_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_another_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_ENUM_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_another_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherEnumResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherEnumResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_another_enum_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_another_enum_response_new(
    CoreTestsPigeonTestAnotherEnum return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_another_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom(130, fl_value_new_int(return_value),
                                           (GDestroyNotify)fl_value_unref));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_another_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_another_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedDefaultStringResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedDefaultStringResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedDefaultStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NAMED_DEFAULT_STRING_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedDefaultStringResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedDefaultStringResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedDefaultStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_response_new(
    const gchar* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedDefaultStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NAMED_DEFAULT_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedDefaultStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedDefaultStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NAMED_DEFAULT_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalDefaultDoubleResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalDefaultDoubleResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalDefaultDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_OPTIONAL_DEFAULT_DOUBLE_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalDefaultDoubleResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalDefaultDoubleResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalDefaultDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_response_new(
    double return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalDefaultDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_OPTIONAL_DEFAULT_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_float(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalDefaultDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalDefaultDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_OPTIONAL_DEFAULT_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoRequiredIntResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoRequiredIntResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_required_int_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_required_int_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoRequiredIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_REQUIRED_INT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_required_int_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_required_int_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoRequiredIntResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_required_int_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoRequiredIntResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_required_int_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoRequiredIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_required_int_response_new(
    int64_t return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoRequiredIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_REQUIRED_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_required_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_int(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoRequiredIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_required_int_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoRequiredIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_REQUIRED_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_required_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ALL_NULLABLE_TYPES_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesResponse*
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_response_new(
    CoreTestsPigeonTestAllNullableTypes* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ALL_NULLABLE_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value, return_value != nullptr
                       ? fl_value_new_custom_object(133, G_OBJECT(return_value))
                       : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesResponse*
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ALL_NULLABLE_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesWithoutRecursionResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesWithoutRecursionResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesWithoutRecursionResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ALL_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesWithoutRecursionResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesWithoutRecursionResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesWithoutRecursionResponse*
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_response_new(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesWithoutRecursionResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ALL_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value, return_value != nullptr
                       ? fl_value_new_custom_object(134, G_OBJECT(return_value))
                       : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesWithoutRecursionResponse*
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesWithoutRecursionResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ALL_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiExtractNestedNullableStringResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiExtractNestedNullableStringResponse,
    core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiExtractNestedNullableStringResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_EXTRACT_NESTED_NULLABLE_STRING_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiExtractNestedNullableStringResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiExtractNestedNullableStringResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiExtractNestedNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_response_new(
    const gchar* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiExtractNestedNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_EXTRACT_NESTED_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_string(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiExtractNestedNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiExtractNestedNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_EXTRACT_NESTED_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCreateNestedNullableStringResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCreateNestedNullableStringResponse,
    core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCreateNestedNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CREATE_NESTED_NULLABLE_STRING_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCreateNestedNullableStringResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCreateNestedNullableStringResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiCreateNestedNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_response_new(
    CoreTestsPigeonTestAllClassesWrapper* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCreateNestedNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CREATE_NESTED_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom_object(135, G_OBJECT(return_value)));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiCreateNestedNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCreateNestedNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CREATE_NESTED_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_SEND_MULTIPLE_NULLABLE_TYPES_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesResponse*
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_response_new(
    CoreTestsPigeonTestAllNullableTypes* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_SEND_MULTIPLE_NULLABLE_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom_object(133, G_OBJECT(return_value)));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesResponse*
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_SEND_MULTIPLE_NULLABLE_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesWithoutRecursionResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesWithoutRecursionResponse,
    core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesWithoutRecursionResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_SEND_MULTIPLE_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesWithoutRecursionResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesWithoutRecursionResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesWithoutRecursionResponse*
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_response_new(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesWithoutRecursionResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_SEND_MULTIPLE_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom_object(134, G_OBJECT(return_value)));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesWithoutRecursionResponse*
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesWithoutRecursionResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_SEND_MULTIPLE_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_INT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_response_new(
    int64_t* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_int(*return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableDoubleResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableDoubleResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_DOUBLE_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableDoubleResponse* self) {
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableDoubleResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_response_new(
    double* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_float(*return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableBoolResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableBoolResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_BOOL_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableBoolResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableBoolResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableBoolResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_response_new(
    gboolean* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_BOOL_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_bool(*return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableBoolResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_BOOL_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_STRING_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringResponse* self) {
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_response_new(
    const gchar* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_string(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableUint8ListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableUint8ListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_UINT8_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableUint8ListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableUint8ListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_response_new(
    const uint8_t* return_value, size_t return_value_length) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_uint8_list(
                                              return_value, return_value_length)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableObjectResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableObjectResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_OBJECT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableObjectResponse* self) {
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableObjectResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableObjectResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_OBJECT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableObjectResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_OBJECT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableListResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_ENUM_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_CLASS_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumListResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_ENUM_LIST_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassListResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_CLASS_LIST_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableMapResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_STRING_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_INT_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntMapResponse* self) {
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_ENUM_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_CLASS_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullStringMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullStringMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_STRING_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullStringMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullStringMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullIntMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_INT_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullIntMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullIntMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_ENUM_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_CLASS_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_NON_NULL_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_ENUM_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_response_new(
    CoreTestsPigeonTestAnEnum* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value,
      return_value != nullptr
          ? fl_value_new_custom(129, fl_value_new_int(*return_value),
                                (GDestroyNotify)fl_value_unref)
          : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherNullableEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherNullableEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_NULLABLE_ENUM_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherNullableEnumResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherNullableEnumResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_response_new(
    CoreTestsPigeonTestAnotherEnum* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value,
      return_value != nullptr
          ? fl_value_new_custom(130, fl_value_new_int(*return_value),
                                (GDestroyNotify)fl_value_unref)
          : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalNullableIntResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalNullableIntResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_OPTIONAL_NULLABLE_INT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalNullableIntResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalNullableIntResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalNullableIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_response_new(
    int64_t* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_OPTIONAL_NULLABLE_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_int(*return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalNullableIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_OPTIONAL_NULLABLE_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedNullableStringResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedNullableStringResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NAMED_NULLABLE_STRING_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedNullableStringResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedNullableStringResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_response_new(
    const gchar* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NAMED_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_string(return_value)
                                        : fl_value_new_null());
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_NAMED_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponse,
    core_tests_pigeon_test_host_integration_core_api_noop_async_response,
    CORE_TESTS_PIGEON_TEST, HOST_INTEGRATION_CORE_API_NOOP_ASYNC_RESPONSE,
    GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponse,
    core_tests_pigeon_test_host_integration_core_api_noop_async_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_noop_async_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_NOOP_ASYNC_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_noop_async_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_noop_async_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_noop_async_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_noop_async_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponse*
core_tests_pigeon_test_host_integration_core_api_noop_async_response_new() {
  CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_NOOP_ASYNC_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_noop_async_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponse*
core_tests_pigeon_test_host_integration_core_api_noop_async_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_NOOP_ASYNC_RESPONSE(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_noop_async_response_get_type(),
          nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_int_response,
    CORE_TESTS_PIGEON_TEST, HOST_INTEGRATION_CORE_API_ECHO_ASYNC_INT_RESPONSE,
    GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_int_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_int_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_INT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_int_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_int_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_int_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_int_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_int_response_new(
    int64_t return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_int(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_int_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_double_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_DOUBLE_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_double_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_double_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_DOUBLE_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_double_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_double_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_double_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_double_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_double_response_new(
    double return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_float(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_double_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response,
    CORE_TESTS_PIGEON_TEST, HOST_INTEGRATION_CORE_API_ECHO_ASYNC_BOOL_RESPONSE,
    GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_BOOL_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response_new(
    gboolean return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_BOOL_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_bool(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_BOOL_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_string_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_STRING_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_string_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_string_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_STRING_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_string_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_string_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_string_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_string_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_string_response_new(
    const gchar* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_string_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_UINT8_LIST_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_UINT8_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponse* self) {
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response_new(
    const uint8_t* return_value, size_t return_value_length) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value, fl_value_new_uint8_list(return_value, return_value_length));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_object_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_OBJECT_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_object_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_object_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_OBJECT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_object_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_object_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_object_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_object_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_object_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_OBJECT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_object_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_object_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_OBJECT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_object_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_list_response,
    CORE_TESTS_PIGEON_TEST, HOST_INTEGRATION_CORE_API_ECHO_ASYNC_LIST_RESPONSE,
    GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_LIST_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_CLASS_LIST_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_CLASS_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponse* self) {
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_map_response,
    CORE_TESTS_PIGEON_TEST, HOST_INTEGRATION_CORE_API_ECHO_ASYNC_MAP_RESPONSE,
    GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponseClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_STRING_MAP_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_STRING_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponse* self) {
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_INT_MAP_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_INT_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_MAP_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_CLASS_MAP_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_CLASS_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response,
    CORE_TESTS_PIGEON_TEST, HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_RESPONSE,
    GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response_new(
    CoreTestsPigeonTestAnEnum return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom(129, fl_value_new_int(return_value),
                                           (GDestroyNotify)fl_value_unref));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_ASYNC_ENUM_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_ASYNC_ENUM_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response_new(
    CoreTestsPigeonTestAnotherEnum return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_ASYNC_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom(130, fl_value_new_int(return_value),
                                           (GDestroyNotify)fl_value_unref));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_ASYNC_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponse,
    core_tests_pigeon_test_host_integration_core_api_throw_async_error_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_THROW_ASYNC_ERROR_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponse,
    core_tests_pigeon_test_host_integration_core_api_throw_async_error_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_error_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ASYNC_ERROR_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_throw_async_error_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_error_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_error_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_throw_async_error_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponse*
core_tests_pigeon_test_host_integration_core_api_throw_async_error_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ASYNC_ERROR_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_async_error_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponse*
core_tests_pigeon_test_host_integration_core_api_throw_async_error_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ASYNC_ERROR_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_async_error_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponse,
    core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_THROW_ASYNC_ERROR_FROM_VOID_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponse,
    core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ASYNC_ERROR_FROM_VOID_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponse*
core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response_new() {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ASYNC_ERROR_FROM_VOID_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponse*
core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ASYNC_ERROR_FROM_VOID_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponse,
    core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_THROW_ASYNC_FLUTTER_ERROR_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponse,
    core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ASYNC_FLUTTER_ERROR_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponse*
core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ASYNC_FLUTTER_ERROR_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponse*
core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_THROW_ASYNC_FLUTTER_ERROR_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncAllTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ALL_TYPES_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncAllTypesResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncAllTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncAllTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ALL_TYPES_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncAllTypesResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncAllTypesResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncAllTypesResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_response_new(
    CoreTestsPigeonTestAllTypes* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncAllTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ALL_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom_object(132, G_OBJECT(return_value)));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncAllTypesResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncAllTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_ALL_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ALL_NULLABLE_TYPES_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ALL_NULLABLE_TYPES_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_response_new(
    CoreTestsPigeonTestAllNullableTypes* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ALL_NULLABLE_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value, return_value != nullptr
                       ? fl_value_new_custom_object(133, G_OBJECT(return_value))
                       : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ALL_NULLABLE_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesWithoutRecursionResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ALL_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesWithoutRecursionResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesWithoutRecursionResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesWithoutRecursionResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ALL_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesWithoutRecursionResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesWithoutRecursionResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesWithoutRecursionResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_response_new(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesWithoutRecursionResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ALL_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value, return_value != nullptr
                       ? fl_value_new_custom_object(134, G_OBJECT(return_value))
                       : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesWithoutRecursionResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableAllNullableTypesWithoutRecursionResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ALL_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_INT_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_INT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_response_new(
    int64_t* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_int(*return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableDoubleResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_DOUBLE_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableDoubleResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableDoubleResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_DOUBLE_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableDoubleResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableDoubleResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_response_new(
    double* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_float(*return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableBoolResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_BOOL_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableBoolResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableBoolResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_BOOL_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableBoolResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableBoolResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableBoolResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_response_new(
    gboolean* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_BOOL_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_bool(*return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableBoolResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_BOOL_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_STRING_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_STRING_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_response_new(
    const gchar* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_string(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableUint8ListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_UINT8_LIST_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableUint8ListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableUint8ListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_UINT8_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableUint8ListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableUint8ListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_response_new(
    const uint8_t* return_value, size_t return_value_length) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_uint8_list(
                                              return_value, return_value_length)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableObjectResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_OBJECT_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableObjectResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableObjectResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_OBJECT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableObjectResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableObjectResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableObjectResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_OBJECT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableObjectResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableObjectResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_OBJECT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_LIST_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_LIST_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_CLASS_LIST_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_CLASS_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassListResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_MAP_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_STRING_MAP_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_STRING_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_INT_MAP_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_INT_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_MAP_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_CLASS_MAP_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_CLASS_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_response_new(
    CoreTestsPigeonTestAnEnum* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value,
      return_value != nullptr
          ? fl_value_new_custom(129, fl_value_new_int(*return_value),
                                (GDestroyNotify)fl_value_unref)
          : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ASYNC_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncNullableEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_ASYNC_NULLABLE_ENUM_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncNullableEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncNullableEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncNullableEnumResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_ASYNC_NULLABLE_ENUM_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncNullableEnumResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncNullableEnumResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_response_new(
    CoreTestsPigeonTestAnotherEnum* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_ASYNC_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value,
      return_value != nullptr
          ? fl_value_new_custom(130, fl_value_new_int(*return_value),
                                (GDestroyNotify)fl_value_unref)
          : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_ECHO_ANOTHER_ASYNC_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApiDefaultIsMainThreadResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiDefaultIsMainThreadResponse,
    core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiDefaultIsMainThreadResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_DEFAULT_IS_MAIN_THREAD_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiDefaultIsMainThreadResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiDefaultIsMainThreadResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiDefaultIsMainThreadResponse*
core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_response_new(
    gboolean return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiDefaultIsMainThreadResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_DEFAULT_IS_MAIN_THREAD_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_bool(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiDefaultIsMainThreadResponse*
core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiDefaultIsMainThreadResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_DEFAULT_IS_MAIN_THREAD_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiTaskQueueIsBackgroundThreadResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiTaskQueueIsBackgroundThreadResponse,
    core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiTaskQueueIsBackgroundThreadResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_TASK_QUEUE_IS_BACKGROUND_THREAD_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiTaskQueueIsBackgroundThreadResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiTaskQueueIsBackgroundThreadResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_response_dispose;
}

CoreTestsPigeonTestHostIntegrationCoreApiTaskQueueIsBackgroundThreadResponse*
core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_response_new(
    gboolean return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiTaskQueueIsBackgroundThreadResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_TASK_QUEUE_IS_BACKGROUND_THREAD_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_bool(return_value));
  return self;
}

CoreTestsPigeonTestHostIntegrationCoreApiTaskQueueIsBackgroundThreadResponse*
core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiTaskQueueIsBackgroundThreadResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_TASK_QUEUE_IS_BACKGROUND_THREAD_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterNoopResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_NOOP_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterNoopResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterNoopResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterNoopResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_NOOP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterNoopResponse* self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterNoopResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterNoopResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_response_new() {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterNoopResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_NOOP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterNoopResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterNoopResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_NOOP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_THROW_ERROR_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_THROW_ERROR_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_THROW_ERROR_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_THROW_ERROR_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorFromVoidResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_THROW_ERROR_FROM_VOID_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorFromVoidResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorFromVoidResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorFromVoidResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_THROW_ERROR_FROM_VOID_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorFromVoidResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorFromVoidResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorFromVoidResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_response_new() {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorFromVoidResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_THROW_ERROR_FROM_VOID_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorFromVoidResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterThrowErrorFromVoidResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_THROW_ERROR_FROM_VOID_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_TYPES_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllTypesResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_TYPES_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllTypesResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllTypesResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllTypesResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_response_new(
    CoreTestsPigeonTestAllTypes* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom_object(132, G_OBJECT(return_value)));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllTypesResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllTypesResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_NULLABLE_TYPES_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_NULLABLE_TYPES_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_response_new(
    CoreTestsPigeonTestAllNullableTypes* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_NULLABLE_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value, return_value != nullptr
                       ? fl_value_new_custom_object(133, G_OBJECT(return_value))
                       : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_NULLABLE_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SEND_MULTIPLE_NULLABLE_TYPES_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SEND_MULTIPLE_NULLABLE_TYPES_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_response_new(
    CoreTestsPigeonTestAllNullableTypes* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SEND_MULTIPLE_NULLABLE_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom_object(133, G_OBJECT(return_value)));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SEND_MULTIPLE_NULLABLE_TYPES_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesWithoutRecursionResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesWithoutRecursionResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesWithoutRecursionResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesWithoutRecursionResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesWithoutRecursionResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesWithoutRecursionResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesWithoutRecursionResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_response_new(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesWithoutRecursionResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value, return_value != nullptr
                       ? fl_value_new_custom_object(134, G_OBJECT(return_value))
                       : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesWithoutRecursionResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAllNullableTypesWithoutRecursionResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ALL_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesWithoutRecursionResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SEND_MULTIPLE_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesWithoutRecursionResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesWithoutRecursionResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesWithoutRecursionResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SEND_MULTIPLE_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesWithoutRecursionResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesWithoutRecursionResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesWithoutRecursionResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_response_new(
    CoreTestsPigeonTestAllNullableTypesWithoutRecursion* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesWithoutRecursionResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SEND_MULTIPLE_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom_object(134, G_OBJECT(return_value)));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesWithoutRecursionResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSendMultipleNullableTypesWithoutRecursionResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SEND_MULTIPLE_NULLABLE_TYPES_WITHOUT_RECURSION_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoBoolResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_BOOL_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoBoolResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoBoolResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_BOOL_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoBoolResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoBoolResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoBoolResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_response_new(
    gboolean return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_BOOL_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_bool(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoBoolResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_BOOL_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_INT_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_INT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntResponse* self) {
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_response_new(
    int64_t return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_int(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoDoubleResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_DOUBLE_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoDoubleResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoDoubleResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_DOUBLE_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoDoubleResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoDoubleResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_response_new(
    double return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_float(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_STRING_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_STRING_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_response_new(
    const gchar* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoUint8ListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_UINT8_LIST_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoUint8ListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoUint8ListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_UINT8_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoUint8ListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoUint8ListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_response_new(
    const uint8_t* return_value, size_t return_value_length) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value, fl_value_new_uint8_list(return_value, return_value_length));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoUint8ListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_LIST_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_LIST_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_CLASS_LIST_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_CLASS_LIST_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_ENUM_LIST_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumListResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_ENUM_LIST_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_CLASS_LIST_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassListResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_CLASS_LIST_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_MAP_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoMapResponse* self) {
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_STRING_MAP_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_STRING_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoStringMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_INT_MAP_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_INT_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_MAP_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_CLASS_MAP_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_CLASS_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoClassMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_STRING_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullStringMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullStringMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_STRING_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullStringMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullStringMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullStringMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullStringMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_INT_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullIntMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullIntMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_INT_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullIntMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullIntMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_ENUM_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_ENUM_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullEnumMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_CLASS_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_CLASS_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_ref(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNonNullClassMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NON_NULL_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_RESPONSE, GObject)

struct _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_response_new(
    CoreTestsPigeonTestAnEnum return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom(129, fl_value_new_int(return_value),
                                           (GDestroyNotify)fl_value_unref));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ANOTHER_ENUM_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ANOTHER_ENUM_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherEnumResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherEnumResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherEnumResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_response_new(
    CoreTestsPigeonTestAnotherEnum return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ANOTHER_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value,
                       fl_value_new_custom(130, fl_value_new_int(return_value),
                                           (GDestroyNotify)fl_value_unref));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherEnumResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ANOTHER_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableBoolResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_BOOL_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableBoolResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableBoolResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableBoolResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_BOOL_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableBoolResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableBoolResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableBoolResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_response_new(
    gboolean* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_BOOL_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_bool(*return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableBoolResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableBoolResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_BOOL_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_INT_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_INT_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_response_new(
    int64_t* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_int(*return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_INT_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableDoubleResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_DOUBLE_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableDoubleResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableDoubleResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableDoubleResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_DOUBLE_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableDoubleResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableDoubleResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_response_new(
    double* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_float(*return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableDoubleResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableDoubleResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_DOUBLE_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_STRING_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_STRING_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_response_new(
    const gchar* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_string(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableUint8ListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_UINT8_LIST_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableUint8ListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableUint8ListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableUint8ListResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_UINT8_LIST_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableUint8ListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableUint8ListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_response_new(
    const uint8_t* return_value, size_t return_value_length) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableUint8ListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_new_uint8_list(
                                              return_value, return_value_length)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableUint8ListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableUint8ListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_UINT8_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_LIST_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableListResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_LIST_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableListResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_LIST_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumListResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_LIST_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_CLASS_LIST_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassListResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_CLASS_LIST_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_ENUM_LIST_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumListResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_ENUM_LIST_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_ENUM_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_CLASS_LIST_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassListResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassListResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassListResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_CLASS_LIST_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassListResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassListResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassListResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassListResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_CLASS_LIST_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_MAP_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_MAP_RESPONSE(
          object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_STRING_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_STRING_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableStringMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_INT_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_INT_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableIntMapResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_CLASS_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_CLASS_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableClassMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_STRING_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullStringMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullStringMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullStringMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_STRING_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullStringMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullStringMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullStringMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullStringMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullStringMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_STRING_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_INT_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullIntMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullIntMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullIntMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_INT_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullIntMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullIntMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullIntMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullIntMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullIntMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_INT_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_ENUM_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_ENUM_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullEnumMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_ENUM_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_CLASS_MAP_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassMapResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassMapResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassMapResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_CLASS_MAP_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassMapResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassMapResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_response_new(
    FlValue* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, return_value != nullptr
                                        ? fl_value_ref(return_value)
                                        : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassMapResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableNonNullClassMapResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_NON_NULL_CLASS_MAP_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_RESPONSE, GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_response_new(
    CoreTestsPigeonTestAnEnum* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value,
      return_value != nullptr
          ? fl_value_new_custom(129, fl_value_new_int(*return_value),
                                (GDestroyNotify)fl_value_unref)
          : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoNullableEnumResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherNullableEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ANOTHER_NULLABLE_ENUM_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherNullableEnumResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherNullableEnumResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherNullableEnumResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ANOTHER_NULLABLE_ENUM_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherNullableEnumResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherNullableEnumResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_response_new(
    CoreTestsPigeonTestAnotherEnum* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherNullableEnumResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ANOTHER_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(
      self->value,
      return_value != nullptr
          ? fl_value_new_custom(130, fl_value_new_int(*return_value),
                                (GDestroyNotify)fl_value_unref)
          : fl_value_new_null());
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherNullableEnumResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterEchoAnotherNullableEnumResponse*
      self = CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_ECHO_ANOTHER_NULLABLE_ENUM_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

G_DECLARE_FINAL_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSmallApiEchoStringResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_response,
    CORE_TESTS_PIGEON_TEST,
    HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SMALL_API_ECHO_STRING_RESPONSE,
    GObject)

struct
    _CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSmallApiEchoStringResponse {
  GObject parent_instance;

  FlValue* value;
};

G_DEFINE_TYPE(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSmallApiEchoStringResponse,
    core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_response,
    G_TYPE_OBJECT)

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_response_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSmallApiEchoStringResponse*
      self =
          CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SMALL_API_ECHO_STRING_RESPONSE(
              object);
  g_clear_pointer(&self->value, fl_value_unref);
  G_OBJECT_CLASS(
      core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_response_parent_class)
      ->dispose(object);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_response_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSmallApiEchoStringResponse*
        self) {}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_response_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSmallApiEchoStringResponseClass*
        klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_response_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSmallApiEchoStringResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_response_new(
    const gchar* return_value) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSmallApiEchoStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SMALL_API_ECHO_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(return_value));
  return self;
}

static CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSmallApiEchoStringResponse*
core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_response_new_error(
    const gchar* code, const gchar* message, FlValue* details) {
  CoreTestsPigeonTestHostIntegrationCoreApiCallFlutterSmallApiEchoStringResponse* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API_CALL_FLUTTER_SMALL_API_ECHO_STRING_RESPONSE(
          g_object_new(
              core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_response_get_type(),
              nullptr));
  self->value = fl_value_new_list();
  fl_value_append_take(self->value, fl_value_new_string(code));
  fl_value_append_take(self->value,
                       fl_value_new_string(message != nullptr ? message : ""));
  fl_value_append_take(self->value, details != nullptr ? fl_value_ref(details)
                                                       : fl_value_new_null());
  return self;
}

struct _CoreTestsPigeonTestHostIntegrationCoreApi {
  GObject parent_instance;

  const CoreTestsPigeonTestHostIntegrationCoreApiVTable* vtable;
  gpointer user_data;
  GDestroyNotify user_data_free_func;
};

G_DEFINE_TYPE(CoreTestsPigeonTestHostIntegrationCoreApi,
              core_tests_pigeon_test_host_integration_core_api, G_TYPE_OBJECT)

static void core_tests_pigeon_test_host_integration_core_api_dispose(
    GObject* object) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(object);
  if (self->user_data != nullptr) {
    self->user_data_free_func(self->user_data);
  }
  self->user_data = nullptr;
  G_OBJECT_CLASS(core_tests_pigeon_test_host_integration_core_api_parent_class)
      ->dispose(object);
}

static void core_tests_pigeon_test_host_integration_core_api_init(
    CoreTestsPigeonTestHostIntegrationCoreApi* self) {}

static void core_tests_pigeon_test_host_integration_core_api_class_init(
    CoreTestsPigeonTestHostIntegrationCoreApiClass* klass) {
  G_OBJECT_CLASS(klass)->dispose =
      core_tests_pigeon_test_host_integration_core_api_dispose;
}

static CoreTestsPigeonTestHostIntegrationCoreApi*
core_tests_pigeon_test_host_integration_core_api_new(
    const CoreTestsPigeonTestHostIntegrationCoreApiVTable* vtable,
    gpointer user_data, GDestroyNotify user_data_free_func) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(g_object_new(
          core_tests_pigeon_test_host_integration_core_api_get_type(),
          nullptr));
  self->vtable = vtable;
  self->user_data = user_data;
  self->user_data_free_func = user_data_free_func;
  return self;
}

static void core_tests_pigeon_test_host_integration_core_api_noop_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->noop == nullptr) {
    return;
  }

  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiNoopResponse) response =
      self->vtable->noop(self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "noop");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "noop", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_all_types_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_all_types == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAllTypes* everything = CORE_TESTS_PIGEON_TEST_ALL_TYPES(
      fl_value_get_custom_value_object(value0));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoAllTypesResponse)
      response = self->vtable->echo_all_types(everything, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoAllTypes");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAllTypes", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_throw_error_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->throw_error == nullptr) {
    return;
  }

  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorResponse)
      response = self->vtable->throw_error(self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "throwError");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "throwError", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->throw_error_from_void == nullptr) {
    return;
  }

  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiThrowErrorFromVoidResponse)
      response = self->vtable->throw_error_from_void(self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "throwErrorFromVoid");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "throwErrorFromVoid", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->throw_flutter_error == nullptr) {
    return;
  }

  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiThrowFlutterErrorResponse)
      response = self->vtable->throw_flutter_error(self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "throwFlutterError");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "throwFlutterError", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_int_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_int == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  int64_t an_int = fl_value_get_int(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoIntResponse) response =
      self->vtable->echo_int(an_int, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoInt");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoInt", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_double_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_double == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  double a_double = fl_value_get_float(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoDoubleResponse)
      response = self->vtable->echo_double(a_double, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoDouble");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoDouble", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_bool_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_bool == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  gboolean a_bool = fl_value_get_bool(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoBoolResponse)
      response = self->vtable->echo_bool(a_bool, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoBool");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoBool", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_string_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_string == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const gchar* a_string = fl_value_get_string(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoStringResponse)
      response = self->vtable->echo_string(a_string, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoString");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoString", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_uint8_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const uint8_t* a_uint8_list = fl_value_get_uint8_list(value0);
  size_t a_uint8_list_length = fl_value_get_length(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoUint8ListResponse)
      response = self->vtable->echo_uint8_list(
          a_uint8_list, a_uint8_list_length, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoUint8List");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoUint8List", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_object_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_object == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* an_object = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoObjectResponse)
      response = self->vtable->echo_object(an_object, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoObject");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoObject", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoListResponse)
      response = self->vtable->echo_list(list, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoList");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoList", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_enum_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_enum_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumListResponse)
      response = self->vtable->echo_enum_list(enum_list, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoEnumList");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoEnumList", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_class_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_class_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoClassListResponse)
      response = self->vtable->echo_class_list(class_list, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoClassList");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoClassList", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_non_null_enum_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_list = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumListResponse)
      response =
          self->vtable->echo_non_null_enum_list(enum_list, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNonNullEnumList");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNonNullEnumList", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_non_null_class_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_list = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassListResponse)
      response =
          self->vtable->echo_non_null_class_list(class_list, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNonNullClassList");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNonNullClassList", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoMapResponse) response =
      self->vtable->echo_map(map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoMap", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_string_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_string_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* string_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoStringMapResponse)
      response = self->vtable->echo_string_map(string_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoStringMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoStringMap", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_int_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_int_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* int_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoIntMapResponse)
      response = self->vtable->echo_int_map(int_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoIntMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoIntMap", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_enum_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_enum_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumMapResponse)
      response = self->vtable->echo_enum_map(enum_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoEnumMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoEnumMap", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_class_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_class_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoClassMapResponse)
      response = self->vtable->echo_class_map(class_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoClassMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoClassMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_non_null_string_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* string_map = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullStringMapResponse)
      response =
          self->vtable->echo_non_null_string_map(string_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNonNullStringMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNonNullStringMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_non_null_int_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* int_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullIntMapResponse)
      response = self->vtable->echo_non_null_int_map(int_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNonNullIntMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNonNullIntMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_non_null_enum_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullEnumMapResponse)
      response =
          self->vtable->echo_non_null_enum_map(enum_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNonNullEnumMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNonNullEnumMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_non_null_class_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_map = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNonNullClassMapResponse)
      response =
          self->vtable->echo_non_null_class_map(class_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNonNullClassMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNonNullClassMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_class_wrapper == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAllClassesWrapper* wrapper =
      CORE_TESTS_PIGEON_TEST_ALL_CLASSES_WRAPPER(
          fl_value_get_custom_value_object(value0));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoClassWrapperResponse)
      response = self->vtable->echo_class_wrapper(wrapper, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoClassWrapper");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoClassWrapper", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_echo_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnEnum an_enum = static_cast<CoreTestsPigeonTestAnEnum>(
      fl_value_get_int(reinterpret_cast<FlValue*>(
          const_cast<gpointer>(fl_value_get_custom_value(value0)))));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoEnumResponse)
      response = self->vtable->echo_enum(an_enum, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoEnum");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoEnum", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_another_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnotherEnum another_enum =
      static_cast<CoreTestsPigeonTestAnotherEnum>(
          fl_value_get_int(reinterpret_cast<FlValue*>(
              const_cast<gpointer>(fl_value_get_custom_value(value0)))));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherEnumResponse)
      response = self->vtable->echo_another_enum(another_enum, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoAnotherEnum");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAnotherEnum", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_named_default_string == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const gchar* a_string = fl_value_get_string(value0);
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedDefaultStringResponse)
      response =
          self->vtable->echo_named_default_string(a_string, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNamedDefaultString");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNamedDefaultString", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_optional_default_double == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  double a_double = fl_value_get_float(value0);
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalDefaultDoubleResponse)
      response =
          self->vtable->echo_optional_default_double(a_double, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoOptionalDefaultDouble");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoOptionalDefaultDouble", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_required_int_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_required_int == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  int64_t an_int = fl_value_get_int(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoRequiredIntResponse)
      response = self->vtable->echo_required_int(an_int, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoRequiredInt");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoRequiredInt", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_all_nullable_types == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAllNullableTypes* everything =
      CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES(
          fl_value_get_custom_value_object(value0));
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesResponse)
      response =
          self->vtable->echo_all_nullable_types(everything, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoAllNullableTypes");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAllNullableTypes", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_all_nullable_types_without_recursion == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAllNullableTypesWithoutRecursion* everything =
      CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(
          fl_value_get_custom_value_object(value0));
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAllNullableTypesWithoutRecursionResponse)
      response = self->vtable->echo_all_nullable_types_without_recursion(
          everything, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoAllNullableTypesWithoutRecursion");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAllNullableTypesWithoutRecursion", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->extract_nested_nullable_string == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAllClassesWrapper* wrapper =
      CORE_TESTS_PIGEON_TEST_ALL_CLASSES_WRAPPER(
          fl_value_get_custom_value_object(value0));
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiExtractNestedNullableStringResponse)
      response = self->vtable->extract_nested_nullable_string(wrapper,
                                                              self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "extractNestedNullableString");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "extractNestedNullableString", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->create_nested_nullable_string == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const gchar* nullable_string = fl_value_get_string(value0);
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiCreateNestedNullableStringResponse)
      response = self->vtable->create_nested_nullable_string(nullable_string,
                                                             self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "createNestedNullableString");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "createNestedNullableString", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->send_multiple_nullable_types == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  gboolean* a_nullable_bool = nullptr;
  gboolean a_nullable_bool_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_nullable_bool_value = fl_value_get_bool(value0);
    a_nullable_bool = &a_nullable_bool_value;
  }
  FlValue* value1 = fl_value_get_list_value(message_, 1);
  int64_t* a_nullable_int = nullptr;
  int64_t a_nullable_int_value;
  if (fl_value_get_type(value1) != FL_VALUE_TYPE_NULL) {
    a_nullable_int_value = fl_value_get_int(value1);
    a_nullable_int = &a_nullable_int_value;
  }
  FlValue* value2 = fl_value_get_list_value(message_, 2);
  const gchar* a_nullable_string = fl_value_get_string(value2);
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesResponse)
      response = self->vtable->send_multiple_nullable_types(
          a_nullable_bool, a_nullable_int, a_nullable_string, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "sendMultipleNullableTypes");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "sendMultipleNullableTypes", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->send_multiple_nullable_types_without_recursion == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  gboolean* a_nullable_bool = nullptr;
  gboolean a_nullable_bool_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_nullable_bool_value = fl_value_get_bool(value0);
    a_nullable_bool = &a_nullable_bool_value;
  }
  FlValue* value1 = fl_value_get_list_value(message_, 1);
  int64_t* a_nullable_int = nullptr;
  int64_t a_nullable_int_value;
  if (fl_value_get_type(value1) != FL_VALUE_TYPE_NULL) {
    a_nullable_int_value = fl_value_get_int(value1);
    a_nullable_int = &a_nullable_int_value;
  }
  FlValue* value2 = fl_value_get_list_value(message_, 2);
  const gchar* a_nullable_string = fl_value_get_string(value2);
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiSendMultipleNullableTypesWithoutRecursionResponse)
      response = self->vtable->send_multiple_nullable_types_without_recursion(
          a_nullable_bool, a_nullable_int, a_nullable_string, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "sendMultipleNullableTypesWithoutRecursion");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "sendMultipleNullableTypesWithoutRecursion", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_nullable_int == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  int64_t* a_nullable_int = nullptr;
  int64_t a_nullable_int_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_nullable_int_value = fl_value_get_int(value0);
    a_nullable_int = &a_nullable_int_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntResponse)
      response =
          self->vtable->echo_nullable_int(a_nullable_int, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableInt");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableInt", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_double == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  double* a_nullable_double = nullptr;
  double a_nullable_double_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_nullable_double_value = fl_value_get_float(value0);
    a_nullable_double = &a_nullable_double_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableDoubleResponse)
      response = self->vtable->echo_nullable_double(a_nullable_double,
                                                    self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableDouble");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableDouble", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_nullable_bool == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  gboolean* a_nullable_bool = nullptr;
  gboolean a_nullable_bool_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_nullable_bool_value = fl_value_get_bool(value0);
    a_nullable_bool = &a_nullable_bool_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableBoolResponse)
      response =
          self->vtable->echo_nullable_bool(a_nullable_bool, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableBool");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableBool", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_string == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const gchar* a_nullable_string = fl_value_get_string(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringResponse)
      response = self->vtable->echo_nullable_string(a_nullable_string,
                                                    self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableString");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableString", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_uint8_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const uint8_t* a_nullable_uint8_list = fl_value_get_uint8_list(value0);
  size_t a_nullable_uint8_list_length = fl_value_get_length(value0);
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableUint8ListResponse)
      response = self->vtable->echo_nullable_uint8_list(
          a_nullable_uint8_list, a_nullable_uint8_list_length, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableUint8List");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableUint8List", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_object == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* a_nullable_object = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableObjectResponse)
      response = self->vtable->echo_nullable_object(a_nullable_object,
                                                    self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableObject");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableObject", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_nullable_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* a_nullable_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableListResponse)
      response =
          self->vtable->echo_nullable_list(a_nullable_list, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableList");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableList", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_enum_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_list = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumListResponse)
      response =
          self->vtable->echo_nullable_enum_list(enum_list, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableEnumList");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableEnumList", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_class_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_list = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassListResponse)
      response =
          self->vtable->echo_nullable_class_list(class_list, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableClassList");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableClassList", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_non_null_enum_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_list = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumListResponse)
      response = self->vtable->echo_nullable_non_null_enum_list(
          enum_list, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableNonNullEnumList");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableNonNullEnumList", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_non_null_class_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_list = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassListResponse)
      response = self->vtable->echo_nullable_non_null_class_list(
          class_list, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableNonNullClassList");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableNonNullClassList", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_nullable_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableMapResponse)
      response = self->vtable->echo_nullable_map(map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_string_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* string_map = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableStringMapResponse)
      response =
          self->vtable->echo_nullable_string_map(string_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableStringMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableStringMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_int_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* int_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableIntMapResponse)
      response = self->vtable->echo_nullable_int_map(int_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableIntMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableIntMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_enum_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_map = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumMapResponse)
      response =
          self->vtable->echo_nullable_enum_map(enum_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableEnumMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableEnumMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_class_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_map = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableClassMapResponse)
      response =
          self->vtable->echo_nullable_class_map(class_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableClassMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableClassMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_non_null_string_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* string_map = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullStringMapResponse)
      response = self->vtable->echo_nullable_non_null_string_map(
          string_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableNonNullStringMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableNonNullStringMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_non_null_int_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* int_map = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullIntMapResponse)
      response = self->vtable->echo_nullable_non_null_int_map(int_map,
                                                              self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableNonNullIntMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableNonNullIntMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_non_null_enum_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_map = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullEnumMapResponse)
      response = self->vtable->echo_nullable_non_null_enum_map(enum_map,
                                                               self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableNonNullEnumMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableNonNullEnumMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_nullable_non_null_class_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_map = value0;
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableNonNullClassMapResponse)
      response = self->vtable->echo_nullable_non_null_class_map(
          class_map, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableNonNullClassMap");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableNonNullClassMap", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_nullable_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnEnum* an_enum = nullptr;
  CoreTestsPigeonTestAnEnum an_enum_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    an_enum_value = static_cast<CoreTestsPigeonTestAnEnum>(
        fl_value_get_int(reinterpret_cast<FlValue*>(
            const_cast<gpointer>(fl_value_get_custom_value(value0)))));
    an_enum = &an_enum_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoNullableEnumResponse)
      response = self->vtable->echo_nullable_enum(an_enum, self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNullableEnum");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNullableEnum", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_another_nullable_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnotherEnum* another_enum = nullptr;
  CoreTestsPigeonTestAnotherEnum another_enum_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    another_enum_value = static_cast<CoreTestsPigeonTestAnotherEnum>(
        fl_value_get_int(reinterpret_cast<FlValue*>(
            const_cast<gpointer>(fl_value_get_custom_value(value0)))));
    another_enum = &another_enum_value;
  }
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherNullableEnumResponse)
      response = self->vtable->echo_another_nullable_enum(another_enum,
                                                          self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoAnotherNullableEnum");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAnotherNullableEnum", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_optional_nullable_int == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  int64_t* a_nullable_int = nullptr;
  int64_t a_nullable_int_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_nullable_int_value = fl_value_get_int(value0);
    a_nullable_int = &a_nullable_int_value;
  }
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoOptionalNullableIntResponse)
      response = self->vtable->echo_optional_nullable_int(a_nullable_int,
                                                          self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoOptionalNullableInt");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoOptionalNullableInt", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_named_nullable_string == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const gchar* a_nullable_string = fl_value_get_string(value0);
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoNamedNullableStringResponse)
      response = self->vtable->echo_named_nullable_string(a_nullable_string,
                                                          self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "echoNamedNullableString");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoNamedNullableString", error->message);
  }
}

static void core_tests_pigeon_test_host_integration_core_api_noop_async_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->noop_async == nullptr) {
    return;
  }

  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->noop_async(handle, self->user_data);
}

static void core_tests_pigeon_test_host_integration_core_api_echo_async_int_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_async_int == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  int64_t an_int = fl_value_get_int(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_int(an_int, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_double_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_async_double == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  double a_double = fl_value_get_float(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_double(a_double, handle, self->user_data);
}

static void core_tests_pigeon_test_host_integration_core_api_echo_async_bool_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_async_bool == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  gboolean a_bool = fl_value_get_bool(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_bool(a_bool, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_string_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_async_string == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const gchar* a_string = fl_value_get_string(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_string(a_string, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_uint8_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const uint8_t* a_uint8_list = fl_value_get_uint8_list(value0);
  size_t a_uint8_list_length = fl_value_get_length(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_uint8_list(a_uint8_list, a_uint8_list_length, handle,
                                      self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_object_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_async_object == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* an_object = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_object(an_object, handle, self->user_data);
}

static void core_tests_pigeon_test_host_integration_core_api_echo_async_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_async_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_list(list, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_enum_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_enum_list(enum_list, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_class_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_class_list(class_list, handle, self->user_data);
}

static void core_tests_pigeon_test_host_integration_core_api_echo_async_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_async_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_map(map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_string_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* string_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_string_map(string_map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_async_int_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* int_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_int_map(int_map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_async_enum_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_enum_map(enum_map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_class_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_class_map(class_map, handle, self->user_data);
}

static void core_tests_pigeon_test_host_integration_core_api_echo_async_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->echo_async_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnEnum an_enum = static_cast<CoreTestsPigeonTestAnEnum>(
      fl_value_get_int(reinterpret_cast<FlValue*>(
          const_cast<gpointer>(fl_value_get_custom_value(value0)))));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_enum(an_enum, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_another_async_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnotherEnum another_enum =
      static_cast<CoreTestsPigeonTestAnotherEnum>(
          fl_value_get_int(reinterpret_cast<FlValue*>(
              const_cast<gpointer>(fl_value_get_custom_value(value0)))));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_another_async_enum(another_enum, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_error_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->throw_async_error == nullptr) {
    return;
  }

  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->throw_async_error(handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->throw_async_error_from_void == nullptr) {
    return;
  }

  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->throw_async_error_from_void(handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->throw_async_flutter_error == nullptr) {
    return;
  }

  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->throw_async_flutter_error(handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_all_types == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAllTypes* everything = CORE_TESTS_PIGEON_TEST_ALL_TYPES(
      fl_value_get_custom_value_object(value0));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_all_types(everything, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_all_nullable_types == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAllNullableTypes* everything =
      CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES(
          fl_value_get_custom_value_object(value0));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_all_nullable_types(everything, handle,
                                                       self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_all_nullable_types_without_recursion ==
          nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAllNullableTypesWithoutRecursion* everything =
      CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(
          fl_value_get_custom_value_object(value0));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_all_nullable_types_without_recursion(
      everything, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_int == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  int64_t* an_int = nullptr;
  int64_t an_int_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    an_int_value = fl_value_get_int(value0);
    an_int = &an_int_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_int(an_int, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_double == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  double* a_double = nullptr;
  double a_double_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_double_value = fl_value_get_float(value0);
    a_double = &a_double_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_double(a_double, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_bool == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  gboolean* a_bool = nullptr;
  gboolean a_bool_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_bool_value = fl_value_get_bool(value0);
    a_bool = &a_bool_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_bool(a_bool, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_string == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const gchar* a_string = fl_value_get_string(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_string(a_string, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_uint8_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const uint8_t* a_uint8_list = fl_value_get_uint8_list(value0);
  size_t a_uint8_list_length = fl_value_get_length(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_uint8_list(
      a_uint8_list, a_uint8_list_length, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_object == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* an_object = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_object(an_object, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_list(list, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_enum_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_enum_list(enum_list, handle,
                                              self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_class_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_class_list(class_list, handle,
                                               self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_map(map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_string_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* string_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_string_map(string_map, handle,
                                               self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_int_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* int_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_int_map(int_map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_enum_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_enum_map(enum_map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_class_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_class_map(class_map, handle,
                                              self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_async_nullable_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnEnum* an_enum = nullptr;
  CoreTestsPigeonTestAnEnum an_enum_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    an_enum_value = static_cast<CoreTestsPigeonTestAnEnum>(
        fl_value_get_int(reinterpret_cast<FlValue*>(
            const_cast<gpointer>(fl_value_get_custom_value(value0)))));
    an_enum = &an_enum_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_async_nullable_enum(an_enum, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->echo_another_async_nullable_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnotherEnum* another_enum = nullptr;
  CoreTestsPigeonTestAnotherEnum another_enum_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    another_enum_value = static_cast<CoreTestsPigeonTestAnotherEnum>(
        fl_value_get_int(reinterpret_cast<FlValue*>(
            const_cast<gpointer>(fl_value_get_custom_value(value0)))));
    another_enum = &another_enum_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->echo_another_async_nullable_enum(another_enum, handle,
                                                 self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->default_is_main_thread == nullptr) {
    return;
  }

  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiDefaultIsMainThreadResponse)
      response = self->vtable->default_is_main_thread(self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "defaultIsMainThread");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "defaultIsMainThread", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->task_queue_is_background_thread == nullptr) {
    return;
  }

  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiTaskQueueIsBackgroundThreadResponse)
      response = self->vtable->task_queue_is_background_thread(self->user_data);
  if (response == nullptr) {
    g_warning("No response returned to %s.%s", "HostIntegrationCoreApi",
              "taskQueueIsBackgroundThread");
    return;
  }

  g_autoptr(GError) error = NULL;
  if (!fl_basic_message_channel_respond(channel, response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "taskQueueIsBackgroundThread", error->message);
  }
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr || self->vtable->call_flutter_noop == nullptr) {
    return;
  }

  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_noop(handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_throw_error == nullptr) {
    return;
  }

  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_throw_error(handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_throw_error_from_void == nullptr) {
    return;
  }

  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_throw_error_from_void(handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_all_types == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAllTypes* everything = CORE_TESTS_PIGEON_TEST_ALL_TYPES(
      fl_value_get_custom_value_object(value0));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_all_types(everything, handle,
                                            self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_all_nullable_types == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAllNullableTypes* everything =
      CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES(
          fl_value_get_custom_value_object(value0));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_all_nullable_types(everything, handle,
                                                     self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_send_multiple_nullable_types == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  gboolean* a_nullable_bool = nullptr;
  gboolean a_nullable_bool_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_nullable_bool_value = fl_value_get_bool(value0);
    a_nullable_bool = &a_nullable_bool_value;
  }
  FlValue* value1 = fl_value_get_list_value(message_, 1);
  int64_t* a_nullable_int = nullptr;
  int64_t a_nullable_int_value;
  if (fl_value_get_type(value1) != FL_VALUE_TYPE_NULL) {
    a_nullable_int_value = fl_value_get_int(value1);
    a_nullable_int = &a_nullable_int_value;
  }
  FlValue* value2 = fl_value_get_list_value(message_, 2);
  const gchar* a_nullable_string = fl_value_get_string(value2);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_send_multiple_nullable_types(
      a_nullable_bool, a_nullable_int, a_nullable_string, handle,
      self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_all_nullable_types_without_recursion ==
          nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAllNullableTypesWithoutRecursion* everything =
      CORE_TESTS_PIGEON_TEST_ALL_NULLABLE_TYPES_WITHOUT_RECURSION(
          fl_value_get_custom_value_object(value0));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_all_nullable_types_without_recursion(
      everything, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable
              ->call_flutter_send_multiple_nullable_types_without_recursion ==
          nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  gboolean* a_nullable_bool = nullptr;
  gboolean a_nullable_bool_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_nullable_bool_value = fl_value_get_bool(value0);
    a_nullable_bool = &a_nullable_bool_value;
  }
  FlValue* value1 = fl_value_get_list_value(message_, 1);
  int64_t* a_nullable_int = nullptr;
  int64_t a_nullable_int_value;
  if (fl_value_get_type(value1) != FL_VALUE_TYPE_NULL) {
    a_nullable_int_value = fl_value_get_int(value1);
    a_nullable_int = &a_nullable_int_value;
  }
  FlValue* value2 = fl_value_get_list_value(message_, 2);
  const gchar* a_nullable_string = fl_value_get_string(value2);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_send_multiple_nullable_types_without_recursion(
      a_nullable_bool, a_nullable_int, a_nullable_string, handle,
      self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_bool == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  gboolean a_bool = fl_value_get_bool(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_bool(a_bool, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_int == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  int64_t an_int = fl_value_get_int(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_int(an_int, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_double == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  double a_double = fl_value_get_float(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_double(a_double, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_string == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const gchar* a_string = fl_value_get_string(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_string(a_string, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_uint8_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const uint8_t* list = fl_value_get_uint8_list(value0);
  size_t list_length = fl_value_get_length(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_uint8_list(list, list_length, handle,
                                             self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_list(list, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_enum_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_enum_list(enum_list, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_class_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_class_list(class_list, handle,
                                             self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_non_null_enum_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_non_null_enum_list(enum_list, handle,
                                                     self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_non_null_class_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_non_null_class_list(class_list, handle,
                                                      self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_map(map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_string_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* string_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_string_map(string_map, handle,
                                             self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_int_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* int_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_int_map(int_map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_enum_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_enum_map(enum_map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_class_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_class_map(class_map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_non_null_string_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* string_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_non_null_string_map(string_map, handle,
                                                      self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_non_null_int_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* int_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_non_null_int_map(int_map, handle,
                                                   self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_non_null_enum_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_non_null_enum_map(enum_map, handle,
                                                    self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_non_null_class_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_non_null_class_map(class_map, handle,
                                                     self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnEnum an_enum = static_cast<CoreTestsPigeonTestAnEnum>(
      fl_value_get_int(reinterpret_cast<FlValue*>(
          const_cast<gpointer>(fl_value_get_custom_value(value0)))));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_enum(an_enum, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_another_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnotherEnum another_enum =
      static_cast<CoreTestsPigeonTestAnotherEnum>(
          fl_value_get_int(reinterpret_cast<FlValue*>(
              const_cast<gpointer>(fl_value_get_custom_value(value0)))));
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_another_enum(another_enum, handle,
                                               self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_bool == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  gboolean* a_bool = nullptr;
  gboolean a_bool_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_bool_value = fl_value_get_bool(value0);
    a_bool = &a_bool_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_bool(a_bool, handle,
                                                self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_int == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  int64_t* an_int = nullptr;
  int64_t an_int_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    an_int_value = fl_value_get_int(value0);
    an_int = &an_int_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_int(an_int, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_double == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  double* a_double = nullptr;
  double a_double_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    a_double_value = fl_value_get_float(value0);
    a_double = &a_double_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_double(a_double, handle,
                                                  self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_string == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const gchar* a_string = fl_value_get_string(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_string(a_string, handle,
                                                  self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_uint8_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const uint8_t* list = fl_value_get_uint8_list(value0);
  size_t list_length = fl_value_get_length(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_uint8_list(list, list_length, handle,
                                                      self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_list(list, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_enum_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_enum_list(enum_list, handle,
                                                     self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_class_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_class_list(class_list, handle,
                                                      self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_non_null_enum_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_non_null_enum_list(enum_list, handle,
                                                              self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_non_null_class_list == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_list = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_non_null_class_list(
      class_list, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_map(map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_string_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* string_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_string_map(string_map, handle,
                                                      self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_int_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* int_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_int_map(int_map, handle,
                                                   self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_enum_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_enum_map(enum_map, handle,
                                                    self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_class_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_class_map(class_map, handle,
                                                     self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_non_null_string_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* string_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_non_null_string_map(
      string_map, handle, self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_non_null_int_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* int_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_non_null_int_map(int_map, handle,
                                                            self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_non_null_enum_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* enum_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_non_null_enum_map(enum_map, handle,
                                                             self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_non_null_class_map == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  FlValue* class_map = value0;
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_non_null_class_map(class_map, handle,
                                                              self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_nullable_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnEnum* an_enum = nullptr;
  CoreTestsPigeonTestAnEnum an_enum_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    an_enum_value = static_cast<CoreTestsPigeonTestAnEnum>(
        fl_value_get_int(reinterpret_cast<FlValue*>(
            const_cast<gpointer>(fl_value_get_custom_value(value0)))));
    an_enum = &an_enum_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_nullable_enum(an_enum, handle,
                                                self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_echo_another_nullable_enum == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  CoreTestsPigeonTestAnotherEnum* another_enum = nullptr;
  CoreTestsPigeonTestAnotherEnum another_enum_value;
  if (fl_value_get_type(value0) != FL_VALUE_TYPE_NULL) {
    another_enum_value = static_cast<CoreTestsPigeonTestAnotherEnum>(
        fl_value_get_int(reinterpret_cast<FlValue*>(
            const_cast<gpointer>(fl_value_get_custom_value(value0)))));
    another_enum = &another_enum_value;
  }
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_echo_another_nullable_enum(another_enum, handle,
                                                        self->user_data);
}

static void
core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_cb(
    FlBasicMessageChannel* channel, FlValue* message_,
    FlBasicMessageChannelResponseHandle* response_handle, gpointer user_data) {
  CoreTestsPigeonTestHostIntegrationCoreApi* self =
      CORE_TESTS_PIGEON_TEST_HOST_INTEGRATION_CORE_API(user_data);

  if (self->vtable == nullptr ||
      self->vtable->call_flutter_small_api_echo_string == nullptr) {
    return;
  }

  FlValue* value0 = fl_value_get_list_value(message_, 0);
  const gchar* a_string = fl_value_get_string(value0);
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle) handle =
      core_tests_pigeon_test_host_integration_core_api_response_handle_new(
          channel, response_handle);
  self->vtable->call_flutter_small_api_echo_string(a_string, handle,
                                                   self->user_data);
}

void core_tests_pigeon_test_host_integration_core_api_set_method_handlers(
    FlBinaryMessenger* messenger, const gchar* suffix,
    const CoreTestsPigeonTestHostIntegrationCoreApiVTable* vtable,
    gpointer user_data, GDestroyNotify user_data_free_func) {
  g_autofree gchar* dot_suffix =
      suffix != nullptr ? g_strdup_printf(".%s", suffix) : g_strdup("");
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApi) api_data =
      core_tests_pigeon_test_host_integration_core_api_new(vtable, user_data,
                                                           user_data_free_func);

  g_autoptr(CoreTestsPigeonTestMessageCodec) codec =
      core_tests_pigeon_test_message_codec_new();
  g_autofree gchar* noop_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.noop%"
      "s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) noop_channel = fl_basic_message_channel_new(
      messenger, noop_channel_name, FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      noop_channel, core_tests_pigeon_test_host_integration_core_api_noop_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_all_types_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAllTypes%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_all_types_channel =
      fl_basic_message_channel_new(messenger, echo_all_types_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_all_types_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_all_types_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* throw_error_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwError%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_error_channel =
      fl_basic_message_channel_new(messenger, throw_error_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      throw_error_channel,
      core_tests_pigeon_test_host_integration_core_api_throw_error_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* throw_error_from_void_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwErrorFromVoid%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_error_from_void_channel =
      fl_basic_message_channel_new(messenger,
                                   throw_error_from_void_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      throw_error_from_void_channel,
      core_tests_pigeon_test_host_integration_core_api_throw_error_from_void_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* throw_flutter_error_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwFlutterError%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_flutter_error_channel =
      fl_basic_message_channel_new(messenger, throw_flutter_error_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      throw_flutter_error_channel,
      core_tests_pigeon_test_host_integration_core_api_throw_flutter_error_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_int_channel =
      fl_basic_message_channel_new(messenger, echo_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_int_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_int_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_double_channel =
      fl_basic_message_channel_new(messenger, echo_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_double_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_double_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_bool_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoBool%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_bool_channel =
      fl_basic_message_channel_new(messenger, echo_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_bool_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_bool_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_string_channel =
      fl_basic_message_channel_new(messenger, echo_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_string_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_string_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_uint8_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoUint8List%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_uint8_list_channel =
      fl_basic_message_channel_new(messenger, echo_uint8_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_uint8_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_uint8_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_object_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoObject%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_object_channel =
      fl_basic_message_channel_new(messenger, echo_object_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_object_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_object_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_list_channel =
      fl_basic_message_channel_new(messenger, echo_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_enum_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoEnumList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_enum_list_channel =
      fl_basic_message_channel_new(messenger, echo_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_enum_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_enum_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_class_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoClassList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_class_list_channel =
      fl_basic_message_channel_new(messenger, echo_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_class_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_class_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_non_null_enum_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullEnumList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_enum_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_non_null_enum_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_non_null_class_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullClassList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_class_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_non_null_class_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_map_channel =
      fl_basic_message_channel_new(messenger, echo_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_string_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoStringMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_string_map_channel =
      fl_basic_message_channel_new(messenger, echo_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_string_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_string_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_int_map_channel =
      fl_basic_message_channel_new(messenger, echo_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_int_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_int_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_enum_map_channel =
      fl_basic_message_channel_new(messenger, echo_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_enum_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_enum_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_class_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoClassMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_class_map_channel =
      fl_basic_message_channel_new(messenger, echo_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_class_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_class_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_non_null_string_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullStringMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_string_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_non_null_string_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_string_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_non_null_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_int_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_non_null_int_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_int_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_non_null_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_enum_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_non_null_enum_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_enum_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_non_null_class_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullClassMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_class_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_non_null_class_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_non_null_class_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_class_wrapper_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoClassWrapper%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_class_wrapper_channel =
      fl_basic_message_channel_new(messenger, echo_class_wrapper_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_class_wrapper_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_class_wrapper_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_enum_channel =
      fl_basic_message_channel_new(messenger, echo_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_another_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAnotherEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_another_enum_channel =
      fl_basic_message_channel_new(messenger, echo_another_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_another_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_another_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_named_default_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNamedDefaultString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_named_default_string_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_named_default_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_named_default_string_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_named_default_string_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_optional_default_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoOptionalDefaultDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_optional_default_double_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_optional_default_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_optional_default_double_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_optional_default_double_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_required_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoRequiredInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_required_int_channel =
      fl_basic_message_channel_new(messenger, echo_required_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_required_int_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_required_int_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_all_nullable_types_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAllNullableTypes%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_all_nullable_types_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_all_nullable_types_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_all_nullable_types_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_all_nullable_types_without_recursion_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAllNullableTypesWithoutRecursion%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      echo_all_nullable_types_without_recursion_channel =
          fl_basic_message_channel_new(
              messenger, echo_all_nullable_types_without_recursion_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_all_nullable_types_without_recursion_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_all_nullable_types_without_recursion_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* extract_nested_nullable_string_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "extractNestedNullableString%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) extract_nested_nullable_string_channel =
      fl_basic_message_channel_new(messenger,
                                   extract_nested_nullable_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      extract_nested_nullable_string_channel,
      core_tests_pigeon_test_host_integration_core_api_extract_nested_nullable_string_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* create_nested_nullable_string_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "createNestedNullableString%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) create_nested_nullable_string_channel =
      fl_basic_message_channel_new(messenger,
                                   create_nested_nullable_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      create_nested_nullable_string_channel,
      core_tests_pigeon_test_host_integration_core_api_create_nested_nullable_string_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* send_multiple_nullable_types_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "sendMultipleNullableTypes%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) send_multiple_nullable_types_channel =
      fl_basic_message_channel_new(messenger,
                                   send_multiple_nullable_types_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      send_multiple_nullable_types_channel,
      core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar*
      send_multiple_nullable_types_without_recursion_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi."
              "sendMultipleNullableTypesWithoutRecursion%s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      send_multiple_nullable_types_without_recursion_channel =
          fl_basic_message_channel_new(
              messenger,
              send_multiple_nullable_types_without_recursion_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      send_multiple_nullable_types_without_recursion_channel,
      core_tests_pigeon_test_host_integration_core_api_send_multiple_nullable_types_without_recursion_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_int_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_int_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_double_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_double_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_double_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_bool_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableBool%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_bool_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_bool_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_bool_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_string_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_string_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_uint8_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableUint8List%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_uint8_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_uint8_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_uint8_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_uint8_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_object_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableObject%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_object_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_object_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_object_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_object_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_list_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_enum_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableEnumList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_enum_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_enum_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_class_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableClassList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_class_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_class_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_non_null_enum_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullEnumList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_enum_list_channel =
      fl_basic_message_channel_new(
          messenger, echo_nullable_non_null_enum_list_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_enum_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_non_null_class_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullClassList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_class_list_channel =
      fl_basic_message_channel_new(
          messenger, echo_nullable_non_null_class_list_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_class_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_map_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_string_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableStringMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_string_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_string_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_string_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_int_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_int_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_int_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_enum_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_enum_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_class_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableClassMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_class_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_class_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_class_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_non_null_string_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullStringMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_string_map_channel =
      fl_basic_message_channel_new(
          messenger, echo_nullable_non_null_string_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_string_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_string_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_non_null_int_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullIntMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_int_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_non_null_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_int_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_int_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_non_null_enum_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullEnumMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_enum_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_non_null_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_enum_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_enum_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_non_null_class_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullClassMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_class_map_channel =
      fl_basic_message_channel_new(
          messenger, echo_nullable_non_null_class_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_class_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_non_null_class_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_nullable_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_enum_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_nullable_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_another_nullable_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAnotherNullableEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_another_nullable_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_another_nullable_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_another_nullable_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_another_nullable_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_optional_nullable_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoOptionalNullableInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_optional_nullable_int_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_optional_nullable_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_optional_nullable_int_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_optional_nullable_int_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_named_nullable_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNamedNullableString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_named_nullable_string_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_named_nullable_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_named_nullable_string_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_named_nullable_string_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* noop_async_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "noopAsync%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) noop_async_channel =
      fl_basic_message_channel_new(messenger, noop_async_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      noop_async_channel,
      core_tests_pigeon_test_host_integration_core_api_noop_async_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_int_channel =
      fl_basic_message_channel_new(messenger, echo_async_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_int_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_int_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_double_channel =
      fl_basic_message_channel_new(messenger, echo_async_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_double_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_double_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_bool_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncBool%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_bool_channel =
      fl_basic_message_channel_new(messenger, echo_async_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_bool_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_bool_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_string_channel =
      fl_basic_message_channel_new(messenger, echo_async_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_string_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_string_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_uint8_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncUint8List%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_uint8_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_uint8_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_uint8_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_object_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncObject%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_object_channel =
      fl_basic_message_channel_new(messenger, echo_async_object_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_object_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_object_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_list_channel =
      fl_basic_message_channel_new(messenger, echo_async_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_enum_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncEnumList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_enum_list_channel =
      fl_basic_message_channel_new(messenger, echo_async_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_enum_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_class_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncClassList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_class_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_class_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_map_channel =
      fl_basic_message_channel_new(messenger, echo_async_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_string_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncStringMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_string_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_string_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_int_map_channel =
      fl_basic_message_channel_new(messenger, echo_async_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_int_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_enum_map_channel =
      fl_basic_message_channel_new(messenger, echo_async_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_enum_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_class_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncClassMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_class_map_channel =
      fl_basic_message_channel_new(messenger, echo_async_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_class_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_enum_channel =
      fl_basic_message_channel_new(messenger, echo_async_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_another_async_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAnotherAsyncEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_another_async_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_another_async_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_another_async_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* throw_async_error_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwAsyncError%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_async_error_channel =
      fl_basic_message_channel_new(messenger, throw_async_error_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      throw_async_error_channel,
      core_tests_pigeon_test_host_integration_core_api_throw_async_error_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* throw_async_error_from_void_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwAsyncErrorFromVoid%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_async_error_from_void_channel =
      fl_basic_message_channel_new(messenger,
                                   throw_async_error_from_void_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      throw_async_error_from_void_channel,
      core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* throw_async_flutter_error_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwAsyncFlutterError%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_async_flutter_error_channel =
      fl_basic_message_channel_new(messenger,
                                   throw_async_flutter_error_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      throw_async_flutter_error_channel,
      core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_all_types_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncAllTypes%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_all_types_channel =
      fl_basic_message_channel_new(messenger, echo_async_all_types_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_all_types_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_all_types_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_all_nullable_types_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableAllNullableTypes%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      echo_async_nullable_all_nullable_types_channel =
          fl_basic_message_channel_new(
              messenger, echo_async_nullable_all_nullable_types_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_all_nullable_types_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar*
      echo_async_nullable_all_nullable_types_without_recursion_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi."
              "echoAsyncNullableAllNullableTypesWithoutRecursion%s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      echo_async_nullable_all_nullable_types_without_recursion_channel =
          fl_basic_message_channel_new(
              messenger,
              echo_async_nullable_all_nullable_types_without_recursion_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_all_nullable_types_without_recursion_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_all_nullable_types_without_recursion_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_int_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_int_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_double_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_double_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_double_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_bool_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableBool%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_bool_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_bool_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_bool_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_string_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_string_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_uint8_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableUint8List%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_uint8_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_uint8_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_uint8_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_uint8_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_object_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableObject%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_object_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_object_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_object_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_object_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_enum_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableEnumList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_enum_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_enum_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_class_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableClassList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_class_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_class_list_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_string_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableStringMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_string_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_string_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_string_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_int_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_int_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_int_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_enum_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_enum_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_class_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableClassMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_class_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_class_map_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_class_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_async_nullable_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_async_nullable_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* echo_another_async_nullable_enum_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAnotherAsyncNullableEnum%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_another_async_nullable_enum_channel =
      fl_basic_message_channel_new(
          messenger, echo_another_async_nullable_enum_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_another_async_nullable_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_echo_another_async_nullable_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* default_is_main_thread_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "defaultIsMainThread%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) default_is_main_thread_channel =
      fl_basic_message_channel_new(messenger,
                                   default_is_main_thread_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      default_is_main_thread_channel,
      core_tests_pigeon_test_host_integration_core_api_default_is_main_thread_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* task_queue_is_background_thread_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "taskQueueIsBackgroundThread%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) task_queue_is_background_thread_channel =
      fl_basic_message_channel_new(messenger,
                                   task_queue_is_background_thread_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      task_queue_is_background_thread_channel,
      core_tests_pigeon_test_host_integration_core_api_task_queue_is_background_thread_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_noop_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterNoop%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_noop_channel =
      fl_basic_message_channel_new(messenger, call_flutter_noop_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_noop_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_noop_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_throw_error_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterThrowError%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_throw_error_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_throw_error_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_throw_error_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_throw_error_from_void_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterThrowErrorFromVoid%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_throw_error_from_void_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_throw_error_from_void_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_throw_error_from_void_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_throw_error_from_void_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_all_types_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoAllTypes%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_all_types_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_all_types_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_all_types_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_types_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_all_nullable_types_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoAllNullableTypes%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_all_nullable_types_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_all_nullable_types_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_all_nullable_types_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_send_multiple_nullable_types_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterSendMultipleNullableTypes%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_send_multiple_nullable_types_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_send_multiple_nullable_types_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_send_multiple_nullable_types_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar*
      call_flutter_echo_all_nullable_types_without_recursion_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi."
              "callFlutterEchoAllNullableTypesWithoutRecursion%s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_all_nullable_types_without_recursion_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_all_nullable_types_without_recursion_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_all_nullable_types_without_recursion_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_all_nullable_types_without_recursion_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar*
      call_flutter_send_multiple_nullable_types_without_recursion_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi."
              "callFlutterSendMultipleNullableTypesWithoutRecursion%s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_send_multiple_nullable_types_without_recursion_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_send_multiple_nullable_types_without_recursion_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_send_multiple_nullable_types_without_recursion_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_send_multiple_nullable_types_without_recursion_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_bool_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoBool%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_bool_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_bool_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_bool_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_int_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_int_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_double_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_double_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_double_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_string_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_string_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_uint8_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoUint8List%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_uint8_list_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_uint8_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_uint8_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_uint8_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_list_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_enum_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoEnumList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_enum_list_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_enum_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_class_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoClassList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_class_list_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_class_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_non_null_enum_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullEnumList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_non_null_enum_list_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_non_null_enum_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_enum_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_non_null_class_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullClassList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_non_null_class_list_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_non_null_class_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_class_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_string_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoStringMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_string_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_string_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_string_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_int_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_int_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_int_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_enum_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_enum_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_class_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoClassMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_class_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_class_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_class_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_non_null_string_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullStringMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_non_null_string_map_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_non_null_string_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_string_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_string_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_non_null_int_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullIntMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_non_null_int_map_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_non_null_int_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_int_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_int_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_non_null_enum_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullEnumMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_non_null_enum_map_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_non_null_enum_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_enum_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_enum_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_non_null_class_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullClassMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_non_null_class_map_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_non_null_class_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_class_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_non_null_class_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_another_enum_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoAnotherEnum%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_another_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_another_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_another_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_bool_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableBool%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_bool_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_nullable_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_bool_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_bool_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_int_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableInt%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_int_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_nullable_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_int_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_double_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableDouble%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_double_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_nullable_double_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_double_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_double_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_string_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableString%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_string_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_nullable_string_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_string_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_uint8_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableUint8List%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_uint8_list_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_nullable_uint8_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_uint8_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_uint8_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_list_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_nullable_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_enum_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableEnumList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_enum_list_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_nullable_enum_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_enum_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_class_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableClassList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_class_list_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_nullable_class_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_class_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_non_null_enum_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableNonNullEnumList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_enum_list_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_enum_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_enum_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar*
      call_flutter_echo_nullable_non_null_class_list_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi.callFlutterEchoNullableNonNullClassList%"
              "s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_class_list_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_class_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_class_list_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_list_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_nullable_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_string_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableStringMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_string_map_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_nullable_string_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_string_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_string_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_int_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableIntMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_int_map_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_nullable_int_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_int_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_int_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_enum_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableEnumMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_enum_map_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_nullable_enum_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_enum_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_class_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableClassMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_class_map_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_nullable_class_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_class_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_class_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar*
      call_flutter_echo_nullable_non_null_string_map_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi.callFlutterEchoNullableNonNullStringMap%"
              "s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_string_map_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_string_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_string_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_string_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_non_null_int_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableNonNullIntMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_int_map_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_int_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_int_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_int_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_non_null_enum_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableNonNullEnumMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_enum_map_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_enum_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_enum_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_enum_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_non_null_class_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableNonNullClassMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_class_map_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_class_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_class_map_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_non_null_class_map_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_nullable_enum_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableEnum%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_nullable_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_nullable_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_echo_another_nullable_enum_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoAnotherNullableEnum%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_another_nullable_enum_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_another_nullable_enum_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_another_nullable_enum_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_echo_another_nullable_enum_cb,
      g_object_ref(api_data), g_object_unref);
  g_autofree gchar* call_flutter_small_api_echo_string_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterSmallApiEchoString%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_small_api_echo_string_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_small_api_echo_string_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_small_api_echo_string_channel,
      core_tests_pigeon_test_host_integration_core_api_call_flutter_small_api_echo_string_cb,
      g_object_ref(api_data), g_object_unref);
}

void core_tests_pigeon_test_host_integration_core_api_clear_method_handlers(
    FlBinaryMessenger* messenger, const gchar* suffix) {
  g_autofree gchar* dot_suffix =
      suffix != nullptr ? g_strdup_printf(".%s", suffix) : g_strdup("");

  g_autoptr(CoreTestsPigeonTestMessageCodec) codec =
      core_tests_pigeon_test_message_codec_new();
  g_autofree gchar* noop_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi.noop%"
      "s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) noop_channel = fl_basic_message_channel_new(
      messenger, noop_channel_name, FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(noop_channel, nullptr, nullptr,
                                               nullptr);
  g_autofree gchar* echo_all_types_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAllTypes%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_all_types_channel =
      fl_basic_message_channel_new(messenger, echo_all_types_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_all_types_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* throw_error_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwError%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_error_channel =
      fl_basic_message_channel_new(messenger, throw_error_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(throw_error_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* throw_error_from_void_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwErrorFromVoid%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_error_from_void_channel =
      fl_basic_message_channel_new(messenger,
                                   throw_error_from_void_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(throw_error_from_void_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* throw_flutter_error_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwFlutterError%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_flutter_error_channel =
      fl_basic_message_channel_new(messenger, throw_flutter_error_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(throw_flutter_error_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_int_channel =
      fl_basic_message_channel_new(messenger, echo_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_int_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_double_channel =
      fl_basic_message_channel_new(messenger, echo_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_double_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_bool_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoBool%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_bool_channel =
      fl_basic_message_channel_new(messenger, echo_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_bool_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_string_channel =
      fl_basic_message_channel_new(messenger, echo_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_string_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_uint8_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoUint8List%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_uint8_list_channel =
      fl_basic_message_channel_new(messenger, echo_uint8_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_uint8_list_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_object_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoObject%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_object_channel =
      fl_basic_message_channel_new(messenger, echo_object_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_object_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_list_channel =
      fl_basic_message_channel_new(messenger, echo_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_list_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_enum_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoEnumList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_enum_list_channel =
      fl_basic_message_channel_new(messenger, echo_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_enum_list_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_class_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoClassList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_class_list_channel =
      fl_basic_message_channel_new(messenger, echo_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_class_list_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_non_null_enum_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullEnumList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_enum_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_non_null_enum_list_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_non_null_class_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullClassList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_class_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_non_null_class_list_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_map_channel =
      fl_basic_message_channel_new(messenger, echo_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_map_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_string_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoStringMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_string_map_channel =
      fl_basic_message_channel_new(messenger, echo_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_string_map_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_int_map_channel =
      fl_basic_message_channel_new(messenger, echo_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_int_map_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_enum_map_channel =
      fl_basic_message_channel_new(messenger, echo_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_enum_map_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_class_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoClassMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_class_map_channel =
      fl_basic_message_channel_new(messenger, echo_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_class_map_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_non_null_string_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullStringMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_string_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_non_null_string_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_non_null_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_int_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_non_null_int_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_non_null_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_enum_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_non_null_enum_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_non_null_class_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNonNullClassMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_non_null_class_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_non_null_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_non_null_class_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_class_wrapper_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoClassWrapper%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_class_wrapper_channel =
      fl_basic_message_channel_new(messenger, echo_class_wrapper_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_class_wrapper_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_enum_channel =
      fl_basic_message_channel_new(messenger, echo_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_enum_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_another_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAnotherEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_another_enum_channel =
      fl_basic_message_channel_new(messenger, echo_another_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_another_enum_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_named_default_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNamedDefaultString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_named_default_string_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_named_default_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_named_default_string_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_optional_default_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoOptionalDefaultDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_optional_default_double_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_optional_default_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_optional_default_double_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_required_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoRequiredInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_required_int_channel =
      fl_basic_message_channel_new(messenger, echo_required_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_required_int_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_all_nullable_types_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAllNullableTypes%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_all_nullable_types_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_all_nullable_types_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_all_nullable_types_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_all_nullable_types_without_recursion_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAllNullableTypesWithoutRecursion%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      echo_all_nullable_types_without_recursion_channel =
          fl_basic_message_channel_new(
              messenger, echo_all_nullable_types_without_recursion_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_all_nullable_types_without_recursion_channel, nullptr, nullptr,
      nullptr);
  g_autofree gchar* extract_nested_nullable_string_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "extractNestedNullableString%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) extract_nested_nullable_string_channel =
      fl_basic_message_channel_new(messenger,
                                   extract_nested_nullable_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      extract_nested_nullable_string_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* create_nested_nullable_string_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "createNestedNullableString%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) create_nested_nullable_string_channel =
      fl_basic_message_channel_new(messenger,
                                   create_nested_nullable_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      create_nested_nullable_string_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* send_multiple_nullable_types_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "sendMultipleNullableTypes%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) send_multiple_nullable_types_channel =
      fl_basic_message_channel_new(messenger,
                                   send_multiple_nullable_types_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      send_multiple_nullable_types_channel, nullptr, nullptr, nullptr);
  g_autofree gchar*
      send_multiple_nullable_types_without_recursion_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi."
              "sendMultipleNullableTypesWithoutRecursion%s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      send_multiple_nullable_types_without_recursion_channel =
          fl_basic_message_channel_new(
              messenger,
              send_multiple_nullable_types_without_recursion_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      send_multiple_nullable_types_without_recursion_channel, nullptr, nullptr,
      nullptr);
  g_autofree gchar* echo_nullable_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_int_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_int_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_double_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_double_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_bool_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableBool%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_bool_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_bool_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_string_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_string_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_uint8_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableUint8List%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_uint8_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_uint8_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_uint8_list_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_object_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableObject%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_object_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_object_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_object_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_list_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_list_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_enum_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableEnumList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_enum_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_enum_list_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_class_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableClassList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_class_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_class_list_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_non_null_enum_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullEnumList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_enum_list_channel =
      fl_basic_message_channel_new(
          messenger, echo_nullable_non_null_enum_list_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_enum_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_non_null_class_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullClassList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_class_list_channel =
      fl_basic_message_channel_new(
          messenger, echo_nullable_non_null_class_list_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_class_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_map_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_string_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableStringMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_string_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_string_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_int_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_int_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_enum_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_enum_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_class_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableClassMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_class_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_class_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_non_null_string_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullStringMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_string_map_channel =
      fl_basic_message_channel_new(
          messenger, echo_nullable_non_null_string_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_string_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_non_null_int_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullIntMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_int_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_non_null_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_int_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_non_null_enum_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullEnumMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_enum_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_nullable_non_null_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_enum_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_non_null_class_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoNullableNonNullClassMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_non_null_class_map_channel =
      fl_basic_message_channel_new(
          messenger, echo_nullable_non_null_class_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_nullable_non_null_class_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_nullable_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNullableEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_nullable_enum_channel =
      fl_basic_message_channel_new(messenger, echo_nullable_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_nullable_enum_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_another_nullable_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAnotherNullableEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_another_nullable_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_another_nullable_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_another_nullable_enum_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_optional_nullable_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoOptionalNullableInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_optional_nullable_int_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_optional_nullable_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_optional_nullable_int_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_named_nullable_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoNamedNullableString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_named_nullable_string_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_named_nullable_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_named_nullable_string_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* noop_async_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "noopAsync%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) noop_async_channel =
      fl_basic_message_channel_new(messenger, noop_async_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(noop_async_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_async_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_int_channel =
      fl_basic_message_channel_new(messenger, echo_async_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_int_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_async_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_double_channel =
      fl_basic_message_channel_new(messenger, echo_async_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_double_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_bool_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncBool%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_bool_channel =
      fl_basic_message_channel_new(messenger, echo_async_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_bool_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_async_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_string_channel =
      fl_basic_message_channel_new(messenger, echo_async_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_string_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_uint8_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncUint8List%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_uint8_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_uint8_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_uint8_list_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_object_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncObject%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_object_channel =
      fl_basic_message_channel_new(messenger, echo_async_object_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_object_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_list_channel =
      fl_basic_message_channel_new(messenger, echo_async_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_list_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_async_enum_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncEnumList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_enum_list_channel =
      fl_basic_message_channel_new(messenger, echo_async_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_enum_list_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_class_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncClassList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_class_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_class_list_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_map_channel =
      fl_basic_message_channel_new(messenger, echo_async_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_map_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_async_string_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncStringMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_string_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_string_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_int_map_channel =
      fl_basic_message_channel_new(messenger, echo_async_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_int_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_enum_map_channel =
      fl_basic_message_channel_new(messenger, echo_async_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_enum_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_class_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncClassMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_class_map_channel =
      fl_basic_message_channel_new(messenger, echo_async_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_class_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_enum_channel =
      fl_basic_message_channel_new(messenger, echo_async_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_enum_channel, nullptr,
                                               nullptr, nullptr);
  g_autofree gchar* echo_another_async_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAnotherAsyncEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_another_async_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_another_async_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_another_async_enum_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* throw_async_error_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwAsyncError%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_async_error_channel =
      fl_basic_message_channel_new(messenger, throw_async_error_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(throw_async_error_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* throw_async_error_from_void_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwAsyncErrorFromVoid%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_async_error_from_void_channel =
      fl_basic_message_channel_new(messenger,
                                   throw_async_error_from_void_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      throw_async_error_from_void_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* throw_async_flutter_error_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "throwAsyncFlutterError%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) throw_async_flutter_error_channel =
      fl_basic_message_channel_new(messenger,
                                   throw_async_flutter_error_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      throw_async_flutter_error_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_all_types_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncAllTypes%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_all_types_channel =
      fl_basic_message_channel_new(messenger, echo_async_all_types_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_all_types_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_all_nullable_types_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableAllNullableTypes%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      echo_async_nullable_all_nullable_types_channel =
          fl_basic_message_channel_new(
              messenger, echo_async_nullable_all_nullable_types_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_all_nullable_types_channel, nullptr, nullptr,
      nullptr);
  g_autofree gchar*
      echo_async_nullable_all_nullable_types_without_recursion_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi."
              "echoAsyncNullableAllNullableTypesWithoutRecursion%s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      echo_async_nullable_all_nullable_types_without_recursion_channel =
          fl_basic_message_channel_new(
              messenger,
              echo_async_nullable_all_nullable_types_without_recursion_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_all_nullable_types_without_recursion_channel, nullptr,
      nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_int_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_nullable_int_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_double_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_double_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_bool_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableBool%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_bool_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_nullable_bool_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_string_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_string_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_uint8_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableUint8List%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_uint8_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_uint8_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_uint8_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_object_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableObject%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_object_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_object_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_object_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_nullable_list_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_enum_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableEnumList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_enum_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_enum_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_class_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableClassList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_class_list_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_class_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_nullable_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_string_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableStringMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_string_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_string_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_int_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_int_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_enum_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_enum_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_class_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAsyncNullableClassMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_class_map_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_async_nullable_class_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* echo_async_nullable_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "echoAsyncNullableEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_async_nullable_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   echo_async_nullable_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(echo_async_nullable_enum_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* echo_another_async_nullable_enum_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "echoAnotherAsyncNullableEnum%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) echo_another_async_nullable_enum_channel =
      fl_basic_message_channel_new(
          messenger, echo_another_async_nullable_enum_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      echo_another_async_nullable_enum_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* default_is_main_thread_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "defaultIsMainThread%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) default_is_main_thread_channel =
      fl_basic_message_channel_new(messenger,
                                   default_is_main_thread_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(default_is_main_thread_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* task_queue_is_background_thread_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "taskQueueIsBackgroundThread%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) task_queue_is_background_thread_channel =
      fl_basic_message_channel_new(messenger,
                                   task_queue_is_background_thread_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      task_queue_is_background_thread_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_noop_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterNoop%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_noop_channel =
      fl_basic_message_channel_new(messenger, call_flutter_noop_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(call_flutter_noop_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_throw_error_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterThrowError%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_throw_error_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_throw_error_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(call_flutter_throw_error_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_throw_error_from_void_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterThrowErrorFromVoid%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_throw_error_from_void_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_throw_error_from_void_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_throw_error_from_void_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_all_types_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoAllTypes%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_all_types_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_all_types_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_all_types_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_all_nullable_types_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoAllNullableTypes%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_all_nullable_types_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_all_nullable_types_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_all_nullable_types_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_send_multiple_nullable_types_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterSendMultipleNullableTypes%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_send_multiple_nullable_types_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_send_multiple_nullable_types_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_send_multiple_nullable_types_channel, nullptr, nullptr,
      nullptr);
  g_autofree gchar*
      call_flutter_echo_all_nullable_types_without_recursion_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi."
              "callFlutterEchoAllNullableTypesWithoutRecursion%s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_all_nullable_types_without_recursion_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_all_nullable_types_without_recursion_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_all_nullable_types_without_recursion_channel, nullptr,
      nullptr, nullptr);
  g_autofree gchar*
      call_flutter_send_multiple_nullable_types_without_recursion_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi."
              "callFlutterSendMultipleNullableTypesWithoutRecursion%s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_send_multiple_nullable_types_without_recursion_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_send_multiple_nullable_types_without_recursion_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_send_multiple_nullable_types_without_recursion_channel,
      nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_bool_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoBool%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_bool_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(call_flutter_echo_bool_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_int_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoInt%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_int_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(call_flutter_echo_int_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_double_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoDouble%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_double_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_double_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(call_flutter_echo_double_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_string_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoString%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_string_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_string_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(call_flutter_echo_string_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_uint8_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoUint8List%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_uint8_list_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_uint8_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_uint8_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_list_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(call_flutter_echo_list_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_enum_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoEnumList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_enum_list_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_enum_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_enum_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_class_list_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoClassList%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_class_list_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_class_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_class_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_non_null_enum_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullEnumList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_non_null_enum_list_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_non_null_enum_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_enum_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_non_null_class_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullClassList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_non_null_class_list_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_non_null_class_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_class_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(call_flutter_echo_map_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_string_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoStringMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_string_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_string_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_string_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_int_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoIntMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_int_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_int_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_int_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_enum_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoEnumMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_enum_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_enum_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_enum_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_class_map_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoClassMap%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_class_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_class_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_class_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_non_null_string_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullStringMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_non_null_string_map_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_non_null_string_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_string_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_non_null_int_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullIntMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_non_null_int_map_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_non_null_int_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_int_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_non_null_enum_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullEnumMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_non_null_enum_map_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_non_null_enum_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_enum_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_non_null_class_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNonNullClassMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_non_null_class_map_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_non_null_class_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_non_null_class_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_enum_channel_name = g_strdup_printf(
      "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
      "callFlutterEchoEnum%s",
      dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(call_flutter_echo_enum_channel,
                                               nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_another_enum_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoAnotherEnum%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_another_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_another_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_another_enum_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_bool_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableBool%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_bool_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_nullable_bool_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_bool_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_int_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableInt%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_int_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_nullable_int_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_int_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_double_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableDouble%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_double_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_nullable_double_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_double_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_string_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableString%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_string_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_nullable_string_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_string_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_uint8_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableUint8List%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_uint8_list_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_nullable_uint8_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_uint8_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_list_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_nullable_list_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_enum_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableEnumList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_enum_list_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_nullable_enum_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_enum_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_class_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableClassList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_class_list_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_nullable_class_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_class_list_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_non_null_enum_list_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableNonNullEnumList%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_enum_list_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_enum_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_enum_list_channel, nullptr, nullptr,
      nullptr);
  g_autofree gchar*
      call_flutter_echo_nullable_non_null_class_list_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi.callFlutterEchoNullableNonNullClassList%"
              "s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_class_list_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_class_list_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_class_list_channel, nullptr, nullptr,
      nullptr);
  g_autofree gchar* call_flutter_echo_nullable_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_map_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_nullable_map_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_string_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableStringMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_string_map_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_nullable_string_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_string_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_int_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableIntMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_int_map_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_nullable_int_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_int_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_enum_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableEnumMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_enum_map_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_echo_nullable_enum_map_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_enum_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_nullable_class_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableClassMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_class_map_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_nullable_class_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_class_map_channel, nullptr, nullptr, nullptr);
  g_autofree gchar*
      call_flutter_echo_nullable_non_null_string_map_channel_name =
          g_strdup_printf(
              "dev.flutter.pigeon.pigeon_integration_tests."
              "HostIntegrationCoreApi.callFlutterEchoNullableNonNullStringMap%"
              "s",
              dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_string_map_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_string_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_string_map_channel, nullptr, nullptr,
      nullptr);
  g_autofree gchar* call_flutter_echo_nullable_non_null_int_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableNonNullIntMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_int_map_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_int_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_int_map_channel, nullptr, nullptr,
      nullptr);
  g_autofree gchar* call_flutter_echo_nullable_non_null_enum_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableNonNullEnumMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_enum_map_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_enum_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_enum_map_channel, nullptr, nullptr,
      nullptr);
  g_autofree gchar* call_flutter_echo_nullable_non_null_class_map_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableNonNullClassMap%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_nullable_non_null_class_map_channel =
          fl_basic_message_channel_new(
              messenger,
              call_flutter_echo_nullable_non_null_class_map_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_non_null_class_map_channel, nullptr, nullptr,
      nullptr);
  g_autofree gchar* call_flutter_echo_nullable_enum_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoNullableEnum%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_echo_nullable_enum_channel =
      fl_basic_message_channel_new(messenger,
                                   call_flutter_echo_nullable_enum_channel_name,
                                   FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_nullable_enum_channel, nullptr, nullptr, nullptr);
  g_autofree gchar* call_flutter_echo_another_nullable_enum_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterEchoAnotherNullableEnum%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel)
      call_flutter_echo_another_nullable_enum_channel =
          fl_basic_message_channel_new(
              messenger, call_flutter_echo_another_nullable_enum_channel_name,
              FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_echo_another_nullable_enum_channel, nullptr, nullptr,
      nullptr);
  g_autofree gchar* call_flutter_small_api_echo_string_channel_name =
      g_strdup_printf(
          "dev.flutter.pigeon.pigeon_integration_tests.HostIntegrationCoreApi."
          "callFlutterSmallApiEchoString%s",
          dot_suffix);
  g_autoptr(FlBasicMessageChannel) call_flutter_small_api_echo_string_channel =
      fl_basic_message_channel_new(
          messenger, call_flutter_small_api_echo_string_channel_name,
          FL_MESSAGE_CODEC(codec));
  fl_basic_message_channel_set_message_handler(
      call_flutter_small_api_echo_string_channel, nullptr, nullptr, nullptr);
}

void core_tests_pigeon_test_host_integration_core_api_respond_noop_async(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponse) response =
      core_tests_pigeon_test_host_integration_core_api_noop_async_response_new();
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "noopAsync", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_noop_async(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiNoopAsyncResponse) response =
      core_tests_pigeon_test_host_integration_core_api_noop_async_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "noopAsync", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_int(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    int64_t return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_int_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncInt", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_int(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_int_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncInt", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_double(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    double return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_double_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncDouble", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_double(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncDoubleResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_double_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncDouble", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_bool(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    gboolean return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncBool", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_bool(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncBoolResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_bool_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncBool", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_string(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_string_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncString", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_string(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_string_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncString", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_uint8_list(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const uint8_t* return_value, size_t return_value_length) {
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response_new(
              return_value, return_value_length);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncUint8List", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_uint8_list(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncUint8ListResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_echo_async_uint8_list_response_new_error(
              code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncUint8List", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_object(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    FlValue* return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_object_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncObject", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_object(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncObjectResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_object_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncObject", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_list(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    FlValue* return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_list_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncList", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_list(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncListResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_list_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncList", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_enum_list(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    FlValue* return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncEnumList", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_enum_list(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumListResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_list_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncEnumList", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_class_list(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    FlValue* return_value) {
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response_new(
              return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncClassList", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_class_list(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassListResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_echo_async_class_list_response_new_error(
              code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncClassList", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_map(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    FlValue* return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_map_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncMap", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_map(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncMapResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_map_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncMap", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_string_map(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    FlValue* return_value) {
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response_new(
              return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncStringMap", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_string_map(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncStringMapResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_echo_async_string_map_response_new_error(
              code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncStringMap", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_int_map(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    FlValue* return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncIntMap", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_int_map(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncIntMapResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_int_map_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncIntMap", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_enum_map(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    FlValue* return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncEnumMap", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_enum_map(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumMapResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_map_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncEnumMap", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_class_map(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    FlValue* return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncClassMap", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_class_map(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncClassMapResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_class_map_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncClassMap", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_async_enum(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    CoreTestsPigeonTestAnEnum return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncEnum", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_async_enum(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAsyncEnumResponse) response =
      core_tests_pigeon_test_host_integration_core_api_echo_async_enum_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAsyncEnum", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_echo_another_async_enum(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    CoreTestsPigeonTestAnotherEnum return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response_new(
              return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAnotherAsyncEnum", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_echo_another_async_enum(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiEchoAnotherAsyncEnumResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_echo_another_async_enum_response_new_error(
              code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "echoAnotherAsyncEnum", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_throw_async_error(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    FlValue* return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponse) response =
      core_tests_pigeon_test_host_integration_core_api_throw_async_error_response_new(
          return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "throwAsyncError", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_throw_async_error(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorResponse) response =
      core_tests_pigeon_test_host_integration_core_api_throw_async_error_response_new_error(
          code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "throwAsyncError", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_throw_async_error_from_void(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response_new();
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "throwAsyncErrorFromVoid", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_throw_async_error_from_void(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncErrorFromVoidResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_throw_async_error_from_void_response_new_error(
              code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "throwAsyncErrorFromVoid", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_throw_async_flutter_error(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    FlValue* return_value) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response_new(
              return_value);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_handle,
                                        response->value, &error)) {
    g_warning("Failed to send response to %s.%s: %s", "HostIntegrationCoreApi",
              "throwAsyncFlutterError", error->message);
  }
}

void core_tests_pigeon_test_host_integration_core_api_respond_error_throw_async_flutter_error(
    CoreTestsPigeonTestHostIntegrationCoreApiResponseHandle* response_handle,
    const gchar* code, const gchar* message, FlValue* details) {
  g_autoptr(
      CoreTestsPigeonTestHostIntegrationCoreApiThrowAsyncFlutterErrorResponse)
      response =
          core_tests_pigeon_test_host_integration_core_api_throw_async_flutter_error_response_new_error(
              code, message, details);
  g_autoptr(GError) error = nullptr;
  if (!fl_basic_message_channel_respond(response_handle->channel,
                                        response_handle->response_hand