"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDialogOverlay = exports.AlertDialogFooter = exports.AlertDialogBody = exports.AlertDialogHeader = exports.AlertDialogCloseButton = exports.AlertDialogContent = exports.AlertDialog = void 0;

var _reactNative = require("react-native");

const sizes = {
  xs: {
    contentSize: {
      width: '60%',
      maxWidth: '280'
    }
  },
  sm: {
    contentSize: {
      width: '65%',
      maxWidth: '320'
    }
  },
  md: {
    contentSize: {
      width: '75%',
      maxWidth: '380'
    }
  },
  lg: {
    contentSize: {
      width: '80%',
      maxWidth: '520'
    }
  },
  xl: {
    contentSize: {
      width: '90%',
      maxWidth: '580'
    }
  },
  full: {
    contentSize: {
      width: '100%'
    }
  }
};
const AlertDialog = {
  baseStyle: {
    width: '100%',
    height: '100%',
    justifyContent: 'center',
    alignItems: 'center',
    _web: {
      pointerEvents: 'box-none'
    },
    _backdropFade: {
      exitDuration: 150,
      entryDuration: 200
    },
    _fade: {
      exitDuration: 100,
      entryDuration: 200
    },
    _slide: {
      duration: 200,
      overlay: false
    },
    _overlay: {
      unmountOnExit: true
    }
  },
  sizes,
  defaultProps: {
    size: 'md',
    closeOnOverlayClick: true
  }
};
exports.AlertDialog = AlertDialog;
const AlertDialogContent = {
  baseStyle: () => {
    return {
      shadow: 1,
      rounded: 'lg',
      maxHeight: "".concat(_reactNative.Dimensions.get('window').height - 150, "px"),
      overflow: 'hidden',
      bg: 'muted.50',
      _text: {
        color: 'text.900'
      },
      _dark: {
        bg: 'muted.800',
        color: 'text.50'
      }
    };
  }
};
exports.AlertDialogContent = AlertDialogContent;
const AlertDialogCloseButton = {
  baseStyle: () => {
    return {
      position: 'absolute',
      right: '3',
      top: '3',
      zIndex: '1',
      p: '2',
      bg: 'transparent',
      borderRadius: 'sm',
      _web: {
        outlineWidth: 0,
        cursor: 'pointer'
      },
      _icon: {
        size: '4',
        color: 'muted.500'
      },
      _hover: {
        bg: 'muted.200'
      },
      _pressed: {
        bg: 'muted.300'
      },
      _dark: {
        _icon: {
          color: 'muted.400'
        },
        _hover: {
          bg: 'muted.700'
        },
        _pressed: {
          bg: 'muted.600'
        }
      }
    };
  }
};
exports.AlertDialogCloseButton = AlertDialogCloseButton;
const AlertDialogHeader = {
  baseStyle: () => {
    return {
      p: '4',
      borderBottomWidth: '1',
      _text: {
        color: 'text.900',
        fontSize: 'md',
        fontWeight: 'semibold',
        lineHeight: 'sm'
      },
      bg: 'muted.50',
      borderColor: 'muted.300',
      _dark: {
        bg: 'muted.800',
        borderColor: 'muted.700',
        _text: {
          color: 'text.50'
        }
      }
    };
  }
};
exports.AlertDialogHeader = AlertDialogHeader;
const AlertDialogBody = {
  baseStyle: () => {
    return {
      p: '4',
      bg: 'muted.50',
      _text: {
        color: 'text.900'
      },
      _dark: {
        bg: 'muted.800',
        _text: {
          color: 'text.50'
        }
      }
    };
  }
};
exports.AlertDialogBody = AlertDialogBody;
const AlertDialogFooter = {
  baseStyle: () => {
    return {
      p: '4',
      flexDirection: 'row',
      justifyContent: 'flex-end',
      flexWrap: 'wrap',
      borderTopWidth: '1',
      bg: 'muted.50',
      borderColor: 'muted.300',
      _dark: {
        bg: 'muted.800',
        borderColor: 'muted.700'
      }
    };
  }
};
exports.AlertDialogFooter = AlertDialogFooter;
const AlertDialogOverlay = {
  baseStyle: {
    position: 'absolute',
    left: '0',
    top: '0',
    opacity: '50',
    right: '0',
    bottom: '0'
  }
};
exports.AlertDialogOverlay = AlertDialogOverlay;
//# sourceMappingURL=alert-dialog.js.map