# <img src="https://raw.githubusercontent.com/GeekyAnts/NativeBase/master/img/header_new.png" alt="Nativebase Logo">

[![Financial Contributors on Open Collective](https://opencollective.com/NativeBase/all/badge.svg?label=financial+contributors)](https://opencollective.com/NativeBase)
[![](https://img.shields.io/discord/785491682719301643?label=Discord&logo=discord&logoColor=%237289DA)](https://discord.com/invite/TSgCw2UPmb)
[![npm next package](https://img.shields.io/npm/v/native-base/next.svg)](https://www.npmjs.com/package/native-base)
[![npm latest package](https://img.shields.io/npm/v/native-base/latest.svg)](https://www.npmjs.com/package/native-base)
[![npm downloads](https://img.shields.io/npm/dm/native-base.svg)](https://npm-stat.com/charts.html?package=native-base)
[![license](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/GeekyAnts/NativeBase/blob/master/LICENSE)
[![Follow on Twitter](https://img.shields.io/twitter/follow/nativebase.svg?label=follow+NativeBase)](https://twitter.com/nativebase)
[![Github Stars](https://img.shields.io/github/stars/GeekyAnts/NativeBase)](https://img.shields.io/github/stars/GeekyAnts/NativeBase)

## NativeBase is a mobile-first, accessible component library for building a consistent design system across android, iOS & web.

[**Website**](https://nativebase.io/)
<br/>
[**Documentation**](https://docs.nativebase.io/)

## Table of Contents

1. [Introduction](#1-introduction)
2. [Motivation](#2-motivation)
3. [Features](#3-features)
4. [Dependencies](#4-dependencies)
5. [Installation & Setup](#5-installation)
6. [Components](#6-components)
7. [Examples](#7-examples)
8. [KitchenSink App](#8-kitchensink-app)
9. [Tech Stack](#9-tech-stack)
10. [Compatible Versions](#10-compatible-versions)
11. [Contributors](#11-contributors)
12. [Changelog](#12-changelog)
13. [Community](#13-community)
14. [License](#14-license)

## 1. Introduction?

[NativeBase](https://nativebase.io/) is a mobile-first, component library for React & React Native. Version 3.0 ships with complete ARIA integration, support for utility props and nearly 40 components that are consistent across Android, iOS and Web. Fast-track your dev process with NativeBase 3.0.

**Recommended by [Awesome React Native](https://github.com/jondot/awesome-react-native)**

> NativeBase was added to the list of Frameworks of Awesome React Native and it is used by numerous React lovers across the world.

## 2. Motivation

Building with React Native from scratch is a tedious process with multiple steps such as adding styling, interactions, state management, responsiveness, accessibility, etc. We wanted to build and ship accessible, high-quality apps quickly.
<br />

Our inspirations include Material UI, Chakra UI, Ant Design, Braid Design System, Bootstrap, TailwindCSS & Flutter.

## 3. Features

### **Out of the Box Accessibility**

Integrated with React ARIA and React Native ARIA, which provides React hooks. This enables you to build accessible design systems in no time.

<img src="https://raw.githubusercontent.com/GeekyAnts/NativeBase/development/img/feature.png" alt="Out of the box accessibility">

### **Supporting Utility Props**

Powered by [Styled System](https://styled-system.com) so you can rapidly build custom UI components with constraint-based utility style props.

### **Rich Component Library**

NativeBase offers around 40 components so you can build seamlessly. It includes button, checkbox, flex, stack and more.

### **Highly Themeable**

Themeability is one of the core elements of NativeBase. You can customise your app theme and component styles to your heart's content.

<img src="https://raw.githubusercontent.com/GeekyAnts/NativeBase/development/img/theme.png" alt="Nativebase Logo">

### **Available for Both Mobile and Web**

NativeBase 3.0 is powered by React Native Web so you can build consistent UIs across Web, Android and iOS.

### **Responsiveness Made Easy**

Instead of manually adding responsiveness, NativeBase 3.0 allows you to provide object and array values to add responsive styles.

### **Now with** **Dark Mode**

Building apps with a dark mode setting just got a whole lot easier. NativeBase is now optimised for light and dark modes.

## 4. Dependencies

React Native, Expo

## 5. Installation

NativeBase is supported in Expo or React Native CLI initiated apps. Web support is made possible by react-native-web.

Refer the [guides](https://docs.nativebase.io/installation) to setup NativeBase in your React app.

## 6. Components

NativeBase 3.0 is a rich component library with nearly 40 components.

- [**Layout**](https://docs.nativebase.io/box)
- [**Forms**](https://docs.nativebase.io/button)
- [**Data Display**](https://docs.nativebase.io/badge)
- [**Feedback**](https://docs.nativebase.io/alert)
- [**Typography**](https://docs.nativebase.io/text)
- [**Overlay** ](https://docs.nativebase.io/alert-dialog)
- [**Disclosure**](https://docs.nativebase.io/action-sheet)
- [**Media & Icons**](https://docs.nativebase.io/avatar)
- [**Transition**](https://docs.nativebase.io/presence-transition)
- [**Other**](https://docs.nativebase.io/fab)

## 7. Examples

[Check out the Todo-List example](https://docs.nativebase.io/todo-list)

## 8. KitchenSink App

[Kitchen Sink](https://kitchensink.nativebase.io/) is a comprehensive demo app showcasing all the NativeBase components in action. It includes buttons, forms, icons, etc.

<div class="flexible">
  <img src="https://github.com/GeekyAnts/NativeBase/raw/development/img/kitchensink.gif" height="500px" alt="Kitchensink App gif">  
  <img src="https://raw.githubusercontent.com/GeekyAnts/NativeBase/development/img/qr.png" height="500px"   alt="Kitchensink App QR code">
</div>

## 9. Tech Stack

JavaScript, React Native, Styled System

### Made with :heart: at [GeekyAnts](https://geekyants.com/?utm_source=nb-github&utm_medium=landing+page&utm_campaign=nativebase-github-cta)
NativeBase is an open-source project made by the tech-savvy geeks at GeekyAnts.
GeekyAnts is a group of React Native experts. Do [get in touch with us](https://geekyants.com/hire/?utm_source=nb-github&utm_medium=landing+page&utm_campaign=nativebase-github-hire-cta) for any help with your React Native project. Always happy to help!


## 10. Compatible Versions

| NativeBase                       | React Native                                               |
| -------------------------------- | ---------------------------------------------------------- |
| v0.1.1                           | v0.22 to v0.23                                             |
| v0.2.0 to v0.3.1                 | v0.24 to v0.25                                             |
| v0.4.6 to v0.4.9                 | v0.26.0 - v0.27.1                                          |
| v0.5.0 to v0.5.15                | v0.26.0 - v0.37.0                                          |
| v0.5.16 to v0.5.20               | v0.38.0 - v0.39.0                                          |
| v2.0.0-alpha1 to v2.1.3          | v0.38.0 to v0.43.0                                         |
| v2.1.4 to v2.1.5                 | v0.44.0 to v0.45.0                                         |
| v2.2.0                           | v0.44.0 to v0.45.0                                         |
| v2.2.1                           | v0.46.0 and above                                          |
| v2.3.0 to 2.6.1                  | v0.46.0 and above (does not support React 16.0.0-alpha.13) |
| v2.7.0                           | v0.56.0 and above                                          |
| v3.0.0-next.36 to v3.0.0-next-41 | v0.63.0 and above                                          |
| v3.0.0 to latest                 | v0.63.0 and above                                          |

## 11. Contributors

### Code Contributors

This project exists thanks to all the people who contribute. [[Contribute](CONTRIBUTING.md)].
<a href="https://github.com/GeekyAnts/NativeBase/graphs/contributors"><img src="https://opencollective.com/NativeBase/contributors.svg?width=890&button=false" /></a>

### Financial Contributors

Become a financial contributor and help us sustain our community. [[Contribute](https://opencollective.com/NativeBase/contribute)]

#### Individuals

<a href="https://opencollective.com/NativeBase"><img src="https://opencollective.com/NativeBase/individuals.svg?width=890"></a>

#### Organizations

Support this project with your organization. Your logo will show up here with a link to your website. [[Contribute](https://opencollective.com/NativeBase/contribute)]

<a href="https://opencollective.com/NativeBase/organization/0/website"><img src="https://opencollective.com/NativeBase/organization/0/avatar.svg"></a>
<a href="https://opencollective.com/NativeBase/organization/1/website"><img src="https://opencollective.com/NativeBase/organization/1/avatar.svg"></a>
<a href="https://opencollective.com/NativeBase/organization/2/website"><img src="https://opencollective.com/NativeBase/organization/2/avatar.svg"></a>
<a href="https://opencollective.com/NativeBase/organization/3/website"><img src="https://opencollective.com/NativeBase/organization/3/avatar.svg"></a>
<a href="https://opencollective.com/NativeBase/organization/4/website"><img src="https://opencollective.com/NativeBase/organization/4/avatar.svg"></a>
<a href="https://opencollective.com/NativeBase/organization/5/website"><img src="https://opencollective.com/NativeBase/organization/5/avatar.svg"></a>
<a href="https://opencollective.com/NativeBase/organization/6/website"><img src="https://opencollective.com/NativeBase/organization/6/avatar.svg"></a>
<a href="https://opencollective.com/NativeBase/organization/7/website"><img src="https://opencollective.com/NativeBase/organization/7/avatar.svg"></a>
<a href="https://opencollective.com/NativeBase/organization/8/website"><img src="https://opencollective.com/NativeBase/organization/8/avatar.svg"></a>
<a href="https://opencollective.com/NativeBase/organization/9/website"><img src="https://opencollective.com/NativeBase/organization/9/avatar.svg"></a>

## 12. Changelog

[Check out the changelog in the official documentation](https://docs.nativebase.io/changelog)

## 13. Community

- [Facebook](https://www.facebook.com/nativebaseio)
- [Twitter](https://twitter.com/nativebase)
- [Discord](https://discord.com/invite/TSgCw2UPmb)
- [Stackoverflow](https://stackoverflow.com/questions/tagged/native-base)
- [Blog](https://nativebase.io/blogs)
- [YouTube](https://www.youtube.com/channel/UCoL_iTwpY07vDs91974z3xA/about)

## 14. License

Licensed under the MIT License, Copyright © 2021 GeekyAnts. See [LICENSE](https://github.com/GeekyAnts/NativeBase/blob/master/LICENSE) for more information.

